#  
#  
# INDEXU 
# Database backup file 
# http://www.nicecoder.com 
# 
# Host    : localhost
# Database: indexu530
# Date    : 12-Sep-2006
#  


#  
# Table structure for table 'idx_bad_link' 
#  

DROP TABLE IF EXISTS idx_bad_link;
CREATE TABLE idx_bad_link (
  bad_link_id mediumint(9) unsigned NOT NULL auto_increment,
  link_id mediumint(9) unsigned NOT NULL,
  name varchar(50) NOT NULL,
  email varchar(50) NOT NULL,
  type tinyint(3) unsigned NOT NULL,
  date date DEFAULT '0000-00-00' NOT NULL,
  PRIMARY KEY (bad_link_id)
);

#  
# Dumping data for table 'idx_bad_link' 
#  


#  
# Table structure for table 'idx_category' 
#  

DROP TABLE IF EXISTS idx_category;
CREATE TABLE idx_category (
  category_id mediumint(9) unsigned NOT NULL auto_increment,
  parent_id mediumint(9) unsigned NOT NULL,
  name varchar(100) NOT NULL,
  description text NOT NULL,
  image varchar(100),
  content text,
  visible char(1),
  links mediumint(9),
  meta_keyword text,
  meta_description text,
  permission char(2),
  registered_only char(1),
  header text NOT NULL,
  footer text NOT NULL,
  related mediumint(6) NOT NULL,
  page_title varchar(200) NOT NULL,
  hits int(11) NOT NULL,
  order_num smallint(6) NOT NULL,
  basic_price double unsigned NOT NULL,
  premium_price double unsigned NOT NULL,
  sponsored_price double unsigned NOT NULL,
  PRIMARY KEY (category_id)
);

#  
# Dumping data for table 'idx_category' 
#  


#  
# Table structure for table 'idx_category_path' 
#  

DROP TABLE IF EXISTS idx_category_path;
CREATE TABLE idx_category_path (
  category_id mediumint(9) NOT NULL,
  path text,
  path_with_url text,
  parents text,
  PRIMARY KEY (category_id)
);

#  
# Dumping data for table 'idx_category_path' 
#  


#  
# Table structure for table 'idx_checkurl' 
#  

DROP TABLE IF EXISTS idx_checkurl;
CREATE TABLE idx_checkurl (
  link_id mediumint(9) NOT NULL,
  date date DEFAULT '0000-00-00' NOT NULL,
  live char(1) NOT NULL,
  reciprocal_found char(1) NOT NULL,
  PRIMARY KEY (link_id)
);

#  
# Dumping data for table 'idx_checkurl' 
#  


#  
# Table structure for table 'idx_custom_field' 
#  

DROP TABLE IF EXISTS idx_custom_field;
CREATE TABLE idx_custom_field (
  field_name varchar(32) NOT NULL,
  field_text varchar(64) NOT NULL,
  field_type enum('TEXT','TEXTAREA','SELECT','MULTISELECT','CHECKBOX','RADIO','FILE','IMAGE','DATE','DATETIME') DEFAULT 'TEXT' NOT NULL,
  field_option text NOT NULL,
  field_img_width int(10) unsigned NOT NULL,
  field_img_height int(10) unsigned NOT NULL,
  field_file_size int(10) unsigned NOT NULL,
  field_file_extension varchar(64) NOT NULL,
  required char(1) NOT NULL,
  searchable char(1) DEFAULT '1' NOT NULL,
  permission char(1) NOT NULL
);

#  
# Dumping data for table 'idx_custom_field' 
#  


#  
# Table structure for table 'idx_editor' 
#  

DROP TABLE IF EXISTS idx_editor;
CREATE TABLE idx_editor (
  username varchar(20),
  category_id mediumint(9),
  category char(1),
  link char(1),
  review char(1),
  pick char(1),
  status char(1),
  date date
);

#  
# Dumping data for table 'idx_editor' 
#  


#  
# Table structure for table 'idx_favorites' 
#  

DROP TABLE IF EXISTS idx_favorites;
CREATE TABLE idx_favorites (
  favorite_id int(11) NOT NULL auto_increment,
  username varchar(20),
  date date,
  title varchar(100),
  description text,
  PRIMARY KEY (favorite_id)
);

#  
# Dumping data for table 'idx_favorites' 
#  


#  
# Table structure for table 'idx_favorites_detail' 
#  

DROP TABLE IF EXISTS idx_favorites_detail;
CREATE TABLE idx_favorites_detail (
  favorite_id int(11),
  link_id mediumint(9)
);

#  
# Dumping data for table 'idx_favorites_detail' 
#  


#  
# Table structure for table 'idx_invoice' 
#  

DROP TABLE IF EXISTS idx_invoice;
CREATE TABLE idx_invoice (
  invoice_id varchar(10) NOT NULL,
  invoice_date date,
  due_date date,
  invoiced_to text,
  service varchar(255),
  description text,
  total double(8,2),
  comment text,
  paid char(1),
  paid_date date,
  email varchar(255),
  PRIMARY KEY (invoice_id)
);

#  
# Dumping data for table 'idx_invoice' 
#  


#  
# Table structure for table 'idx_invoice_config' 
#  

DROP TABLE IF EXISTS idx_invoice_config;
CREATE TABLE idx_invoice_config (
  company varchar(255),
  contact varchar(255),
  address text,
  phone varchar(255),
  email varchar(255),
  currency_symbol varchar(255) DEFAULT '$',
  currency_code varchar(255) DEFAULT 'USD'
);

#  
# Dumping data for table 'idx_invoice_config' 
#  

INSERT INTO idx_invoice_config VALUES( 'Your website / Company', 'Billing Department', 'Your address', 'Your phone #', 'Billing<name@yourdomain.com>', '$', 'USD');

#  
# Table structure for table 'idx_link' 
#  

DROP TABLE IF EXISTS idx_link;
CREATE TABLE idx_link (
  link_id mediumint(9) unsigned NOT NULL auto_increment,
  category_id mediumint(9) unsigned NOT NULL,
  title varchar(100) NOT NULL,
  url text NOT NULL,
  description text NOT NULL,
  contact_name varchar(100) NOT NULL,
  email varchar(100) NOT NULL,
  hits mediumint(9),
  votes smallint(6) NOT NULL,
  rating float(4,2) DEFAULT '0.00' NOT NULL,
  date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  bid smallint(6) NOT NULL,
  new char(1),
  hot char(1),
  top_rated char(1),
  pick char(1),
  password varchar(20),
  updated char(1),
  reviews smallint(6),
  avg_review float(4,2),
  last_updated datetime,
  official_review text,
  keywords varchar(255),
  cat1 mediumint(6) NOT NULL,
  cat2 mediumint(6) NOT NULL,
  suspended char(1) NOT NULL,
  reciprocal_url varchar(255),
  PRIMARY KEY (link_id)
);

#  
# Dumping data for table 'idx_link' 
#  


#  
# Table structure for table 'idx_link_temp' 
#  

DROP TABLE IF EXISTS idx_link_temp;
CREATE TABLE idx_link_temp (
  vid mediumint(9) unsigned NOT NULL auto_increment,
  link_id mediumint(9),
  category_id mediumint(9) unsigned NOT NULL,
  title varchar(100) NOT NULL,
  url text NOT NULL,
  description text NOT NULL,
  contact_name varchar(100) NOT NULL,
  email varchar(100) NOT NULL,
  hits mediumint(9),
  votes smallint(6),
  rating float(4,2),
  date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  bid smallint(6) NOT NULL,
  new char(1),
  hot char(1),
  top_rated char(1),
  pick char(1),
  password varchar(20),
  updated char(1),
  reviews smallint(6),
  avg_review float(4,2),
  last_updated datetime,
  official_review text,
  keywords varchar(255),
  cat1 mediumint(6) NOT NULL,
  cat2 mediumint(6) NOT NULL,
  suspended char(1) NOT NULL,
  reciprocal_url varchar(255),
  PRIMARY KEY (vid)
);

#  
# Dumping data for table 'idx_link_temp' 
#  


#  
# Table structure for table 'idx_link_temp_user' 
#  

DROP TABLE IF EXISTS idx_link_temp_user;
CREATE TABLE idx_link_temp_user (
  vid mediumint(9) unsigned NOT NULL,
  username varchar(20) NOT NULL,
  PRIMARY KEY (vid)
);

#  
# Dumping data for table 'idx_link_temp_user' 
#  


#  
# Table structure for table 'idx_link_user' 
#  

DROP TABLE IF EXISTS idx_link_user;
CREATE TABLE idx_link_user (
  link_id mediumint(9) unsigned NOT NULL,
  username varchar(20) NOT NULL,
  PRIMARY KEY (link_id)
);

#  
# Dumping data for table 'idx_link_user' 
#  


#  
# Table structure for table 'idx_mailing_list' 
#  

DROP TABLE IF EXISTS idx_mailing_list;
CREATE TABLE idx_mailing_list (
  email varchar(50) NOT NULL,
  code varchar(4),
  status char(1),
  PRIMARY KEY (email)
);

#  
# Dumping data for table 'idx_mailing_list' 
#  


#  
# Table structure for table 'idx_message' 
#  

DROP TABLE IF EXISTS idx_message;
CREATE TABLE idx_message (
  message_id smallint(6) NOT NULL auto_increment,
  date date,
  body text,
  subject varchar(100),
  PRIMARY KEY (message_id)
);

#  
# Dumping data for table 'idx_message' 
#  


#  
# Table structure for table 'idx_notification' 
#  

DROP TABLE IF EXISTS idx_notification;
CREATE TABLE idx_notification (
  username varchar(20) NOT NULL,
  category_id mediumint(9) NOT NULL
);

#  
# Dumping data for table 'idx_notification' 
#  


#  
# Table structure for table 'idx_pagerank' 
#  

DROP TABLE IF EXISTS idx_pagerank;
CREATE TABLE idx_pagerank (
  link_id mediumint(8) unsigned NOT NULL,
  engine char(1) NOT NULL,
  rank tinyint(4) NOT NULL,
  last_update date DEFAULT '0000-00-00' NOT NULL,
  PRIMARY KEY (link_id)
);

#  
# Dumping data for table 'idx_pagerank' 
#  


#  
# Table structure for table 'idx_paid_listing' 
#  

DROP TABLE IF EXISTS idx_paid_listing;
CREATE TABLE idx_paid_listing (
  link_id mediumint(9) unsigned NOT NULL,
  premium char(1),
  sponsored char(1),
  expire datetime,
  paid char(1),
  PRIMARY KEY (link_id)
);

#  
# Dumping data for table 'idx_paid_listing' 
#  


#  
# Table structure for table 'idx_payment_history' 
#  

DROP TABLE IF EXISTS idx_payment_history;
CREATE TABLE idx_payment_history (
  payment_id int(10) unsigned NOT NULL auto_increment,
  username varchar(255),
  type varchar(255),
  detail text,
  amount double,
  time datetime,
  PRIMARY KEY (payment_id)
);

#  
# Dumping data for table 'idx_payment_history' 
#  


#  
# Table structure for table 'idx_review' 
#  

DROP TABLE IF EXISTS idx_review;
CREATE TABLE idx_review (
  review_id mediumint(9) unsigned NOT NULL auto_increment,
  link_id mediumint(9) unsigned NOT NULL,
  review text NOT NULL,
  rating tinyint(3) unsigned NOT NULL,
  date date DEFAULT '0000-00-00' NOT NULL,
  subject varchar(100),
  status char(1),
  username varchar(20),
  name varchar(20),
  email varchar(100),
  PRIMARY KEY (review_id)
);

#  
# Dumping data for table 'idx_review' 
#  


#  
# Table structure for table 'idx_searchlog' 
#  

DROP TABLE IF EXISTS idx_searchlog;
CREATE TABLE idx_searchlog (
  keyword varchar(100) NOT NULL,
  time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  result mediumint(9) unsigned,
  ip varchar(100)
);

#  
# Dumping data for table 'idx_searchlog' 
#  


#  
# Table structure for table 'idx_sessions' 
#  

DROP TABLE IF EXISTS idx_sessions;
CREATE TABLE idx_sessions (
  SESSKEY varchar(32) NOT NULL,
  EXPIRY int(11) unsigned NOT NULL,
  EXPIREREF varchar(64),
  DATA text NOT NULL,
  PRIMARY KEY (SESSKEY)
);

#  
# Dumping data for table 'idx_sessions' 
#  

INSERT INTO idx_sessions VALUES( '7913c0eb34e895be203e9a54a1ea2fb7', '1158087992', NULL, 'indexu_session_username%7Cs%3A5%3A%22admin%22%3Bindexu_session_location%7Cs%3A18%3A%22Administrator%20Area%22%3Bindexu_session_ip%7Cs%3A9%3A%22127.0.0.1%22%3B');

#  
# Table structure for table 'idx_users' 
#  

DROP TABLE IF EXISTS idx_users;
CREATE TABLE idx_users (
  username varchar(20) NOT NULL,
  password varchar(20),
  name varchar(50),
  email varchar(50),
  date date,
  status char(1),
  vcode varchar(4),
  group_id tinyint(4),
  homepage varchar(100),
  icq varchar(20),
  aol varchar(20),
  yahoo varchar(20),
  biography text,
  location varchar(50),
  interest varchar(50),
  occupation varchar(50),
  PRIMARY KEY (username)
);

#  
# Dumping data for table 'idx_users' 
#  

INSERT INTO idx_users VALUES( 'admin', 'admin', 'Administrator', '', '2006-09-12', '1', '', '0', '', '', '', '', '', '', '', '');

#  
# Table structure for table 'idx_votes' 
#  

DROP TABLE IF EXISTS idx_votes;
CREATE TABLE idx_votes (
  link_id mediumint(9) NOT NULL,
  ip varchar(100),
  value tinyint(4)
);

#  
# Dumping data for table 'idx_votes' 
#  


