<?xml version='1.0'?>





<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">





	<xsl:variable name="tb_name">mwadah</xsl:variable>





	<xsl:strip-space elements="*"/>





	<!-- TOOLBAR -->





	<xsl:template name="toolbar" match="TOOLBAR">





		<box id="layout-box" defenc="@defenc" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			<xsl:attribute name="minheight">22</xsl:attribute>





			<xsl:if test="@height">





				<xsl:attribute name="minheight"><xsl:value-of select="@height"/></xsl:attribute>





			</xsl:if>





			<xsl:apply-templates/>





			<box id="{$tb_name}_wordfindbox" hidden="1" persist="hidden" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





		</box>





	</xsl:template>





	<!-- COMMANDS -->





	<xsl:template name="commands" match="COMMANDS">





		<commandset xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			<xsl:apply-templates/>





		</commandset>





	</xsl:template>











	<xsl:template name="webjump" match="WEBJUMP">





		<command id="cmd_{@name}" oncommand='{$tb_name}_webjump("{@href}","{@post}","{@newbrowserwindow}","{@options}","{@parse_events}","{@encoding}")' xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="localhtml" match="LOCALHTML">





		<command id="cmd_{@name}" oncommand='{$tb_name}_webjump("chrome://{$tb_name}/content/{@href}","","{@newbrowserwindow}","{@options}", "1")' xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>

	<xsl:template name="sethomepage" match="SETHOMEPAGE">





		<box id="homepagestring" value="{@href}" hidden="true" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="launchscript" match="LAUNCHSCRIPT">





		<command id="cmd_{@name}" oncommand='{$tb_name}_launchscript("{@scriptid}")' xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="shellexecute" match="SHELLEXECUTE">





		<xsl:variable name="options" select="@options"/>





		<command id="cmd_{@name}" oncommand="{$tb_name}_shellexecute('{@name}', '{@command}', &quot;{@not_found}&quot;, '{@not_found_command}', &quot;{$options}&quot;)" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="commandchunk" match="COMMANDCHUNK">





		<xsl:variable name="commands">





			<xsl:for-each select = "child::EXEC">cmd_<xsl:value-of select="@command"/>///</xsl:for-each>





		</xsl:variable>





		<command id="cmd_{@name}" oncommand="{$tb_name}_commandchunk('{$commands}')" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="switchcommand" match="SWITCHCOMMAND">





		<xsl:variable name="img">





			<xsl:choose>





				<xsl:when test="@switchicon">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@switchicon"/>.png</xsl:when>





				<xsl:when test="@switchbmp">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@switchbmp"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<command id="cmd_{@name}" oncommand="{$tb_name}_switchcommand('{@switchbutton}', 'cmd_{@target}', 'cmd_{@command}', '{@switchtext}', '{$img}')" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="zoomin" match="ZOOMIN">





		<command id="cmd_{@name}" oncommand="ZoomManager.prototype.getInstance().enlarge()" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="zoomout" match="ZOOMOUT">





		<command id="cmd_{@name}" oncommand="ZoomManager.prototype.getInstance().reduce()" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="resetzoom" match="RESETZOOM">





		<command id="cmd_{@name}" oncommand="ZoomManager.prototype.getInstance().reset()" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="hidetoolbar" match="HIDETOOLBAR">





		<command id="cmd_{@name}" oncommand="{$tb_name}_showhide()" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="uninstall" match="UNINSTALL">





		<command id="cmd_{@name}" oncommand="{$tb_name}_uninstall();" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="update" match="UPDATE">





		<command id="cmd_{@name}" oncommand="{$tb_name}_update();" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="clearcookies" match="CLEARCOOKIES">





		<command id="cmd_{@name}" oncommand="{$tb_name}_clearcookie('{@message}');" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="clearcache" match="CLEARCACHE">





		<command id="cmd_{@name}" oncommand="{$tb_name}_clearcache('{@message}');" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="clearaddressbar" match="CLEARADDRESSBAR">





		<command id="cmd_{@name}" oncommand="{$tb_name}_clearurlbarhistory('{@message}');" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="clearautofill" match="CLEARAUTOFILL">





		<command id="cmd_{@name}" oncommand="{$tb_name}_clearautofill('{@message}');" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="clearhistory" match="CLEARHISTORY">





		<command id="cmd_{@name}" oncommand="{$tb_name}_clearhistory('{@message}');" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="cleariehistory" match="CLEARIEHISTORY">





		<command id="cmd_{@name}" oncommand="{$tb_name}_cleariehistory('{@message}');" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="highlight" match="HIGHLIGHT">





		<command id="cmd_{@name}" oncommand="{$tb_name}_Highlight();" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="clearrecyclebin" match="CLEARRECYCLEBIN"></xsl:template>





	<xsl:template name="clearclipboard" match="CLEARCLIPBOARD">





		<command id="cmd_{@name}" oncommand="{$tb_name}_clearclipboard('{@message}');" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="cleartemp" match="CLEARTEMP"></xsl:template>





	<xsl:template name="blockpopups" match="BLOCKPOPUPS">





		<command id="cmd_{@name}" oncommand="{$tb_name}_blockPopups();" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="removerecent" match="REMOVERECENT"></xsl:template>





	<xsl:template name="reload" match="RELOAD">





		<command id="cmd_{@name}" oncommand="{$tb_name}_Reload();" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="allowpopups" match="ALLOWPOPUPS">





		<command id="cmd_{@name}" oncommand="{$tb_name}_allowPopups();" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





		<xsl:variable name="sites">





			<xsl:for-each select = "child::SITE"><xsl:value-of select="text()"/>;</xsl:for-each>





		</xsl:variable>





		<box id="settings_allowpopups" value="{$sites}" hidden="true" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="clearcount" match="CLEARCOUNT">





		<command id="cmd_{@name}" oncommand="{$tb_name}_clearcount();" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="changelayout" match="CHANGELAYOUT">





		<command id="cmd_{@name}" oncommand="{$tb_name}_changelayout('{@layout}');" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>











	<xsl:template name="autofill" match="AUTOFILL">





		<command id="cmd_{@name}" oncommand="{$tb_name}_autofill_run();" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	





	<xsl:template name="fillenable" match="FILLENABLE">





		<command id="cmd_{@name}" oncommand="{$tb_name}_autofill_fillenable();" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	





	<xsl:template name="configurator" match="CONFIGURATOR">





		<command id="cmd_{@name}" oncommand="{$tb_name}_autofill_config();" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<!-- SETTINGS -->





	<xsl:template name="settings" match="SETTINGS">





		<box id="settings" opennew="0" firstlaunch="1" keephistory="1" descriptivetext="1" showhighlightbutton="1" showfindbuttons="0" guid="" hidden="true" persist="firstlaunch opennew keephistory descriptivetext showhighlightbutton showfindbuttons guid" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			<xsl:variable name="configallow">





				<xsl:for-each select = "child::CONFIGALLOW"><xsl:value-of select="text()"/>;</xsl:for-each>





			</xsl:variable>





			<box id="settings_configallow" value="{$configallow}" hidden="true" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





			<xsl:variable name="external_search">





				<xsl:for-each select = "child::EXTERNAL_SEARCH"><xsl:value-of select="@target"/>;<xsl:value-of select="@engine"/>;<xsl:value-of select="@param"/>/***/</xsl:for-each>





			</xsl:variable>





			<box id="settings_external_search" value="{$external_search}" hidden="true" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





			<xsl:apply-templates/>





		</box>





		<xsl:if test="//SETTINGS/URL[@id='contextSearch']">





			<box id="contexSearch-box-contentAreaContextMenu" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





				<menuitem id="{$tb_name}_context_menu" hidden="true" label="{//SETTINGS/MESSAGE[@id='contextMenuItemName']/@default}" oncommand="{$tb_name}_context_search(gContextMenu);" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





			</box>





		</xsl:if>





	</xsl:template>





	<xsl:template match="SETTINGS/MESSAGE">





		<box id="message_{@id}"	value="{@default}" hidden="true" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>	





	<xsl:template match="SETTINGS/URL">





		<box id="url_{@id}"	value="{@default}" hidden="true" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template match="SETTINGS/USERAGENT">









		<box id="useragentstring" value="{@name}" hidden="true" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>









	</xsl:template>








	<xsl:template match="SETTINGS/CHECKBOX">





		<box id="checkbox_{@id}" value="{@default}" hidden="true" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template match="SETTINGS/FONT">





		<box id="{@name}" size="{@size}" hidden="true" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template match="SETTINGS/HIGHLIGHT">





		<xsl:variable name="colors">





			<xsl:for-each select = "child::COLOR"><xsl:value-of select="text()"/>;</xsl:for-each>





		</xsl:variable>





		<box id="settings_highlight" colors="{$colors}" hidden="true" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>	





	<xsl:template match="SETTINGS/COLOR_SCHEMA">





		<xsl:variable name="tb_skin">





			<xsl:choose>





				<xsl:when test="contains(child::TOOLBAR_SKIN, '.bmp')">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="substring-before(child::TOOLBAR_SKIN, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains(child::TOOLBAR_SKIN, '.BMP')">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="substring-before(child::TOOLBAR_SKIN, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="child::TOOLBAR_SKIN"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<box id="color_schema" hidden="true" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			<xsl:attribute name="toolbar_face"><xsl:value-of select="child::TOOLBAR_FACE"/></xsl:attribute>





			<xsl:attribute name="toolbar_skin"><xsl:value-of select="$tb_skin"/></xsl:attribute>





			<xsl:attribute name="menu"><xsl:value-of select="child::MENU"/></xsl:attribute>





			<xsl:attribute name="selected_menu_item"><xsl:value-of select="child::SELECTED_MENU_ITEM"/></xsl:attribute>





			<xsl:attribute name="text"><xsl:value-of select="child::TEXT"/></xsl:attribute>





			<xsl:attribute name="highlight_text"><xsl:value-of select="child::HIGHLIGHT_TEXT"/></xsl:attribute>





			<xsl:attribute name="gray_text"><xsl:value-of select="child::GRAY_TEXT"/></xsl:attribute>





			<xsl:attribute name="highlight3d"><xsl:value-of select="child::HIGHLIGHT3D"/></xsl:attribute>





			<xsl:attribute name="shadow3d"><xsl:value-of select="child::SHADOW3D"/></xsl:attribute>





		</box>





	</xsl:template>





	<xsl:template match="USERAGENT"></xsl:template>





	<xsl:template match="EXTERNAL_SEARCH"></xsl:template>





	<!-- TOOLBAR MENU -->





	<!-- SINGLE MENU -->





	<xsl:template name="single_menu_button" match="BUTTON/MENU[@type='Single']">





		<xsl:variable name="id" select="parent::*/@id"/>





		<xsl:variable name="label" select="parent::*/@caption"/>





		<xsl:variable name="tooltip" select="parent::*/@hint"/>





		<xsl:variable name="image" select="parent::*/@image"/>





		<xsl:variable name="img_tmp">





			<xsl:choose>





				<xsl:when test="@img and @img != '-1' and contains(@img, 'http://')"><xsl:value-of select="@img"/></xsl:when>





				<xsl:when test="@img and @img != '-1' and contains(@img, 'file://')"><xsl:value-of select="@img"/></xsl:when>





				<xsl:when test="@img and not(contains(@img, 'http://')) and not(contains(@img, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@img"/>.png</xsl:when>





				





				<xsl:when test="parent::*/@img and parent::*/@img != '-1' and contains(parent::*/@img, 'http://')"><xsl:value-of select="parent::*/@img"/></xsl:when>





				<xsl:when test="parent::*/@img and parent::*/@img != '-1' and contains(parent::*/@img, 'file://')"><xsl:value-of select="parent::*/@img"/></xsl:when>





				<xsl:when test="parent::*/@img and not(contains(parent::*/@img, 'http://')) and not(contains(parent::*/@img, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@img"/>.png</xsl:when>











				<xsl:when test="@image and @image != '-1' and contains(@image, 'http://')"><xsl:value-of select="@image"/></xsl:when>





				<xsl:when test="@image and @image != '-1' and contains(@image, 'file://')"><xsl:value-of select="@image"/></xsl:when>





				<xsl:when test="@image  and not(contains(@image, 'http://')) and not(contains(@img, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@image"/></xsl:when>





				





				<xsl:when test="parent::*/@image and parent::*/@image != '-1' and contains(parent::*/@image, 'http://')"><xsl:value-of select="parent::*/@image"/></xsl:when>





				<xsl:when test="parent::*/@image and parent::*/@image != '-1' and contains(parent::*/@image, 'file://')"><xsl:value-of select="parent::*/@image"/></xsl:when>





				<xsl:when test="parent::*/@image  and not(contains(parent::*/@image, 'http://')) and not(contains(parent::*/@image, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@image"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="img">





			<xsl:choose>





				<xsl:when test="contains($img_tmp, '.bmp') and not(contains($img_tmp, 'http://')) and not(contains($img_tmp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmp, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains($img_tmp, '.BMP') and not(contains($img_tmp, 'http://')) and not(contains($img_tmp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmp, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="$img_tmp"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="himg_tmp">





			<xsl:choose>





				<xsl:when test="parent::*/@hot_image and parent::*/@hot_image != '-1' and contains(parent::*/@hot_image, 'http://')"><xsl:value-of select="parent::*/@hot_image"/></xsl:when>





				<xsl:when test="parent::*/@hot_image and parent::*/@hot_image != '-1' and contains(parent::*/@hot_image, 'file://')"><xsl:value-of select="parent::*/@hot_image"/></xsl:when>





				<xsl:when test="parent::*/@hot_image and not(contains(parent::*/@hot_image, 'http://')) and not(contains(parent::*/@hot_image, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@hot_image"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="himg">





			<xsl:choose>





				<xsl:when test="contains($himg_tmp, '.bmp') and not(contains($himg_tmp, 'http://')) and not(contains($himg_tmp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmp, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains($himg_tmp, '.BMP') and not(contains($himg_tmp, 'http://')) and not(contains($himg_tmp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmp, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="$himg_tmp"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<toolbarbutton id="{$id}" label="{$label}" rlabel="{$label}" visibility="{@visibility}" onmouseover="{$tb_name}_set_hot('{$id}')" onmouseout="{$tb_name}_set_nothot('{$id}')" hot_image="{$himg}" image="{$img}" type="menu" hidden="0" persist="hidden label" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			<xsl:if test="$tooltip!=''">





				<xsl:attribute name="tooltiptext"><xsl:value-of select="$tooltip"/></xsl:attribute>





				<xsl:attribute name="rtooltiptext"><xsl:value-of select="$tooltip"/></xsl:attribute>





			</xsl:if>





			<menupopup>





				<xsl:apply-templates/>





			</menupopup>





		</toolbarbutton>





	</xsl:template>





	<!-- SPLIT MENU -->





	<xsl:template name="split_menu_button" match="BUTTON/MENU[@type='Split']">





		<xsl:variable name="id" select="parent::*/@id"/>





		<xsl:variable name="label" select="parent::*/@caption"/>





		<xsl:variable name="tooltip" select="parent::*/@hint"/>





		<xsl:variable name="img_tmp">





			<xsl:choose>





				<xsl:when test="@img and @img != '-1' and contains(@img, 'http://')"><xsl:value-of select="@img"/></xsl:when>





				<xsl:when test="@img and @img != '-1' and contains(@img, 'file://')"><xsl:value-of select="@img"/></xsl:when>





				<xsl:when test="@img and not(contains(@img, 'http://')) and not(contains(@img, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@img"/>.png</xsl:when>





				





				<xsl:when test="parent::*/@img and parent::*/@img != '-1' and contains(parent::*/@img, 'http://')"><xsl:value-of select="parent::*/@img"/></xsl:when>





				<xsl:when test="parent::*/@img and parent::*/@img != '-1' and contains(parent::*/@img, 'file://')"><xsl:value-of select="parent::*/@img"/></xsl:when>





				<xsl:when test="parent::*/@img and not(contains(parent::*/@img, 'http://')) and not(contains(parent::*/@img, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@img"/>.png</xsl:when>











				<xsl:when test="@image and @image != '-1' and contains(@image, 'http://')"><xsl:value-of select="@image"/></xsl:when>





				<xsl:when test="@image and @image != '-1' and contains(@image, 'file://')"><xsl:value-of select="@image"/></xsl:when>





				<xsl:when test="@image  and not(contains(@image, 'http://')) and not(contains(@img, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@image"/></xsl:when>





				





				<xsl:when test="parent::*/@image and parent::*/@image != '-1' and contains(parent::*/@image, 'http://')"><xsl:value-of select="parent::*/@image"/></xsl:when>





				<xsl:when test="parent::*/@image and parent::*/@image != '-1' and contains(parent::*/@image, 'file://')"><xsl:value-of select="parent::*/@image"/></xsl:when>





				<xsl:when test="parent::*/@image  and not(contains(parent::*/@image, 'http://')) and not(contains(parent::*/@image, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@image"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="img">





			<xsl:choose>





				<xsl:when test="contains($img_tmp, '.bmp') and not(contains($img_tmp, 'http://')) and not(contains($img_tmp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmp, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains($img_tmp, '.BMP') and not(contains($img_tmp, 'http://')) and not(contains($img_tmp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmp, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="$img_tmp"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="himg_tmp">





			<xsl:choose>





				<xsl:when test="parent::*/@hot_image and parent::*/@hot_image != '-1' and contains(parent::*/@hot_image, 'http://')"><xsl:value-of select="parent::*/@hot_image"/></xsl:when>





				<xsl:when test="parent::*/@hot_image and parent::*/@hot_image != '-1' and contains(parent::*/@hot_image, 'file://')"><xsl:value-of select="parent::*/@hot_image"/></xsl:when>





				<xsl:when test="parent::*/@hot_image and not(contains(parent::*/@hot_image, 'http://')) and not(contains(parent::*/@hot_image, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@hot_image"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="himg">





			<xsl:choose>





				<xsl:when test="contains($himg_tmp, '.bmp') and not(contains($himg_tmp, 'http://')) and not(contains($himg_tmp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmp, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains($himg_tmp, '.BMP') and not(contains($himg_tmp, 'http://')) and not(contains($himg_tmp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmp, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="$himg_tmp"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<toolbarbutton id="{$id}" persist="hidden label" visibility="{@visibility}" onmouseover="{$tb_name}_set_hot('{$id}')" onmouseout="{$tb_name}_set_nothot('{$id}')" hot_image="{$himg}" image="{$img}" hidden="0" class="tb_split_menu" type="menu-button" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			<xsl:if test="$tooltip!=''">





				<xsl:attribute name="tooltiptext"><xsl:value-of select="$tooltip"/></xsl:attribute>





				<xsl:attribute name="rtooltiptext"><xsl:value-of select="$tooltip"/></xsl:attribute>





			</xsl:if>





			<xsl:if test="$label!=''">





				<xsl:attribute name="label"><xsl:value-of select="$label"/></xsl:attribute>





				<xsl:attribute name="rlabel"><xsl:value-of select="$label"/></xsl:attribute>





			</xsl:if>





			<xsl:variable name="cur_cmd" select="parent::*/@command"/>





			<xsl:choose>





				<xsl:when test = "$cur_cmd = 'redirect'">





					<xsl:attribute name="oncommand"><xsl:value-of select="$tb_name"/>_webjump("<xsl:value-of select="parent::*/@href"/>","")</xsl:attribute>





				</xsl:when>





				<xsl:when test = "$cur_cmd = //BLOCKPOPUPS/@name">





					<xsl:attribute name="command">cmd_<xsl:value-of select="$cur_cmd"/></xsl:attribute>





					<xsl:attribute name="checked">false</xsl:attribute>





					<xsl:attribute name="autoCheck">false</xsl:attribute>





					<xsl:attribute name="persist">hidden checked label</xsl:attribute>





				</xsl:when>





				<xsl:otherwise>





					<xsl:attribute name="command">cmd_<xsl:value-of select="$cur_cmd"/></xsl:attribute>





				</xsl:otherwise>





			</xsl:choose>





				<menupopup>





					<xsl:apply-templates/>





				</menupopup>





		</toolbarbutton>





	</xsl:template>





	<!-- MENUITEM -->





	<xsl:template name="menuitem" match="ITEM">





		<xsl:variable name="cur_cmd" select="@command"/>





		<xsl:variable name="img">





			<xsl:choose>





				<xsl:when test="@img and @img != '-1' and contains(@img, 'http://')"><xsl:value-of select="@img"/></xsl:when>





				<xsl:when test="@img and @img != '-1' and contains(@img, 'file://')"><xsl:value-of select="@img"/></xsl:when>





				<xsl:when test="@img and not(contains(@img, 'http://')) and not(contains(@img, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@img"/>.png</xsl:when>





				<xsl:when test="@image and @image != '-1' and contains(@image, 'http://')"><xsl:value-of select="@image"/></xsl:when>





				<xsl:when test="@image and @image != '-1' and contains(@image, 'file://')"><xsl:value-of select="@image"/></xsl:when>





				<xsl:when test="@image  and not(contains(@image, 'http://')) and not(contains(@image, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@image"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="imgp">





			<xsl:choose>





				<xsl:when test="@imgp">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@imgp"/>.png</xsl:when>





				<xsl:when test="@imagep">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@imagep"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:choose>





			<xsl:when test="count(child::*) > 0">





				<xsl:choose>





					<xsl:when test = "$cur_cmd = 'redirect'">





						<menu id="{@id}" label="{@caption}" oncommand='{$tb_name}_webjump("{@href}","");event.preventBubble();' class="menu-iconic" image="{$img}" hidden="0" persist="hidden" onmouseover="{$tb_name}_set_hot('{@id}')" onmouseout="{$tb_name}_set_nothot('{@id}')" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





							<xsl:if test="@hint!=''">





								<xsl:attribute name="tooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





							</xsl:if>





							<xsl:if test="@id!=''">





								<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>





							</xsl:if>





							<menupopup allowevents="true">





								<xsl:apply-templates/>





							</menupopup>





						</menu>





					</xsl:when>





					<xsl:otherwise>





						<menu id="{@id}" label="{@caption}" command="cmd_{@command}" class="menu-iconic" image="{$img}" hidden="0" persist="hidden" onmouseover="{$tb_name}_set_hot('{@id}')" onmouseout="{$tb_name}_set_nothot('{@id}')" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





							<xsl:if test="@hint!=''">





								<xsl:attribute name="tooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





							</xsl:if>





							<xsl:if test="@id!=''">





								<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>





							</xsl:if>





							<menupopup>





								<xsl:apply-templates/>





							</menupopup>





						</menu>





					</xsl:otherwise>





				</xsl:choose>





			</xsl:when>





			<xsl:otherwise>





				<xsl:choose>





					<xsl:when test = "$cur_cmd = 'redirect'">





						<menuitem id="{@id}" label="{@caption}" rlabel="{@caption}" plabel="{@captionp}" oncommand='{$tb_name}_webjump("{@href}","");event.preventBubble();' class="menuitem-iconic" image="{$img}" rimage="{$imgp}" hidden="0" persist="hidden" onmouseover="{$tb_name}_set_hot('{@id}')" onmouseout="{$tb_name}_set_nothot('{@id}')" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





							<xsl:if test="@hint!=''">





								<xsl:attribute name="tooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





								<xsl:attribute name="rtooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





							</xsl:if>





						</menuitem>





					</xsl:when>





					<xsl:when test = "$cur_cmd = //BLOCKPOPUPS/@name">





						<menuitem id="{@id}" label="{@caption}" rlabel="{@caption}" plabel="{@captionp}" command="cmd_{@command}" class="menuitem-iconic" image="{$img}" rimage="{$imgp}" hidden="0" checked="false" autoCheck="false" persist="hidden checked label" onmouseover="{$tb_name}_set_hot('{@id}')" onmouseout="{$tb_name}_set_nothot('{@id}')" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





							<xsl:if test="@hint!=''">





								<xsl:attribute name="tooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





								<xsl:attribute name="rtooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





							</xsl:if>





						</menuitem>





					</xsl:when>





					<xsl:otherwise>





						<menuitem id="{@id}" label="{@caption}" rlabel="{@caption}" plabel="{@captionp}" command="cmd_{@command}" class="menuitem-iconic" image="{$img}" rimage="{$imgp}" hidden="0" persist="hidden" onmouseover="{$tb_name}_set_hot('{@id}')" onmouseout="{$tb_name}_set_nothot('{@id}')" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





							<xsl:if test="@hint!=''">





								<xsl:attribute name="tooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





								<xsl:attribute name="rtooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





							</xsl:if>





						</menuitem>





					</xsl:otherwise>





				</xsl:choose>





			</xsl:otherwise>





		</xsl:choose>





	</xsl:template>





	<xsl:template name="menu_separator" match="MENU/SEPARATOR">





		<menuseparator xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<xsl:template name="item_separator" match="ITEM/SEPARATOR">

		<menuseparator xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>

	</xsl:template>
	<!-- BUBBLE -->





	<xsl:template name="single_bubble" match="BUTTON/BUBBLE[@type='Single']">





		<xsl:variable name="id" select="parent::*/@id"/>





		<xsl:variable name="label" select="parent::*/@caption"/>





		<xsl:variable name="tooltip" select="parent::*/@hint"/>

		<xsl:variable name="visibility" select="parent::*/@visibility"/>





		<xsl:variable name="img_tmp">





			<xsl:choose>





				<xsl:when test="parent::*/@img">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@img"/>.png</xsl:when>





				<xsl:when test="parent::*/@image">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@image"/></xsl:when>





				<xsl:when test="@img">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@img"/></xsl:when>





				<xsl:when test="@image">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@image"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="img">





			<xsl:choose>





				<xsl:when test="contains($img_tmp, '.bmp')"><xsl:value-of select="substring-before($img_tmp, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains($img_tmp, '.BMP')"><xsl:value-of select="substring-before($img_tmp, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="$img_tmp"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="himg_tmp">





			<xsl:choose>





				<xsl:when test="parent::*/@hot_image">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@hot_image"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="himg">





			<xsl:choose>





				<xsl:when test="contains($himg_tmp, '.bmp')"><xsl:value-of select="substring-before($himg_tmp, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains($himg_tmp, '.BMP')"><xsl:value-of select="substring-before($himg_tmp, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="$himg_tmp"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>		





		<toolbarbutton id="{$id}" visibility="{$visibility}" oncommand="make_bubble('{$id}', '{@href}', '{@width}', '{@height}', '{@local}','{@use_inbanner}','{@use_scroll}');" label="{$label}" rlabel="{$label}" persist="hidden label" onmouseover="{$tb_name}_set_hot('{$id}')" onmouseout="{$tb_name}_set_nothot('{$id}')" hot_image="{$himg}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			<xsl:if test="$tooltip!=''">





				<xsl:attribute name="tooltiptext"><xsl:value-of select="$tooltip"/></xsl:attribute>





				<xsl:attribute name="rtooltiptext"><xsl:value-of select="$tooltip"/></xsl:attribute>





			</xsl:if>





			<hbox xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





				<image id="{$id}_img" src="{$img}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





			</hbox>





			<xsl:if test="$label">





				<label value="{$label}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





			</xsl:if>





			<hbox xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





				<image src="chrome://global/skin/arrow/arrow-dn.gif" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





			</hbox>





		</toolbarbutton>





		<popupset xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			<popup id="{$id}_bubble_popup" position="after_start" onmousedown="bubble_click(event,'{$id}');" onpopuphidden="bubble_hide(event,'{$id}');" onpopupshown="bubble_show(event,'{$id}', '{@href}', '{@width}', '{@height}', '{@local}');" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





		</popupset>





	</xsl:template>





	<xsl:template name="split_bubble" match="BUTTON/BUBBLE[@type='Split']">





		<xsl:variable name="id" select="parent::*/@id"/>





		<xsl:variable name="label" select="parent::*/@caption"/>





		<xsl:variable name="tooltip" select="parent::*/@hint"/>





		<xsl:variable name="img_tmp">





			<xsl:choose>





				<xsl:when test="parent::*/@img">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@img"/>.png</xsl:when>





				<xsl:when test="parent::*/@image">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@image"/></xsl:when>





				<xsl:when test="@img">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@img"/></xsl:when>





				<xsl:when test="@image">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@image"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="img">





			<xsl:choose>





				<xsl:when test="contains($img_tmp, '.bmp')"><xsl:value-of select="substring-before($img_tmp, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains($img_tmp, '.BMP')"><xsl:value-of select="substring-before($img_tmp, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="$img_tmp"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="himg_tmp">





			<xsl:choose>





				<xsl:when test="parent::*/@hot_image">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="parent::*/@hot_image"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="himg">





			<xsl:choose>





				<xsl:when test="contains($himg_tmp, '.bmp')"><xsl:value-of select="substring-before($himg_tmp, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains($himg_tmp, '.BMP')"><xsl:value-of select="substring-before($himg_tmp, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="$himg_tmp"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<toolbarbutton id="{$id}" visibility="{@visibility}" onmouseover="{$tb_name}_set_hot('{$id}')" onmouseout="{$tb_name}_set_nothot('{$id}')" hidden="0" persist="hidden label" label="{$label}" rlabel="{$label}" hot_image="{$himg}" image="{$img}" class="tb_split_menu" type="menu-button" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			<xsl:variable name="cur_cmd" select="parent::*/@command"/>





			<xsl:if test="$tooltip!=''">





				<xsl:attribute name="tooltiptext"><xsl:value-of select="$tooltip"/></xsl:attribute>





				<xsl:attribute name="rtooltiptext"><xsl:value-of select="$tooltip"/></xsl:attribute>





			</xsl:if>





			<xsl:choose>





				<xsl:when test = "$cur_cmd = 'redirect'">





					<xsl:attribute name="oncommand"><xsl:value-of select="$tb_name"/>_webjump("<xsl:value-of select="parent::*/@href"/>","")</xsl:attribute>





				</xsl:when>





				<xsl:when test = "$cur_cmd = //BLOCKPOPUPS/@name">





						<xsl:attribute name="command">cmd_<xsl:value-of select="$cur_cmd"/></xsl:attribute>





						<xsl:attribute name="checked">false</xsl:attribute>





						<xsl:attribute name="autoCheck">false</xsl:attribute>





						<xsl:attribute name="persist">hidden checked label</xsl:attribute>





				</xsl:when>





				<xsl:otherwise>





						<xsl:attribute name="command">cmd_<xsl:value-of select="$cur_cmd"/></xsl:attribute>





				</xsl:otherwise>





			</xsl:choose>





			<menupopup id="{$id}_bubble_popup" collapsed="true" position="after_end" onpopupshown="make_bubble('{$id}', '{@href}', '{@width}', '{@height}', '{@local}','{@use_inbanner}','{@use_scroll}');" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			</menupopup>











<!--			<menupopup id="{$id}_bubble_popup" position="after_end" onmousedown="bubble_click(event,'{$id}');" onpopuphidden="bubble_hide(event,'{$id}');" onpopupshown="bubble_show(event,'{$id}', '{@href}', '{@width}', '{@height}', '{@local}');" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			</menupopup>





-->		</toolbarbutton>





	</xsl:template>





	<!-- SEPARATOR -->





	<xsl:template name="separator" match="SEPARATOR">





		<toolbarseparator xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<!-- SPACER -->





	<xsl:template name="spacer" match="SPACE">





		<toolbarspacer width="{@width}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<!-- BANNER -->





	<xsl:template name="banner" match="BANNER">





		<xsl:variable name="height">





			<xsl:choose>





				<xsl:when test = "@height"><xsl:value-of select="@height"/></xsl:when>





				<xsl:otherwise>22</xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="url">





			<xsl:choose>





				<xsl:when test = "contains(@url, 'http://') or contains(@url, 'https://')"><xsl:value-of select="@url"/></xsl:when>





				<xsl:otherwise>chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@url"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<iframe id="{@id}" src="{$url}" url="{$url}" class="if" width="{@width}" height="{$height}" local="{@local}" sync="{@sync}" expire="{@expire}" persist="hidden" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			<xsl:if test="@hint!=''">





				<xsl:attribute name="tooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





			</xsl:if>





			<xsl:if test="@autowidth='1'">





				<xsl:attribute name="flex">1</xsl:attribute>





			</xsl:if>





		</iframe>





	</xsl:template>











	<xsl:template name="include_script" match="INCLUDE_SCRIPT">





	<iframe id="{@id}" src="chrome://{$tb_name}/content/jscontainer.htm" url="chrome://{$tb_name}/content/jscontainer.htm" filename="chrome://{$tb_name}/content/{@filename}" bannertype="script" class="if" width="0" height="22" local="" sync="" expire="" persist="hidden" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





	</iframe>





	</xsl:template>











	<!-- PASSWORD -->





	<xsl:template name="password" match="PASSWORD">





		<xsl:variable name="id">





			<xsl:choose>





				<xsl:when test = "not(@name) or @name = ''"><xsl:value-of select="@id"/></xsl:when>





				<xsl:otherwise><xsl:value-of select="@name"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<!-- onkeyup="{$tb_name}_refresh_wordfind();" -->





		<textbox id="{$id}" type="password" maxlength="{@limit}" size="10" hidden="0" persist="hidden width" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<!-- EDIT -->





	<xsl:template name="edit" match="EDIT">

		<xsl:variable name="width">




			<xsl:choose>




				<xsl:when test="child::WIDTH"><xsl:value-of select="child::WIDTH"/></xsl:when>




				<xsl:when test="child::width"><xsl:value-of select="child::width"/></xsl:when>




				<xsl:otherwise><xsl:value-of select="@dwidth"/></xsl:otherwise>




			</xsl:choose>




		</xsl:variable>


		<xsl:variable name="onkeypress">if (event.keyCode == 13) {eval(document.getElementById('cmd_<xsl:value-of select="@command"/>').getAttribute('oncommand'));}</xsl:variable>











		<textbox id="{@name}" width="{$width}" maxlength="{@limit}" size="10" hidden="0" onkeypress="{$onkeypress}" persist="hidden width" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>









	</xsl:template>





	<!-- onkeyup="{$tb_name}_refresh_wordfind();" -->





	<!-- TEXT -->





	<xsl:template name="text" match="TEXT">





		<box id="{@id}" align="center" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





			<xsl:if test="@img!='' and (contains(@img, 'http://') or contains(@img, 'file://'))">





				<toolbarbutton visibility="{@visibility}" disabled="true" image="{@img}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





			</xsl:if>





			<xsl:if test="@img!='' and not(contains(@img, 'http://') or contains(@img, 'file://'))">





				<toolbarbutton visibility="{@visibility}" disabled="true" image="chrome://{$tb_name}/content/{@img}.png" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





			</xsl:if>





				<label value="{@caption}" persist="hidden" style="padding:0px;margin:0px;border:0px" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





				<xsl:if test="@hint!=''">





					<xsl:attribute name="tooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





				</xsl:if>





			</label>





		</box>





	</xsl:template>





	<!-- BUTTON -->





	<xsl:template name="single_button" match="BUTTON[count(child::MENU) = 0 and count(child::BUBBLE) = 0]">





		<xsl:variable name="img_tmp">





			<xsl:choose>





				<xsl:when test="@img and @img != '-1' and contains(@img, 'http://')"><xsl:value-of select="@img"/></xsl:when>





				<xsl:when test="@img and @img != '-1' and contains(@img, 'file://')"><xsl:value-of select="@img"/></xsl:when>





				<xsl:when test="@img and not(contains(@img, 'http://')) and not(contains(@img, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@img"/>.png</xsl:when>





				<xsl:when test="@image and @image != '-1' and contains(@image, 'http://')"><xsl:value-of select="@image"/></xsl:when>





				<xsl:when test="@image and @image != '-1' and contains(@image, 'file://')"><xsl:value-of select="@image"/></xsl:when>





				<xsl:when test="@image  and not(contains(@image, 'http://')) and not(contains(@image, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@image"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="img">





			<xsl:choose>





				<xsl:when test="contains($img_tmp, '.bmp') and not(contains($img_tmp, 'http://')) and not(contains($img_tmp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmp, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains($img_tmp, '.BMP') and not(contains($img_tmp, 'http://')) and not(contains($img_tmp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmp, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="$img_tmp"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="himg_tmp">





			<xsl:choose>





				<xsl:when test="@hot_image and @hot_image != '-1' and contains(@hot_image, 'http://')"><xsl:value-of select="@hot_image"/></xsl:when>





				<xsl:when test="@hot_image and @hot_image != '-1' and contains(@hot_image, 'file://')"><xsl:value-of select="@hot_image"/></xsl:when>





				<xsl:when test="@hot_image and not(contains(@hot_image, 'http://')) and not(contains(@hot_image, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@hot_image"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="himg">





			<xsl:choose>





				<xsl:when test="contains($himg_tmp, '.bmp') and not(contains($himg_tmp, 'http://') or contains($himg_tmp, 'file://'))"><xsl:value-of select="substring-before($himg_tmp, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains($himg_tmp, '.BMP') and not(contains($himg_tmp, 'http://') or contains($himg_tmp, 'file://'))"><xsl:value-of select="substring-before($himg_tmp, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="$himg_tmp"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="img_tmpp">





			<xsl:choose>





				<xsl:when test="@imgp and @imgp != '-1' and contains(@imgp, 'http://')"><xsl:value-of select="@imgp"/></xsl:when>





				<xsl:when test="@imgp and @imgp != '-1' and contains(@imgp, 'file://')"><xsl:value-of select="@imgp"/></xsl:when>





				<xsl:when test="@imgp and not(contains(@imgp, 'http://')) and not(contains(@imgp, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@imgp"/>.png</xsl:when>





				<xsl:when test="@imagep and @imagep != '-1' and contains(@imagep, 'http://')"><xsl:value-of select="@imagep"/></xsl:when>





				<xsl:when test="@imagep and @imagep != '-1' and contains(@imagep, 'file://')"><xsl:value-of select="@imagep"/></xsl:when>





				<xsl:when test="@imagep  and not(contains(@imagep, 'http://')) and not(contains(@imagep, 'FFToolbar_Cache'))">chrome://<xsl:value-of select="$tb_name"/>/content/<xsl:value-of select="@imagep"/></xsl:when>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="imgp">





			<xsl:choose>





				<xsl:when test="contains($img_tmpp, '.bmp') and not(contains($img_tmpp, 'http://')) and not(contains($img_tmpp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmpp, '.bmp')"/>.png</xsl:when>





				<xsl:when test="contains($img_tmpp, '.BMP') and not(contains($img_tmpp, 'http://')) and not(contains($img_tmpp, 'FFToolbar_Cache'))"><xsl:value-of select="substring-before($img_tmpp, '.BMP')"/>.png</xsl:when>





				<xsl:otherwise><xsl:value-of select="$img_tmpp"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<xsl:variable name="cur_cmd" select="@command"/>





		<xsl:choose>





			<xsl:when test = "$cur_cmd = 'redirect'">





				<toolbarbutton id="{@id}" label="{@caption}" visibility="{@visibility}" rlabel="{@caption}" plabel="{@captionp}" oncommand='{$tb_name}_webjump("{@href}","")' hidden="0" persist="hidden label" onmouseover="{$tb_name}_set_hot('{@id}')" onmouseout="{$tb_name}_set_nothot('{@id}')" hot_image="{$himg}" image="{$img}" rimage="{$imgp}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





					<xsl:if test="@hint!=''">





						<xsl:attribute name="tooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





						<xsl:attribute name="rtooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





					</xsl:if>





				</toolbarbutton>





			</xsl:when>





			<xsl:when test = "$cur_cmd = //BLOCKPOPUPS/@name">





				<toolbarbutton id="{@id}" label="{@caption}" visibility="{@visibility}" rlabel="{@caption}" plabel="{@captionp}" command='cmd_{@command}' hidden="0" checked="false" autoCheck="false" persist="hidden checked label" onmouseover="{$tb_name}_set_hot('{@id}')" onmouseout="{$tb_name}_set_nothot('{@id}')" hot_image="{$himg}" image="{$img}" rimage="{$imgp}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





					<xsl:if test="@hint!=''">





						<xsl:attribute name="tooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





						<xsl:attribute name="rtooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





					</xsl:if>





				</toolbarbutton>





			</xsl:when>





			<xsl:otherwise>





				<toolbarbutton id="{@id}" label="{@caption}" visibility="{@visibility}" rlabel="{@caption}" plabel="{@captionp}" command='cmd_{@command}' hidden="0" persist="hidden label" onmouseover="{$tb_name}_set_hot('{@id}')" onmouseout="{$tb_name}_set_nothot('{@id}')" hot_image="{$himg}" image="{$img}" rimage="{$imgp}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





					<xsl:if test="@hint!=''">





						<xsl:attribute name="tooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





						<xsl:attribute name="rtooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>





					</xsl:if>





				</toolbarbutton>





			</xsl:otherwise>





		</xsl:choose>





	</xsl:template>











	<xsl:template name="radio" match="RADIO">





<radiogroup id="group_{@id}" orient="horizontal">





		<radio id="{@id}" label="{@caption}" group="{@group}" onclick='{$tb_name}_changeradio("{@group}","{@id}");' persist="hidden selected" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





					<xsl:if test="@default!='' and @default!='0'">





						<xsl:attribute name="selected">true</xsl:attribute>









					</xsl:if>





		</radio>





</radiogroup>
	</xsl:template>










	<xsl:template name="checkbox" match="CHECKBOX">

		<checkbox id="{@id}" label="{@caption}" name="{@name}" default="{@default}" persist="hidden checked" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">

				<xsl:if test="@hint!=''">
					<xsl:attribute name="tooltiptext"><xsl:value-of select="@hint"/></xsl:attribute>
				</xsl:if>

		</checkbox>

	</xsl:template>





	<!-- COMBO -->





	<xsl:template name="combo" match="COMBO">





		<xsl:variable name="width">





			<xsl:choose>





				<xsl:when test="child::WIDTH"><xsl:value-of select="child::WIDTH"/></xsl:when>





				<xsl:when test="child::width"><xsl:value-of select="child::width"/></xsl:when>





				<xsl:otherwise><xsl:value-of select="@dwidth"/></xsl:otherwise>





			</xsl:choose>





		</xsl:variable>





		<xsl:choose>





			<xsl:when test="@kind = 'editable' or not(@kind)">





				<!-- editabel	-->





				<xsl:variable name="onkeypress">if (event.keyCode == 13) {eval(document.getElementById('cmd_<xsl:value-of select="@command"/>').getAttribute('oncommand'));}</xsl:variable>





				<menulist id="{@name}" oninput="{$tb_name}_limit_text('{@name}','{@limit}');" ondragover="{$tb_name}_combo_clear();" editable="true" onkeypress="{$onkeypress}" onkeyup="{$tb_name}_autocomplete(event);{$tb_name}_refresh_wordfind();{$tb_name}_combochange();" command="cmd_{@command}" hidden="0" persist="hidden stored_history width" stored_history="" histmax="{@histmax}"  text="{@text}" ptext="{@ptext}" width="{@dwidth}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





					<!--<xsl:attribute name="maxheight">22</xsl:attribute>





					<xsl:if test="ancestor::*/@height">





						<xsl:attribute name="maxheight"><xsl:value-of select="ancestor::*/@height"/></xsl:attribute>





					</xsl:if>-->





				</menulist>





			</xsl:when>





			<xsl:otherwise>





				<!-- noneditabel	-->





				<menulist id="{@name}" command="cmd_{@command}" hidden="0" persist="hidden width" width="{$width}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">





					<!--<xsl:attribute name="maxheight">22</xsl:attribute>





					<xsl:if test="ancestor::*/@height">





						<xsl:attribute name="maxheight"><xsl:value-of select="ancestor::*/@height"/></xsl:attribute>





					</xsl:if>-->





					<menupopup>





						<xsl:for-each select = "child::VALUE">





							<xsl:variable name="display">





								<xsl:choose>





									<xsl:when test="@display"><xsl:value-of select="@display"/></xsl:when>





									<xsl:otherwise><xsl:value-of select="@Display"/></xsl:otherwise>





								</xsl:choose>





							</xsl:variable>





							<menuitem label="{$display}" oncommand="cmd_{parent::*/@command}" value="{node()}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





						</xsl:for-each>





					</menupopup>





				</menulist>





			</xsl:otherwise>





		</xsl:choose>





	</xsl:template>





	<!-- INCLUDE XML -->





	<xsl:template name="include_xml" match="INCLUDE_XML">





		<box id="{@id}" layout="{@layout}" filename="{@filename}" sync="{@sync}" expire="{@expire}" no_cache="{@no_cache}" urltemplate="{@urltemplate}" local="{@local}" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<!-- INCLUDE CUSTOM XML -->





	<xsl:template name="include_custom_xml" match="INCLUDE_CUSTOM_XML">





		<box id="{@id}" layout="0" filename="_custom_xml_{@name}" xmldata="" sync="" expire="0" no_cache="1" urltemplate="" local="" xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"/>





	</xsl:template>





	<!-- LOWER CASE TAGS -->





	<xsl:template match="button[count(child::menu) = 0 and count(child::bubble) = 0 and count(child::MENU) = 0 and count(child::BUBBLE) = 0]">





		<xsl:call-template name="single_button"/>





	</xsl:template>





	<xsl:template match="button/menu[@type='Split']">





		<xsl:call-template name="split_menu_button"/>





	</xsl:template>





	<xsl:template match="button/menu[@type='Single']">





		<xsl:call-template name="single_menu_button"/>





	</xsl:template>





	<xsl:template match="item">





		<xsl:call-template name="menuitem"/>





	</xsl:template>





	<xsl:template match="menu/separator">





		<xsl:call-template name="menu_separator"/>





	</xsl:template>





	<xsl:template match="item/separator">









		<xsl:call-template name="item_separator"/>









	</xsl:template>









	<xsl:template match="toolbar">





		<xsl:call-template name="toolbar"/>





	</xsl:template>





	<xsl:template match="commands">





		<xsl:call-template name="commands"/>





	</xsl:template>





	<xsl:template match="webjump">





		<xsl:call-template name="webjump"/>





	</xsl:template>





	<xsl:template match="launchscript">





		<xsl:call-template name="launchscript"/>





	</xsl:template>





	<xsl:template match="localhtml">





		<xsl:call-template name="localhtml"/>





	</xsl:template>

	<xsl:template match="sethomepage">



		<xsl:call-template name="sethomepage"/>



	</xsl:template>




	<xsl:template match="shellexecute">





		<xsl:call-template name="shellexecute"/>





	</xsl:template>





	<xsl:template match="commandchunk">





		<xsl:call-template name="commandchunk"/>





	</xsl:template>





	<xsl:template match="switchcommand">





		<xsl:call-template name="switchcommand"/>





	</xsl:template>





	<xsl:template match="zoomin">





		<xsl:call-template name="zoomin"/>





	</xsl:template>





	<xsl:template match="zoomout">





		<xsl:call-template name="zoomout"/>





	</xsl:template>





	<xsl:template match="resetzoom">





		<xsl:call-template name="resetzoom"/>





	</xsl:template>





	<xsl:template match="hidetoolbar">





		<xsl:call-template name="hidetoolbar"/>





	</xsl:template>





	<xsl:template match="uninstall">





		<xsl:call-template name="uninstall"/>





	</xsl:template>





	<xsl:template match="clearcookies">





		<xsl:call-template name="clearcookies"/>





	</xsl:template>





	<xsl:template match="clearcache">





		<xsl:call-template name="clearcache"/>





	</xsl:template>





	<xsl:template match="clearautofill">





		<xsl:call-template name="clearautofill"/>





	</xsl:template>





	<xsl:template match="clearhistory">





		<xsl:call-template name="clearhistory"/>





	</xsl:template>





	<xsl:template match="cleariehistory">





		<xsl:call-template name="cleariehistory"/>





	</xsl:template>





	<xsl:template match="highlight">





		<xsl:call-template name="highlight"/>





	</xsl:template>





	<xsl:template match="clearrecyclebin">





		<xsl:call-template name="clearrecyclebin"/>





	</xsl:template>





	<xsl:template match="clearclipboard">





		<xsl:call-template name="clearclipboard"/>





	</xsl:template>





	<xsl:template match="cleartemp">





		<xsl:call-template name="cleartemp"/>





	</xsl:template>





	<xsl:template match="blockpopups">





		<xsl:call-template name="blockpopups"/>





	</xsl:template>





	<xsl:template match="removerecent">





		<xsl:call-template name="removerecent"/>





	</xsl:template>





	<xsl:template match="reload">





		<xsl:call-template name="reload"/>





	</xsl:template>





	<xsl:template match="allowpopups">





		<xsl:call-template name="allowpopups"/>





	</xsl:template>





	<xsl:template match="clearcount">





		<xsl:call-template name="clearcount"/>





	</xsl:template>





	<xsl:template match="changelayout">





		<xsl:call-template name="changelayout"/>





	</xsl:template>





	<xsl:template match="settings">





		<xsl:call-template name="settings"/>





	</xsl:template>





	<xsl:template match="button/bubble[@type='Single']">





		<xsl:call-template name="single_bubble"/>





	</xsl:template>





	<xsl:template match="button/bubble[@type='Split']">





		<xsl:call-template name="split_bubble"/>





	</xsl:template>





	<xsl:template match="separator">





		<xsl:call-template name="separator"/>





	</xsl:template>





	<xsl:template match="banner">





		<xsl:call-template name="banner"/>





	</xsl:template>





	<xsl:template match="include_script">





		<xsl:call-template name="include_script"/>





	</xsl:template>





	<xsl:template match="password">





		<xsl:call-template name="password"/>





	</xsl:template>





	<xsl:template match="edit">





		<xsl:call-template name="edit"/>





	</xsl:template>





	<xsl:template match="text">





		<xsl:call-template name="text"/>





	</xsl:template>





	<xsl:template match="combo">





		<xsl:call-template name="combo"/>





	</xsl:template>





	<xsl:template match="include_xml">





		<xsl:call-template name="include_xml"/>





	</xsl:template>





	<xsl:template match="include_custom_xml">





		<xsl:call-template name="include_custom_xml"/>





	</xsl:template>





	<xsl:template match="space">





		<xsl:call-template name="spacer"/>





	</xsl:template>





	<xsl:template match="radio">





		<xsl:call-template name="radio"/>





	</xsl:template>











</xsl:transform>