<?php
/* =============================================================================
 * $Revision: 2244 $
 * $Date: 2007-10-03 18:21:33 +0200 (Wed, 03 Oct 2007) $
 * 
 * Vivvo CMS 4.0 
 * Copyright 2005-07 SpoonLabs d.o.o.
 * http://www.spoonlabs.com, All Rights Reserved
 * 
 * Warning: This program is protected by copyright law. Unauthorized
 * reproduction or distribution of this program, or any portion of it, may
 * result in severe civil and criminal penalties, and will be prosecuted to the
 * maximum extent possible under the law. For more information about this
 * script or other scripts see http://www.spoonlabs.com
 * ============================================================================ 
 */



/**
 * Vivvo CMS
 *
 * LICENSE: 
 *
 * @package    Vivvo
 * @subpackage box
 * @author     Slobodan Utvic <utvara@spoonlabs.com>
 * @copyright  Spoonlbas
 * @license    http://www.vivvo.net/license.php
 * @version    0.1
 * @category   CMS
 */	
	
	/**
	 * Box vb comments
	 *
	 * @version Release: @package_version@
	 * @license http://www.vivvo.net/license.php
	 * @copyright SpoonLabs
	 * @package Vivvo
	 * @subpackage box
	 * @author Slobodan Utvic <utvara@spoonlabs.com>
	 */
	
	class box_vb_comments extends module {
		var $data = array();
		
		/**
		 * Generate box output
		 *
		 * @param array $params Parameters
		 */
		function generate_output($params){
			$this->set_template($params);
			
			if (isset($params['thread_id'])){
				$thread_id = (int) $params['thread_id'];
				global $config;			
				require (VIVVO_PLUGIN_VB_USER_FS_ROOT . 'includes/config.php');
	
				require_once(VIVVO_FS_FRAMEWORK . 'PEAR/MDB2.php');
				$dsn = array(
				    'phptype'  => $config['Database']['dbtype'],
				    'username' => $config['MasterServer']['username'],
				    'password' => $config['MasterServer']['password'],
				    'hostspec' => $config['MasterServer']['servername'],
				    'database' => $config['Database']['dbname'],
				    'new_link' => true
				);
				
				$prefix = $config['Database']['tableprefix'];
				$this->_cookie_prefix = $config['Misc']['cookieprefix'];
				$options = array(
				    'debug'       => 2,
				    'portability' => MDB2_PORTABILITY_ALL,
				);
	
				$db = MDB2::connect($dsn, $options);
	
				if (PEAR::isError($this->_db)) {
				    die($this->_db->getMessage());
				}
				
				$res =& $db->query ('SELECT p.pagetext, p.dateline, p.userid, u.username, u.homepage, av.avatarpath
					FROM `'. $prefix. 'post` as p 
					LEFT JOIN `'. $prefix. 'user` as u ON p.userid = u.userid
					LEFT JOIN `'. $prefix. 'avatar` AS av ON av.avatarid = u.avatarid
					WHERE p.threadid = ' . $thread_id . ' and p.visible = 1 GROUP BY p.postid ORDER BY dateline ASC LIMIT 1, 200');
				
				require_once (VIVVO_FS_FRAMEWORK . 'PEAR/HTML/BBCodeParser.php');
				$parser = new HTML_BBCodeParser();
				$parser->setOption('filters', 'Basic,Extended,Images,Links,Lists,Email');
				$parser->addFilters($parser->_options['filters']);
					
				while ($row = $res->fetchRow(MDB2_FETCHMODE_ASSOC)){
					$row['dateline'] = format_time($row['dateline']);\
					$parser->setText($row['pagetext']);
					$parser->parse();
					$row['pagetext'] = $parser->getParsed();
					if ($row['avatarpath'] != ''){
						$row['avatar_url'] = VIVVO_PLUGIN_VB_USER_URL . $row['avatarpath'];
					}else{
						$row['avatar_url'] = VIVVO_PLUGIN_VB_USER_URL . 'image.php?u=' . $row['userid'];
					}
					$this->data[] = $row;
				}
				$this->_template->assign('comment_list', $this->data);
				$this->_template->assign('thread_id', $thread_id);
				
				$res1 =& $db->query ('SELECT COUNT(*)
					FROM `'. $prefix. 'post` as p 
					WHERE p.threadid = ' . $thread_id . ' and p.visible = 1');
				
				$num_of_comments = $res1->fetchOne() - 1;
				$this->_template->assign('number_of_comments', $num_of_comments);
			}
		}
	}
?>