<?php
/* =============================================================================
 * $Revision: 2270 $
 * $Date: 2007-10-05 18:25:41 +0200 (Fri, 05 Oct 2007) $
 * 
 * Vivvo CMS 4.0 
 * Copyright 2005-07 SpoonLabs d.o.o.
 * http://www.spoonlabs.com, All Rights Reserved
 * 
 * Warning: This program is protected by copyright law. Unauthorized
 * reproduction or distribution of this program, or any portion of it, may
 * result in severe civil and criminal penalties, and will be prosecuted to the
 * maximum extent possible under the law. For more information about this
 * script or other scripts see http://www.spoonlabs.com
 * ============================================================================ 
 */


/**
 * Vivvo CMS
 *
 * LICENSE: 
 *
 * @package    Vivvo
 * @subpackage core
 * @author     Slobodan Utvic <utvara@spoonlabs.com>
 * @copyright  Spoonlbas
 * @license    http://www.vivvo.net/license.php
 * @version    0.1
 * @category   CMS
 */

	/** 
	 * Users object 
	 * 
	 * @license      http://www.vivvo.net/license.php 
	 * @copyright      SpoonLabs 
	 * @author      Vedran Martinovic <vmartinovic@spoonlabs.com> 
	 * @author      Slobodan Utvic <utvara@spoonlabs.com> 
	 * @see      vivvo_post_object 
	 * @version      Vivvo Lite - Generic Database Engine
	 */
	class vb_user extends vivvo_post_object {
		
		var $id_key = 'userid';
		var $_sql_table = 'users';
		
		var $id;
		
		/**
		 * userid 
		 * Database field type:	int(9) 
		 * Null status:		
		 *
		 * @var	integer	$userid
		 */
		var $userid;
		
		/**
		 * first_name 
		 * Database field type:	varchar(25) 
		 * Null status:		
		 *
		 * @var	string	$first_name
		 */
		var $first_name;
		
		/**
		 * last_name 
		 * Database field type:	varchar(25) 
		 * Null status:		YES
		 *
		 * @var	string	$last_name
		 */
		var $last_name;
		
		var $email;
		
		/**
		 * email_address 
		 * Database field type:	varchar(35) 
		 * Null status:		YES
		 *
		 * @var	string	$email_address
		 */
		var $email_address;
		
		/**
		 * username 
		 * Database field type:	varchar(25) 
		 * Null status:		
		 *
		 * @var	string	$username
		 */
		var $username;
		
		/**
		 * password 
		 * Database field type:	varchar(255) 
		 * Null status:		
		 *
		 * @var	string	$password
		 */
		var $password;
		
		/**
		 * activated 
		 * Database field type:	enum('-1','0','1','2') 
		 * Null status:		
		 *
		 * @var	string	$activated
		 */
		var $activated;
		
		/**
		 * user_type 
		 * Database field type:	int(3) 
		 * Null status:		
		 *
		 * @var	integer	$user_type
		 */
		var $user_type;
		
		/**
		 * category_id 
		 * Database field type:	int(6) 
		 * Null status:		
		 *
		 * @var	integer	$category_id
		 */
		var $category_id = 0;
		
		/**
		 * picture 
		 * Database field type:	varchar(100) 
		 * Null status:		YES
		 *
		 * @var	string	$picture
		 */
		var $picture = 1;
		
		/**
		 * bio 
		 * Database field type:	text 
		 * Null status:		YES
		 *
		 * @var	string	$bio
		 */
		var $bio;
		
		/**
		 * www 
		 * Database field type:	varchar(100) 
		 * Null status:		YES
		 *
		 * @var	string	$www
		 */
		var $www;
		var $homepage;
		/**
		 * logins 
		 * Database field type:	int(9) 
		 * Null status:		
		 *
		 * @var	integer	$logins
		 */
		var $logins;
		
		/**
		 * last_login 
		 * Database field type:	datetime 
		 * Null status:		
		 *
		 * @var	string	$last_login
		 */
		var $last_login;
		
		/**
		 * session_id 
		 * Database field type:	varchar(32) 
		 * Null status:		YES
		 *
		 * @var	string	$session_id
		 */
		var $session_id;
		
		var $created;
		
		var $joindate;
		var $lastvisit;
		var $membergroupids;
		var $usergroupid;
		var $salt;
		var $group = array ();
		var $avatarpath;
		
		/**
		 * Sets {@link $userid}
		 *
		 * @param	integer	$userid
		 */
		function set_id($userid){
			$this->userid = $userid;
			return true;
		}
	
		/**
		 * Sets {@link $userid}
		 *
		 * @param	integer	$userid
		 */
		function set_userid($userid){
			$this->userid = $userid;
			return true;
		}
	
		/**
		 * Sets {@link $first_name}
		 *
		 * @param	string	$first_name
		 */
		function set_first_name($first_name){
			$this->first_name = $first_name;
			return true;
		}
	
		/**
		 * Sets {@link $last_name}
		 *
		 * @param	string	$last_name
		 */
		function set_last_name($last_name){
			$this->last_name = $last_name;
			return true;
		}
	
		/**
		 * Sets {@link $email_address}
		 *
		 * @param	string	$email_address
		 */
		function set_email_address($email_address){
			$email_address = strtolower($email_address);
			if (!preg_match("/^[-_a-z0-9]+(\.[-_a-z0-9]+)*@[-a-z0-9]+(\.[-a-z0-9]+)*\.[a-z]{2,6}$/", $email_address)){
				$this->email_address = $email_address;
				return false;
			}else{
				$this->email_address = $email_address;	
				return true;
			}
		}
	
		function set_email($email) {
			$this->set_email_address($email);
		}
		
		function set_homepage($homepage){
			return $this->set_www($homepage);
		}
		
		/**
		 * Sets {@link $username}
		 *
		 * @param	string	$username
		 */
		function set_username($username){
			if ($username != ''){
				$this->username = $username;
				return true;
			}else{
				return false;
			}
		}
	
		/**
		 * Sets {@link $password}
		 *
		 * @param	string	$password
		 */
		function set_password($password){
			$this->password = $password;
			return true;
		}
	
		/**
		 * Sets {@link $activated}
		 *
		 * @param	string	$activated
		 */
		function set_activated($activated){
			$this->activated = $activated;
			return true;
		}
	
		/**
		 * Sets {@link $user_type}
		 *
		 * @param	integer	$user_type
		 */
		function set_user_type($user_type){
			$ag = array_intersect($this->group, explode(',', VIVVO_PLUGIN_VB_USER_ADMIN_GROUPS));
			$eg = array_intersect($this->group, explode(',', VIVVO_PLUGIN_VB_USER_EDITOR_GROUPS));
			$twg = array_intersect($this->group, explode(',', VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS));
			$wg = array_intersect($this->group, explode(',', VIVVO_PLUGIN_VB_USER_WRITER_GROUPS));
			$pmg = array_intersect($this->group, explode(',', VIVVO_PLUGIN_VB_USER_PREMIUM_MEMBER_GROUPS));
			$mg = array_intersect($this->group, explode(',', VIVVO_PLUGIN_VB_USER_MEMBER_GROUPS));
			if (!empty($ag)){
				$this->user_type = 2; 
			}elseif (!empty($eg)){
				if ($this->user_type != 2) $this->user_type = 1;
			}elseif (!empty ($twg)){
				if ($this->user_type != 2 && $this->user_type != 1) $this->user_type = 3;
			}elseif (!empty ($wg)){
				if ($this->user_type != 2 && $this->user_type != 1 && $this->user_type != 3) $this->user_type = 0;
			}elseif (!empty ($pmg)){
				if ($this->user_type != 2 && $this->user_type != 1 && $this->user_type != 3 && $this->user_type != 0) $this->user_type = 5;
			}elseif (!empty ($mg)){
				if ($this->user_type != 2 && $this->user_type != 1 && $this->user_type != 3 && $this->user_type != 0 && $this->user_type != 5) $this->user_type = 4;
			}else{
				if (!is_numeric($this->user_type)) $this->user_type = -1;
			}
			return true;
		}
	
		/**
		 * Sets {@link $category_id}
		 *
		 * @param	integer	$category_id
		 */
		function set_category_id($category_id){
			$this->category_id = $category_id;
			return true;
		}
	
		/**
		 * Sets {@link $picture}
		 *
		 * @param	string	$picture
		 */
		function set_picture($picture){
			$this->picture = 1;
			return true;
		}
	
		
		/**
		 * Sets {@link $bio}
		 *
		 * @param	string	$bio
		 */
		function set_bio($bio){
			$this->bio = $bio;
			return true;
		}
	
		/**
		 * Sets {@link $www}
		 *
		 * @param	string	$www
		 */
		function set_www($www){
			$this->www = $www;
			return true;
		}
	
		/**
		 * Sets {@link $logins}
		 *
		 * @param	integer	$logins
		 */
		function set_logins($logins){
			$this->logins = $logins;
			return true;
		}
	
		/**
		 * Sets {@link $last_login}
		 *
		 * @param	string	$last_login
		 */
		function set_last_login($last_login){
			$this->last_login = $last_login;
			return true;
		}
	
		function set_lastvisit($lastvisit){
			return $this->set_last_login(date('Y-m-d H:i:s', $lastvisit));
		}
		
		/**
		 * Sets {@link $session_id}
		 *
		 * @param	string	$session_id
		 */
		function set_session_id($session_id){
			$this->session_id = $session_id;
			return true;
		}
		
		/**
		 * Sets {@link $created}
		 *
		 * @param	string	$created
		 */
		function set_created($created){
			$this->created = $created;
			return true;
		}
		
		function set_joindate($joindate){
			return $this->set_created(date('Y-m-d H:i:s', $joindate));
		}
	
		function set_membergroupids($membergroupsids){
			$this->group = array_merge($this->group, explode(',', $membergroupids));
			$this->set_user_type(0);
		}
		
		function set_usergroupid($usergroupid){
			$this->group = array_merge($this->group, explode(',', $usergroupid));
			$this->set_user_type(0);
		}
	
		function set_salt($salt){
			$this->salt = $salt;
		}
		
		function set_avatarpath($avatarpath){
			$this->avatarpath = $avatarpath;
		}
		
		/** 
		 * Gets $userid
		 *
		 * @return	integer
		 */
		function get_id(){
			return $this->userid;
		}
	
		/** 
		 * Gets $userid
		 *
		 * @return	integer
		 */
		function get_userid(){
			return $this->userid;
		}
		/** 
		 * Gets $first_name
		 *
		 * @return	string
		 */
		function get_first_name(){
			return '';
		}
		/** 
		 * Gets $last_name
		 *
		 * @return	string
		 */
		function get_last_name(){
			return '';
		}
		/** 
		 * Gets $email_address
		 *
		 * @return	string
		 */
		function get_email_address(){
			return $this->email_address;
		}
		/** 
		 * Gets $username
		 *
		 * @return	string
		 */
		function get_username(){
			return $this->username;
		}
		/** 
		 * Gets $password
		 *
		 * @return	string
		 */
		function get_password(){
			return $this->password;
		}
		/** 
		 * Gets $activated
		 *
		 * @return	string
		 */
		function get_activated(){
			return $this->activated;
		}
		/** 
		 * Gets $user_type
		 *
		 * @return	integer
		 */
		function get_user_type(){
			return $this->user_type;
		}
		
		function get_group_name (){
			return $this->_site_manager->_lang->get_value('LNG_USER_GROUP_' . $this->user_type);
		}
		
		/** 
		 * Gets $category_id
		 *
		 * @return	integer
		 */
		function get_category_id(){
			return 0;
		}
		/** 
		 * Gets $picture
		 *
		 * @return	string
		 */
		function get_picture(){
			return 1;
		}
		
		function get_picture_href($size = 'summary_large'){
			if ($this->avatarpath != ''){
				return VIVVO_PLUGIN_VB_USER_URL . $this->avatarpath;
			}else{
				return VIVVO_PLUGIN_VB_USER_URL . 'image.php?u=' . $this->userid;
			}
		}
		
		/** 
		 * Gets $bio
		 *
		 * @return	string
		 */
		function get_bio(){
			return $this->bio;
		}
		/** 
		 * Gets $www
		 *
		 * @return	string
		 */
		function get_www(){
			return $this->www;
		}
		/** 
		 * Gets $logins
		 *
		 * @return	integer
		 */
		function get_logins(){
			return 0;
		}
		/** 
		 * Gets $last_login
		 *
		 * @return	string
		 */
		function get_last_login(){
			return $this->last_login;
		}
		/** 
		 * Gets $session_id
		 *
		 * @return	string
		 */
		function get_session_id(){
			return '';
		}
		
		/** 
		 * Gets $created
		 *
		 * @return	string
		 */
		function get_created(){
			return $this->created;
		}
		
		function get_name(){
			return $this->username;
		}
		
		function get_href(){
			if (VIVVO_FRIENDY_URL == 1) {
	             return 'author/' . $this->username . '/';
	           } else {
	             return 'index.php?author='.$this->get_id();
	           }
		}

		function get_login_hash(){
			return md5($this->userid . $this->salt  . VIVVO_PLUGIN_VB_USER_COOKIE_SALT);
		}
		
		function get_admin_logout_url(){
			return VIVVO_PLUGIN_VB_USER_URL . 'login.php?do=logout&logouthash=' . $this->get_login_hash();
		}
		
		/** 
		 * Gets $keywords
		 *
		 * @return	string
		 */
		function get_keywords(){
			return $this->get_name() . ',' . VIVVO_WEBSITE_TITLE;
		}
		/** 
		 * Gets $description
		 *
		 * @return	string
		 */
		function get_description(){
			return $this->get_name() . ' on ' . VIVVO_WEBSITE_TITLE;
		}

		function is_admin(){
			return ($this->user_type == 2);
		}
		
		function is_editor(){
			return ($this->user_type == 1 || $this->user_type == 2);
		}
		
		function is_writer(){
			return ($this->user_type == 0);
		}
		
		function is_trusted_writer(){
			return ($this->user_type == 3);
		}
		
		function is_member(){
			return ($this->user_type == 4 || $this->user_type == 5);
		}
		
		function is_premium_member(){
			return ($this->user_type == 5);
		}
		
		function on_delete(){
			
		}
	}
	
	/**
	 * User list
	 *
	 * @license http://www.vivvo.net/license.php
	 * @copyright SpoonLabs
	 * @package Vivvo
	 * @subpackage core
	 * @author Slobodan Utvic <utvara@spoonlabs.com>
	 * @version    0.1
 	 * @category   CMS
	 * @see vivvo_db_list
	 */	
	class vb_user_list extends vivvo_db_paged_list  {
		var $post_object_type = 'vb_user';
		var $_prefix;
		var $_cookie_prefix;
		var $id_key = 'userid';
		var $_sql_table = 'user';
		
		function _default_query(){
			$this->_query->add_fields('u.*');
			$this->_query->add_fields('av.avatarpath');
			$this->_query->set_from(
					$this->_prefix . 'user AS u LEFT JOIN ' . $this->_prefix . 'avatar AS av ON u.avatarid = av.avatarid'
			);
			$this->_query->add_group_by(' u.userid ');
		}

		/**
		 * Secure filter for SELECT query
		 *
		 * @param	string	$type
		 * @param	string	$condition
		 */
		function add_filter($type, $condition = ''){
			
			$condition = secure_sql($condition);
			
			switch ($type){
				case 'userid':
					$condition = secure_sql_in($condition);
					$this->_query->add_where('(u.userid IN (' . $condition . '))');
				break;
				case 'first_name':
					$this->_query->add_where('(username = \'' . $condition . '\')');
				break;
				case 'last_name':
					$this->_query->add_where('(username = \'' . $condition . '\')');
				break;
				case 'name':
					$condition = str_replace('%', '\%', $condition);
					$this->_query->add_where('username LIKE \'%' . $condition . '%\'');
				break;
				case 'email_address':
					$this->_query->add_where('(email = \'' . $condition . '\')');
				break;
				case 'username':
					$this->_query->add_where('(username = \'' . $condition . '\')');
				break;
				case 'password':
					$this->_query->add_where('(password = \'' . $condition . '\')');
				break;
				case 'activated':
					$this->_query->add_where('(activated = \'' . $condition . '\')');
				break;
				case 'user_type':
					$condition = explode (',', $condition);
					$new_condition = '';
					
					if (in_array(2, $condition)){
						$new_condition .= VIVVO_PLUGIN_VB_USER_ADMIN_GROUPS . ',';	
					}
					if (in_array(1, $condition)){
						$new_condition .= VIVVO_PLUGIN_VB_USER_EDITOR_GROUPS . ',';
					}
					if (in_array(3, $condition)){
						$new_condition .= VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS . ',';
					}
					if (in_array(0, $condition)){
						$new_condition .= VIVVO_PLUGIN_VB_USER_WRITER_GROUPS . ',';
					}
					if (in_array(4, $condition)){
						$new_condition .= VIVVO_PLUGIN_VB_USER_PREMIUM_MEMBER_GROUPS . ',';
					}
					if (in_array(4, $condition)){
						$new_condition .= VIVVO_PLUGIN_VB_USER_MEMBER_GROUPS . ',';
					}
					
					$new_condition = trim ($new_condition, ',');

					$this->_query->add_where('(membergroupids IN (' . $new_condition . ') OR usergroupid IN (' . $new_condition . '))');
				break;
				case 'category_id':
					//$this->_query->add_where('(category_id = \'' . $condition . '\')');
				break;
				case 'picture':
					//$this->_query->add_where('(picture = \'' . $condition . '\')');
				break;
				case 'bio':
					//$this->_query->add_where('(bio = \'' . $condition . '\')');
				break;
				case 'www':
					$this->_query->add_where('(homepage = \'' . $condition . '\')');
				break;
				case 'logins':
					//$this->_query->add_where('(logins = \'' . $condition . '\')');
				break;
				case 'last_login':
					$this->_query->add_where('(lastvisit = \'' . $condition . '\')');
				break;
				case 'session_id':
					//$this->_query->add_where('(session_id = \'' . $condition . '\')');
				break;
				case 'concat_first_last':
					///TODO: kako ovo resisti ????
					$this->_query->add_where('username = \'' . $condition .'\'');
				break;
				case 'created_before':
					$this->_query->add_where('(joindate < (DATE_SUB(NOW(), INTERVAL ' . $condition . '  DAY)))');
				break;
				case 'created_after':
					$this->_query->add_where('(joindate > (DATE_SUB(NOW(), INTERVAL ' . $condition . '  DAY)))');
				break;
				case 'md5':
					$this->_query->add_where("md5( concat( `email` , `username` , `joindate` ) ) = '$condition'");
				break;
	
			}
		}
		
		
		/**
		 * Advaced search list generator
		 *
		 * @param	array	$params	Search parameters
		 * @param	string	$order	Order parameters
		 * @param	integer	$limit	Limit
		 * @param	integer	$offset	Offset
		 * @return	array	Array of articles
		 */
		function &search($params, $order='', $direction = 'ascending', $limit =0, $offset =0, $set_list = true){				
			//search_query	
			if (isset($params['search_id'])){
				if (is_array($params['search_id'])){
					if (!in_array(0, $params['search_id'])){
						$params['search_id'] = implode(',', $params['search_id']);
						$this->add_filter('userid',$params['search_id']);
					}
				}else{
					if ($params['search_id'] != 0){
						$this->add_filter('userid',$params['search_id']);
					}
				}
				$this->add_generator_option('search_id', $params['search_id']);
			}
	
			if (isset($params['search_first_name'])){
				$this->add_filter('first_name',$params['search_first_name']);
				$this->add_generator_option('search_first_name', $params['search_first_name']);
			}
			if (isset($params['search_last_name'])){
				$this->add_filter('last_name',$params['search_last_name']);
				$this->add_generator_option('search_last_name', $params['search_last_name']);
			}
			if (isset($params['search_email_address'])){
				$this->add_filter('email_address',$params['search_email_address']);
				$this->add_generator_option('search_email_address', $params['search_email_address']);
			}
			if (isset($params['search_username'])){
				$this->add_filter('username',$params['search_username']);
				$this->add_generator_option('search_username', $params['search_username']);
			}
			if (isset($params['search_activated']) && ($params['search_activated'] != '')){
				$this->add_filter('activated',$params['search_activated']);
				$this->add_generator_option('search_activated', $params['search_activated']);
			}
			if (isset($params['search_user_type'])){
				if (is_array($params['search_user_type']) && (count ($params['search_user_type']) < 2)){
					$params['search_user_type'] = implode($params['search_user_type']);
				}
				if (is_array($params['search_user_type'])){
					if (!in_array('', $params['search_user_type'])){
						$params['search_user_type'] = implode(',', $params['search_user_type']);
						$this->add_filter('user_type',$params['search_user_type']);
					}
				}elseif ($params['search_user_type'] == 'staff'){
					$params['search_user_type'] = '0,1,2,3';
					$this->add_filter('user_type',$params['search_user_type']);
				}elseif ($params['search_user_type'] == 'members'){
					$params['search_user_type'] = '4,5';
					$this->add_filter('user_type',$params['search_user_type']);
				}else{
					if ($params['search_user_type'] != ''){
						$this->add_filter('user_type',$params['search_user_type']);
					}
				}
				$this->add_generator_option('search_user_type', $params['search_user_type']);
			}
			if (isset($params['search_last_login'])){
				$this->add_filter('last_login',$params['search_last_login']);
				$this->add_generator_option('search_last_login', $params['search_last_login']);
			}
			
			if (isset($params['search_query']) && !empty($params['search_query'])){
				$this->add_filter('name',$params['search_query']);
				$this->add_generator_option('search_query', $params['search_query']);
			}
			
			if (intval($params['search_search_date']) !== 0){
				$this->add_filter((($params['search_before_after'] === '1') ? 'created_before' : 'created_after'), $params['search_search_date']);
				$this->add_generator_option('search_before_after', $params['search_before_after']);
				$this->add_generator_option('search_search_date', $params['search_search_date']);				
			}
	
				
			// search order //
			$search_direction = ($direction === 'descending') ? ' DESC' : ' ASC';
	
			switch ($order){
				case 'id':
					$this->_query->add_order('userid' . $search_direction);
					break;
				case 'first_name':
					$this->_query->add_order('username' . $search_direction);
					break;
				case 'last_name':
					$this->_query->add_order('username' . $search_direction);
					break;
				case 'email_address':
					$this->_query->add_order('email' . $search_direction);
					break;
				case 'username':
					$this->_query->add_order('username' . $search_direction);
					break;
				case 'password':
					$this->_query->add_order('password' . $search_direction);
					break;
				case 'activated':
					$this->_query->add_order('userid' . $search_direction);
					break;
				case 'user_type':
					$this->_query->add_order('userid' . $search_direction);
					break;
				case 'category_id':
					$this->_query->add_order('userid' . $search_direction);
					break;
				case 'picture':
					$this->_query->add_order('userid' . $search_direction);
					break;
				case 'bio':
					$this->_query->add_order('userid' . $search_direction);
					break;
				case 'www':
					$this->_query->add_order('homepage' . $search_direction);
					break;
				case 'logins':
					$this->_query->add_order('userid' . $search_direction);
					break;
				case 'last_login':
					$this->_query->add_order('lastlogin' . $search_direction);
					break;
				case 'session_id':
					$this->_query->add_order('userid' . $search_direction);
					break;
				case 'name':
					$this->_query->add_order('username' . $search_direction);
					break;
				case 'random':
					$this->_query->add_order('rand( )' . $search_direction);
					break;
				default:
					$order = 'id';	
					$this->_query->add_order('userid' . ' DESC');
					break;
			}
			$this->add_order_option($order, $direction);
						
			$limit = (int) $limit;
			$this->_query->set_limit($limit);
			$offset = (int) $offset;
			$this->_query->set_offset($offset);
			$this->_default_query(true);
	
			if ($set_list){
				$this->set_list();
				return $this->list;
			}
		}
		
		function get_author_by_name_concat($name){
			$this->_default_query();
			$this->add_filter('concat_first_last' , $name);
			$this->_query->add_order('username');
			$this->add_order_option('username');
			$this->set_list();
			if (!empty($this->list)){
				return current($this->list);
			}else{
				return false;
			}
		}
	
		function get_author_by_exact_name($e_name){
			$this->_default_query();
			$this->add_filter('username' , $e_name);
			$this->add_filter('user_type', '0,1,2,3');
			$this->set_list();
			if (!empty($this->list)){
				return current($this->list);
			}else{
				return false;
			}
		}
			
		function get_user_by_exact_name($e_name){
			$this->_default_query();
			$this->add_filter('username' , $e_name);
			$this->set_list();
			if (!empty($this->list)){
				return current($this->list);
			}else{
				return false;
			}
		}
		
		function get_user_from_session(){
			$um = $this->_site_manager->get_url_manager();
			$session_id = $um->get_param($this->_cookie_prefix . 'sessionhash');
			if ($session_id){
				$sql = 'SELECT userid FROM ' . $this->_prefix . 'session WHERE sessionhash=\'' . $session_id . '\'';
				$res = $this->_db->query($sql);
				if (!PEAR::isError($res)){
					$session_user_id = $res->fetchOne();
				}else{
					return false;
				}
				
				if ($session_user_id > 0){
					return $this->get_user_by_id($session_user_id);
				}
			}
			return false;
		}
		
		function get_user_by_id($id){
			$id = (int) $id;
			$this->_default_query();
			$this->add_filter('userid' , $id);
			$this->set_list();
			if (!empty($this->list)){
				return current($this->list);
			}else{
				return false;
			}
		}
		
		function get_author_by_id($id){
			$id = (int) $id;
			$this->_default_query();
			$this->add_filter('userid' , $id);
			$this->add_filter('user_type', '0,1,2,3');
			$this->set_list();
			if (!empty($this->list)){
				return current($this->list);
			}else{
				return false;
			}
		}
		
		
		function get_users_by_ids($ids){
			$val = trim(implode(',', $ids));
			if (empty($val)){
				return false;
			}
			$this->search(array('search_id'=>$ids));
			if (empty($this->list)){
				return false;
			}else{
				return $this->list;
			}
		}
		
		function get_user_data($username = null, $passwd = null){
			if (($username != null) && ($passwd != null)){
				$passwd = md5($passwd);		
				$this->_default_query();		
				$this->add_filter('username' , $username);
				$this->add_filter('password' , $passwd);
				$this->set_list();
				
				if (!empty($this->list)){
					return current($this->list);
				}else{
					return false;
				}
			}else{
				return false;
			}
		}
	
		function get_email_exists($email_address){
			$this->_default_query();
			$this->add_filter('email_address' , $email_address);
			$this->set_list();
			if (!empty($this->list)){
				return true;
			}else{
				return false;
			}
		}
		
		function get_user_exists($username){
			$this->_default_query();
			$this->add_filter('username' , $username);
			$this->set_list();
			if (!empty($this->list)){
				return true;
			}else{
				return false;
			}
		}
		
		function &get_user_by_md5($param){
			$this->_default_query();
			$this->add_filter('md5' , $param );
	
			$this->set_list();
			if (!empty($this->list)){
				return  current($this->list);
			}else{
				return false;
			}
		}
		
		function get_search_params(&$sm, $in_params){
			$params = array ();
			
			if (!empty($in_params['search_limit'])){
				$params['search_limit'] = $in_params['search_limit'];
			}else{
				$params['search_limit'] = 10;
			}
			
			$params['search_options'] = array();
			
			if (isset($in_params['search_options']) && is_array($in_params['search_options']) && !empty($in_params['search_options'])) $params['search_options'] = $in_params['search_options'];  
			
			if (!empty($in_params['search_id'])) $params['search_options']['search_id'] = $in_params['search_id'];
			if (isset($in_params['search_user_type'])) $params['search_options']['search_user_type'] = $in_params['search_user_type'];
			if (defined('VIVVO_ADMIN_MODE')){
				if (!empty($in_params['search_query'])) $params['search_options']['search_query'] = $in_params['search_query'];
				if (isset($in_params['search_activated'])) $params['search_options']['search_activated'] = $in_params['search_activated'];
				if (!empty($in_params['search_search_date'])) $params['search_options']['search_search_date'] = $in_params['search_search_date'];
				if (!empty($in_params['search_before_after'])) $params['search_options']['search_before_after'] = $in_params['search_before_after'];
			}else{
				$params['search_options']['search_activated'] = 1;
			}
			
			if (!empty($in_params['search_sort_by'])){
				$params['search_sort_by'] = $in_params['search_sort_by'];
			}else{
				$params['search_sort_by'] = 'userid';
			}
			
			if (isset($in_params['search_order']) && !empty($in_params['search_order'])){
				$params['search_order'] = $in_params['search_order'];
			}else{
				$params['search_order'] = 'descending';
			}
			
			if (isset($in_params['pg'])){
				$cur_page = (int) $in_params['pg'];
			}
			if (empty($cur_page)) $cur_page=1;
			
			$params['pg'] = $cur_page;
			
			$params['offset'] = ($cur_page-1) * $params['search_limit'];
			if (empty($params['offset'])) $params['offset'] = 0;
	
			if (!empty($in_params['cache'])) $params['cache'] = $in_params['cache'];
			
			return $params;
		}
		
		function get_search_params_from_url(&$sm){
			$um =& $sm->get_url_manager();
			$params = vb_user_list::get_search_params($sm, $um->list);
			return $params;
		}
		
		function get_admin_login_tempalte(){
			return 'plugins/vb_users/admin/templates/vb_login.tpl';
		}
		
		function get_login_tempalte(){
			return 'box/vb_login.tpl';
		}
		
		function set_db(){
			global $config;			
			require (VIVVO_PLUGIN_VB_USER_FS_ROOT . 'includes/config.php');

			require_once(VIVVO_FS_FRAMEWORK . 'PEAR/MDB2.php');
			$dsn = array(
			    'phptype'  => $config['Database']['dbtype'],
			    'username' => $config['MasterServer']['username'],
			    'password' => $config['MasterServer']['password'],
			    'hostspec' => $config['MasterServer']['servername'],
			    'database' => $config['Database']['dbname'],
			    'new_link' => true
			);
			
			$this->_prefix = $config['Database']['tableprefix'];
			$this->_cookie_prefix = $config['Misc']['cookieprefix'];
			$options = array(
			    'debug'       => 2,
			    'portability' => MDB2_PORTABILITY_ALL,
			);

			$this->_db = MDB2::connect($dsn, $options);

			if (PEAR::isError($this->_db)) {
			    die($this->_db->getMessage());
			}
		}
		
		function vb_user_list(&$site_manager){
			if ($site_manager){
				$this->set_site_manager($site_manager);
				$this->set_db();
				$this->set_query();
			}
		}
	}
?>