<?php
/* =============================================================================
 * $Revision: 2254 $
 * $Date: 2007-10-04 15:55:59 +0200 (Thu, 04 Oct 2007) $
 * 
 * Vivvo CMS 4.0 
 * Copyright 2005-07 SpoonLabs d.o.o.
 * http://www.spoonlabs.com, All Rights Reserved
 * 
 * Warning: This program is protected by copyright law. Unauthorized
 * reproduction or distribution of this program, or any portion of it, may
 * result in severe civil and criminal penalties, and will be prosecuted to the
 * maximum extent possible under the law. For more information about this
 * script or other scripts see http://www.spoonlabs.com
 * ============================================================================ 
 */



/**
 * @see  'vivvo_plugin.php'
 */
require_once(VIVVO_FS_FRAMEWORK . 'vivvo_plugin.php');

	/**
	 * Plugin class
	 *
	 * @license		http://www.vivvo.net/license.php
	 * @copyright	SpoonLabs
	 * @package		Vivvo
	 * @subpackage	plugin
	 * @version		0.1
	 * @category	CMS
	 * @author		Slobodan Utvic <utvara@spoonlabs.com>
	 * @author		Vedran Martinovic <vmartinovic@spoonlabs.com>
	 */
	
	Class vb_users_definition extends plugin{
		
		/**
		 * Plugin identifyer
		 *
		 * @var string
		 */
		var $plugin_name = 'vb_users';
		
		/**
		 * Install feed importer
		 *
		 * @param vivvo_site $site_manager
		 * @param integer $step
		 */
		function install(&$site_manager, $step = 1){
			if ($step == ''){
				$step = 1;
			}
			global $config;
			
			$plugin_root_dir = dirname(__FILE__) . '/';
			$plugin_root_dir = substr($plugin_root_dir, strlen(VIVVO_FS_ROOT));
			$plugin_root_dir = str_replace('\\', '/', $plugin_root_dir);
			
			$lang =& $site_manager->get_lang();
			$lang->load_lang(VIVVO_ADMIN_LANG, $plugin_root_dir . 'admin/lang/');
			
			$template =& $site_manager->get_template();
			
			$template->assign('PLUGIN_ROOT', $plugin_root_dir);
			
			$content_template =& new template($site_manager, $template);
			
			$lang =& $site_manager->get_lang();
			$lang->load_lang(VIVVO_ADMIN_LANG, $plugin_root_dir . 'admin/lang/');	
			
			if ($step == 4){
				require_once(VIVVO_FS_FRAMEWORK . 'vivvo_post.php');
				$db =& $site_manager->get_db();
				$pm =& new vivvo_post_master($site_manager);
				$dbm =& $site_manager->get_db_manager();
				$um =& $site_manager->get_url_manager();
				$continue = false;

				require_once(VIVVO_FS_FRAMEWORK . 'vivvo_preference.php');
				
				$vb_config =& new preferences($site_manager);
					
				$vb_config_list =& new preferences_list($site_manager);
				if (!$vb_config_list->get_preference_by_all_variable('name','','vb_users','plugins',1)){
					$vb_config->set_variable_name('name');
					$vb_config->set_variable_property(NULL);
					$vb_config->set_variable_value('vb_users');
					$vb_config->set_module('plugins');
					$vb_config->set_domain_id(1);
					$pm->set_data_object($vb_config);
					$pm->sql_insert();
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if (!$vb_config_list->get_preference_by_all_variable('root_dir','', $plugin_root_dir, 'vb_users',1)){
					$vb_config->set_variable_name('root_dir');
					$vb_config->set_variable_property(NULL);
					$vb_config->set_variable_value($plugin_root_dir);
					$vb_config->set_module('vb_users');
					$pm->set_data_object($vb_config);
					$pm->sql_insert();
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if (!$vb_config_list->get_preference_by_all_variable('name','','vBulletin users','vb_users',1)){
					$vb_config->set_variable_name('name');
					$vb_config->set_variable_property(NULL);
					$vb_config->set_variable_value('vBulletin users');
					$vb_config->set_module('vb_users');
					$pm->set_data_object($vb_config);
					$pm->sql_insert();
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				$conf =& $vb_config_list->get_preference_by_all_variable('VIVVO_USER_SOURCE','','','',1);
				if ($conf){
					$conf->set_variable_value('vb@localhost');
					$pm->set_data_object($conf);
					$pm->sql_update();
					HTTP_Session::pause();
					header('Location:index.php');
					exit;
				}
			}elseif ($step == 3){
				require_once(VIVVO_FS_FRAMEWORK . 'vivvo_post.php');
				$db =& $site_manager->get_db();
				$pm =& new vivvo_post_master($site_manager);
				$dbm =& $site_manager->get_db_manager();
				$um =& $site_manager->get_url_manager();
				$continue = false;
				if ($um->get_param('VIVVO_PLUGIN_VB_USER_USER_ID') && $um->get_param('VIVVO_PLUGIN_VB_USER_FORUM_ID')){
					$VIVVO_PLUGIN_VB_USER_ADMIN_GROUPS = implode(',',$um->get_param('VIVVO_PLUGIN_VB_USER_ADMIN_GROUPS'));
					$VIVVO_PLUGIN_VB_USER_EDITOR_GROUPS = implode(',',$um->get_param('VIVVO_PLUGIN_VB_USER_EDITOR_GROUPS'));
					$VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS = implode(',',$um->get_param('VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS'));
					$VIVVO_PLUGIN_VB_USER_WRITER_GROUPS = implode(',',$um->get_param('VIVVO_PLUGIN_VB_USER_WRITER_GROUPS'));
					$VIVVO_PLUGIN_VB_USER_PREMIUM_MEMBER_GROUPS = implode(',',$um->get_param('VIVVO_PLUGIN_VB_USER_PREMIUM_MEMBER_GROUPS'));
					$VIVVO_PLUGIN_VB_USER_MEMBER_GROUPS = implode(',',$um->get_param('VIVVO_PLUGIN_VB_USER_MEMBER_GROUPS'));
					if (!empty($VIVVO_PLUGIN_VB_USER_ADMIN_GROUPS)){
						require_once(VIVVO_FS_FRAMEWORK . 'vivvo_preference.php');
						
						$vb_config =& new preferences($site_manager);
						
						$vb_config_list =& new preferences_list($site_manager);
						if (!$vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_USER_ID','','','',1)){
							$vb_config->set_variable_name('VIVVO_PLUGIN_VB_USER_USER_ID');
							$vb_config->set_variable_property(NULL);
							$vb_config->set_variable_value($um->get_param('VIVVO_PLUGIN_VB_USER_USER_ID'));
							$vb_config->set_module(NULL);
							$vb_config->set_domain_id(1);
							$pm->set_data_object($vb_config);
							$pm->sql_insert();
						}
						
						$vb_config_list =& new preferences_list($site_manager);
						if (!$vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_FORUM_ID','', '', '',1)){
							$vb_config->set_variable_name('VIVVO_PLUGIN_VB_USER_FORUM_ID');
							$vb_config->set_variable_property(NULL);
							$vb_config->set_variable_value($um->get_param('VIVVO_PLUGIN_VB_USER_FORUM_ID'));
							$vb_config->set_module(NULL);
							$pm->set_data_object($vb_config);
							$pm->sql_insert();
						}
						
						$vb_config_list =& new preferences_list($site_manager);
						if (!$vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_ADMIN_GROUPS','','','',1)){
							$vb_config->set_variable_name('VIVVO_PLUGIN_VB_USER_ADMIN_GROUPS');
							$vb_config->set_variable_property(NULL);
							$vb_config->set_variable_value($VIVVO_PLUGIN_VB_USER_ADMIN_GROUPS);
							$vb_config->set_module();
							$pm->set_data_object($vb_config);
							$pm->sql_insert();
						}

						$vb_config_list =& new preferences_list($site_manager);
						if (!$vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_EDITOR_GROUPS','','','',1)){
							$vb_config->set_variable_name('VIVVO_PLUGIN_VB_USER_EDITOR_GROUPS');
							$vb_config->set_variable_property(NULL);
							$vb_config->set_variable_value($VIVVO_PLUGIN_VB_USER_EDITOR_GROUPS);
							$vb_config->set_module();
							$pm->set_data_object($vb_config);
							$pm->sql_insert();
						}
					
						$vb_config_list =& new preferences_list($site_manager);
						if (!$vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS','','','',1)){
							$vb_config->set_variable_name('VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS');
							$vb_config->set_variable_property(NULL);
							$vb_config->set_variable_value($VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS);
							$vb_config->set_module();
							$pm->set_data_object($vb_config);
							$pm->sql_insert();
						}
					
						$vb_config_list =& new preferences_list($site_manager);
						if (!$vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS','','','',1)){
							$vb_config->set_variable_name('VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS');
							$vb_config->set_variable_property(NULL);
							$vb_config->set_variable_value($VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS);
							$vb_config->set_module();
							$pm->set_data_object($vb_config);
							$pm->sql_insert();
						}
					
						$vb_config_list =& new preferences_list($site_manager);
						if (!$vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_PREMIUM_MEMBER_GROUPS','','','',1)){
							$vb_config->set_variable_name('VIVVO_PLUGIN_VB_USER_PREMIUM_MEMBER_GROUPS');
							$vb_config->set_variable_property(NULL);
							$vb_config->set_variable_value($VIVVO_PLUGIN_VB_USER_PREMIUM_MEMBER_GROUPS);
							$vb_config->set_module();
							$pm->set_data_object($vb_config);
							$pm->sql_insert();
						}
					
						$vb_config_list =& new preferences_list($site_manager);
						if (!$vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_MEMBER_GROUPS','','','',1)){
							$vb_config->set_variable_name('VIVVO_PLUGIN_VB_USER_MEMBER_GROUPS');
							$vb_config->set_variable_property(NULL);
							$vb_config->set_variable_value($VIVVO_PLUGIN_VB_USER_MEMBER_GROUPS);
							$vb_config->set_module();
							$pm->set_data_object($vb_config);
							$pm->sql_insert();
						}
						
						$continue = true;
						
					}else{
						$this->set_error_code(10304);
					}
				}else{
					$this->set_error_code(10303);
				}

				if ($continue){
					$content_template->set_template_file(VIVVO_FS_ROOT . $plugin_root_dir . 'admin/templates/install/step_3.xml');
				}else{
					//Dump errors
					require (VIVVO_PLUGIN_VB_USER_FS_ROOT . 'includes/config.php');
		
					require_once(VIVVO_FS_FRAMEWORK . 'PEAR/MDB2.php');
					$dsn = array(
					    'phptype'  => $config['Database']['dbtype'],
					    'username' => $config['MasterServer']['username'],
					    'password' => $config['MasterServer']['password'],
					    'hostspec' => $config['MasterServer']['servername'],
					    'database' => $config['Database']['dbname'],
					    'new_link' => true
					);
					
					$_prefix = $config['Database']['tableprefix'];
					$_cookie_prefix = $config['Misc']['cookieprefix'];
					$options = array(
					    'debug'       => 2,
					    'portability' => MDB2_PORTABILITY_ALL,
					);
		
					$vb_db = MDB2::connect($dsn, $options);
		
					if (PEAR::isError($this->_db)) {
					    die($this->_db->getMessage());
					}
					
					$vb_res =& $vb_db->query('SELECT usergroupid, title FROM ' . $_prefix . 'usergroup ORDER BY title ASC');
					
					$groups = array();
					
					while ($row = $vb_res->fetchRow(MDB2_FETCHMODE_ASSOC)){
						$groups[] = $row;	
					}
					
					$content_template->set_template_file(VIVVO_FS_ROOT . $plugin_root_dir . 'admin/templates/install/step_2.xml');
					$content_template->assign('groups', $groups);
					$step = 2;
				}
				
			}elseif ($step == 2){
				require_once(VIVVO_FS_FRAMEWORK . 'vivvo_post.php');
				$db =& $site_manager->get_db();
				$pm =& new vivvo_post_master($site_manager);
				$dbm =& $site_manager->get_db_manager();
				$um =& $site_manager->get_url_manager();
				
				$continue = false;
				if ($um->get_param('VIVVO_PLUGIN_VB_USER_URL') && $um->get_param('VIVVO_PLUGIN_VB_USER_FS_ROOT')){
					$vb_root = $um->get_param('VIVVO_PLUGIN_VB_USER_FS_ROOT');
					$vb_root = str_replace('\\','/',$vb_root);
					if ($vb_root[strlen($vb_root) - 1] != '/') $vb_root .= '/';
					$vb_url = $um->get_param ('VIVVO_PLUGIN_VB_USER_URL'); 
					if ($vb_url[strlen($vb_url) - 1] != '/') $vb_url .= '/'; 
					if (substr($vb_url, 0, 4) != 'http') $vb_url = 'http://'. $vb_url;

					if (file_exists($vb_root . 'includes/config.php') && file_exists($vb_root . 'includes/functions.php')){
						if (include($vb_root .'includes/functions.php')){
							if (defined('COOKIE_SALT')){
								$continue = true;
							}else{
								$this->set_error_code(10301);
							}
						}else{
							$this->set_error_code(10301);
						}
					}else{
						$this->set_error_code(10301);
					}
				}else{
					$this->set_error_code(10302);
				}
								
				if ($continue){
					$db->manager->alterTable(VIVVO_DB_PREFIX . 'Articles', array('add' => array( 'vb_thread' => array( 'type' => 'integer', 'length' => '11', 'notnull' > 0))), false);
					
					require_once(VIVVO_FS_FRAMEWORK . 'vivvo_preference.php');
					
					$vb_config =& new preferences($site_manager);
					
					$vb_config_list =& new preferences_list($site_manager);
					if (!$vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_URL','','','',1)){
						$vb_config->set_variable_name('VIVVO_PLUGIN_VB_USER_URL');
						$vb_config->set_variable_property(NULL);
						$vb_config->set_variable_value($vb_url);
						$vb_config->set_module(NULL);
						$pm->set_data_object($vb_config);
						$pm->sql_insert();
					}
					
					$vb_config_list =& new preferences_list($site_manager);
					if (!$vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_FS_ROOT','','','',1)){
						$vb_config->set_variable_name('VIVVO_PLUGIN_VB_USER_FS_ROOT');
						$vb_config->set_variable_property(NULL);
						$vb_config->set_variable_value($vb_root);
						$vb_config->set_module(NULL);
						$pm->set_data_object($vb_config);
						$pm->sql_insert();
					}
					
					$vb_config_list =& new preferences_list($site_manager);
					if (!$vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_COOKIE_SALT','','','',1)){
						$vb_config->set_variable_name('VIVVO_PLUGIN_VB_USER_COOKIE_SALT');
						$vb_config->set_variable_property(NULL);
						$vb_config->set_variable_value(COOKIE_SALT);
						$vb_config->set_module(NULL);
						$pm->set_data_object($vb_config);
						$pm->sql_insert();
					}
					
					$vb_config_list =& new preferences_list($site_manager);
					if (!$vb_config_list->get_preference_by_all_variable('box_vb_comments','class_name','','',1)){
						$vb_config->set_variable_name('box_vb_comments');
						$vb_config->set_variable_property('class_name');
						$vb_config->set_variable_value('box_vb_comments');
						$vb_config->set_module('modules');
						$pm->set_data_object($vb_config);
						$pm->sql_insert();
					}
					
					$vb_config_list =& new preferences_list($site_manager);
					if (!$vb_config_list->get_preference_by_all_variable('box_vb_comments','file','','',1)){
						$vb_config->set_variable_name('box_vb_comments');
						$vb_config->set_variable_property('file');
						$vb_config->set_variable_value($plugin_root_dir . 'box.php');
						$vb_config->set_module('modules');
						$pm->set_data_object($vb_config);
						$pm->sql_insert();
					}
					
					$vb_config_list =& new preferences_list($site_manager);
					$conf =& $vb_config_list->get_preference_by_all_variable('VIVVO_COMMENTS_ENABLE','','','',1);
					if ($conf){
						$conf->set_variable_value('0');
						$pm->set_data_object($conf);
						$pm->sql_update();
					}	
					
					$vb_config_list =& new preferences_list($site_manager);
					if (!$vb_config_list->get_preference_by_all_variable('vb@localhost','user_object','vb_user','user',1)){
						$vb_config->set_variable_name('vb@localhost');
						$vb_config->set_variable_property('user_object');
						$vb_config->set_variable_value('vb_user');
						$vb_config->set_module('vb_user');
						$pm->set_data_object($vb_config);
						$pm->sql_insert();
					}
					
					$vb_config_list =& new preferences_list($site_manager);
					if (!$vb_config_list->get_preference_by_all_variable('vb@localhost','file','','user',1)){
						$vb_config->set_variable_name('vb@localhost');
						$vb_config->set_variable_property('file');
						$vb_config->set_variable_value($plugin_root_dir . 'vb_user.class.php');
						$vb_config->set_module('user');
						$pm->set_data_object($vb_config);
						$pm->sql_insert();
					}
					
					$vb_config_list =& new preferences_list($site_manager);
					if (!$vb_config_list->get_preference_by_all_variable('vb@localhost','user_list','vb_user_list','user',1)){
						$vb_config->set_variable_name('vb@localhost');
						$vb_config->set_variable_property('user_list');
						$vb_config->set_variable_value('vb_user_list');
						$vb_config->set_module('user');
						$pm->set_data_object($vb_config);
						$pm->sql_insert();
					}

					if ($handle = opendir(VIVVO_FS_PLUGIN_ROOT . $plugin_root_dir . 'templates/')) {
						while (false !== ($filename = readdir($handle))) {
							if ($filename[0] != "." && !is_dir(VIVVO_FS_PLUGIN_ROOT . $plugin_root_dir . 'templates/' . $filename)) {
			        			@copy(VIVVO_FS_PLUGIN_ROOT . $plugin_root_dir . 'templates/' . $filename, VIVVO_FS_TEMPLATE_ROOT . VIVVO_TEMPLATE_DIR . 'box/' . $filename);
							}
			        	}
			        }
					
					require ($vb_root . 'includes/config.php');
		
					require_once(VIVVO_FS_FRAMEWORK . 'PEAR/MDB2.php');
					$dsn = array(
					    'phptype'  => $config['Database']['dbtype'],
					    'username' => $config['MasterServer']['username'],
					    'password' => $config['MasterServer']['password'],
					    'hostspec' => $config['MasterServer']['servername'],
					    'database' => $config['Database']['dbname'],
					    'new_link' => true
					);
					
					$_prefix = $config['Database']['tableprefix'];
					$_cookie_prefix = $config['Misc']['cookieprefix'];
					$options = array(
					    'debug'       => 2,
					    'portability' => MDB2_PORTABILITY_ALL,
					);
		
					$vb_db = MDB2::connect($dsn, $options);
		
					if (PEAR::isError($this->_db)) {
					    die($this->_db->getMessage());
					}
					
					$vb_res =& $vb_db->query('SELECT usergroupid, title FROM ' . $_prefix . 'usergroup ORDER BY title ASC');
					
					$groups = array();
					
					while ($row = $vb_res->fetchRow(MDB2_FETCHMODE_ASSOC)){
						$groups[] = $row;	
					}
					
					$content_template->set_template_file(VIVVO_FS_ROOT . $plugin_root_dir . 'admin/templates/install/step_2.xml');
					$content_template->assign('groups', $groups);
				}else{
					//Dump errors
					$content_template->set_template_file(VIVVO_FS_ROOT . $plugin_root_dir . 'admin/templates/install/step_1.xml');
					$step = 1;
				}
			}else{
				$content_template->set_template_file(VIVVO_FS_ROOT . $plugin_root_dir . 'admin/templates/install/step_1.xml');
			}		
															
			$template->assign('content', $content_template->get_output());
			$template->assign('step', strval($step));
				
			$search_template =& new template($site_manager, $template);
			$search_template->set_template_file(VIVVO_FS_ROOT . $plugin_root_dir . 'admin/templates/install/tabs.xml');
	
			$template->assign('left', $search_template->get_output());
			
			$output = $site_manager->get_output();			
				
			echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' . "\n";
			echo $output;
		}
		
		function uninstall(&$site_manager, $step = 1){
			$plugin_root_dir = dirname(__FILE__) . '/';
			$plugin_root_dir = substr($plugin_root_dir, strlen(VIVVO_FS_ROOT));
			$plugin_root_dir = str_replace('\\', '/', $plugin_root_dir);
			
			$template =& $site_manager->get_template();
			
			$template->assign('PLUGIN_ROOT', $plugin_root_dir);
			
			$content_template =& new template($site_manager, $template);
			
			require_once(VIVVO_FS_FRAMEWORK . 'vivvo_preference.php');
			require_once(VIVVO_FS_FRAMEWORK . 'vivvo_post.php');
			
			$vb_config =& new preferences($site_manager);
			$pm =& new vivvo_post_master($site_manager);
			
			if ($step == 2){
				$content_template->set_template_file(VIVVO_FS_ROOT . $plugin_root_dir . 'admin/templates/uninstall/step_2.xml');
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_URL','','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_FS_ROOT','','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_COOKIE_SALT','','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('box_vb_comments','class_name','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('box_vb_comments','file','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('vb@localhost','user_object','vb_user','user',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('vb@localhost','file','','user',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('vb@localhost','user_list','vb_user_list','user',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_USER_ID','','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_FORUM_ID','', '', '',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_ADMIN_GROUPS','','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}

				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_EDITOR_GROUPS','','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}
			
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS','','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}
			
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_TRUSTED_WRITER_GROUPS','','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}
			
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_PREMIUM_MEMBER_GROUPS','','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}
			
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('VIVVO_PLUGIN_VB_USER_MEMBER_GROUPS','','','',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('name','','vb_users','plugins',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('root_dir','', $plugin_root_dir, 'vb_users',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				if ($vb_config_list->get_preference_by_all_variable('name','','vBulletin users','vb_users',1)){
					$vb_config_list->sql_delete_list($pm);
				}
				
				$vb_config_list =& new preferences_list($site_manager);
				$conf =& $vb_config_list->get_preference_by_all_variable('VIVVO_USER_SOURCE','','','',1);
				if ($conf){
					$conf->set_variable_value('vivvo@localhost');
					$pm->set_data_object($conf);
					$pm->sql_update();
				}

			}else{
				$content_template->set_template_file(VIVVO_FS_ROOT . $plugin_root_dir . 'admin/templates/uninstall/step_1.xml');
			}
			
			$template->assign('content', $content_template->get_output());
			$template->assign('step', strval($step));
			
			$search_template =& new template($site_manager, $template);
			$search_template->set_template_file(VIVVO_FS_ROOT . $plugin_root_dir . 'admin/templates/uninstall/tabs.xml');
	
			$template->assign('left', $search_template->get_output());
			
			$output = $site_manager->get_output();			
				
			echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' . "\n";
			echo $output;
		}
		
		function url_handler($url_array){
			return false;
		}
		
		/**
		 * Load admin javaScript 
		 * 
		 */
		function load_admin_js (){
			
		}
		
		/**
		 * Load administration content
		 * 
		 * @param vivvo_lite_site $sm
		 */
		function get_admin_content (&$sm){
			return false;
		}
		
		function get_plugin_menu_item (){
			return false;
		}
		
		function get_content(&$site_manager){
			return false;
		}
		
		function load_admin_lang(){
			$pm =& $this->_site_manager->get_plugin_manager();			
			$lang =& $this->_site_manager->get_lang();
			$lang->load_lang(VIVVO_ADMIN_LANG, $pm->plugins['vb_users']['root_dir'] . 'admin/lang/');			
		}
		
		function load_lang(){
				
		}
	}
?>