<?php
/*======================================================================*\
|| ######################################################################## ||
|| # vBulletin
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2006 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| ######################################################################## ||
\*======================================================================*/

// #############################################################################
// Set time limit, error handeling and aborting
// #############################################################################

if (function_exists('set_time_limit') AND get_cfg_var('safe_mode')==0)
{
	@set_time_limit(0);
}

ignore_user_abort(true);
error_reporting(E_ALL  & ~E_NOTICE);


// #############################################################################
// Define constants
// #############################################################################

define('IDIR', (($getcwd = getcwd()) ? $getcwd : '.'));
define('VB_AREA', 'ImpEx');


// #############################################################################
// Require config & Language
// #############################################################################

if(!is_file(IDIR . '/ImpExConfig.php'))
{
	echo 'Cannot find ImpExConfig.php, have you configured the file and renamed it ?';
	exit;
}
else
{
	require_once (IDIR . '/ImpExConfig.php');
	require_once (IDIR . $impexconfig['system']['language']);
}


// #############################################################################
// Requires
// #############################################################################

#$auth_redirect = 'index.php';
#require_once (IDIR . '/impex_auth.php');
require_once (IDIR . '/db_mysql.php');

require_once (IDIR . '/ImpExFunction.php');
require_once (IDIR . '/ImpExSession.php');
require_once (IDIR . '/ImpExController.php');
require_once (IDIR . '/ImpExDisplay.php');
require_once (IDIR . '/ImpExDisplayWrapper.php');


// #############################################################################
// Checking for standalnoe
// #############################################################################

if (file_exists('../includes/config.php'))
{
	// Running installed
	if (file_exists('../admincp/language.php'))
	{
		// admin CP directory wasn't renamed
		// this bit allows people on 3.0.0 to do an import (if they haven't renamed their admin CP dir)
		chdir('../admincp/');
	}
	else
	{
		// If the admincp was renamed, lets try and find it depending on vBulletin version
		$admincpdir = '';
		require('../includes/config.php');
		
		if (!empty($admincpdir))
		{
			// Version 3.0.x
			chdir("../{$admincpdir}/");	
		}
		else if (!empty($config['Misc']['admincpdir']))
		{
			if(is_dir("../{$config['Misc']['admincpdir']}/"))
			{
				// Version 3.5.x
				chdir("../{$config['Misc']['admincpdir']}/");
			}
			else
			{
				// The config.php path is invalid 
				die('config.php admincp path does not exsist');
			}
		}
		else
		{
			// Should never be here.
		}
	}
	
	// Get the admincp global
	require_once('./global.php');

	$usewrapper = true;
}
else
{
	// Running standalone
	chdir('../'); // make sure our includes use the same paths
	$usewrapper = false;
}


// #############################################################################
// Try to locate vBulletin config, or use ImpExConfig 
// #############################################################################

// $usewrapper is a flag for standalone, so if its true were installed
if ($usewrapper)
{
	include ('./includes/config.php');

	$using_local_config = '<p>' . $impex_phrases['using_local_config'] . '</p>';

	// Only if it is all there or a 3.5 config file
	if ($config['Database']['dbtype'] AND $config['MasterServer']['servername'] AND $config['MasterServer']['username']	AND $config['MasterServer']['password'] AND $config['Database']['dbname'])
	{
		// Over write ImpExConfig.php
		$impexconfig['target']['databasetype']	= $config['Database']['dbtype'] ? $config['Database']['dbtype'] : 'mysql';
		$impexconfig['target']['server']		= $config['MasterServer']['servername'];
		$impexconfig['target']['user']			= $config['MasterServer']['username'];
		$impexconfig['target']['password']		= $config['MasterServer']['password'];
		$impexconfig['target']['database']		= $config['Database']['dbname'];
		$impexconfig['target']['tableprefix']	= $config['Database']['tableprefix'];
	}
}
else
{
	$using_local_config = '<p>' . $impex_phrases['using_impex_config'] . '</p>';
}


// #############################################################################
// Database connect
// #############################################################################

$Db_target = new DB_Sql_vb_impex();
$Db_source = new DB_Sql_vb_impex();

$Db_target->appname 		= 'vBulletin:ImpEx Target';
$Db_target->appshortname 	= 'vBulletin:ImpEx Target';
$Db_target->database 		= $impexconfig['target']['database'];
$Db_target->type 			= $impexconfig['target']['databasetype'];

$Db_target->connect($impexconfig['target']['server'], $impexconfig['target']['user'], $impexconfig['target']['password'], 0);

$Db_target->select_db($impexconfig['target']['database']);


// #############################################################################
// Session start
// #############################################################################

$ImpEx = new ImpExController();

$session_state = $ImpEx->return_session($Db_target, $impexconfig['target']['tableprefix']);

if ($session_state)
{
	$ImpExSession = $session_state;
}
else
{
	$ImpExSession = new ImpExSession();
}


// #############################################################################
// Requires ImpExDatabase version (has to be done here as it needs the session)
// #############################################################################

switch ($ImpExSession->get_session_var('targetsystem'))
{
	case 360:
		require_once (IDIR . '/ImpExDatabase_360.php');
		break;	
	case 350:
		require_once (IDIR . '/ImpExDatabase_350.php');
		break;
	case 309:
		require_once (IDIR . '/ImpExDatabase_309.php');
		break;
	default:
		require_once (IDIR . '/ImpExDatabase_350.php');
		break;
}

// Module extends database
require_once (IDIR . '/ImpExModule.php');
require_once (IDIR . '/ImpExData.php');


// #############################################################################
// Instantiate ImpExDisplay
// #############################################################################

if($usewrapper)
{
	$ImpExDisplay = new ImpExDisplayWrapper();
}
else
{
	$ImpExDisplay = new ImpExDisplay();
}

$ImpExDisplay->phrases =& $impex_phrases;


// #############################################################################
// create vbfields
// #############################################################################

if($ImpExSession->get_session_var('vbfields') != 'done')
{
	require_once(IDIR. '/vbfields.php');
	$queries = &retrieve_vbfields_queries($impexconfig['target']['tableprefix']);
	foreach ($queries AS $query)
	{
		$Db_target->query($query);
	}

	$ImpExSession->add_session_var('vbfields', 'done');
}


// #############################################################################
// initalise error store
// #############################################################################

if($ImpExSession->get_session_var('errortable') != 'done')
{
	// Just incase the session was removed and the error table is still there.
	$Db_target->query("DROP TABLE IF EXISTS {$impexconfig['target']['tableprefix']}impexerror");

	// Create a new one.
	$error_table = "CREATE TABLE {$impexconfig['target']['tableprefix']}impexerror (
						errorid bigint(20) unsigned NOT NULL auto_increment,
						datatype varchar(50) NOT NULL default '',
						importid bigint(20) NOT NULL default 0,
						error varchar(250) default 'NULL',
						remedy varchar(250) default 'NULL',
						PRIMARY KEY (errorid)
					) TYPE=MyISAM";

	$Db_target->query($error_table);

	$ImpExSession->add_session_var('errortable', 'done');
}

$ImpExSession->_target_db =& $Db_target;


// #############################################################################
// Add vars to session
// #############################################################################

$ImpExSession->add_session_var('systempath', IDIR);
$ImpExSession->add_session_var('sourceexists', $impexconfig['sourceexists']);

$ImpExSession->add_session_var('targettableprefix', $impexconfig['target']['tableprefix']);
$ImpExSession->add_session_var('targetdatabasetype', strtolower($impexconfig['target']['databasetype']));

$ImpExSession->add_session_var('sourcetableprefix', $impexconfig['source']['tableprefix']);
$ImpExSession->add_session_var('sourcedatabasetype', strtolower($impexconfig['source']['databasetype']));

$ImpExSession->add_session_var('errorlogging', $impexconfig['system']['errorlogging']);
$ImpExSession->add_session_var('pagespeed', $impexconfig['system']['pagespeed']);

if($impexconfig['sourceexists'])
{
	if ($impexconfig['source']['databasetype'] == 'mssql')
	{// Check if mssql support is in php or should a connection be made via pure style .......
		if(!function_exists('mssql_connect'))
		{
			$ImpExDisplay->display_error($ImpExDisplay->phrases['no_mssql_support']);
			$ImpExDisplay->display_error($ImpExDisplay->phrases['no_mssql_support_link']);
			exit;
		}
	}

	$Db_source->appname 		= 'vBulletin:ImpEx Source';
	$Db_source->appshortname 	= 'vBulletin:ImpEx Source';
	$Db_source->database 		= $impexconfig['source']['database'];
	$Db_source->type 			= $impexconfig['source']['databasetype'];
	$Db_source->reporterror 	= 0;
	$Db_source->connect($impexconfig['source']['server'], $impexconfig['source']['user'], $impexconfig['source']['password'], 0);
	$Db_source->reporterror = 1;

	if ($Db_source->link_id)
	{ // got connected
		switch ($Db_source->geterrno())
		{
			case 1046:
				$ImpExDisplay->display_error($ImpExDisplay->phrases['no_source_set']);
				exit;
			break;
			case 1049:
				$ImpExDisplay->display_error($ImpExDisplay->phrases['source_not_exsist']);
				exit;
			break;
		}
	}
	else
	{
		$ImpExDisplay->display_error($ImpExDisplay->phrases['failed_connection']);
		exit;
	}

	// php versions before 4.2.0 do nasty things with multiple connections to the same server
	// See http://uk.php.net/manual/en/function.mysql-connect.php
	if (($Db_target->link_id === $Db_source->link_id) AND phpversion() < '4.2.0')
	{
		$Db_target->require_db_reselect = true;
		$Db_source->require_db_reselect = true;
	}
}

$ImpEx->get_post_values($ImpExSession,$_POST);


// #############################################################################
// Autosubmit
// #############################################################################

$ImpExDisplay->update_basic('autosubmit',$ImpExSession->get_session_var('autosubmit'));


// #############################################################################
// Autosubmit & Home
// #############################################################################

$currentmoduleworking	= $ImpExSession->any_working();
$system					= $ImpExSession->get_session_var('system');
$module 				= $ImpExSession->get_session_var('module');

if ($module == '000' OR $module == NULL)
{
	if ($system != '' AND $system != 'NONE')
	{
		// When there is a system chosen, but not running, build the module list.
		require_once (IDIR . "/systems/{$system}/000.php");
		$ImpExSession->build_module_list($ImpExDisplay);
	}
	else
	{
		if ($system == '')
		{
			// Catching a blank string
			$ImpExSession->set_session_var('system', 'NONE');
		}
		else
		{
			// Nothing chosen yet
			$ImpExSession->set_session_var('system', $system);
			$ImpExDisplay->update_basic('title', $system);
		}
	}
}

echo $ImpExDisplay->page_header() .
		'<br> <div align="center"><a href="help.php">' . $ImpExDisplay->phrases['db_cleanup'] .
		'</a></div>';

if ($using_local_config) { echo '<div align="center"> ' . $using_local_config . '</div><br>'; }


// #############################################################################
// Resume
// #############################################################################

if ($currentmoduleworking != NULL)
{
	// Ensure we have the $system_000.php module to extend from
	require_once (IDIR . "/systems/{$system}/000.php");

	// Get the one we are working with.
	require_once (IDIR . "/systems/{$system}/{$currentmoduleworking}.php");

	// Create that class
	$classname = "{$system}_{$currentmoduleworking}";
	$ModuleCall = new $classname($ImpExSession);

	// Then call resume on it
	$ModuleCall->resume($ImpExSession, $ImpExDisplay, $Db_target, $Db_source);
}


// #############################################################################
// Init
// #############################################################################

if ($module != '000' AND $module != NULL AND $currentmoduleworking == FALSE)
{
	$ImpExDisplay->update_basic('displaymodules', 'FALSE');

	// Ensure we have the $system_000.php module to extend from
	require_once(IDIR . "/systems/{$system}/000.php");

	// Check if its a core module
	if ($module < 900)
	{
		require_once (IDIR . "/systems/{$system}/{$module}.php");
		// Create the name of the class to instantiate
		$classname = "{$system}_{$module}";
	}
	else
	{
		require_once (IDIR . "/cleanup.php");
		// Create the name of the class to instantiate
		$classname = "core_{$module}";
	}

	// Instantiate it
	$ModuleCall = new $classname($ImpExSession);

	// If its been FINISHED, then we are restarting it
	if ($ImpExSession->get_session_var($module) == 'FINISHED')
	{
		$ModuleCall->restarted();
	}

	// Sets the current to working
	$ModuleCall->using($ImpExSession);

	// Actually calls the init and does the work
	$ModuleCall->init($ImpExSession, $ImpExDisplay, $Db_target, $Db_source);
}


// #############################################################################
// Update & Display
// #############################################################################

$ImpEx->updateDisplay($ImpExSession, $ImpExDisplay);
echo $ImpExDisplay->display($ImpExSession);
if ($displayerrors)
{
	echo $ImpExSession->display_errors('all');
}


// #############################################################################
// Session End
// #############################################################################

$ImpEx->store_session($Db_target, $impexconfig['target']['tableprefix'], $ImpExSession);

echo "<!-- From {$system} to " . $ImpExSession->get_session_var('targetsystem') . "-->";

echo $ImpExDisplay->page_footer();

/*======================================================================*\
|| ####################################################################
|| #
|| # CVS: $RCSfile: index.php,v $ - $Revision: 1.54 $
|| ####################################################################
\*======================================================================*/
?>
