<?
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2006 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* 404 for external and internal link redirect.
*
* @package			ImpEx.tools
* @version			$Revision: 1.3 $
* @author			Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout		$Name:  $
* @date				$Date: 2006/03/22 23:35:09 $
* @copyright		http://www.vbulletin.com/license.html
*
*/

/*

Ensure you have this table for logging

CREATE TABLE `404_actions` (
`id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
`time` INT UNSIGNED NOT NULL ,
`incomming` VARCHAR( 250 ) NOT NULL ,
`outgoing` VARCHAR( 250 ) NOT NULL ,
`action` TINYINT UNSIGNED NOT NULL DEFAULT '0',
PRIMARY KEY ( `id` )
) TYPE = MYISAM ;
*/

// System

#Currently supported : phpBB2

$old_system 	= 'phpBB2';

// Domain
// Example :: http://www.example.com/phpBB/

$old_folder 	= 'phpBB';
$standard_404 	= 'http://www.example.com/not_found.html'; // The usual 404 that this script replaces

// Example :: http://www.example.com/vBulletin/

$new_domain 	= 'example';
$new_folder		= 'vBulletin';
$ext_type		= 'php'; // File extension type that vBulletin is using, i.e. index.php

// Database
// This is the vBulletin database, needed for import id look up and logging
$server 		= 'localhost';
$user 			= 'user';
$password 		= 'password';
$database 		= 'forum';
$tableprefix 	= '';

// System
$refresh_speed 	= 0;		// Speed of the redirect, 0 advised.
$do_logs 		= true;		// Always best to log to see that its working and if there are any "Unknown link type, talk to Jerry" links
$do_404			= false; 	// true = a 404 (Not Found) redirect. false is a 301 search engine friendly redirect (Moved Permanently)

#############################################################################################################################
# Don't touch below
#############################################################################################################################

$old_id 		= 0;
$action_code	= 0;		
$action 		= null;
$sql 			= null;

// Get the file names and types

switch ($old_system)
{
	case 'phpBB2' :
		$old_forum_script 	= 'viewforum.php?f=';
		$old_thread_script 	= 'viewtopic.php?t=';
		$old_post_script 	= "viewtopic.php?p=";
		$old_user_script 	= 'profile.php?mode=viewprofile&u='; // Append userid
		break;
	default :
		// No valid system entered
		die('No valid system entered');
}

// It's for the old forum
if (strpos($_SERVER['REQUEST_URI'], "/{$old_folder}/") === 0)
{
	switch ($old_system)
	{
		case 'phpBB2' :
			// It's a forum link
			if (strpos($_SERVER['REQUEST_URI'], "/{$old_folder}/{$old_forum_script}") === 0)
			{
				$action = 'forum';
				$sql = "SELECT forumid FROM {$tableprefix}forum WHERE importforumid = " . substr($_SERVER['REDIRECT_QUERY_STRING'], 2);
			}

			// It's a thread link
			if (strpos($_SERVER['REQUEST_URI'], "/{$old_folder}/{$old_thread_script}") === 0)
			{
				$action = 'thread';
				$sql = "SELECT threadid FROM {$tableprefix}thread WHERE importthreadid = " . substr($_SERVER['REDIRECT_QUERY_STRING'], 2);
			}
	
			// It's a post link
			if (strpos($_SERVER['REQUEST_URI'], "/{$old_folder}/{$old_post_script}") === 0)
			{
				$action = 'post';
				$sql = "SELECT postid FROM {$tableprefix}post WHERE importpostid = " . substr($_SERVER['REDIRECT_QUERY_STRING'], 2);
			}

			// It's a user link
			if (strpos($_SERVER['REQUEST_URI'], "/{$old_folder}/{$old_user_script}") === 0)
			{
				$action = 'user';
				// Cuts 12 out of this : profile.php?mode=viewprofile&u=12&sid=f646e2a0948e0244ba82cef12c3b93d8
				$sql = "SELECT userid FROM {$tableprefix}user WHERE importuserid = " . substr(substr($_SERVER['REDIRECT_QUERY_STRING'], 19), 0,  strpos(substr($_SERVER['REDIRECT_QUERY_STRING'], 19), '&'));
			}
			break;
		default :
			// No valid system entered
			die('No valid system entered');
	}	
	
	if (!$action)
	{
		$action = 'log'; 
	}
	
}

if (!$action)
{
?>
	<html>
	<head>
		<meta http-equiv="refresh" content="<? echo $refresh_speed; ?>; URL=<? echo $standard_404; ?>">
	</head>
	<body>
	</body>
	</html>
<?
	// Got nuffink
	die;
}
	

// If we are here we have data to look up and redirect to a vBulletin page.

$link = @mysql_connect($server, $user, $password);
if (!$link)
{
	#die('Could not connect: ' . mysql_error());
	$new_url = $standard_404;
}
$db_selected = @mysql_select_db($database, $link);

if (!$db_selected)
{
	#die ('Can\'t use foo : ' . mysql_error());
	$new_url = $standard_404;
}

if ($sql)
{	
	$result = @mysql_query($sql);
	$row = @mysql_fetch_row($result);
	
	if (!$row[0])
	{
		$action = 'Original data missing';
	}
	@mysql_free_result($result);
}

// Just incase 
$new_url = $standard_404;

switch ($action)
{
	case 'cat':
	case 'forum':
		$new_url = "http://{$new_domain}/{$new_folder}/forumdisplay.{$ext_type}?f=" . $row[0];
		$action_code = 1;
		break;
	case 'thread':
		$new_url = "http://{$new_domain}/{$new_folder}/showthread.{$ext_type}?t=" . $row[0];
		$action_code = 2;
		break;
	case 'post':
		$new_url = "http://{$new_domain}/{$new_folder}/showpost.{$ext_type}?p=" . $row[0];
		$action_code = 3;
		break;		
	case 'user':
		$new_url = "http://{$new_domain}/{$new_folder}/member.{$ext_type}?u=" . $row[0];
		$action_code = 4;
		break;
	case 'Original data missing':
		$action_code = 10;
		break;
	default :
		$action_code = 20;
		break;
}
		

// Do logging ?
if ($do_logs)
{
	// Codes
	# forum 	= 1
	# thread 	= 2
	# post 		= 3
	# user 		= 4
	
	# script error = 0
	
	# Original data missing 			= 10
	# Unknown link type, talk to Jerry	= 20
	
	$sql = "
	INSERT INTO {$tableprefix}404_actions 
	(
		time, incomming, outgoing, action
	)
	VALUES
	(
		" . time() . ", '" . $_SERVER['REQUEST_URI'] . "', '" . $new_url . "', '" . $action_code . "' 
	)
	";
	
	mysql_query($sql);
}

@mysql_close($link);

// Do the new redirect
// Do the new redirect
if ($do_404)
{
?>
	<html>
	<head>
		<meta http-equiv="refresh" content="<? echo $refresh_speed; ?> URL=<? echo $new_url; ?>">
	</head>
	<body>
	</body>
	</html>
<?
}
else
{
	Header( "HTTP/1.1 301 Moved Permanently" );
	Header( "Location: {$new_url}" );
}
// Da end
?>
