<?php
	// ======================================== \
	// Package: Mihalism Multi Host
	// Version: 4.0.0
	// Copyright (c) 2007, 2008 Mihalism, Inc.
	// License: http://www.gnu.org/licenses/gpl.txt GNU Public License
	// ======================================== /

	require_once "./source/includes/data.php";

	if ($mmhclass->info->is_admin == false) {
		$mmhclass->templ->error("يجب أن تكون مدير {$mmhclass->info->config['site_name']} حتى ترى هذه الصفحة.", true);
		exit;
	}
	
	$mmhclass->templ->templ_vars[] = array(
		"BASE_URL"   => $mmhclass->info->base_url,
		"URL_SCHEME" => (($mmhclass->funcs->is_null($mmhclass->input->server_vars['https']) == false) ? "s://ssl." : "://www"),
	);
		
	$mmhclass->templ->page_header = $mmhclass->templ->parse_template("admin/page_header");
	$mmhclass->templ->page_footer = $mmhclass->templ->parse_template("admin/page_footer");
		
	switch ($mmhclass->input->get_vars['act']) {
		case "mass_email":
			$captcha_session_id = $mmhclass->funcs->random_string(25);
			$mmhclass->db->query("INSERT INTO `mmh_captcha_sessions` (`session_id`, `captcha_code`, `session_start`) VALUES ('{$captcha_session_id}', '".$mmhclass->funcs->random_string(7)."', '".time()."');");

			$mmhclass->templ->templ_vars[] = array(
				"SITE_NAME"  => $mmhclass->info->config['site_name'],
				"CAPTCHA_ID" => $captcha_session_id,
			);
			
			$mmhclass->templ->output("admin/admin", "mass_email_page");
			break;
		case "mass_email-s":
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['email_subject']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['message_body']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['captcha_code']) == true) {
				$mmhclass->templ->error("من فضلك تأكد من كتابة جميع البيانات بشكل صحيح.", true);
			} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_captcha_sessions` WHERE `captcha_code` = '{$mmhclass->input->post_vars['captcha_code']}';")) != 1) {
				$mmhclass->templ->error("نص صورة التحقق الأمني غير صحيح.");
			} else {
				$mmhclass->db->query("DELETE FROM `mmh_captcha_sessions` WHERE `captcha_code` = '{$mmhclass->input->post_vars['captcha_code']}';");
				
				$mmhclass->templ->templ_vars[] = array(
					"SITE_NAME"       => $mmhclass->info->config['site_name'],
					"WEBMASTER_EMAIL" => $mmhclass->info->config['email_out'],
					"EMAIL_BODY"      => strip_tags(str_replace("<br />", "\n", $mmhclass->input->post_vars['message_body'])),
				);
				
				$message_body = $mmhclass->templ->parse_template("admin/admin", "mass_email_email"); 
	
				$sql = $mmhclass->db->query("SELECT * FROM `mmh_user_info`;");
				while ($row = $mmhclass->db->fetch_array($sql)) {
					$carbon_copies .= (($cc_count == 0 && $mmhclass->info->config['email_out'] != $mmhclass->info->user_data['email_addres']) ? $row['email_address'] : ", {$row['email_address']}");
					$cc_count++;
				}
				
				$email_headers  = "From: {$mmhclass->info->config['site_name']} <{$mmhclass->info->config['email_out']}>\r\n";
				$email_headers .= "Bcc: {$carbon_copies}\r\n";
				$email_headers .= "Reply-To: {$mmhclass->info->config['email_out']}\r\n";

				if (mail($mmhclass->info->config['email_out'], "{$mmhclass->input->post_vars['email_subject']} ({$mmhclass->info->config['site_name']})", $message_body, $email_headers) == true) {
					$mmhclass->templ->message("تم إرسال الرسالة بنجاح. <br /><br /> <a href=\"admin.php?act=mass_email\">الصفحة السابقة</a> <br /> <a href=\"admin.php\">صفحة الإدارة الرئيسية</a>", true);
				} else {
					$mmhclass->templ->error("لم يتم إرسال الرسالة بسبب خطأ غير معروف.");
				}
			}
			break;
		case "ban_control":
			$sql = $mmhclass->db->query("SELECT * FROM `mmh_ban_filter`;");
			while ($row = $mmhclass->db->fetch_array($sql)) {
				if ($row['ban_type'] == 1) {
					$banned_ip_list .= "<option value=\"{$row['ban_id']}\">{$row['ban_value']} : ".gethostbyaddr($row['ban_value'])."</option>";
				} elseif ($row['ban_type'] == 2) {
					$banned_user_list .= "<option value=\"{$row['ban_id']}\">{$row['ban_value']}</option>";
				}
			}
			
			$mmhclass->templ->templ_vars[] = array(
				"BANNED_USER_LIST" => $banned_user_list,
				"BANNED_IP_LIST"   => $banned_ip_list,
			);
			
			$mmhclass->templ->output("admin/admin", "ban_control_page");
			break;
		case "ban_control-u":
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['banned']['username']) == false && $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `username` = '{$mmhclass->input->post_vars['banned']['username']}' AND `user_group` = 'normal_user';")) == 1) {
				$mmhclass->db->query("INSERT INTO `mmh_ban_filter` (ban_type, time_banned, ban_value) VALUES ('2', '".time()."', '".trim($mmhclass->input->post_vars['banned']['username'])."');");
	
				if ($mmhclass->input->post_vars['delete_files']['username'] == 1) {
					$user_data = $mmhclass->db->fetch_array($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `username` = '{$mmhclass->input->post_vars['banned']['username']}' AND `user_group` = 'normal_user';"));
					$sql = $mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$user_data['user_id']}';");
					while ($row = $mmhclass->db->fetch_array($sql)) {
						if (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($row['filename'])) == true) {
							if (unlink($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$row['filename']) == false) {
								$mmhclass->templ->error("فشلت عملية حذف <b>{$row['filename']}</b> الصورة بسبب خطأ غير معروف.", true);
							}
					
							if (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($row['filename'])) == true) {
								if (unlink($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($row['filename'])) == false) {
									$mmhclass->templ->error("فشل عملية حذف مصغرة الصورة <b>{$row['filename']}</b> بسبب خطأ غير معروف.", true);
								}
							}
					
							$mmhclass->db->query("DELETE FROM `mmh_file_storage` WHERE `filename` = '{$row['filename']}';");
						}
					}
				}
			}
			
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['banned']['ip_address']) == false && preg_match("/^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$/", trim($mmhclass->input->post_vars['banned']['ip_address']))) {
				$mmhclass->db->query("INSERT INTO `mmh_ban_filter` (ban_type, time_banned, ban_value) VALUES ('1', '".time()."', '".trim($mmhclass->input->post_vars['banned']['ip_address'])."');");
	
				if ($mmhclass->input->post_vars['delete_files']['ip_address'] == 1) {
					$sql = $mmhclass->db->query("SELECT * FROM `mmh_file_logs` WHERE `ip_address` = '".trim($mmhclass->input->post_vars['banned']['ip_address'])."';");
					while ($row = $mmhclass->db->fetch_array($sql)) {
						if (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($row['filename'])) == true) {
							if (unlink($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$row['filename']) == false) {
								$mmhclass->templ->error("فشلت عملية حذف الصورة <b>{$row['filename']}</b> بسبب خطأ غير معروف.", true);
							}
					
							if (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($row['filename'])) == true) {
								if (unlink($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($row['filename'])) == false) {
									$mmhclass->templ->error("فشلت عملية حذف مصغرة الصورة <b>{$row['filename']}</b> بسبب خطأ غير معروف.", true);
								}
							}
					
							$mmhclass->db->query("DELETE FROM `mmh_file_storage` WHERE `filename` = '{$row['filename']}';");
						}
					}
				}
			}
			
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['unban']['username']) == false) {
				for ($i = 0; $i < count($mmhclass->input->post_vars['unban']['username']); $i++) {
					$mmhclass->db->query("DELETE FROM `mmh_ban_filter` WHERE `ban_id` = '{$mmhclass->input->post_vars['unban']['username'][$i]}';");
				}
			}
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['unban']['ip_address']) == false) {
				for ($i = 0; $i < count($mmhclass->input->post_vars['unban']['ip_address']); $i++) {
					$mmhclass->db->query("DELETE FROM `mmh_ban_filter` WHERE `ban_id` = '{$mmhclass->input->post_vars['unban']['ip_address'][$i]}';");
				}
			}
			
			$mmhclass->templ->message("تم تحديث قائمة الحظر بنجاح. <br /><br /> <a href=\"admin.php?act=ban_control\">العودة للصفحة السابقة</a> <br /> <a href=\"admin.php\">صفحة الإدارة الرئيسية</a>", true);
			break;
		case "processes":
			echo "<pre>";
			if(strstr(strtolower(PHP_OS), "win")) {
				echo str_replace(" ", "&nbsp;", shell_exec("tasklist"));
			} else {
				echo str_replace(" ", "&nbsp;", shell_exec( "top -b -n 1" ));
			}
			echo "</pre>";
			break;
		case "phpinfo":
			phpinfo();
			break;
		case "users-d":
			if ($mmhclass->funcs->is_null($mmhclass->input->get_vars['id']) == true || $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `user_id` = '{$mmhclass->input->get_vars['id']}';")) != 1) {
				$mmhclass->templ->error("العضو المطلوب غير موجود.", true);
			} elseif ($mmhclass->input->get_vars['id'] == 1) {
				$mmhclass->templ->error("لا يمكن حذف المدير الأصلي.");
			} else {
				$mmhclass->templ->templ_vars[] = array(
					"USER_TO_DELETE" => $mmhclass->input->get_vars['id'],
					"RETURN_URL"     => $mmhclass->input->get_vars['return'],
					"LIGHTBOX_ID"    => $mmhclass->input->get_vars['lb_div'],
				);
		
				exit($mmhclass->templ->parse_template("admin/admin", "delete_user_lightbox"));
			}
			break;
		case "users-d-d":
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['user_id']) == true || $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `user_id` = '{$mmhclass->input->post_vars['user_id']}';")) != 1) {
				$mmhclass->templ->error("العضو المطلوب غير موجود.", true);
			} elseif ($mmhclass->input->post_vars['user_id'] == 1) {
				$mmhclass->templ->error("لا يمكن حذف المدير الأصلي.");
			} else {
				$sql = $mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->input->post_vars['user_id']}';");
				while ($row = $mmhclass->db->fetch_array($sql)) {
					$filename = basename($row['filename']);
					if ($mmhclass->funcs->is_null($filename) == true) {
						$mmhclass->templ->error("من فضلك اختر صورة لتستمر.", true);
					} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($filename)) == false) {
						$mmhclass->templ->error("الصورة المحددة <b>{$filename}</b> غير موجودة.", true);
					} else {
						if (unlink($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$filename) == false) {
							$mmhclass->templ->error("فشلت عملية حذف الصورة <b>{$filename}</b> بسبب خطأ غير معروف.", true);
						}
					
						if (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($filename)) == true) {
							if (unlink($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($filename)) == false) {
								$mmhclass->templ->error("فشلت عملية حذف مصغرة الصورة <b>{$filename}</b> بسبب خطأ غير معروف.", true);
							}
						}
					
						$mmhclass->db->query("DELETE FROM `mmh_file_storage` WHERE `filename` = '{$filename}';");
					}
				}
			
				$mmhclass->db->query("DELETE FROM `mmh_user_info` WHERE `user_id` = '{$mmhclass->input->post_vars['user_id']}';");
			
				$mmhclass->templ->message("تم تحديث إعدادات العضو بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"admin.php\">صفحة الإدارة الرئيسية</a>", true);
			}
			break;
		case "users-s":
			if ($mmhclass->funcs->is_null($mmhclass->input->get_vars['id']) == true || $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `user_id` = '{$mmhclass->input->get_vars['id']}';")) != 1) {
				$mmhclass->templ->error("العضو المحدد غير موجود.", true);
			} else {
				$mmhclass->templ->templ_globals['user_data'] = $mmhclass->db->fetch_array($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `user_id` = '{$mmhclass->input->get_vars['id']}';"));
			
				$mmhclass->templ->templ_vars[] = array(
					"USER_ID"             => $mmhclass->templ->templ_globals['user_data']['user_id'],
					"USERNAME"            => $mmhclass->templ->templ_globals['user_data']['username'],
					"IP_ADDRESS"          => $mmhclass->templ->templ_globals['user_data']['ip_address'],
					"EMAIL_ADDRESS"       => $mmhclass->templ->templ_globals['user_data']['email_address'],
          "COUNTRY"                 => $mmhclass->templ->templ_globals['user_data']['country'],
					"PRIVATE_GALLERY_YES" => (($mmhclass->templ->templ_globals['user_data']['private_gallery'] == 1) ? "checked=\"checked\"" : NULL),
					"PRIVATE_GALLERY_NO"  => (($mmhclass->templ->templ_globals['user_data']['private_gallery'] == 0) ? "checked=\"checked\"" : NULL),
					"TIME_JOINED"         => date($mmhclass->info->config['date_format'], $mmhclass->templ->templ_globals['user_data']['time_joined']),
					"ADMIN_USER_GROUP"    => (($mmhclass->templ->templ_globals['user_data']['user_group'] == "normal_admin") ? "selected=\"selected\"" : NULL),
				);
			
				$mmhclass->templ->output("admin/admin", "user_settings_page");
			}
			break;
		case "users-s-s":
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['user_id']) == true || $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `user_id` = '{$mmhclass->input->post_vars['user_id']}';")) != 1) {
				$mmhclass->templ->error("العضو المحدد غير موجود.", true);
			} else {
				if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['email_address']) == true) {
					$mmhclass->templ->error("من فضلك تأكد من كتابة جميع البيانات بشكل صحيح.", true);
				} elseif ($mmhclass->funcs->valid_email($mmhclass->input->post_vars['email_address']) == false) {
					$mmhclass->templ->error("البريد الإلكتروني المدخل غير صالح.", true);
				} elseif ($mmhclass->funcs->is_null($mmhclass->input->post_vars['password']) == false && strlen($mmhclass->input->post_vars['password']) < 6 || strlen($mmhclass->input->post_vars['password']) > 30) {
					$mmhclass->templ->error("من فضلك تأكد من إدخال كلمة مرور صحيحة.", true);
				} else {
					$mmhclass->db->query("UPDATE `mmh_user_info` SET `email_address` = '{$mmhclass->input->post_vars['email_address']}', `country` = '{$mmhclass->input->post_vars['country']}', `private_gallery` = '{$mmhclass->input->post_vars['private_gallery']}'{$user_password} WHERE `user_id` = '{$mmhclass->input->post_vars['user_id']}';");

					if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['password']) == false) {
						$user_password = md5($mmhclass->input->post_vars['password']);
						$mmhclass->db->query("UPDATE `mmh_user_info` SET `password` = '{$user_password}' WHERE `user_id` = '{$mmhclass->input->post_vars['user_id']}';");
					}

					if ($mmhclass->input->post_vars['user_id'] != 1) {
						$user_group = (($mmhclass->input->post_vars['user_group'] == 1) ? "normal_user" : "normal_admin");
						$mmhclass->db->query("UPDATE `mmh_user_info` SET `user_group` = '{$user_group}' WHERE `user_id` = '{$mmhclass->input->post_vars['user_id']}';");
					}

					$mmhclass->templ->message("تم تعديل الإعدادات بنجاح. <br /><br /> <a href=\"admin.php?act=users-s&id={$mmhclass->input->post_vars['user_id']}\">تعديل الإعدادات مرة أخرى</a> <br /> <a href=\"admin.php\">صفحة الإدارة الرئيسية</a>", true);
				}
			}
			break;
		case "file_logs":
			$sql = $mmhclass->db->query("SELECT * FROM `mmh_file_logs` ORDER BY `log_id` DESC LIMIT <# QUERY_LIMIT #>;");
			if ($mmhclass->db->total_rows($sql) < 1) {
		 		$mmhclass->templ->message("سجل الملفات فارغ لأنه لم يتم رفع أي صور.", true);
		 	} else {
				while ($row = $mmhclass->db->fetch_array($sql)) {
					$file_owners_data = $mmhclass->db->fetch_array($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `user_id` = '{$row['gallery_id']}';"));
			
					$mmhclass->templ->templ_globals['get_whileloop'] = true;
				
					$mmhclass->templ->templ_vars[] = array(
						"LOG_ID"        => $row['log_id'],
						"FILENAME"      => $row['filename'],
						"FILE_STATUS"   => ((is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$row['filename']) == true) ? "موجود" : "محذوف"),
						"IP_ADDRESS"    => $row['ip_address'],
						"TIME_UPLOADED" => date($mmhclass->info->config['date_format'], $row['time_uploaded']),
						"UPLOADED_BY"   => (($row['gallery_id'] == 0 || $mmhclass->funcs->is_null($file_owners_data['user_id']) == true) ? "زائر" : "<a href=\"admin.php?gal={$file_owners_data['user_id']}\">{$file_owners_data['username']}</a>"),
						"FILESIZE"      => $mmhclass->image->format_filesize($row['filesize']),
						"TDCLASS"       => $tdclass = (($tdclass == "tdrow1") ? "tdrow2" : "tdrow1"),
					);
				
					$mmhclass->templ->templ_globals['file_logs_whileloop'] .= $mmhclass->templ->parse_template("admin/admin", "file_logs_page");
				
					unset($file_owners_data, $mmhclass->templ->templ_globals['get_whileloop'], $mmhclass->templ->templ_vars);	
				}
			
				$mmhclass->templ->templ_vars[] = array(
					"PAGINATION_LINKS" => $mmhclass->templ->pagelinks("admin.php?act=file_logs", $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_logs` ORDER BY `log_id` DESC;"))),
				);
			
				$mmhclass->templ->output("admin/admin", "file_logs_page");
			}
			break;
		case "robot_logs":
			$sql = $mmhclass->db->query("SELECT * FROM `mmh_robot_logs` ORDER BY `log_id` DESC LIMIT <# QUERY_LIMIT #>;");
			if ($mmhclass->db->total_rows($sql) < 1) {
		 		$mmhclass->templ->message("سجل محركات البحث فارغ لأنه لم يتم فحص موقعك.", true);
		 	} else {
				while ($row = $mmhclass->db->fetch_array($sql)) {
					$robot_data = $mmhclass->db->fetch_array($mmhclass->db->query("SELECT * FROM `mmh_robot_info` WHERE `robot_id` = '{$row['robot_id']}';"));
			
					$mmhclass->templ->templ_globals['get_whileloop'] = true;
				
					$mmhclass->templ->templ_vars[] = array(
						"LOG_ID"        => $row['log_id'],
						"ROBOT_NAME"    => $robot_data['robot_name'],
						"DATE_INDEXED"  => date($mmhclass->info->config['date_format'], $row['time_indexed']),
						"PAGE_INDEXED"  => ("<a href=\"{$row['page_indexed']}\">".((strlen($row['page_indexed']) > 60) ? (substr($row['page_indexed'], 0, 60)."...") : $row['page_indexed'])."</a>"),
						"HTTP_REFERER"  => (($mmhclass->funcs->is_null($row['http_referer']) == true) ? "غير معروف" : ("<a href=\"{$row['http_referer']}\">".((strlen($row['http_referer']) > 60) ? (substr($row['http_referer'], 0, 60)."...") : $row['http_referer'])."</a>")),
						"TDCLASS"       => $tdclass = (($tdclass == "tdrow1") ? "tdrow2" : "tdrow1"),
					);
				
					$mmhclass->templ->templ_globals['robot_logs_whileloop'] .= $mmhclass->templ->parse_template("admin/admin", "robot_logs_page");
				
					unset($file_owners_data, $mmhclass->templ->templ_globals['get_whileloop'], $mmhclass->templ->templ_vars);	
				}
			
				$mmhclass->templ->templ_vars[] = array(
					"PAGINATION_LINKS" => $mmhclass->templ->pagelinks("admin.php?act=robot_logs", $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_robot_logs` ORDER BY `log_id` DESC;"))),
				);
			
				$mmhclass->templ->output("admin/admin", "robot_logs_page");
			}
			break;
		case "robot_logs-de":
			$mmhclass->db->query("TRUNCATE `mmh_robot_logs`;");
			
			$mmhclass->templ->message("تم مسح سجل محركات البحث بنجاح. <br /><br /> <a href=\"admin.php\">صفحة الإدارة الرئيسية</a>", true);
			break;
		case "site_settings":
			$sql = $mmhclass->db->query("SELECT * FROM `mmh_site_settings`;");
			while ($row = $mmhclass->db->fetch_array($sql)) {
				$setting[$row['config_key']] = $row['config_value']; // <-- load unchanged values of settings
			}

			for ($i = 1; $i <= 100; $i++) {
				$mmhclass->templ->templ_globals['get_whileloop'] = true;
				
				$mmhclass->templ->templ_vars[] = array(
					"MAX_RESULTS_SUM"      => $i,
					"MAX_RESULTS_SELECTED" => (($setting['max_results'] == $i) ? "selected=\"selected\"" : NULL),
				);
										
				$mmhclass->templ->templ_globals['max_results_forloop'] .= $mmhclass->templ->parse_template("admin/admin", "site_settings_page");

				unset($mmhclass->templ->templ_vars, $mmhclass->templ->templ_globals['get_whileloop']);
			}
			
			$mmhclass->templ->templ_vars[] = array(
				"SITE_NAME"               => $setting['site_name'],
				"MAX_FILESIZE"            => $setting['max_filesize'],
				"USER_MAX_FILESIZE"       => $setting['user_max_filesize'],
				"FILE_EXTENSIONS"         => $setting['file_extensions'],
				"USER_FILE_EXTENSIONS"    => $setting['user_file_extensions'],
				"GALLERY_VIEWING_NO"      => (($setting['gallery_viewing'] == 0) ? "checked=\"checked\"" : NULL),
				"GALLERY_VIEWING_YES"     => (($setting['gallery_viewing'] == 1) ? "checked=\"checked\"" : NULL),
				"ADVANCED_THUMBNAILS_NO"  => (($setting['advanced_thumbnails'] == 0) ? "checked=\"checked\"" : NULL),
				"ADVANCED_THUMBNAILS_YES" => (($setting['advanced_thumbnails'] == 1) ? "checked=\"checked\"" : NULL),
				"EMAIL_OUT"               => $setting['email_out'],
				"DATE_FORMAT"             => $setting['date_format'],
				"THUMBNAIL_WIDTH"         => $setting['thumbnail_width'],
				"THUMBNAIL_HEIGHT"        => $setting['thumbnail_height'],
				"DISK_USED_SPACE"         => $mmhclass->image->format_filesize(disk_total_space($mmhclass->info->root_path) - disk_free_space($mmhclass->info->root_path)),
				"DISK_TOTAL_SPACE"        => $mmhclass->image->format_filesize(disk_total_space($mmhclass->info->root_path)),
			);
			
			$mmhclass->templ->output("admin/admin", "site_settings_page");
			break;
		case "site_settings-s":
			$new_config_values = array(
				"site_name"            => $mmhclass->input->post_vars['site_name'],
				"max_filesize"         => round($mmhclass->input->post_vars['max_filesize']),
				"user_max_filesize"    => round($mmhclass->input->post_vars['user_max_filesize']),
				"file_extensions"      => trim($mmhclass->input->post_vars['file_extensions']),
				"user_file_extensions" => trim($mmhclass->input->post_vars['user_file_extensions']),
				"gallery_viewing"      => round($mmhclass->input->post_vars['gallery_viewing']),
				"email_out"            => (($mmhclass->funcs->valid_email($mmhclass->input->post_vars['email_out']) == false) ? $mmhclass->info->config['email_out'] : $mmhclass->input->post_vars['email_out']),
				"date_format"          => $mmhclass->input->post_vars['date_format'],
				"thumbnail_width"      => round($mmhclass->input->post_vars['thumbnail_width']),
				"thumbnail_height"     => round($mmhclass->input->post_vars['thumbnail_height']),
				"max_results"          => round($mmhclass->input->post_vars['max_results']),
				"advanced_thumbnails"  => (($mmhclass->image->manipulator == "imagick") ? round($mmhclass->input->post_vars['advanced_thumbnails']) : 0),
			);
			
			foreach ($new_config_values as $config_key => $config_value) {
				$mmhclass->db->query("UPDATE `mmh_site_settings` SET `config_value` = '{$config_value}' WHERE `config_key` = '{$config_key}';");
			}
			
			$mmhclass->templ->message("تم تحديث الإعدادات بنجاح. <br /><br /> <a href=\"admin.php?act=site_settings\">العودة لصفحة الإعدادات</a> <br /> <a href=\"admin.php\">صفحة الإدارة الرئيسية</a>", true);
			break;
		case "user_list":
			$sql = $mmhclass->db->query("SELECT * FROM `mmh_user_info` ORDER BY `user_id` DESC LIMIT <# QUERY_LIMIT #>;");
			while ($row = $mmhclass->db->fetch_array($sql)) {
				$mmhclass->templ->templ_globals['get_whileloop'] = true;
				
				$mmhclass->templ->templ_vars[] = array(
					"USERNAME"        => $row['username'],
					"USER_ID"         => $row['user_id'],
					"TDCLASS"         => $tdclass = (($tdclass == "tdrow1") ? "tdrow2" : "tdrow1"),
					"TIME_JOINED"     => date($mmhclass->info->config['date_format'], $row['time_joined']),
					"GALLERY_STATUS"  => (($row['private_gallery'] == 1) ? "مخفي" : "عام"),
					"TOTAL_UPLOADS"   => $mmhclass->funcs->format_number($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$row['user_id']}';"))),
					"IP_ADDRESS"      => $row['ip_address'],
					"EMAIL_ADDRESS"   => $row['email_address'],
					"RETURN_URL"      => base64_encode($mmhclass->info->page_url),
				);

				$mmhclass->templ->templ_globals['user_list_whileloop'] .= $mmhclass->templ->parse_template("admin/admin", "user_list_page");

				unset($mmhclass->templ->templ_globals['get_whileloop'], $mmhclass->templ->templ_vars);	
			}

			$mmhclass->templ->templ_vars[] = array(
				"PAGINATION_LINKS" => $mmhclass->templ->pagelinks("admin.php?act=user_list", $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info`;"))),
			);

			$mmhclass->templ->output("admin/admin", "user_list_page");
		case "rename_file_title":
			if ($mmhclass->funcs->is_null($mmhclass->input->get_vars['file']) == true) {
				$mmhclass->templ->error("من فضلك اختر صورة لتستمر.", true);
			} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($mmhclass->input->get_vars['file'])) == false) {
				$mmhclass->templ->error("الصورة المحددة <b>{$mmhclass->input->get_vars['file']}</b> غير موجودة.", true);
			} else {
				$filename  = basename($mmhclass->input->get_vars['file']);
				$new_title = strip_tags($mmhclass->input->get_vars['title']);
				
				$mmhclass->db->query("UPDATE `mmh_file_storage` SET `file_title` = '{$new_title}' WHERE `filename` = '{$filename}';");
	
				exit($new_title);
			}
			break;
		case "move_files":
			$files_to_move = preg_split("/,/", $mmhclass->input->get_vars['files']);
			for ($i = 0; $i < count($files_to_move); $i++) {
				$filename = basename($files_to_move[$i]);
				if ($mmhclass->funcs->is_null($filename) == true) {
					$mmhclass->templ->error("من فضلك اختر صورة لتستمر.", true);
				} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($filename)) == false) {
					$mmhclass->templ->error("الصورة المحددة <b>{$filename}</b> غير موجودة.", true);
				}
			}
		
			$sql = $mmhclass->db->query("SELECT * FROM `mmh_gallery_albums` WHERE `gallery_id` = '{$mmhclass->input->get_vars['gal']}';");
			while ($row = $mmhclass->db->fetch_array($sql)) {
				$mmhclass->templ->templ_globals['get_whileloop'] = true;
				
				$mmhclass->templ->templ_vars[] = array(
					"ALBUM_ID"   => $row['album_id'],
					"ALBUM_NAME" => $row['album_title'],
				);

				$mmhclass->templ->templ_globals['album_options_whileloop'] .= $mmhclass->templ->parse_template("admin/admin", "move_files_lightbox");

				unset($mmhclass->templ->templ_vars, $mmhclass->templ->templ_globals['get_whileloop']);
			}
		
			$mmhclass->templ->templ_vars[] = array(
				"FILES_TO_MOVE" => $mmhclass->input->get_vars['files'],
				"LIGHTBOX_ID"   => $mmhclass->input->get_vars['lb_div'],
				"RETURN_URL"    => base64_encode(urldecode($mmhclass->input->get_vars['return'])),
				"GALLERY_ID"    => $mmhclass->input->get_vars['gal'],
			);
		
			exit($mmhclass->templ->parse_template("admin/admin", "move_files_lightbox"));
			break;
		case "move_files-d":
			$files_to_move = preg_split("/,/", $mmhclass->input->post_vars['files']);
			for ($i = 0; $i < count($files_to_move); $i++) {
				$filename = basename($files_to_move[$i]);
				if ($mmhclass->funcs->is_null($filename) == true) {
					$mmhclass->templ->error("من فضلك اختر صورة لتستمر.", true);
				} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($filename)) == false) {
					$mmhclass->templ->error("الصورة المحددة <b>{$filename}</b> غير موجودة.", true);
				} else {
					$mmhclass->db->query("UPDATE `mmh_file_storage` SET `album_id` = '{$mmhclass->input->post_vars['move_to']}' WHERE `filename` = '{$filename}';");
				}
			}
			
			$mmhclass->templ->message("تم نقل الصور بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"admin.php\">صفحة الإدارة الرئيسية</a>", true);
			break;
		case "delete_files":
			$files_to_delete = preg_split("/,/", $mmhclass->input->get_vars['files']);
			for ($i = 0; $i < count($files_to_delete); $i++) {
				$filename = basename($files_to_delete[$i]);
				if ($mmhclass->funcs->is_null($filename) == true) {
					$mmhclass->templ->error("من فضلك اختر صورة لتستمر.", true);
				} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($filename)) == false) {
					$mmhclass->templ->error("الصورة المحددة <b>{$filename}</b> غير موجودة.", true);
				}
			}
		
			$mmhclass->templ->templ_vars[] = array(
				"FILES_TO_DELETE" => $mmhclass->input->get_vars['files'],
				"LIGHTBOX_ID"     => $mmhclass->input->get_vars['lb_div'],
				"RETURN_URL"      => base64_encode(urldecode($mmhclass->input->get_vars['return'])),
				"GALLERY_ID"      => $mmhclass->input->get_vars['gal'],
			);
		
			exit($mmhclass->templ->parse_template("admin/admin", "delete_files_lightbox"));
			break;
		case "delete_files-d":
			$files_to_delete = preg_split("/,/", $mmhclass->input->post_vars['files']);
			for ($i = 0; $i < count($files_to_delete); $i++) {
				$filename = basename($files_to_delete[$i]);
				if ($mmhclass->funcs->is_null($filename) == true) {
					$mmhclass->templ->error("من فضلك اختر صورة لتستمر.", true);
				} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($filename)) == false) {
					$mmhclass->templ->error("الصورة المحددة <b>{$filename}</b> غير موجودة.", true);
				} else {
					if (unlink($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$filename) == false) {
						$mmhclass->templ->error("فشلت عملية حذف الصورة <b>{$filename}</b> بسبب خطأ غير معروف.", true);
					}
					
					if (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($filename)) == true) {
						if (unlink($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($filename)) == false) {
							$mmhclass->templ->error("فشلت عملية حذف مصغرة الصورة <b>{$filename}</b> بسبب خطأ غير معروف.", true);
						}
					}
					
					$mmhclass->db->query("DELETE FROM `mmh_file_storage` WHERE `filename` = '{$filename}';");
				}
			}
			
			$mmhclass->templ->message("تم حذف الصور بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"admin.php\">صفحة الإدارة الرئيسية</a>", true);
			break;
		case "albums-c":
			$mmhclass->templ->templ_vars[] = array(
				"LIGHTBOX_ID" => $mmhclass->input->get_vars['lb_div'],
				"RETURN_URL"  => $mmhclass->input->get_vars['return'],
				"GALLERY_ID"  => $mmhclass->input->get_vars['gal'],
			);
			
			exit($mmhclass->templ->parse_template("admin/admin", "new_album_lightbox"));
			break;
		case "albums-c-d":
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['album_title']) == true) {
				$mmhclass->templ->error("من فضلك تأكد من كتابة جميع البيانات بشكل صحيح.", true);
			} else {
				$mmhclass->db->query("INSERT INTO `mmh_gallery_albums` (`album_title`, `gallery_id`) VALUES ('{$mmhclass->input->post_vars['album_title']}', '{$mmhclass->input->post_vars['gallery']}');");
				
				$mmhclass->templ->message("تم إنشاء الألبوم بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"admin.php\">صفحة الإدارة الرئيسية</a>", true);
			}
			break;
		case "albums-r":
			$mmhclass->templ->templ_vars[] = array(
				"LIGHTBOX_ID" => $mmhclass->input->get_vars['lb_div'],
				"RETURN_URL"  => $mmhclass->input->get_vars['return'],
				"ALBUM_ID"    => $mmhclass->input->get_vars['album'], 
				"GALLERY_ID"  => $mmhclass->input->get_vars['gal'],
			);
		
			exit($mmhclass->templ->parse_template("admin/admin", "rename_album_lightbox"));
			break;	
		case "albums-r-d":
			$mmhclass->templ->page_title .= "إعادة تسمية الألبوم";
			
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['album_title']) == true) {
				$mmhclass->templ->error("من فضلك تأكد من كتابة جميع البيانات بشكل صحيح.", true);
			} else {
				$mmhclass->db->query("UPDATE `mmh_gallery_albums` SET `album_title` = '{$mmhclass->input->post_vars['album_title']}' WHERE `album_id` = '{$mmhclass->input->post_vars['album']}';");
				
				$mmhclass->templ->message("تم إعادة تسمية الألبوم بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"admin.php\">صفحة الإدارة الرئيسية</a>", true);
			}
			break;
		case "albums-d":
			$mmhclass->templ->templ_vars[] = array(
				"ALBUM_TO_DELETE" => $mmhclass->input->get_vars['album'],
				"LIGHTBOX_ID"     => $mmhclass->input->get_vars['lb_div'],
				"RETURN_URL"      => $mmhclass->input->get_vars['return'],
				"GALLERY_ID"      => $mmhclass->input->get_vars['gal'],
			);
			
			exit($mmhclass->templ->parse_template("admin/admin", "delete_album_lightbox"));
			break;	
		case "albums-d-d":
			$mmhclass->db->query("UPDATE `mmh_file_storage` SET `album_id` = '0' WHERE `album_id` = '{$mmhclass->input->post_vars['album']}' AND `gallery_id`  = '{$mmhclass->input->post_vars['gallery']}';");
			$mmhclass->db->query("DELETE FROM `mmh_gallery_albums` WHERE `album_id` = '{$mmhclass->input->post_vars['album']}' AND `gallery_id`  = '{$mmhclass->input->post_vars['gallery']}';");

			$mmhclass->templ->message("تم حذف الألبوم بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"admin.php\">صفحة الإدارة الرئيسية</a>", true);
			break;
		default: 
			$mmhclass->input->get_vars['gal']   = round($mmhclass->input->get_vars['gal']);
			$mmhclass->input->get_vars['cat']   = round($mmhclass->input->get_vars['cat']);
			$mmhclass->info->gallery_owner_data = (($mmhclass->funcs->is_null($mmhclass->input->get_vars['gal']) == false) ? $mmhclass->db->fetch_array($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `user_id` = '{$mmhclass->input->get_vars['gal']}';")) : array("user_id" => 0, "username" => $mmhclass->info->config['site_name']));
			$mmhclass->info->gallery_url        = "{$mmhclass->info->base_url}admin.php?gal={$mmhclass->info->gallery_owner_data['user_id']}";

			if ($mmhclass->funcs->is_null($mmhclass->input->get_vars['gal']) == false && $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `user_id` = '{$mmhclass->input->get_vars['gal']}';")) != 1) {
				$mmhclass->templ->error("المعرض المحدد غير موجود.", true);
			} else {
				if ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}' AND `album_id` = '{$mmhclass->input->get_vars['cat']}' ORDER BY `file_id` DESC LIMIT <# QUERY_LIMIT #>;")) < 1) {
					$mmhclass->templ->templ_globals['empty_gallery'] = true;
				} else {
					$sql = $mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}' AND `album_id` = '{$mmhclass->input->get_vars['cat']}' ORDER BY `file_id` DESC LIMIT <# QUERY_LIMIT #>;");
					while ($row = $mmhclass->db->fetch_array($sql)) {
						if ($tdcount >= 4) {
							$break_line = true;
							$tdcount = 0;
						}
						$tdcount++;
					
						$mmhclass->templ->templ_globals['file_options'] = true;
					
						$mmhclass->templ->templ_vars[] = array(
							"FILENAME"     => $row['filename'],
							"FILE_TITLE"   => "<span class=\"arial\" title=\"اضغط لتغيير الاسم\" id=\"{$row['filename']}\" onclick=\"javascript:gallery_action('rename', this.id);\">{$row['file_title']}</span>",
							"TDCLASS"      => $tdclass = (($tdclass == "tdrow1") ? "tdrow2" : "tdrow1"),
							"TABLE_BREAK"  => (($break_line == true) ? "</tr><tr>" : NULL),
						);
					
						$gallery_html .= $mmhclass->templ->parse_template("global", "global_gallery_layout");

						unset($break_line, $mmhclass->templ->templ_globals['get_whileloop'], $mmhclass->templ->templ_vars);	
					}
				}
							
				$sql = $mmhclass->db->query("SELECT * FROM `mmh_gallery_albums` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}';");
				while ($row = $mmhclass->db->fetch_array($sql)) {
					$mmhclass->templ->templ_globals['get_whileloop'] = true;
				
					$mmhclass->templ->templ_vars[] = array(
						"ALBUM_ID"      => $row['album_id'],
						"ALBUM_NAME"    => $row['album_title'],
						"GALLERY_ID"    => $mmhclass->info->gallery_owner_data['user_id'],
						"TOTAL_UPLOADS" => $mmhclass->funcs->format_number($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}' AND `album_id` = '{$row['album_id']}';"))),
						"PAGE_URL"      => $mmhclass->info->gallery_url,
						"RETURN_URL"    => base64_encode($mmhclass->info->page_url),
					);
					
					$mmhclass->templ->templ_globals['album_pulldown_link_whileloop'] .= $mmhclass->templ->parse_template("admin/admin", "admin_gallery_page");

					unset($mmhclass->templ->templ_vars, $mmhclass->templ->templ_globals['get_whileloop']);
				}
		
				$mmhclass->templ->templ_vars[] = array(
					"GALLERY_OWNER"      => $mmhclass->info->gallery_owner_data['username'],
					"PAGINATION_LINKS"   => $mmhclass->templ->pagelinks(($mmhclass->info->gallery_url.(($mmhclass->funcs->is_null($mmhclass->input->get_vars['cat']) == true) ? NULL : "&amp;cat={$mmhclass->input->get_vars['cat']}")), $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}' AND `album_id` = '{$mmhclass->input->get_vars['cat']}';"))),			
					"GALLERY_HTML"       => $gallery_html,
					"GALLERY_ID"         => $mmhclass->info->gallery_owner_data['user_id'],
					"CURRENT_PAGE"       => $mmhclass->info->current_page,
					"PAGE_URL"           => $mmhclass->info->gallery_url,
					"RETURN_URL"         => base64_encode($mmhclass->info->page_url),
					"EMPTY_GALLERY"      => $mmhclass->templ->message("من فضلك اختر من الشريط العلوي.", false),
					"TOTAL_UPLOADS"      => $mmhclass->funcs->format_number($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}';"))),
					"TOTAL_ROOT_UPLOADS" => $mmhclass->funcs->format_number($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}' AND `album_id` = '0';"))),
				);
				
				$mmhclass->templ->output("admin/admin", "admin_gallery_page");
			}	
	}
	
?>
