<?php
	// ======================================== \
	// Package: Mihalism Multi Host
	// Version: 4.0.0
	// Copyright (c) 2007, 2008 Mihalism, Inc.
	// License: http://www.gnu.org/licenses/gpl.txt GNU Public License
	// ======================================== /

	if (is_object($mmhclass) == false) {
		exit;
	}
	
	header("Content-Type: text/plain;");
	header("Content-Disposition: inline; filename=fileinfo_html.txt;");
	
	if ($mmhclass->funcs->is_null($mmhclass->input->get_vars['file']) == true) {
		exit("Please select an image file to continue.");
	} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($mmhclass->input->get_vars['file'])) == false) {
		exit("The requested image file <b>{$mmhclass->input->get_vars['file']}</b> does not exist.");
	} else {
		$filename    = basename($mmhclass->input->get_vars['file']);
		$rating_info = $mmhclass->db->fetch_array($mmhclass->db->query("SELECT * FROM `mmh_file_ratings` WHERE `filename` = '{$filename}';"));
		$file_info   = $mmhclass->image->get_image_info($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$filename);

		$mmhclass->templ->templ_vars[] = array(
			"LIGHTBOX_ID"    => $mmhclass->input->get_vars['lb_div'],
			"UPLOAD_PATH"    => $mmhclass->info->config['upload_path'],
			"FILENAME"       => $filename,
			"IMAGE_WIDTH"    => $file_info['width'],
			"IMAGE_HEIGHT"   => $file_info['height'],
			"FILE_EXTENSION" => $mmhclass->image->file_extension($filename),
			"MIME_TYPE"      => $file_info['mime'],
			"DATE_UPLOADED"  => date($mmhclass->info->config['date_format'], $file_info['mtime']),
			"TOTAL_FILESIZE" => $mmhclass->image->format_filesize($file_info['bits']),
			"TOTAL_RATINGS"  => $mmhclass->funcs->format_number($rating_info['total_votes']),
		);
		
		exit($mmhclass->templ->parse_template("fileinfo"));
	}
	
?>
