<?php
	// ======================================== \
	// Package: Mihalism Multi Host
	// Version: 4.0.0
	// Copyright (c) 2007, 2008 Mihalism, Inc.
	// License: http://www.gnu.org/licenses/gpl.txt GNU Public License
	// ======================================== /

	require_once "./source/includes/data.php";
	
	$mmhclass->templ->page_title = "{$mmhclass->info->config['site_name']} &raquo; رفع الصور";

	if ($mmhclass->funcs->is_null($mmhclass->input->get_vars['url']) == true) {
		for ($i = 0; $i <= 15; $i++) {
			if ($mmhclass->input->file_vars['userfile']['error'][$i] != 4 && $mmhclass->funcs->is_null($mmhclass->input->file_vars['userfile']['name'][$i]) == false) {
				$total_file_uploads++;

				if ($total_file_uploads <= 15) {
					$mmhclass->templ->html .= (($total_file_uploads > 1) ? "<br /><hr />" : NULL);

					$extension = $mmhclass->image->file_extension($mmhclass->input->file_vars['userfile']['name'][$i]);
					$file = ($mmhclass->input->file_vars['userfile']['name'][$i]."");
					$str1=current(explode('.', $file)); 
					if ($mmhclass->funcs->valid_input($mmhclass->input->file_vars['userfile']['name'][$i]."") == false){
					$filename  = ("image-".$mmhclass->funcs->random_string(4).".{$extension}");
					}elseif ($mmhclass->funcs->valid_input($mmhclass->input->file_vars['userfile']['name'][$i]."") == true){
					$filename = "{$str1}.{$extension}";
					}
					if (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$filename) == true || is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($filename)) == true) {
							$filename  = ("{$str1}-".$mmhclass->funcs->random_string(1).".{$extension}");
							}
					$thumbnail = $mmhclass->image->thumbnail_name($filename);
					$filetitle = strip_tags((strlen($str1) > 20) ? (substr($str1, 0, 20)."...") : $str1);

					if (in_array($extension, $mmhclass->info->config['file_extensions']) == false) {
						$mmhclass->templ->html .= $mmhclass->templ->message("امتداد الملف <b>{$str1}</b> وهو <b>.{$extension}</b> غير مسموح به.", false);
					} elseif ($mmhclass->input->file_vars['userfile']['size'][$i] > $mmhclass->info->config['max_filesize']) {
						$mmhclass->templ->html .= $mmhclass->templ->message("لقد تجاوزت الصورة <b>{$mmhclass->input->file_vars['userfile']['name'][$i]}</b> أقصى حجم مسموح به لكل صورة وهو <b>".$mmhclass->image->format_filesize($mmhclass->info->config['max_filesize'])."</b>.", false);
					} elseif ($mmhclass->image->is_image($mmhclass->input->file_vars['userfile']['tmp_name'][$i]) == false) {
						$mmhclass->templ->html .= $mmhclass->templ->message("الملف <b>{$mmhclass->input->file_vars['userfile']['name'][$i]}</b> لا يبدو أنه صورة حقيقية.", false);
					} elseif ($mmhclass->input->file_vars['userfile']['error'][$i] != 0) {
						$file_errors = array(			
							1 => "<b>PHP Engine Error</b>: The image file <b>{$mmhclass->input->file_vars['userfile']['name'][$i]}</b> exceeds the <a href=\"http://us2.php.net/manual/en/ini.core.php#ini.upload-max-filesize\">upload_max_filesize</a> directive in php.ini.",
							2 => "<b>PHP Engine Error</b>: The image file <b>{$mmhclass->input->file_vars['userfile']['name'][$i]}</b> exceeds the <b><i>MAX_FILE_SIZE</i></b> directive that was specified in the HTML form.", // <- Never will be outputted as an error but still an option
							3 => "<b>PHP Engine Error</b>: The image file <b>{$mmhclass->input->file_vars['userfile']['name'][$i]}</b> was only partially uploaded.",
							6 => "<b>PHP Engine Error</b>: Missing a temporary folder.",
							7 => "<b>PHP Engine Error</b>: Failed to write image file <b>{$mmhclass->input->file_vars['userfile']['name'][$i]}</b> to disk.",
							8 => "<b>PHP Engine Error</b>: Upload stopped by extension."
						);
						$mmhclass->templ->html .= $mmhclass->templ->error($file_errors[$mmhclass->input->file_vars['userfile']['error'][$i]], false);
					} elseif (move_uploaded_file($mmhclass->input->file_vars['userfile']['tmp_name'][$i], $mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$filename) == false) {
						$mmhclass->templ->html .= $mmhclass->templ->error("فشلت عملية رفع الصورة <b>{$mmhclass->input->file_vars['userfile']['name'][$i]}</b> بسبب خطأ غير محدد.", false);
					} else {
						chmod($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$filename, 0644);

						$mmhclass->db->query("INSERT INTO `mmh_file_storage` (`filename`, `is_private`, `gallery_id`, `file_title`, `album_id`) VALUES ('{$filename}', '{$mmhclass->input->post_vars['private_upload']}', '{$mmhclass->info->user_data['user_id']}', '{$filetitle}', '".round($mmhclass->input->post_vars['upload_to'])."'); ");
						$mmhclass->db->query("INSERT INTO `mmh_file_logs` (`filename`, `filesize`, `ip_address`, `user_agent`, `time_uploaded`, `gallery_id`, `is_private`, `original_filename`) VALUES ('{$filename}', '{$mmhclass->input->file_vars['userfile']['size'][$i]}', '{$mmhclass->input->server_vars['remote_addr']}', '{$mmhclass->input->server_vars['http_user_agent']}', '".time()."', '{$mmhclass->info->user_data['user_id']}', '{$mmhclass->input->post_vars['private_upload']}', '".strip_tags($mmhclass->input->file_vars['userfile']['name'][$i])."'); ");
						$mmhclass->db->query("INSERT INTO `mmh_file_ratings` (`filename`, `total_rating`, `total_votes`, `voted_by`) VALUES ('{$filename}', '0', '0', '');");

						$mmhclass->image->create_thumbnail($filename);

						$mmhclass->templ->html .= $mmhclass->templ->file_results($filename);
					}
				}
			}
		}
	} else {
		for ($i = 0; $i <= 15; $i++) {
			if (strtolower(ini_get("allow_url_fopen")) == "on" || $mmhclass->funcs->is_null(ini_get("allow_url_fopen")) == true) {
				$mmhclass->templ->error("<b>PHP Engine Error:</b> The <b>allow_url_fopen</b> directive must be enabled in php.ini in order to use URL upload.", true);
			} else {
				if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['userfile'][$i]) == false) {
					$total_file_uploads++;

					if ($total_file_uploads <= 15) {
						$mmhclass->templ->html .= (($total_file_uploads > 1) ? "<br /><hr>" : NULL);

						$mmhclass->info->file_data = array(
							"http" => $mmhclass->input->post_vars['userfile'][$i],
							"name" => array_shift(explode("?", basename($mmhclass->input->post_vars['userfile'][$i]))),
							"size" => strlen(implode("", file($mmhclass->input->post_vars['userfile'][$i]))),
						);
						
						$extension = $mmhclass->image->file_extension($mmhclass->info->file_data['name']);
						$file = ($mmhclass->info->file_data['name']."");
					  $str1=current(explode('.', $file)); 
				   if ($mmhclass->funcs->valid_input($mmhclass->info->file_data['name']) == false){
					    $filename  = ("arabic_".$mmhclass->funcs->random_string(4).".{$extension}");
				  }elseif ($mmhclass->funcs->valid_input($mmhclass->info->file_data['name']."") == true){
					   $filename = "{$str1}.{$extension}";
				  }
				  if (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$filename) == true || is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($filename)) == true) {
							$filename  = ("{$str1}-".$mmhclass->funcs->random_string(1).".{$extension}");
							}
						$thumbnail = $mmhclass->image->thumbnail_name($filename);
						$filetitle = strip_tags((strlen($str1) > 20) ? (substr($str1, 0, 20)."...") : $str1);

						if (preg_match("/(https|http|ftp):\/\/[^\"\s']+/", $mmhclass->info->file_data['http']) == false || preg_match("/\.([a-zA-Z0-9])/", $mmhclass->info->file_data['name']) == false) {
							$mmhclass->templ->html .= $mmhclass->templ->error("رابط الصورة <b>{$mmhclass->info->file_data['name']}</b> غير مكتوب بشكل صحيح.", false);
						} elseif ($mmhclass->info->file_data['size'] == false) {
							$mmhclass->templ->html .= $mmhclass->templ->error("لا يمكن الحصول على الصورة <b>{$mmhclass->info->file_data['name']}</b>.", false);
						} elseif (in_array($extension, $mmhclass->info->config['file_extensions']) == false) {
							$mmhclass->templ->html .= $mmhclass->templ->message("امتداد الصورة <b>{$str1}</b> وهو <b>.{$extension}</b> غير مسموح به.", false);
						} elseif ($mmhclass->info->file_data['size'] > $mmhclass->info->config['max_filesize']) {
							$mmhclass->templ->html .= $mmhclass->templ->message("لقد تجاوزت الصورة <b>{$mmhclass->info->file_data['name']}</b>أقصى حجم مسموح به لكل صورة وهو <b>".$mmhclass->image->format_filesize($mmhclass->info->config['max_filesize'])."</b>.", false);
						} elseif (copy($mmhclass->info->file_data['http'], $mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$filename) == false) {
							$mmhclass->templ->html .= $mmhclass->templ->error("فشلت عملية رفع الصورة <b>{$mmhclass->info->file_data['name']}</b> بسبب خطأ غير محدد.", false);
						} else {
							chmod($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$filename, 0644);

							$mmhclass->db->query("INSERT INTO `mmh_file_storage` (`filename`, `is_private`, `gallery_id`, `file_title`) VALUES ('{$filename}', '{$mmhclass->input->post_vars['private_upload']}', '{$mmhclass->info->user_data['user_id']}', '{$filetitle}'); ");
							$mmhclass->db->query("INSERT INTO `mmh_file_logs` (`filename`, `filesize`, `ip_address`, `user_agent`, `time_uploaded`, `gallery_id`, `is_private`, `original_filename`) VALUES ('{$filename}', '{$mmhclass->info->file_data['size']}', '{$mmhclass->input->server_vars['remote_addr']}', '{$mmhclass->input->server_vars['http_user_agent']}', '".time()."', '{$mmhclass->info->user_data['user_id']}', '{$mmhclass->input->post_vars['private_upload']}', '".strip_tags($mmhclass->info->file_data['name'])."'); ");
							$mmhclass->db->query("INSERT INTO `mmh_file_ratings` (`filename`, `total_rating`, `total_votes`, `voted_by`) VALUES ('{$filename}', '0', '0', '');");

							$mmhclass->image->create_thumbnail($filename);

							$mmhclass->templ->html .= $mmhclass->templ->file_results($filename);
							
							unset($mmhclass->info->file_data);
						}
					}
				}
			}
		}
	}
	
	if ($total_file_uploads < 1) {
		$mmhclass->templ->error("من فضلك اختر على الأقل ملف واحد لرفعه.", true);
	}

	$mmhclass->templ->output();

?>
