<?php
	// ======================================== \
	// Package: Mihalism Multi Host
	// Version: 4.0.0
	// Copyright (c) 2007, 2008 Mihalism, Inc.
	// License: http://www.gnu.org/licenses/gpl.txt GNU Public License
	// ======================================== /

	require_once "./source/includes/data.php";

	$mmhclass->templ->page_title = "{$mmhclass->info->config['site_name']} &raquo; ";
	
	switch ($mmhclass->input->get_vars['act']) {
		case "contact_us":
			$mmhclass->templ->page_title .= "الاتصال بنا";
	
			$captcha_session_id = $mmhclass->funcs->random_string(25);
			$mmhclass->db->query("INSERT INTO `mmh_captcha_sessions` (`session_id`, `captcha_code`, `session_start`) VALUES ('{$captcha_session_id}', '".$mmhclass->funcs->random_string(7)."', '".time()."');");

			$mmhclass->templ->templ_vars[] = array(
				"SITE_NAME"  => $mmhclass->info->config['site_name'],
				"CAPTCHA_ID" => $captcha_session_id,
			);
			
			$mmhclass->templ->output("contact", "contact_us_page");
			break;
		case "contact_us-s":
			$mmhclass->templ->page_title .= "الاتصال بنا";
			
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['email_address']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['message_body']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['captcha_code']) == true) {
				$mmhclass->templ->error("من فضلك تأكد من إدخال جميع البيانات بشكل صحيح.", true);
			} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_captcha_sessions` WHERE `captcha_code` = '{$mmhclass->input->post_vars['captcha_code']}';")) != 1) {
				$mmhclass->templ->error("نص صورة التحقق الأمني غير مكتوب بشكل صحيح.");
			} elseif ($mmhclass->funcs->valid_email($mmhclass->input->post_vars['email_address']) == false) {
				$mmhclass->templ->error("من فضلك تأكد أن البريد الإلكتروني صالح وفعال.");
			} else {
				$mmhclass->db->query("DELETE FROM `mmh_captcha_sessions` WHERE `captcha_code` = '{$mmhclass->input->post_vars['captcha_code']}';");
				
				$mmhclass->templ->templ_vars[] = array(
					"SITE_NAME"     => $mmhclass->info->config['site_name'],
					"EMAIL_ADDRESS" => $mmhclass->input->post_vars['email_address'],
					"EMAIL_BODY"    => strip_tags(str_replace("<br />", "\n", $mmhclass->input->post_vars['message_body'])),
				);
				
				$message_body = $mmhclass->templ->parse_template("contact", "contact_us_email"); 

				$email_headers  = "From: {$mmhclass->info->config['site_name']} <{$mmhclass->info->config['email_out']}>\r\n";
				$email_headers .= "Reply-To: {$mmhclass->input->post_vars['email_address']}\r\n";

				if (mail($mmhclass->info->config['email_out'], "الاتصال بإدارة ({$mmhclass->info->config['site_name']})", $message_body, $email_headers) == true) {
					$mmhclass->templ->message("تم الإتصال بإدارة {$mmhclass->info->config['site_name']} بنجاح. <br /><br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
				} else {
					$mmhclass->templ->error("لم يتم إرسال الرسالة بسبب خطأ غير معروف.");
				}
			}
			break;
		case "file_report":
			$mmhclass->templ->page_title .= "الإبلاغ عن مخالفة";
	
			$captcha_session_id = $mmhclass->funcs->random_string(25);
			$mmhclass->db->query("INSERT INTO `mmh_captcha_sessions` (`session_id`, `captcha_code`, `session_start`) VALUES ('{$captcha_session_id}', '".$mmhclass->funcs->random_string(7)."', '".time()."');");

			$mmhclass->templ->templ_vars[] = array(
				"SITE_NAME"       => $mmhclass->info->config['site_name'],
				"CAPTCHA_ID"      => $captcha_session_id,
				"PREDEFINED_LIST" => (($mmhclass->funcs->is_null($mmhclass->input->get_vars['file']) == false) ? ($mmhclass->info->base_url.$mmhclass->info->config['upload_path'].basename($mmhclass->input->get_vars['file'])) : NULL),
			);
			
			$mmhclass->templ->output("contact", "report_files_page");
			break;
		case "file_report-s":
			$mmhclass->templ->page_title .= "الإبلاغ عن مخالفة";
			
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['email_address']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['message_body']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['captcha_code']) == true) {
				$mmhclass->templ->error("من فضلك تأكد من إدخال جميع البيانات بشكل صحيح.", true);
			} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_captcha_sessions` WHERE `captcha_code` = '{$mmhclass->input->post_vars['captcha_code']}';")) != 1) {
				$mmhclass->templ->error("نص صورة التحقق الأمني غير مكتوب بشكل صحيح.");
			} elseif ($mmhclass->funcs->valid_email($mmhclass->input->post_vars['email_address']) == false) {
				$mmhclass->templ->error("من فضلك تأكد أن البريد الإلكتروني صالح وفعال.");				$mmhclass->templ->error("من فضلك تأكد أن البريد الإلكتروني صالح وفعال.");
			} else {
				$mmhclass->db->query("DELETE FROM `mmh_captcha_sessions` WHERE `captcha_code` = '{$mmhclass->input->post_vars['captcha_code']}';");
				
				$mmhclass->templ->templ_vars[] = array(
					"SITE_NAME"     => $mmhclass->info->config['site_name'],
					"EMAIL_ADDRESS" => $mmhclass->input->post_vars['email_address'],
					"EMAIL_BODY"    => strip_tags(str_replace("<br />", "\n", $mmhclass->input->post_vars['message_body'])),
				);
				
				$message_body = $mmhclass->templ->parse_template("contact", "report_files_email"); 
	
				$email_headers  = "From: {$mmhclass->info->config['site_name']} <{$mmhclass->info->config['email_out']}>\r\n";
				$email_headers .= "Reply-To: {$mmhclass->input->post_vars['email_address']}\r\n";

				if (mail($mmhclass->info->config['email_out'], "File Report ({$mmhclass->info->config['site_name']})", $message_body, $email_headers) == true) {
					$mmhclass->templ->message("تم إبلاغ إدارة {$mmhclass->info->config['site_name']} بنجاح. <br /><br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
				} else {
					$mmhclass->templ->error("لم يتم إرسال الرسالة بسبب خطأ غير معروف.");
				}
			}
			break;
		default:
			$mmhclass->templ->error("لقد دخلت هذه الصفحة عن طريق الخطأ من فضلك قم بالرجوع لمركز {$mmhclass->info->config['site_name']}.");
	}

?>
