<?php
	// ======================================== \
	// Package: Mihalism Multi Host
	// Version: 4.0.0
	// Copyright (c) 2007, 2008 Mihalism, Inc.
	// License: http://www.gnu.org/licenses/gpl.txt GNU Public License
	// ======================================== /
	
	require_once "./source/includes/data.php";

	$mmhclass->templ->page_title = "مركز رفع الصور &raquo; التثبيت";
	
	if ($mmhclass->info->site_installed == true) {
		$mmhclass->templ->error("سكريبت مركز رفع الصور مثبت بالفعل.");
	}

	switch ($mmhclass->input->get_vars['act']) {
		case "install":
			$mmhclass->templ->templ_vars[] = array(
				"MMH_VERSION"  => $mmhclass->info->version,
				"SERVER_ADMIN" => $mmhclass->input->server_vars['server_admin'],
			);
			
			$mmhclass->templ->output("install", "install_form_page");
			break;
		case "install-d":
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['username']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['password']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['password-c']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['email_address']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['sql_host']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['sql_database']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['sql_username']) == true) {
				$mmhclass->templ->error("من فضلك تأكد من إدخال جميع البيانات بشكل صحيح.", true);
			} elseif ($mmhclass->funcs->valid_email($mmhclass->input->post_vars['email_address']) == false) {
				$mmhclass->templ->error("البريد الإلكتروني المستخدم غير صحيح.", true);
			} elseif ($mmhclass->input->post_vars['password'] != $mmhclass->input->post_vars['password-c']) {
				$mmhclass->templ->error("من فضلك تأكد أن كلمتي المرور متطابقتين.", true);
			} elseif (strlen($mmhclass->input->post_vars['password']) < 6 || strlen($mmhclass->input->post_vars['password']) > 30) {
				$mmhclass->templ->error("من فضلك تأكد من إدخال كلمة مرور طبقا للشروط.", true);
			} elseif ($mmhclass->funcs->valid_string($mmhclass->input->post_vars['username']) == false || strlen($mmhclass->input->post_vars['username']) < 3 || strlen($mmhclass->input->post_vars['username']) > 30) {
				$mmhclass->templ->error("من فضلك أدخل اسم مستخدم مطابق للشروط.", true);
			} elseif (is_writable("{$mmhclass->info->root_path}source/includes/config.php") == false) {
				$mmhclass->templ->error("من فضلك تأكد أن الملف <b>source/includes/config.php</b> قابل للقراءة. قم بإعطائه التصريح 0777.", true);
			} elseif (is_writable("{$mmhclass->info->root_path}files/") == false || is_readable("{$mmhclass->info->root_path}files/") == false) {
				$mmhclass->templ->error("من فضلك تأكد أن المجلد <b>files/</b> قابل للاستخدام. قم بإعطائه التصريح 0777.", true);
			} else {
				$mmhclass->db->connect($mmhclass->input->post_vars['sql_host'], $mmhclass->input->post_vars['sql_username'], $mmhclass->input->post_vars['sql_password'], $mmhclass->input->post_vars['sql_database']);

				$mmhclass->db->install_queries = array();

				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_admin_cache`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_ban_filter`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_captcha_sessions`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_file_logs`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_file_ratings`;";	
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_file_storage`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_gallery_albums`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_site_cache`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_site_settings`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_robot_info`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_robot_logs`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_user_forgotten_passwords`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_user_info`;";
				$mmhclass->db->install_queries[] = "DROP TABLE IF EXISTS `mmh_user_sessions`;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_admin_cache` (
				  `cache_id` varchar(70) NOT NULL default '',
				  `cache_value` text NOT NULL,
				  PRIMARY KEY  (`cache_id`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_ban_filter` (
				  `ban_id` int(25) NOT NULL auto_increment,
				  `time_banned` int(10) NOT NULL default '0',
				  `ban_type` tinyint(1) NOT NULL default '0',
				  `ban_value` text NOT NULL,
				  PRIMARY KEY  (`ban_id`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_captcha_sessions` (
				  `session_id` varchar(32) NOT NULL default '',
				  `session_start` int(10) NOT NULL default '0',
				  `captcha_code` varchar(7) NOT NULL default '',
				  PRIMARY KEY  (`session_id`),
				  UNIQUE KEY `captcha_code` (`captcha_code`)
				) TYPE=MyISAM;";
				
				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_file_logs` (
				  `log_id` int(25) NOT NULL auto_increment,
				  `filename` varchar(30) NOT NULL default '',
				  `filesize` int(20) NOT NULL default '0',
				  `ip_address` varchar(15) NOT NULL default '',
				  `user_agent` varchar(255) NOT NULL,
				  `time_uploaded` int(10) NOT NULL default '0',
				  `gallery_id` int(32) NOT NULL default '0',
				  `is_private` tinyint(1) NOT NULL default '0',
				  `original_filename` varchar(255) NOT NULL default '',
				  PRIMARY KEY  (`log_id`),
				  UNIQUE KEY `filename` (`filename`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_file_ratings` (
				  `rating_id` int(25) NOT NULL auto_increment,
				  `filename` varchar(30) NOT NULL default '',
				  `total_rating` int(5) NOT NULL default '5',
				  `total_votes` int(30) NOT NULL default '1',
				  `voted_by` longtext NOT NULL,
				  PRIMARY KEY  (`rating_id`),
				  UNIQUE KEY `filename` (`filename`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_file_storage` (
				  `file_id` int(25) NOT NULL auto_increment,
				  `filename` varchar(30) NOT NULL default '',
				  `is_private` tinyint(1) NOT NULL default '0',
				  `gallery_id` int(25) NOT NULL default '0',
				  `album_id` int(25) NOT NULL default '0',
				  `file_title` varchar(35) NOT NULL default '',
				  PRIMARY KEY  (`file_id`),
				  UNIQUE KEY `filename` (`filename`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_gallery_albums` (
				  `album_id` int(25) NOT NULL auto_increment,
				  `gallery_id` int(25) NOT NULL default '0',
				  `album_title` varchar(50) NOT NULL default '',
				  PRIMARY KEY  (`album_id`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_robot_info` (
				  `robot_id` int(25) NOT NULL auto_increment,
				  `preg_match` varchar(255) NOT NULL,
				  `robot_name` varchar(100) NOT NULL,
				  PRIMARY KEY  (`robot_id`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_robot_logs` (
				  `log_id` int(25) NOT NULL auto_increment,
				  `robot_id` int(25) NOT NULL default '0',
				  `page_indexed` tinytext NOT NULL,
				  `time_indexed` int(10) NOT NULL default '0',
				  `ip_address` varchar(15) NOT NULL default '',
				  `user_agent` varchar(255) NOT NULL,
				  `http_referer` tinytext NOT NULL,
				  PRIMARY KEY  (`log_id`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_site_cache` (
				  `cache_id` varchar(70) NOT NULL default '',
				  `cache_value` text NOT NULL,
				  PRIMARY KEY  (`cache_id`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_site_settings` (
				  `config_key` varchar(70) NOT NULL default '',
				  `config_value` text NOT NULL,
				  PRIMARY KEY  (`config_key`),
				  UNIQUE KEY `config_key` (`config_key`)
				) TYPE=MyISAM;";
				
				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_user_forgotten_passwords` (
				  `password_id` int(25) NOT NULL auto_increment,
				  `auth_key` varchar(32) NOT NULL default '',
				  `user_id` int(25) NOT NULL default '0',
				  `new_password` varchar(32) NOT NULL default '',
				  `time_requested` int(10) NOT NULL default '0',
				  `ip_address` varchar(15) NOT NULL default '0',
				  PRIMARY KEY  (`password_id`),
				  UNIQUE KEY `password` (`new_password`),
				  UNIQUE KEY `auth_key` (`auth_key`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_user_info` (
				  `user_id` int(25) NOT NULL auto_increment,
				  `username` varchar(30) NOT NULL default '',
				  `password` varchar(32) NOT NULL default '',
				  `email_address` varchar(255) NOT NULL,
				  `country` TEXT NOT NULL,
				  `ip_address` varchar(15) NOT NULL default '',
				  `private_gallery` tinyint(1) NOT NULL default '0',
				  `time_joined` int(10) NOT NULL default '0',
				  `user_group` varchar(20) NOT NULL default '',
				  PRIMARY KEY  (`user_id`),
				  UNIQUE KEY `username` (`username`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "CREATE TABLE `mmh_user_sessions` (
				  `session_id` varchar(32) NOT NULL default '',
				  `session_start` int(10) NOT NULL default '0',
				  `user_id` int(25) NOT NULL default '0',
				  `ip_address` varchar(15) NOT NULL default '',
				  `user_agent` varchar(255) NOT NULL,
				  PRIMARY KEY  (`session_id`)
				) TYPE=MyISAM;";

				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_cache` (`cache_id`, `cache_value`) VALUES ('page_views', '1');";

				/* Robot names provided by the phpBB Group (www.phpbb.com) */

				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (1, 'AdsBot-Google', 'AdsBot [Google]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (2, 'ia_archiver', 'Alexa [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (3, 'Scooter/', 'Alta Vista [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (4, 'Ask Jeeves', 'Ask Jeeves [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (5, 'Baidurobot', 'Baidu [robot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (6, 'Exabot/', 'Exabot [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (7, 'FAST Enterprise Crawler', 'FAST Enterprise [Crawler]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (8, 'FAST-WebCrawler/', 'FAST WebCrawler [Crawler]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (9, 'http://www.neomo.de/', 'Francis [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (10, 'Gigabot/', 'Gigabot [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (11, 'Mediapartners-Google/', 'Google Adsense [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (12, 'Google Desktop', 'Google Desktop');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (13, 'Feedfetcher-Google', 'Google Feedfetcher');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (14, 'Googlebot', 'Google [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (15, 'heise-IT-Markt-Crawler', 'Heise IT-Markt [Crawler]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (16, 'heritrix/1.', 'Heritrix [Crawler]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (17, 'ibm.com/cs/crawler', 'IBM Research [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (18, 'ICCrawler - ICjobs', 'ICCrawler - ICjobs');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (19, 'ichiro/2', 'ichiro [Crawler]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (20, 'MJ12bot/', 'Majestic-12 [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (21, 'MetagerBot/', 'Metager [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (22, 'MihalismBot', 'Mihalism [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (23, 'msnbot-NewsBlogs/', 'MSN NewsBlogs');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (24, 'msnbot/', 'MSN [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (25, 'msnbot-media/', 'MSNbot Media');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (26, 'NG-Search/', 'NG-Search [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (27, 'http://lucene.apache.org/nutch/', 'Nutch [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (28, 'NutchCVS/', 'Nutch/CVS [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (29, 'OmniExplorer_Bot/', 'OmniExplorer [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (30, 'online link validator', 'Online link [Validator]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (31, 'psbot/0', 'psbot [Picsearch]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (32, 'Seekbot/', 'Seekport [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (33, 'Sensis Web Crawler', 'Sensis [Crawler]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (34, 'SEO search Crawler/', 'SEO Crawler');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (35, 'Seoma [SEO Crawler]', 'Seoma [Crawler]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (36, 'SEOsearch/', 'SEOSearch [Crawler]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (37, 'Snappy/1.1 ( http://www.urltrends.com/ )', 'Snappy [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (38, 'http://www.tkl.iis.u-tokyo.ac.jp/~crawler/', 'Steeler [Crawler]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (39, 'SynooBot/', 'Synoo [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (40, 'crawleradmin.t-info@telekom.de', 'Telekom [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (41, 'TurnitinBot/', 'TurnitinBot [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (42, 'voyager/1.0', 'Voyager [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (43, 'W3 SiteSearch Crawler', 'W3 [Sitesearch]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (44, 'W3C-checklink/', 'W3C [Linkcheck]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (45, 'W3C_*Validator', 'W3C [Validator]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (46, 'http://www.WISEnutbot.com', 'WiseNut [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (47, 'yacybot', 'Yacy [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (48, 'Yahoo-MMCrawler/', 'Yahoo MMCrawler [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (49, 'Yahoo! DE Slurp', 'Yahoo Slurp [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (50, 'Yahoo! Slurp', 'Yahoo [Bot]');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_robot_info` (`robot_id`, `preg_match`, `robot_name`) VALUES (51, 'YahooSeeker/', 'YahooSeeker [Bot]');";

				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('thumbnail_width', '160');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('thumbnail_height', '160');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('date_format', 'F j, Y, g:i:s a');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('max_results', '20');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('upload_path', 'files/');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('file_extensions', 'jpeg,jpg,gif,png');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('user_file_extensions', 'jpeg,jpg,gif,png,ico');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('max_filesize', '1075000');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('user_max_filesize', '3145728');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('site_name', 'مركز رفع الصور');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('email_out', '{$mmhclass->input->post_vars['email_address']}');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('gallery_viewing', '1');";
				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_site_settings` (`config_key`, `config_value`) VALUES ('advanced_thumbnails', '0');";

				$mmhclass->db->install_queries[] = "INSERT INTO `mmh_user_info` (`username`, `password`, `email_address`, `country`, `ip_address`, `private_gallery`, `time_joined`, `user_group`) VALUES ('{$mmhclass->input->post_vars['username']}', '".md5($mmhclass->input->post_vars['password'])."', '{$mmhclass->input->post_vars['email_address']}',  '{$mmhclass->input->post_vars['country']}', '{$mmhclass->input->server_vars['remote_addr']}', 0, ".time().", 'root_admin');";

				for ($i = 0; $i < count($mmhclass->db->install_queries); $i++) {
					$mmhclass->db->query($mmhclass->db->install_queries[$i]);
				}
				
				/* Attempt to write htaccess for custom error */
				if ($htaccess = fopen("{$mmhclass->info->root_path}files/.htaccess", "a")) {
					$file_string = "\nErrorDocument 404 {$mmhclass->info->script_path}css/images/error404.gif";
					fwrite($htaccess, $file_string);
				}
				chmod("{$mmhclass->info->root_path}files/.htaccess", 0444);

				if ($config = fopen("{$mmhclass->info->root_path}source/includes/config.php", "w")) {
					$file_string = "<"."?php\n\n";
					$file_string .= "\t\t\t\t\t$"."mmhclass->info->config                 = array();
					$"."mmhclass->info->site_installed         = true;\n
					/"."* DATABASE INFORMATION *"."/ \n
					$"."mmhclass->info->config['sql_host']       = \"{$mmhclass->input->post_vars['sql_host']}\";
					$"."mmhclass->info->config['sql_username']   = \"{$mmhclass->input->post_vars['sql_username']}\";
					$"."mmhclass->info->config['sql_password']   = \"{$mmhclass->input->post_vars['sql_password']}\";
					$"."mmhclass->info->config['sql_database']   = \"{$mmhclass->input->post_vars['sql_database']}\";
					//$"."mmhclass->info->config['sql_tbl_prefix'] = \"mmh_\";"; 
					$file_string .= "\n\n?".">";
					if (fwrite($config, $file_string) == false) {
						$mmhclass->templ->error("من فضلك تأكد أن الملف <b>source/includes/config.php</b> موجود. وله التصريح 0777.");
					}
				} else {
					$config->templ->error("من فضلك تأكد أن الملف <b>source/includes/config.php</b> موجود. وله التصريح 0777.");
				}

				$mmhclass->templ->message("تم تثبيت الموقع بنجاح. <br /><br /> <a href=\"index.php\">الصفحة الرئيسية للموقع</a>", true);
			}
			break;
		default:
			$mmhclass->templ->output("install", "installer_intro_page");
	}
	
?>
