<?php
	// ======================================== \
	// Package: Mihalism Multi Host
	// Version: 4.0.0
	// Copyright (c) 2007, 2008 Mihalism, Inc.
	// License: http://www.gnu.org/licenses/gpl.txt GNU Public License
	// ======================================== /

	require_once "./source/includes/data.php";
	
	$mmhclass->templ->page_title = "{$mmhclass->info->config['site_name']} &raquo; ";

	switch ($mmhclass->input->get_vars['act']) {
		case "register":
			$mmhclass->templ->templ_vars[] = array(
				"SITE_NAME"    => $mmhclass->info->config['site_name'],
				"LIGHTBOX_ID"  => $mmhclass->input->get_vars['lb_div'],
				"RETURN_URL"   => $mmhclass->input->get_vars['return'],
			);
			
			exit($mmhclass->templ->parse_template("users", "registration_lightbox"));
			break;
		case "register-d":
			$mmhclass->templ->page_title .= "التسجيل";
			
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['username'])  == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['password']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['password-c']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['email_address']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['iagree']) == true) {
				$mmhclass->templ->error("من فضلك تأكد من كتابة جميع البيانات بشكل صحيح.", true);
			} elseif ($mmhclass->funcs->valid_email($mmhclass->input->post_vars['email_address']) == false) {
				$mmhclass->templ->error("صيغة البريد الإلكتروني غير صحيحة.", true);
			} elseif ($mmhclass->input->post_vars['password'] != $mmhclass->input->post_vars['password-c']) {
				$mmhclass->templ->error("من فضلك تأكد من أن كلمتي المرور متطابقتين. ", true);
			} elseif (strlen($mmhclass->input->post_vars['password']) < 6 || strlen($mmhclass->input->post_vars['password']) > 30) {
				$mmhclass->templ->error("من فضلك تأكد أن كلمة المرور بين 6 و 30 حرف أو رقم.", true);
			} elseif ($mmhclass->funcs->valid_string($mmhclass->input->post_vars['username']) == false || strlen($mmhclass->input->post_vars['username']) < 3 || strlen($mmhclass->input->post_vars['username']) > 30) {
				$mmhclass->templ->error("من فضلك تأكد من أن اسم المستخدم بين 3 و 30 حرف أو رقم.", true);
			} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `username` = '{$mmhclass->input->post_vars['username']}';")) == 1) {
				$mmhclass->templ->error("اسم المستخدم موجود بالفعل من فضلك اختر اسما آخر.", true);
			} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `email_address` = '{$mmhclass->input->post_vars['email_address']}';")) == 1) {
				$mmhclass->templ->error("تم التسجيل بهذا البريد الإلكتروني من قبل. من فضلك اختر بريد الكتروني آخر.", true);
			} else {
				$mmhclass->db->query("INSERT INTO `mmh_user_info` (`username`, `password`, `email_address`, `country`, `ip_address`, `private_gallery`, `time_joined`, `user_group`) VALUES ('{$mmhclass->input->post_vars['username']}', '".md5($mmhclass->input->post_vars['password'])."', '{$mmhclass->input->post_vars['email_address']}', '{$mmhclass->input->post_vars['country']}', '{$mmhclass->input->server_vars['remote_addr']}', 0, ".time().", 'normal_user');");

				$mmhclass->templ->message("<b>{$mmhclass->input->post_vars['username']}</b>, لقد قمت بالتسجيل بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);		
			}
			break;
		case "login":
			$mmhclass->templ->templ_vars[] = array(
				"LIGHTBOX_ID" => $mmhclass->input->get_vars['lb_div'],
				"RETURN_URL"  => $mmhclass->input->get_vars['return'],
			);
			
			exit($mmhclass->templ->parse_template("users", "login_lightbox"));
			break;
		case "login-d":
			$mmhclass->templ->page_title .= "تسجيل الدخول";
			
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['username']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['password'] == true)) {
				$mmhclass->templ->error("من فضلك تأكد من كتابة جميع البيانات بشكل صحيح.", true);
			} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `username` = '{$mmhclass->input->post_vars['username']}' AND `password` = '".md5($mmhclass->input->post_vars['password'])."';")) != 1) {
				$mmhclass->templ->error("خطأ في اسم المستخدم أو كلمة المرور.", true);
			} else {
				$session_id = md5($mmhclass->funcs->random_string(30));
				$mmhclass->info->user_data = $mmhclass->db->fetch_array($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `username` = '{$mmhclass->input->post_vars['username']}' AND `password` = '".md5($mmhclass->input->post_vars['password'])."';"));
				$mmhclass->db->query("UPDATE `mmh_user_info` SET `ip_address` = '{$mmhclass->input->server_vars['remote_addr']}' WHERE `user_id` = '{$mmhclass->info->user_data['user_id']}';");
				$mmhclass->db->query("INSERT INTO `mmh_user_sessions` (session_id, session_start, user_id, user_agent, ip_address) VALUES ('{$session_id}', '".time()."', '{$mmhclass->info->user_data['user_id']}', '{$mmhclass->input->server_vars['http_user_agent']}', '{$mmhclass->input->server_vars['remote_addr']}');");

				 if(isset($_POST['remember'])){
      setcookie("cookname", $_SESSION['username'], time()+60*60*24*100, "/");
      setcookie("cookpass", $_SESSION['password'], time()+60*60*24*100, "/");
   }	

				if (setcookie("mmh_user_session", serialize(array("session_id" => $session_id, "user_id" => $mmhclass->info->user_data['user_id'])), (time() + 31536000), $mmhclass->info->script_path) == true) {
					$mmhclass->info->is_user = true;
					$mmhclass->templ->message("لقد قمت بتسجيل الدخول بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /><br /> <a href=\"users.php?act=gallery\">معرض صوري</a> <br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
				} else {
					$mmhclass->templ->error("Log in failed. <br /><br /> Failed to set cookie <b>mmh_user_session</b>.", true);
				}
			}
			break;
		case "logout":
			$mmhclass->templ->page_title .= "الخروج";
			
			if (setcookie("mmh_user_session", "session_delete", (time() - 60000)) == true) {
				$mmhclass->info->is_user = false;
				$mmhclass->templ->message("لقد قمت بتسجيل الخروج بنجاح. <br /><br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
			} else {
				$mmhclass->templ->error("Log out failed. <br /><br /> Failed to unset cookie <b>mmh_user_session</b>.", true);
			}
			break;
		case "lost_password":
			$mmhclass->templ->templ_vars[] = array(
				"LIGHTBOX_ID" => $mmhclass->input->get_vars['lb_div'],
			);
			
			exit($mmhclass->templ->parse_template("users", "forgotten_password_lightbox"));
			break;
		case "lost_password-d":
			$mmhclass->templ->page_title .= "استعادة كلمة المرور";
			
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['username']) == true || $mmhclass->funcs->is_null($mmhclass->input->post_vars['email_address']) == true) {
				$mmhclass->templ->error("من فضلك تأكد من كتابة جميع البيانات بشكل صحيح.", true);
			} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `username` = '{$mmhclass->input->post_vars['username']}' AND `email_address` = '{$mmhclass->input->post_vars['email_address']}';")) != 1) {
				$mmhclass->templ->error("خطأ في اسم المستخدم أو في البريد الإلكتروني.", true);
			} else {
				$auth_key     = md5($mmhclass->funcs->random_string(30));
				$new_password = $mmhclass->funcs->random_string(10);
				$user_data    = $mmhclass->db->fetch_array($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `username` = '{$mmhclass->input->post_vars['username']}' AND `email_address` = '{$mmhclass->input->post_vars['email_address']}';"));

				$mmhclass->db->query("INSERT INTO `mmh_user_forgotten_passwords` (auth_key, new_password, user_id, time_requested, ip_address) VALUES ('{$auth_key}', '".md5($new_password)."', '{$user_data['user_id']}', '".time()."', '{$mmhclass->input->server_vars['remote_addr']}');");
        
				$mmhclass->templ->templ_vars[] = array(
					"USERNAME"     => $user_data['username'],
					"BASE_URL"     => $mmhclass->info->base_url,
					"AUTH_KEY"    => $auth_key,
					"NEW_PASSWORD" => $new_password,
				);
			$message_body = strip_tags(str_replace("<br />", "\n", $mmhclass->templ->parse_template("users", "forgotten_password_email")));

				if (mail($user_data['email_address'], "كلمة المرور الجديدة في {$mmhclass->info->config['site_name']}", $message_body, "From: {$mmhclass->info->config['site_name']} <{$mmhclass->info->config['email_out']}>")) {
					$mmhclass->templ->message("تم إرسال رابط التفعيل وكلمة المرور الجديدة إلى بريدك الإلكتروني. لن يتم تغيير كلمة المرور إلا بعد الضغط على رابط التفعيل. <br /><br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
				} else {
					$mmhclass->templ->error("فشلت عملية إرسال البريد الإلكتروني بسبب خطأ غير محدد.");
				}
			}	
			break;
		case "lost_password-a":
			$mmhclass->templ->page_title .= "تفعيل كلمة المرور";
			
			if ($mmhclass->funcs->is_null($mmhclass->input->get_vars['id']) == true || $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_forgotten_passwords` WHERE `auth_key` = '{$mmhclass->input->get_vars['id']}';")) != 1) {
				$mmhclass->templ->error("الكود المدخل غير موجود أو تم استخدامه بالفعل.", true);
			} else {
				$new_password_data = $mmhclass->db->fetch_array($mmhclass->db->query("SELECT * FROM `mmh_user_forgotten_passwords` WHERE `auth_key` = '{$mmhclass->input->get_vars['id']}';"));

				$mmhclass->db->query("DELETE FROM `mmh_user_forgotten_passwords` WHERE `auth_key` = '{$mmhclass->input->get_vars['id']}';");
				$mmhclass->db->query("UPDATE `mmh_user_info` SET `password` = '{$new_password_data['new_password']}' WHERE `user_id` = '{$new_password_data['user_id']}';");
			
				$mmhclass->templ->message("تم تغيير كلمة المرور بنجاح.<br />يمكنك تسجيل الدخول الآن باستخدام كلمة المرور الموجودة في رسالة التفعيل<br /><br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
			}
			break;
		case "user_list":
			$mmhclass->templ->page_title .= "الأعضاء";

			$sql = $mmhclass->db->query("SELECT * FROM `mmh_user_info` ORDER BY `user_id` ASC LIMIT <# QUERY_LIMIT #>;");
			while ($row = $mmhclass->db->fetch_array($sql)) {
				$mmhclass->templ->templ_globals['get_whileloop'] = true;
				
				$mmhclass->templ->templ_vars[] = array(
					"USERNAME"        => $row['username'],
					"USER_ID"         => $row['user_id'],
          "COUNTRY"            => $row['country'],
					"TDCLASS"         => $tdclass = (($tdclass == "tdrow1") ? "tdrow2" : "tdrow1"),
					"TIME_JOINED"     => date($mmhclass->info->config['date_format'], $row['time_joined']),
					"GALLERY_STATUS"  => (($row['private_gallery'] == 1) ? "مخفي" : "عام"),
					"TOTAL_UPLOADS"   => $mmhclass->funcs->format_number($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$row['user_id']}' AND `is_private` = '0';"))),
				);

				$mmhclass->templ->templ_globals['user_list_whileloop'] .= $mmhclass->templ->parse_template("users", "user_list_page");

				unset($mmhclass->templ->templ_globals['get_whileloop'], $mmhclass->templ->templ_vars);	
			}

			$mmhclass->templ->templ_vars[] = array(
				"PAGINATION_LINKS" => $mmhclass->templ->pagelinks("users.php?act=user_list", $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info`;"))),
			);

			$mmhclass->templ->output("users", "user_list_page");
			break;
		case "gallery":
			$mmhclass->templ->page_title .= "معرض الصور";
			
			$mmhclass->input->get_vars['gal']   = round($mmhclass->input->get_vars['gal']);
			$mmhclass->input->get_vars['cat']   = round($mmhclass->input->get_vars['cat']);
			$mmhclass->info->gallery_owner_data = (($mmhclass->funcs->is_null($mmhclass->input->get_vars['gal']) == false) ? $mmhclass->db->fetch_array($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `user_id` = '{$mmhclass->input->get_vars['gal']}';")) : $mmhclass->info->user_data);
			$mmhclass->info->gallery_url        = ("{$mmhclass->info->base_url}users.php?act=gallery".(($mmhclass->funcs->is_null($mmhclass->input->get_vars['gal']) == true) ? NULL : "&amp;gal={$mmhclass->info->gallery_owner_data['user_id']}"));

			if ($mmhclass->funcs->is_null($mmhclass->input->get_vars['gal']) == true && $mmhclass->info->is_user == false) {
				$mmhclass->templ->error("يجب أن تسجل الدخول أولا حتى ترى معرضك.", true);
			} elseif ($mmhclass->funcs->is_null($mmhclass->input->get_vars['gal']) == false && $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `user_id` = '{$mmhclass->input->get_vars['gal']}';")) != 1) {
				$mmhclass->templ->error("المعرض المحدد غير موجود.", true);
			} elseif ($mmhclass->info->is_admin == false && $mmhclass->funcs->is_null($mmhclass->input->get_vars['gal']) == false && $mmhclass->info->gallery_owner_data['private_gallery'] == 1) {
				$mmhclass->templ->message("قام هذا العضو بإخفاء معرضه عن الآخرين.", true);
			} else {
				$hide_private_images = (($mmhclass->funcs->is_null($mmhclass->input->get_vars['gal']) == false) ? " AND `is_private` = '0'" : NULL);
				if ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}' AND `album_id` = '{$mmhclass->input->get_vars['cat']}' {$hide_private_images} ORDER BY `file_id` DESC LIMIT <# QUERY_LIMIT #>;")) < 1) {
					$mmhclass->templ->templ_globals['empty_gallery'] = true;
				} else {
					$sql = $mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}' AND `album_id` = '{$mmhclass->input->get_vars['cat']}' {$hide_private_images} ORDER BY `file_id` DESC LIMIT <# QUERY_LIMIT #>;");
					while ($row = $mmhclass->db->fetch_array($sql)) {
						if ($tdcount >= 4) {
							$break_line = true;
							$tdcount = 0;
						}
						$tdcount++;
					
						if ($mmhclass->funcs->is_null($mmhclass->input->get_vars['gal']) == true) {
							$mmhclass->templ->templ_globals['file_options'] = true;
						}
					
						$mmhclass->templ->templ_vars[] = array(
							"FILENAME"     => $row['filename'],
							"FILE_TITLE"   => (($mmhclass->funcs->is_null($mmhclass->input->get_vars['gal']) == true) ? "<span class=\"arial\" title=\"اضغط لإعادة التسمية\" id=\"{$row['filename']}\" onclick=\"javascript:gallery_action('rename', this.id);\">{$row['file_title']}</span>" : "<a href=\"viewer.php?file={$row['filename']}\">{$row['file_title']}</a>"),
							"TDCLASS"      => $tdclass = (($tdclass == "tdrow1") ? "tdrow2" : "tdrow1"),
							"TABLE_BREAK"  => (($break_line == true) ? "</tr><tr>" : NULL),
						);
					
						$gallery_html .= $mmhclass->templ->parse_template("global", "global_gallery_layout");

						unset($break_line, $mmhclass->templ->templ_globals['get_whileloop'], $mmhclass->templ->templ_vars);	
					}
				}
							
				$sql = $mmhclass->db->query("SELECT * FROM `mmh_gallery_albums` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}';");
				while ($row = $mmhclass->db->fetch_array($sql)) {
					$mmhclass->templ->templ_globals['get_whileloop'] = true;
				
					$mmhclass->templ->templ_vars[] = array(
						"ALBUM_ID"      => $row['album_id'],
						"ALBUM_NAME"    => $row['album_title'],
						"TOTAL_UPLOADS" => $mmhclass->funcs->format_number($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}' AND `album_id` = '{$row['album_id']}';"))),
						"PAGE_URL"      => $mmhclass->info->gallery_url,
						"RETURN_URL"         => base64_encode($mmhclass->info->page_url),
					);
					
					$mmhclass->templ->templ_globals['album_pulldown_link_whileloop'] .= $mmhclass->templ->parse_template("users", "my_gallery_page");

					unset($mmhclass->templ->templ_vars, $mmhclass->templ->templ_globals['get_whileloop']);
				}
		
				$mmhclass->templ->templ_vars[] = array(
					"GALLERY_OWNER"      => $mmhclass->info->gallery_owner_data['username'],
					"PAGINATION_LINKS"   => $mmhclass->templ->pagelinks(($mmhclass->info->gallery_url.(($mmhclass->funcs->is_null($mmhclass->input->get_vars['cat']) == true) ? NULL : "&amp;cat={$mmhclass->input->get_vars['cat']}")), $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}' AND `album_id` = '{$mmhclass->input->get_vars['cat']}' {$hide_private_images};"))),			
					"GALLERY_HTML"       => $gallery_html,
					"GALLERY_ID"         => $mmhclass->info->gallery_owner_data['user_id'],
					"CURRENT_PAGE"       => $mmhclass->info->current_page,
					"PAGE_URL"           => $mmhclass->info->gallery_url,
					"RETURN_URL"         => base64_encode($mmhclass->info->page_url),
					"EMPTY_GALLERY"      => $mmhclass->templ->message("لا يوجد صور في هذه الصفحة حاليا.", false),
					"TOTAL_UPLOADS"      => $mmhclass->funcs->format_number($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}';"))),
					"TOTAL_ROOT_UPLOADS" => $mmhclass->funcs->format_number($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->gallery_owner_data['user_id']}' AND `album_id` = '0';"))),
				);
				
				$mmhclass->templ->output("users", "my_gallery_page");
			}
			break;
		case "rename_file_title":
			if ($mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} elseif ($mmhclass->funcs->is_null($mmhclass->input->get_vars['file']) == true) {
				$mmhclass->templ->error("يجب أن تختار صورة لتستمر.", true);
			} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($mmhclass->input->get_vars['file'])) == false) {
				$mmhclass->templ->error("الصورة المحددة <b>{$mmhclass->input->get_vars['file']}</b> غير موجودة.", true);
			} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->user_data['user_id']}' AND `filename` = '{$mmhclass->input->get_vars['file']}';")) != 1) {
				$mmhclass->templ->error("لا يمكنك إعادة تسمية الصورة <b>{$mmhclass->input->get_vars['file']}</b> لأنها ليست من صورك.", true);
			} else {
				$filename  = basename($mmhclass->input->get_vars['file']);
				$new_title = strip_tags($mmhclass->input->get_vars['title']);
				
				$mmhclass->db->query("UPDATE `mmh_file_storage` SET `file_title` = '{$new_title}' WHERE `filename` = '{$filename}';");
	
				exit($new_title);
			}
			break;
		case "move_files":
			if ($mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} else {
				$files_to_move = preg_split("/,/", $mmhclass->input->get_vars['files']);
				for ($i = 0; $i < count($files_to_move); $i++) {
					$filename = basename($files_to_move[$i]);
					if ($mmhclass->funcs->is_null($filename) == true) {
						$mmhclass->templ->error("يجب أن تختار صورة لتستمر.", true);
					} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($filename)) == false) {
						$mmhclass->templ->error("الصورة المحددة <b>{$filename}</b> غير موجودة.", true);
					} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->user_data['user_id']}' AND `filename` = '{$filename}';")) != 1) {
						$mmhclass->templ->error("لا يمكنك نقل الصورة <b>{$filename}</b> لأنها ليست من صورك.", true);
					}
				}
			
				$sql = $mmhclass->db->query("SELECT * FROM `mmh_gallery_albums` WHERE `gallery_id` = '{$mmhclass->info->user_data['user_id']}';");
				while ($row = $mmhclass->db->fetch_array($sql)) {
					$mmhclass->templ->templ_globals['get_whileloop'] = true;
					
					$mmhclass->templ->templ_vars[] = array(
						"ALBUM_ID"   => $row['album_id'],
						"ALBUM_NAME" => $row['album_title'],
					);
	
					$mmhclass->templ->templ_globals['album_options_whileloop'] .= $mmhclass->templ->parse_template("users", "move_files_lightbox");

					unset($mmhclass->templ->templ_vars, $mmhclass->templ->templ_globals['get_whileloop']);
				}
			
				$mmhclass->templ->templ_vars[] = array(
					"FILES_TO_MOVE" => $mmhclass->input->get_vars['files'],
					"LIGHTBOX_ID"   => $mmhclass->input->get_vars['lb_div'],
					"RETURN_URL"    => base64_encode(urldecode($mmhclass->input->get_vars['return'])),
				);
			
				exit($mmhclass->templ->parse_template("users", "move_files_lightbox"));
			}
			break;
		case "move_files-d":
			$mmhclass->templ->page_title .= "نقل الصور";
			
			if ($mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} else {
				$files_to_move = preg_split("/,/", $mmhclass->input->post_vars['files']);
				for ($i = 0; $i < count($files_to_move); $i++) {
					$filename = basename($files_to_move[$i]);
					if ($mmhclass->funcs->is_null($filename) == true) {
						$mmhclass->templ->error("يجب أن تختار صورة لتستمر.", true);
					} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($filename)) == false) {
						$mmhclass->templ->error("الصورة المحددة <b>{$filename}</b> غير موجودة.", true);
					} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->user_data['user_id']}' AND `filename` = '{$filename}';")) != 1) {
						$mmhclass->templ->error("لا يمكنك نقل الصورة <b>{$filename}</b> لأنها ليست من صورك.", true);
					} else {
						$album_id = round($mmhclass->input->post_vars['move_to']);
						$filename = basename($filename);
						
						$mmhclass->db->query("UPDATE `mmh_file_storage` SET `album_id` = '{$album_id}' WHERE `filename` = '{$filename}';");
					}
				}
				
				$mmhclass->templ->message("تم نقل الصور المحددة بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
			}
			break;
		case "delete_files":
			if ($mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} else {
				$files_to_delete = preg_split("/,/", $mmhclass->input->get_vars['files']);
				for ($i = 0; $i < count($files_to_delete); $i++) {
					$filename = basename($files_to_delete[$i]);
					if ($mmhclass->funcs->is_null($filename) == true) {
						$mmhclass->templ->error("يجب أن تختار صورة لتستمر.", true);
					} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($filename)) == false) {
						$mmhclass->templ->error("الصورة المحددة <b>{$filename}</b> غير موجودة.", true);
					} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->user_data['user_id']}' AND `filename` = '{$filename}';")) != 1) {
						$mmhclass->templ->error("لا يمكنك حذف الصورة <b>{$filename}</b> لأنها ليست من صورك.", true);
					}
				}
			
				$mmhclass->templ->templ_vars[] = array(
					"FILES_TO_DELETE" => $mmhclass->input->get_vars['files'],
					"LIGHTBOX_ID"     => $mmhclass->input->get_vars['lb_div'],
					"RETURN_URL"      => base64_encode(urldecode($mmhclass->input->get_vars['return'])),
				);
			
				exit($mmhclass->templ->parse_template("users", "delete_files_lightbox"));
			}
			break;
		case "delete_files-d":
			$mmhclass->templ->page_title .= "حذف صور";
			
			if ($mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} else {
				$files_to_delete = preg_split("/,/", $mmhclass->input->post_vars['files']);
				for ($i = 0; $i < count($files_to_delete); $i++) {
					$filename = basename($files_to_delete[$i]);
					if ($mmhclass->funcs->is_null($filename) == true) {
						$mmhclass->templ->error("يجب أن تختار صورة لتستمر.", true);
					} elseif (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].basename($filename)) == false) {
						$mmhclass->templ->error("الصورة المحددة <b>{$filename}</b> غير موجودة.", true);
					} elseif ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage` WHERE `gallery_id` = '{$mmhclass->info->user_data['user_id']}' AND `filename` = '{$filename}';")) != 1) {
						$mmhclass->templ->error("لا يمكنك حذف الصورة <b>{$filename}</b> لأنها لسيت من صورك.", true);
					} else {
						$filename = basename($filename);
						
						if (unlink($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$filename) == false) {
							$mmhclass->templ->error("فشلت عملية حذف الصورة <b>{$filename}</b> بسبب خطأ غير معروف.", true);
						}
						
						if (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($filename)) == true) {
							if (unlink($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$mmhclass->image->thumbnail_name($filename)) == false) {
								$mmhclass->templ->error("فشلت عملية حذف مصغرة الصورة <b>{$filename}</b> بسبب خطأ غير معروف.", true);
							}
						}
						
						$mmhclass->db->query("DELETE FROM `mmh_file_storage` WHERE `filename` = '{$filename}';");
					}
				}
				
				$mmhclass->templ->message("تم حذف الصور المحددة بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
			}
			break;
		case "albums-c":
			if ($mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} else {
				$mmhclass->templ->templ_vars[] = array(
					"LIGHTBOX_ID" => $mmhclass->input->get_vars['lb_div'],
					"RETURN_URL"  => $mmhclass->input->get_vars['return'],
				);
			
				exit($mmhclass->templ->parse_template("users", "new_album_lightbox"));
			}
			break;
		case "albums-c-d":
			$mmhclass->templ->page_title .= "ألبوم جديد";
			
			if ($mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} elseif ($mmhclass->funcs->is_null($mmhclass->input->post_vars['album_title']) == true) {
				$mmhclass->templ->error("من فضلك تأكد من كتابة جميع البيانات بشكل صحيح.", true);
			} else {
				$mmhclass->db->query("INSERT INTO `mmh_gallery_albums` (`album_title`, `gallery_id`) VALUES ('{$mmhclass->input->post_vars['album_title']}', '{$mmhclass->info->user_data['user_id']}');");
				
				$mmhclass->templ->message("تم إنشاء الألبوم بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
			}
			break;
		case "albums-r":
			if ($mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} else {
				$album_id = round($mmhclass->input->get_vars['album']);
				
				if ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_gallery_albums` WHERE `album_id` = '{$album_id}' AND `gallery_id` = '{$mmhclass->info->user_data['user_id']}';")) != 1) {
					$mmhclass->templ->error("لا يمكنك تغيير اسم الألبوم المحدد لأنه ليس بمعرضك.", true);
				} else {
					$mmhclass->templ->templ_vars[] = array(
						"LIGHTBOX_ID" => $mmhclass->input->get_vars['lb_div'],
						"RETURN_URL"  => $mmhclass->input->get_vars['return'],
						"ALBUM_ID"    => $album_id,
					);
			
					exit($mmhclass->templ->parse_template("users", "rename_album_lightbox"));
				}
			}
			break;
		case "albums-r-d":
			$mmhclass->templ->page_title .= "إعادة تسمية ألبوم";
			
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['album']) == true || $mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} elseif ($mmhclass->funcs->is_null($mmhclass->input->post_vars['album_title']) == true) {
				$mmhclass->templ->error("من فضلك تأكد من كتابة جميع البيانات بشكل صحيح.", true);
			} else {
				$album_id = round($mmhclass->input->post_vars['album']);
				
				if ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_gallery_albums` WHERE `album_id` = '{$album_id}' AND `gallery_id` = '{$mmhclass->info->user_data['user_id']}';")) != 1) {
					$mmhclass->templ->error("لا يمكنك تغيير اسم الألبوم المحدد لأنه ليس بمعرضك.", true);
				} else {
					$mmhclass->db->query("UPDATE `mmh_gallery_albums` SET `album_title` = '{$mmhclass->input->post_vars['album_title']}' WHERE `album_id` = '{$album_id}';");
				
					$mmhclass->templ->message("تم تغيير اسم الألبوم بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
				}
			}
			break;
		case "albums-d":
			if ($mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} else {
				$album_id = round($mmhclass->input->get_vars['album']);
				
				if ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_gallery_albums` WHERE `album_id` = '{$album_id}' AND `gallery_id` = '{$mmhclass->info->user_data['user_id']}';")) != 1) {
					$mmhclass->templ->error("لا يمكنك حذف الألبوم المحدد لأنه ليس بمعرضك.", true);
				} else {
					$mmhclass->templ->templ_vars[] = array(
						"ALBUM_TO_DELETE" => $album_id,
						"LIGHTBOX_ID"     => $mmhclass->input->get_vars['lb_div'],
						"RETURN_URL"      => $mmhclass->input->get_vars['return'],
					);
			
					exit($mmhclass->templ->parse_template("users", "delete_album_lightbox"));
				}
			}
			break;
		case "albums-d-d":
			$mmhclass->templ->page_title .= "حذف ألبوم";
			
			if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['album']) == true || $mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} else {
				$album_id = round($mmhclass->input->post_vars['album']);
				
				if ($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_gallery_albums` WHERE `album_id` = '{$album_id}' AND `gallery_id` = '{$mmhclass->info->user_data['user_id']}';")) != 1) {
					$mmhclass->templ->error("لا يمكنك حذف الألبوم المحدد لأنه ليس بمعرضك.", true);
				} else {
					$mmhclass->db->query("UPDATE `mmh_file_storage` SET `album_id` = '0' WHERE `album_id` = '{$album_id}' AND `gallery_id`  = '{$mmhclass->info->user_data['user_id']}';");
					$mmhclass->db->query("DELETE FROM `mmh_gallery_albums` WHERE `album_id` = '{$album_id}' AND `gallery_id`  = '{$mmhclass->info->user_data['user_id']}';");

					$mmhclass->templ->message("تم حذف الألبوم بنجاح. <br /><br /> <a href=\"index.php?rurl={$mmhclass->input->post_vars['return']}\">العودة للصفحة السابقة</a> <br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
				}
			}
			break;
		case "settings":
			$mmhclass->templ->page_title .= "الإعدادات";
			
			if ($mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} else {
				$mmhclass->templ->templ_vars[] = array(
					"USER_ID"             => $mmhclass->info->user_data['user_id'],
					"USERNAME"            => $mmhclass->info->user_data['username'],
					"IP_ADDRESS"          => $mmhclass->info->user_data['ip_address'],
					"EMAIL_ADDRESS"       => $mmhclass->info->user_data['email_address'],
          "COUNTRY"                => $mmhclass->info->user_data['country'],
					"PRIVATE_GALLERY_YES" => (($mmhclass->info->user_data['private_gallery'] == 1) ? "checked=\"checked\"" : NULL),
					"PRIVATE_GALLERY_NO"  => (($mmhclass->info->user_data['private_gallery'] == 0) ? "checked=\"checked\"" : NULL),
					"TIME_JOINED"         => date($mmhclass->info->config['date_format'], $mmhclass->info->user_data['time_joined']),
					"USER_GROUP"          => ((preg_match("/admin/i", $mmhclass->info->user_data['user_group']) == true) ? "مدير" : "عضو مشترك"),
				);
			
				$mmhclass->templ->output("users", "user_settings_page");
			}
			break;
		case "settings-s":
			$mmhclass->templ->page_title .= "الإعدادات";

			if ($mmhclass->info->is_user == false) {
				$mmhclass->templ->error("آسف ولكنك لا تملك التصريح بالدخول لهذه الصفحة.", true);
			} elseif ($mmhclass->funcs->is_null($mmhclass->input->post_vars['email_address']) == true) {
				$mmhclass->templ->error("من فضلك تأكد من كتابة جميع البيانات بشكل صحيح.", true);
			} elseif ($mmhclass->funcs->valid_email($mmhclass->input->post_vars['email_address']) == false) {
				$mmhclass->templ->error("صيغة البريد الإلكتروني غير صحيحة.", true);
			} elseif ($mmhclass->funcs->is_null($mmhclass->input->post_vars['password']) == false && strlen($mmhclass->input->post_vars['password']) < 6 || strlen($mmhclass->input->post_vars['password']) > 30) {
				$mmhclass->templ->error("من فضلك تأكد من أن كلمة المرور بين 6 و 30 حرف أو رقم.", true);
			} elseif ($mmhclass->input->post_vars['email_address'] != $mmhclass->info->user_data['email_address'] && $mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_user_info` WHERE `email_address` = '{$mmhclass->input->post_vars['email_address']}';")) == 1) {
				$mmhclass->templ->error("تم التسجيل بهذا البريد الإلكتروني من قبل. من فضلك اختر بريد الكتروني آخر.", true);
			} else {
				$mmhclass->db->query("UPDATE `mmh_user_info` SET `email_address` = '{$mmhclass->input->post_vars['email_address']}',  `country` = '{$mmhclass->input->post_vars['country']}',  `private_gallery` = '{$mmhclass->input->post_vars['private_gallery']}' WHERE `user_id` = '{$mmhclass->info->user_data['user_id']}';");

				if ($mmhclass->funcs->is_null($mmhclass->input->post_vars['password']) == false) {
					$user_password = md5($mmhclass->input->post_vars['password']);
					$mmhclass->db->query("UPDATE `mmh_user_info` SET `password` = '{$user_password}' WHERE `user_id` = '{$mmhclass->info->user_data['user_id']}';");
				}

				$mmhclass->templ->message("تم تغيير الإعدادات بنجاح. <br /><br /> <a href=\"users.php?act=settings\">تغيير الإعدادات مرة أخرى</a> <br /> <a href=\"index.php\">الصفحة الرئيسية</a>", true);
			}
			break;
		default: 
			$mmhclass->templ->error("لقد وصلت هذه الصفحة عن طريق الخطأ,  <br /> <a href=\"index.php\">الصفحة الرئيسية<{$mmhclass->info->config['site_name']}</a>.");
	}	

?>
