<?php
	// ======================================== \
	// Package: Mihalism Multi Host
	// Version: 4.0.0
	// Copyright (c) 2007, 2008 Mihalism, Inc.
	// License: http://www.gnu.org/licenses/gpl.txt GNU Public License
	// ======================================== /

	require_once "./source/includes/data.php";

	$mmhclass->templ->page_title = "{$mmhclass->info->config['site_name']} &raquo; ";

	switch ($mmhclass->input->get_vars['act']) {
		case "about_us":
			$mmhclass->templ->page_title .= "About Us";
			
			$mmhclass->templ->templ_vars[] = array(
				"SITE_NAME"     => $mmhclass->info->config['site_name'],
				"TOTAL_UPLOADS" => $mmhclass->funcs->format_number($mmhclass->db->total_rows($mmhclass->db->query("SELECT * FROM `mmh_file_storage`;"))),
			);
			
			$mmhclass->templ->output("info", "about_us_page");
			break;
		case "rules":
			$mmhclass->templ->page_title .= "الشروط";
			
			$mmhclass->templ->templ_vars[] = array(
				"SITE_NAME"     => $mmhclass->info->config['site_name'],
				"MODIFIED_DATE" => date($mmhclass->info->config['date_format'], filemtime("{$mmhclass->info->root_path}info.php")),
			);
			
			$mmhclass->templ->output("info", "terms_of_service_page");
			break;
		case "privacy_policy":
			$mmhclass->templ->page_title .= "Privacy Policy";

			$mmhclass->templ->templ_vars[] = array(
				"SITE_NAME" => $mmhclass->info->config['site_name'],
			);
			
			$mmhclass->templ->output("info", "privacy_policy_page");
			break;
		default: 
			$mmhclass->templ->error("لقد وصلت هذه الصفحة عن طريق الخطأ. من فضلك قم بالذهاب لصفحة {$mmhclass->info->config['site_name']} الرئيسية.");
	}

?>
