<?php
// ======================================== \
// Package: Mihalism Multi Host
// Version: 4.0.0
// Copyright (c) 2007, 2008 Mihalism, Inc.
// License: http://www.gnu.org/licenses/gpl.txt GNU Public License
// ======================================== /

class mmhclass_image_functions
{
function mmhclass_image_functions()
{
global $mmhclass;
if (class_exists("Imagick") == true && class_exists("ImagickDraw") == true && class_exists("ImagickPixel") == true) {
$this->manipulator = "imagick";
} elseif (extension_loaded("gd") == true || extension_loaded("gd2") == true) {
$this->manipulator = "gd";
} else {
$mmhclass->templ->fatal_error("Sorry but Mihalism Multi Host requires the GD Graphics Library or Imagick Image Library to function.");
}
}

function thumbnail_name($file)
{
$extension = $this->file_extension($file);
return preg_replace("#(.*).{$extension}#", "$1_thumb.{$extension}", $file);
}

function format_filesize($filesize = 0)
{
global $mmhclass;
$filesize_names = array("بايت", "كب", "مب", "جب", "Terabyte(s)", "Petabyte(s)", "Exabyte(s)", "Zettabyte(s)", "Yottabyte(s)");
while (($filesize / 1024) >= 1) { $filesize_count++; $filesize = ($filesize / 1024); }
return (($mmhclass->funcs->is_null($filesize) == true || $filesize_count > 9) ? "Unknown Filesize" : substr($filesize, 0, strpos($filesize, ".") + 4).(" ".(($mmhclass->funcs->is_null($filesize_count) == true) ? $filesize_names['0'] : $filesize_names[$filesize_count])));
}

function file_extension($file)
{
$path_chunks = explode("/", $file);
$thefile = $path_chunks[(count($path_chunks) - 1)];
$dotpos = strrpos($thefile, ".");
return strtolower(substr($thefile, ($dotpos + 1)));
}

function is_image($file)
{
// Only need to catch Imagick errors so no blank pages
if ($this->manipulator == "imagick") {
eval("try {
\$imageh = new Imagick(\$file);
} catch (Exception \$e) {
\$false_image = true;
}");
}

return (($false_image == true) ? false : true);
}

function get_image_info($file) {
if (is_file($file) == false || $this->is_image($file) == false) {
return false;
} else {
if ($this->manipulator == "imagick") {
$imageh = new Imagick();
$imageh->readImage("{$file}[0]");
return array(
"width" => $imageh->getImageWidth(),
"height" => $imageh->getImageHeight(),
"type" => $imageh->getImageType(),
"html" => "width=\"".$imageh->getImageWidth()."\" height=\"".$imageh->getImageHeight()."\"",
"bits" => $imageh->getImageSize(),
"channels" => NULL,
"mime" => ("image/".strtolower($imageh->getImageFormat())),
"mtime" => filemtime($file),
"comment" => trim($imageh->getImageProperty("comment")),
);
} else {
$base_info = getimagesize($file);
return array(
"width" => $base_info['0'],
"height" => $base_info['1'],
"type" => $base_info['2'],
"html" => $base_info['3'],
"bits" => filesize($file),
"channels" => NULL,
"mime" => $base_info['mime'],
"mtime" => filemtime($file),
"comment" => NULL,
);
}
}
}

function create_captcha_image($session_id)
{
global $mmhclass;
if ($mmhclass->funcs->is_null($session_id) == true) {
return false;
} else {
$captcha_session = $mmhclass->db->fetch_array($mmhclass->db->query("SELECT * FROM `mmh_captcha_sessions` WHERE `session_id` = '{$session_id}';"));

if ($this->manipulator == "imagick") {
$captcha = new Imagick();
$backgrd = new ImagickPixel();
$captchadraw = new ImagickDraw();

$backgrd->setColor("white");
$captcha->newImage(85, 30, $backgrd);
$captchadraw->setFontSize(20);
$captcha->annotateImage($captchadraw, 4, 20, 0, $captcha_session['captcha_code']);
$captcha->swirlImage(20);

$captchadraw->line(rand(0, 70), rand(0, 30), rand(0, 70), rand(0, 30));
$captchadraw->line(rand(0, 70), rand(0, 30), rand(0, 70), rand(0, 30));
$captchadraw->line(rand(0, 70), rand(0, 30), rand(0, 70), rand(0, 30));
$captchadraw->line(rand(0, 70), rand(0, 30), rand(0, 70), rand(0, 30));
$captchadraw->line(rand(0, 70), rand(0, 30), rand(0, 70), rand(0, 30));

$captcha->drawImage($captchadraw);
$captcha->setImageFormat("png");

return base64_encode($captcha->getImageBlob());
} else {
for ($i = 0; $i < strlen($captcha_session['captcha_code']); $i++) {
$captcha_code .= (strtoupper(substr($captcha_session['captcha_code'], $i, 1))." ");
}

$image = imagecreatetruecolor(125, 17);
$backgrd = imagecolorallocate($image, 255, 255, 255);
$text = imagecolorallocate($image, 255, 0, 0);
imagefilledrectangle($image, 0, 0, 300, 17, $backgrd);
imagestring($image, 5, 3, 0, $captcha_code, $text);
return base64_encode(imagepng($image));
}
}
}

function create_thumbnail($file, $save_to_disk = true)
{
global $mmhclass;
if (is_file($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$file) == false || $this->is_image($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$file) == false) {
return false;
} else {
$extension = $this->file_extension($file);
$thumbnail = (($this->manipulator == "imagick") ? (basename($this->thumbnail_name($file), ".{$extension}").".jpg") : $this->thumbnail_name($file));
$imageinfo = $this->get_image_info($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$file);
if ($save_to_disk == true) {
if ($imageinfo['width'] > $imageinfo['height']) {
$thumbnail_width = $mmhclass->info->config['thumbnail_width'];
$thumbnail_height = (($imageinfo['height'] * $mmhclass->info->config['thumbnail_height']) / $imageinfo['width']);
} elseif ($imageinfo['width'] < $imageinfo['height']) {
$thumbnail_width = (($imageinfo['width'] * $mmhclass->info->config['thumbnail_width']) / $imageinfo['height']);
$thumbnail_height = $mmhclass->info->config['thumbnail_height'];
} elseif ($imageinfo['height'] == $imageinfo['width']) {
$thumbnail_width = $mmhclass->info->config['thumbnail_width'];
$thumbnail_height = $mmhclass->info->config['thumbnail_height'];
}

if ($this->manipulator == "imagick") {
$canvas = new Imagick();
$canvasdraw = new ImagickDraw();
$transback = new Imagick();
$athumbnail = new Imagick();

$athumbnail->readImage("{$mmhclass->info->root_path}{$mmhclass->info->config['upload_path']}{$file}[0]");
$athumbnail->flattenImages();
$athumbnail->orgImageHeight = $athumbnail->getImageHeight();
$athumbnail->orgImageWidth = $athumbnail->getImageWidth();
$athumbnail->orgImageSize = $athumbnail->getImageSize();
$athumbnail->thumbnailImage($thumbnail_width, $thumbnail_height);

if ($mmhclass->info->config['advanced_thumbnails'] == true && $athumbnail->getImageWidth() > 105) {
while (($athumbnail->orgImageSize / 1024) >= 1) { $filesize_count++; $athumbnail->orgImageSize = ($athumbnail->orgImageSize / 1024); }
$filesize_names = array("b", "kb", "mb", "gb", "tb", "pb", "eb", "zb", "yb");
$resobar_filesize = (($mmhclass->funcs->is_null($athumbnail->orgImageSize) == true || $filesize_count > 9) ? "Unknown Filesize" : substr($athumbnail->orgImageSize, 0, strpos($athumbnail->orgImageSize, ".") + 2).$filesize_names[intval($filesize_count)]);

$canvas->newImage($athumbnail->getImageWidth(), ($athumbnail->getImageHeight() + 14), new ImagickPixel("black"));
$transback->newImage($canvas->getImageWidth(), ($canvas->getImageHeight() - 14), new ImagickPixel("white"));
$canvas->compositeImage($transback, 40, 0, 0);
$canvasdraw->setFillColor(new ImagickPixel("white"));
$canvasdraw->setFontSize(11);
$canvasdraw->setFont("AvantGarde-Demi");
$canvasdraw->setGravity(8);
$canvas->annotateImage($canvasdraw, 0, 0, 0, "{$athumbnail->orgImageWidth}x{$athumbnail->orgImageHeight} - {$resobar_filesize}");
$canvas->compositeImage($athumbnail, 40, 0, 0);
} else {
$canvas = $athumbnail->clone();
}

$canvas->setImageFormat("jpeg");
$canvas->setImageCompression(9);
$canvas->writeImage($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$thumbnail);
} else {
if (in_array($extension, array("png", "gif", "jpg", "jpeg")) == true) {
$function_extension = str_replace("jpg", "jpeg", $extension);
$image_function = "imagecreatefrom{$function_extension}";
$image = $image_function($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$file);
}

$thumbnail_image = imagecreatetruecolor($thumbnail_width, $thumbnail_height);
imagecopyresampled($thumbnail_image, $image, 0, 0, 0, 0, $thumbnail_width, $thumbnail_height, $imageinfo['width'], $imageinfo['height']);

imagejpeg($thumbnail_image, $mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$thumbnail);
chmod($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$thumbnail, 0644);
imagedestroy($thumbnail_image);
imagedestroy($image);
}

chmod($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$thumbnail, 0644);
} else {
readfile($mmhclass->info->root_path.$mmhclass->info->config['upload_path'].$thumbnail);
}
}
}
}

?>