<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBExperience 3.7                                                 # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2006-2008 Marius Czyz. All Rights Reserved.           # ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'xperience');

$phrasegroups = array('xperience', 'user');

$specialtemplates = array(
	'xperience_singleaward'
);

$globaltemplates = array(
	'headinclude',
	'navbar',		
	'xperience_ranking',
	'xperience_ranking_bit',
	'xperience_awards',
	'xperience_singleaward',
	'xperience_award_bit',
	'xperience_awards_awardbit',
	'xperience_awards_awardbit_empty',
	'xperience_awards_bit',
	'xperience_navbar',
	'xperience_shop',
	'xperience_shop_cat',
	'xperience_shop_item_c',
	'xperience_shop_item_p',
	'xperience_shop_item',
	'xperience_shop_item_own',
	'xperience_stats',
	'xperience_stats_entries',
	'xperience_stats_entry',
	'xperience_stats_header',
	'xperience_stats_entries_empty',
	'xperience_stats_entry_empty',
	'xperience_promotion_entry',
	'xperience_promotions',
	
);

$actiontemplates = array();

require_once('./global.php');


if (!$vbulletin->options['xperience_enabled']) 
{
	eval('standard_error($vbphrase[xperience_disabled]);');

	exit;
}

// permissions check
if (!($permissions['forumpermissions'] & $vbulletin->bf_ugp_forumpermissions['canview']) OR !($permissions['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canviewmembers']))
{
	print_no_permission();
}

// ######################### CLEAN GPC ############################
	$go = $vbulletin->input->clean_gpc('r', 'go', TYPE_STR);
	$do = $vbulletin->input->clean_gpc('r', 'do', TYPE_STR);
	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'page', TYPE_UINT);
	$sortfield = $vbulletin->input->clean_gpc('r', 'sortfield', TYPE_STR);
	$sortorder = $vbulletin->input->clean_gpc('r', 'sortorder', TYPE_STR);
	

	$navbits = array();
	$navbits[$parent] = $vbphrase['xperience_ranking'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('$xperience_bar = "' . fetch_template('xperience_navbar') . '";');
	$xperience_version = $vbphrase['xperience_name']." 3.7.16 swaalf.net";

	require_once('./includes/functions_xperience.php');
	require_once('./includes/class_xperience.php');

if ($go == "promotions")
{
	if (!$vbulletin->options['xperience_use_promotions'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}

	$promotionq = $vbulletin->db->query_read("SELECT
		g.usertitle, g.title, u.username, l.* 
		FROM " . TABLE_PREFIX . "xperience_promotion_log AS l
		INNER JOIN " . TABLE_PREFIX . "user AS u ON u.userid=l.userid
		INNER JOIN " . TABLE_PREFIX . "usergroup AS g ON g.usergroupid=l.to_ug
		ORDER BY dateline DESC, promotionid DESC
		LIMIT 50");
		$foundpromotion = 0;
		if ($vbulletin->db->num_rows($promotionq) > 0)
		{	
			$currentdate = "";
			while ($promotion = $vbulletin->db->fetch_array($promotionq))
			{
				$foundpromotion = 1;
				if (strlen($promotion['usertitle'])>1)
				{
					$promotion['usergroup'] = $promotion['usertitle'];
				} else {
					$promotion['usergroup'] = $promotion['title'];
				}
				$promotion['detaildate'] = vbdate($vbulletin->options['timeformat'], $promotion['dateline']);
				$promotion['date'] = vbdate($vbulletin->options['dateformat'], $promotion['dateline']);


				
				if ($currentdate <> $promotion['date'])
				{
					if ($currentdate <> "")
					{
						$promotions .="<br/>";
					}
					eval('$promotions .= "' . fetch_template('xperience_promotion_dateentry') . '";');
				}
				$currentdate = $promotion['date'];
				eval('$promotions .= "' . fetch_template('xperience_promotion_entry') . '";');
			}
				
		}

	eval ('print_output("' . fetch_template('xperience_promotions') . '");');


}
elseif ($go == "stats")
{
	if (!$vbulletin->options['xperience_use_stats'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}

	switch ($do) 
	{
		case "thread":
			$stats = fetch_statistics("thread");
			$statsname = $vbphrase['xperience_points_thread'];
			break;
		case "post":
			$stats = fetch_statistics("post");
			$statsname = $vbphrase['xperience_points_post'];
			break;
		case "misc":
			$stats = fetch_statistics("misc");
			$statsname = $vbphrase['xperience_points_misc'];
			break;
		default:
			$stats = fetch_statistics("user");
			$statsname = $vbphrase['xperience_points_user'];
	}

	eval ('print_output("' . fetch_template('xperience_stats') . '");');


}
elseif ($go == "shop")
{
	if (!$vbulletin->options['xperience_use_shop'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}
	
	$cat = $vbulletin->input->clean_gpc('r', 'cat', TYPE_UINT);

	if ($do == "own")
	{
		$userstats = fetch_xperience($vbulletin->userinfo['userid']);
		
		$itemsaq =$vbulletin->db->query_read("SELECT
			COUNT(t.itemid) as cnt_items, t.*, s.* 
			FROM " . TABLE_PREFIX . "xperience_shop_ta as t
			INNER JOIN " . TABLE_PREFIX . "xperience_shop as s ON s.itemid=t.itemid
			WHERE
			t.buyer=".$vbulletin->userinfo['userid']."
			GROUP BY t.itemid");

		if ($vbulletin->db->num_rows($itemsaq) > 0)
		{	
			while ($itemsa = $vbulletin->db->fetch_array($itemsaq))
				{
					global $bgclass, $altbgclass;
					exec_switch_bg();
					
					require_once(DIR . '/includes/class_bbcode.php');
					$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
					$itemsa['itemdesc'] = $bbcode_parser->do_parse($itemsa['itemdesc'], true);
			
					if (strlen($itemsa['itempicture']) < 3)
					{
						$item['itempicture'] = $stylevar[imgdir_misc]."/level/icon_item.png";
					}
			
					$itemsa['available'] = true;
					$itemsa['buyable'] = false;
					$buyphrase = "xperience_shop_err_own";
					$itemsa['costs'] = vb_number_format($itemsa['costs']);
					$itemsa['costfield'] = $vbphrase['xperience_'.$itemsa[costfield]];
					$dateline = vbdate($vbulletin->options['dateformat'] . ' ' .  $vbulletin->options['timeformat'], $itemsa['dateline']); 
					$cols = 2;
					eval('$items .= "' . fetch_template('xperience_shop_item_own') . '";');
				}
		}
	
		eval ('print_output("' . fetch_template('xperience_shop') . '");');
	}
	elseif ($do == "confirm_buy")
	{
		
		$itemid = $vbulletin->input->clean_gpc('r', 'item', TYPE_INT);
		$userstats = fetch_xperience($vbulletin->userinfo['userid']);
		
		$itemsaq =$vbulletin->db->query_read("SELECT
		*
		FROM " . TABLE_PREFIX . "xperience_shop as s
		INNER JOIN " . TABLE_PREFIX . "xperience_shop_cat as c ON c.catid = s.catid
		WHERE s.itemstatus>0 AND s.itemid=".$itemid);
		
		if ($vbulletin->db->num_rows($itemsaq) > 0)
		{	
			$itemsa = $vbulletin->db->fetch_array($itemsaq);
		}
	
		$vbulletin->url = $vbulletin->options['bburl']."/xperience.php?go=shop";
		if (CheckBuyConditions($itemsa, $userstats))
		{
			$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_shop_ta
				(itemid, buyer, dateline, costs, costfield) VALUES (
				".$itemsa['itemid'].",
				".$vbulletin->userinfo['userid'].",
				".mktime(date("H"), date("i"), 0, date("m"), date("d"), date("Y")).",
				".$itemsa['costs'].",
				'".$itemsa['costfield']."'		
				)");
	
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_shop
				SET quantity=quantity-1
				WHERE itemid=".$itemid);
			
			$message = construct_phrase($vbphrase['xperience_shop_buy_text'], $vbulletin->options['bburl']."/member.php?u=".$vbulletin->userinfo['userid'], $vbulletin->userinfo['username'], $itemsa['itemname'], $itemsa['catname']);
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
			$pmdm->overridequota = true;
			$pmdm->set_info('is_automated', true);
			$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
			$pmdm->set('fromusername', $vbulletin->userinfo['username']);
			$pmdm->setr('title', $vbphrase['xperience_shop_buy_title']);
			$pmdm->setr('message', $message);
		 	$pmdm->set_recipients($vbulletin->options['xperience_shop_pm_rec'], $botpermissions, 'cc');
			$pmdm->set('dateline', TIMENOW);
			$pmdm->save(); 
		 		 
		 	$xPerience =& new xPerience;
		 	$avgppd = $xPerience->GetAVGPPD();
		 	$xPerience->CalculateXP ($vbulletin->userinfo, $avgppd);
			
			eval(print_standard_redirect('xperience_sale_successfully', true, true));
		} else {
			eval(print_standard_redirect('xperience_sale_failed', true, true));		
		}
	
	}
	elseif ($do == "details")
	{
		$itemid = $vbulletin->input->clean_gpc('r', 'item', TYPE_INT);
		$userstats = fetch_xperience($vbulletin->userinfo['userid']);
		
		$itemsaq =$vbulletin->db->query_read("SELECT
		*
		FROM " . TABLE_PREFIX . "xperience_shop as s
		INNER JOIN " . TABLE_PREFIX . "xperience_shop_cat as c ON c.catid = s.catid
		WHERE s.itemstatus>0 AND s.itemid=".$itemid);
		
		if ($vbulletin->db->num_rows($itemsaq) > 0)
		{	
			$itemsa = $vbulletin->db->fetch_array($itemsaq);
			
			$categories = construct_xp_categories(0, $cat);
			
			require_once(DIR . '/includes/class_bbcode.php');
			$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
			$itemsa['itemdesc'] = $bbcode_parser->do_parse($itemsa['itemdesc'], true);
			
			if (strlen($itemsa['itempicture']) < 3)
			{
				$itemsa['itempicture'] = $stylevar[imgdir_misc]."/level/icon_item.png";
			}
			
			$itemsa['buyable'] = CheckBuyConditions($itemsa, $userstats);
			$buyphrase = CheckBuyConditions($itemsa, $userstats, true);
			$owncredits = vb_number_format($userstats["$itemsa[costfield]"]);
			$itemsa['costs'] = vb_number_format($itemsa['costs']);
			$itemsa['costfield'] = $vbphrase['xperience_'.$itemsa[costfield]];
			$itemsa['quantity'] = vb_number_format($itemsa['quantity']);
			$cols = 2;
			eval('$items .= "' . fetch_template('xperience_shop_item') . '";');
			
		}
		eval ('print_output("' . fetch_template('xperience_shop') . '");');
		
		
		
	}
	else
	{
		
		$ownitemsq=$vbulletin->db->query_read("SELECT COUNT(*) as cnt_items FROM " . TABLE_PREFIX . "xperience_shop_ta WHERE buyer=".$vbulletin->userinfo['userid']." ORDER BY dateline");
		if ($vbulletin->db->num_rows($ownitemsq) > 0)
		{	
			$ownitems = $vbulletin->db->fetch_array($ownitemsq);	
		}
		
			
		$categories = construct_xp_categories(0, $cat);
		
		if ($cat > 0)
		{
			$userstats = fetch_xperience($vbulletin->userinfo['userid']);
			
			$itemsaq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_shop WHERE itemstatus>0 AND catid=".$cat." ORDER BY itemstatus, itemname");
			if ($vbulletin->db->num_rows($itemsaq) > 0)
			{	
				while ($itemsa = $vbulletin->db->fetch_array($itemsaq))
				{
					global $bgclass, $altbgclass;
					exec_switch_bg();
					
					$itemsa['available'] = true;
					
					
					if (strlen($itemsa['itemthumb']) < 3)
					{
						$itemsa['itemthumb'] = $stylevar[imgdir_misc]."/level/icon_item.png";
					}

					$owncredits = vb_number_format($userstats["$itemsa[costfield]"]);
					$itemsa['costs'] = vb_number_format($itemsa['costs']);
					$itemsa['costfield'] = $vbphrase['xperience_'.$itemsa[costfield]];
					$itemsa['quantity'] = vb_number_format($itemsa['quantity']);
					$cols = 3;
									
					eval('$items .= "' . fetch_template('xperience_shop_item_c') . '";');
					$printeditem++;
					if ($printeditem > 2)
					{
						$cols = 3;
						$printeditem=0;
						$items.='</tr><tr class="'.$bgclass.'">';
					}
				}
			} else {
				$cols = 2;
				eval('$items .= "' . fetch_template('xperience_shop_item_no') . '";');
			}
		}

		if ($printeditem == 1)
		{
			$items.='<td width="33%" class="alt2">&nbsp;</td><td width="33%" class="alt1">&nbsp;</td>';
		}
		if ($printeditem == 2)
		{
			$items.='<td width="33%" class="alt2">&nbsp;</td>';
		}

		eval ('print_output("' . fetch_template('xperience_shop') . '");');
	}
	


}
elseif ($go=="awards") 
{

	if (!$vbulletin->options['xperience_use_awards'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}

	$count_awards=0;
	$foundaward=0;
	require_once(DIR . '/includes/functions_user.php');
	$awardsq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_awards WHERE awardstatus>0 ORDER BY awardstatus");
	if ($vbulletin->db->num_rows($awardsq) > 0)
	{

		$count_awards=$vbulletin->db->num_rows($awardsq);
		$width_awards=ceil(100/$vbulletin->db->num_rows($awardsq));
		if ($count_awards>3) $count_awards=3;		

		while ($myawards = $vbulletin->db->fetch_array($awardsq))
		{

			$myrows = $vbulletin->db->query_read("SELECT
				u.userid,
				u.username,
				u.xperience_awards
				" . ($vbulletin->options['avatarenabled'] ? ",u.avatarrevision, avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,customavatar.width AS avwidth,customavatar.height AS avheight" : "") . "
				FROM " . TABLE_PREFIX . "user AS u
				" . ($vbulletin->options['avatarenabled'] ? "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = u.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = u.userid)" : "") . "
				WHERE u.xperience_awards LIKE '%|".$myawards['awardname']."|%'");

			if ($vbulletin->db->num_rows($myrows) > 0)
			{
				$foundaward=1;
				while ($myrow = $vbulletin->db->fetch_array($myrows))
				{

					if (function_exists(fetch_avatar_from_userinfo))
					{
						fetch_avatar_from_userinfo($myrow, true, true);
						$avatarurl = GetAvatar($myrow);
					} else {
						//Compatibility to vB 3.6.x
						$arravatarurl = fetch_avatar_url($myrow['userid']);
						$avatarurl = $arravatarurl[0];
					}
				if (strlen($avatarurl)<3) $avatarurl=$stylevar[imgdir_misc].'/level/unknown.gif';
				
				if ($vbulletin->options['xperience_awardgfx'])
				{
					$awardextension=".png";
				} else {
					$awardextension=".gif";
				}
					
					$showaward='<img border="0" src="'.$stylevar[imgdir_misc].'/level/award_'.$myawards['awardname'].$awardextension.'" title="'.$myawards['awardtitle'].'">';
	
					eval('$awardbit.= "' . fetch_template('xperience_awards_awardbit') . '";');
					$printedaward++;
					if ($printedaward>2)
					{
						$printedaward=0;
						$awardbit.='</tr><tr class="alt1">';
					}
				}
			}

		}
						if ($printedaward > 0 AND $printedaward < 3 )
				{
					for($i=$printedaward; $i <= 2; $i++)
					{
						eval('$awardbit .= "' . fetch_template('xperience_awards_awardbit_empty') . '";');
					}
				}

	}

	eval ('print_output("' . fetch_template('xperience_awards') . '");');
	
} else {

	$vbulletin->input->clean_array_gpc('r', array(
		'ausername'      => TYPE_STR,
	));

	$search_username = $vbulletin->GPC['ausername'];

	$condition = '1=1';
	if (strlen($vbulletin->GPC['ausername']) > 0)
	{
		$condition  .=  " AND username LIKE '%" . $db->escape_string_like(htmlspecialchars_uni($vbulletin->GPC['ausername'])) . "%' ";
	}

	if (strlen($vbulletin->options['xperience_ignore_users']) > 0)
	{
		$condition .= " AND u.userid NOT IN(".$vbulletin->options['xperience_ignore_users'].") ";
	}
	
	$members = $vbulletin->db->query_first("SELECT
		COUNT(*) AS users
		FROM " . TABLE_PREFIX . "user as u
		WHERE ".$condition); 
	$userscount = $members['users'];


	sanitize_pageresults($userscount, $pagenumber, $perpage, 100, $vbulletin->options['memberlistperpage']);

	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $userscount)
	{
		$limitupper = $userscount;
		if ($limitlower > $userscount)
		{
			$limitlower = $userscount - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		$limitlower = 1;
	}

	$oppositesort = iif($sortorder == 'asc', 'desc', 'asc');

	if ($sortorder != '') 
	{
		$switchOrder = ($sortorder)?$sortorder:"";
	} else {
		$switchOrder = "";
	}

	switch ($switchOrder) 
	{
		case "asc":
			$deasc = " ASC";
			break;
		case "desc":
			$deasc = " DESC";
			break;
		default:
			$deasc = " DESC";
	}

	
	if ($sortfield != '') 
	{
		$switchSort = ($sortfield)?$sortfield:"";
	} else {
		$switchSort = "";
	}

	switch ($switchSort) 
	{
		case "xp":
		default : $sort_query = "u.xperience " . $deasc;
			break;
		case "xu":
			$sort_query = "s.points_user " . $deasc. ", u.xperience DESC"; 
			break;
		case "xt":
			$sort_query = "s.points_thread " . $deasc. ", u.xperience DESC"; 
			break;
		case "xo":
			$sort_query = "s.points_post " . $deasc. ", u.xperience DESC"; 
			break;
		case "xn":
			$sort_query = "u.username " . $deasc;
			break;
		case "xl":
			$sort_query = "u.xperience_level " . $deasc. ", u.xperience DESC"; 
			break;
		case "xm":
			$sort_query = "s.points_misc " . $deasc. ", u.xperience DESC"; 
			break;
		case "xd":
			$sort_query = "u.xperience_ppd " . $deasc. ", u.xperience ASC"; 
			break;
	}

	
	$pagenav = construct_page_nav($pagenumber, $perpage, $userscount, 'xperience.php?' . $vbulletin->session->vars['sessionurl'] . 'do=getall', ''
		. (!empty($sortfield) ? "&amp;sortfield=$sortfield" : "")
		. (!empty($sortorder) ? "&amp;sortorder=$sortorder" : "")
		. ($search_username != '') ? 'ausername=' . urlencode($search_username) . '&amp;' : ''
	);



	$myquery="SELECT 
		u.userid,
		u.usergroupid,
		u.membergroupids,
		u.username,
		u.xperience_level,
		u.xperience,
		u.xperience_ppd,
		u.xperience_awards,
		s.points_user,
		s.points_thread,
		s.points_post,
		s.points_misc
		FROM " . TABLE_PREFIX . "xperience_stats AS s
		INNER JOIN " . TABLE_PREFIX . "user AS u ON u.userid=s.userid
		WHERE ".$condition." 
		ORDER BY " . $sort_query . "
		LIMIT " . ($limitlower - 1) . "," . $perpage;

	$myrows = $vbulletin->db->query_read($myquery);

	if ($vbulletin->db->num_rows($myrows) > 0)
	{
		while ($myrow = $vbulletin->db->fetch_array ($myrows)) 
		{
		
			$DisplayUser=1;
			if (strlen($vbulletin->options['xperience_ignore_usergroupsids']) > 0) 
			{
				$usergroups=explode(",", $vbulletin->options['xperience_ignore_usergroupsids']);
				for ($i = 0; $i < count($usergroups); $i ++) 
				{
					if (is_member_of($myrow, $usergroups[$i])) 
					{
						$DisplayUser=0;
					}
				}
			}
		
		
			if ($DisplayUser==1) 
			{
				$xperience['xperience']=vb_number_format($myrow['xperience']);
				$xperience['points_user']=vb_number_format($myrow['points_user']);
				$xperience['points_thread']=vb_number_format($myrow['points_thread']);
				$xperience['points_post']=vb_number_format($myrow['points_post']);
				$xperience['points_misc']=vb_number_format($myrow['points_misc']);
				
				
				$awards = GetAwards($myrow['xperience_awards']);
				
							
				global $bgclass, $altbgclass;
				exec_switch_bg(); 
				eval('$xperience_ranking_bit.= "' . fetch_template('xperience_ranking_bit') . '";');
			}
		}
	}
	eval ('print_output("' . fetch_template('xperience_ranking') . '");');
	
}
	
	



	
?>
