<?php

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_mgc_cb_evo_cmd.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'manage_commands';
}

if ($_REQUEST['do'] == "manage_commands")
{
	print_cp_header($vbphrase['mgc_cb_evo_commands_mngt']);

	?>
	<script type="text/javascript">
	function js_page_jump(i, sid)
	{
		var sel = fetch_object("commandsel" + i);
		var act = sel.options[sel.selectedIndex].value;
		if (act != '')
		{
			switch (act)
			{
				case 'command_disable': page = "mgc_cb_evo.php?do=command_enable&what=0&cid="; break;
				case 'command_enable': page = "mgc_cb_evo.php?do=command_enable&what=1&cid="; break;
				case 'command_export': page = "mgc_cb_evo.php?do=command_export&what=edit&cid="; break;
				case 'command_edit': page = "mgc_cb_evo.php?do=command_update&what=edit&cid="; break;				
				case 'command_ugp_perms': page = "mgc_cb_evo.php?do=command_manage_perms&cid="; break;
				case 'command_delete':
					if(confirm("<? echo $vbphrase['mgc_cb_evo_are_you_sure_to_delete']; ?>"))
						page = "mgc_cb_evo.php?do=command_delete&cid=";
					else
						return;
					break;
				default: return;
			}
			jumptopage = page + sid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
			window.location = jumptopage;
		}
		else
		{
			alert('<?php echo addslashes_js($vbphrase['invalid_action_specified']); ?>');
		}
	}
	</script>
	<?php
	
	/** Command list **/
	
	/* Retrieving of the commands */
	print_form_header('mgc_cb_evo', 'command_mngt');
	construct_hidden_code('commandid', '');
	
	print_table_header($vbphrase['mgc_cb_evo_installed_commands'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['mgc_cb_evo_command_version'], $vbphrase['description'], $vbphrase['controls']), 1);
	
	// used for <select> id attribute
	$i = 0;

	$getcommands = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command");
	
	while ($command = $vbulletin->db->fetch_array($getcommands))
	{
		$options = array('command_edit' => $vbphrase['edit']);
		
		$options['command_ugp_perms'] = $vbphrase['mgc_cb_evo_command_edit_permissions'];
		
		if ($command['active'])
		{
			$options['command_disable'] = $vbphrase['disable'];
			$title =  $command['title'];
		}
		else
		{
			$options['command_enable'] = $vbphrase['enable'];
			$title = "<strike>" . $command['title'] . "</strike>";			
		}
				
      $options['command_export'] = $vbphrase['export'];
		
		if ($command['authorurl'])
		{
			$title = '<a href="' . htmlspecialchars_uni($command['authorurl']) . "\" target=\"_blank\">$title</a>";
		}

		$options['command_delete'] = $vbphrase['delete'];
		
		$i++;
		
		print_cells_row(array(
			$title,
			"<div align=\"center\">" . htmlspecialchars_uni($command['version']) . "</div>",
			$command['description'],
			"<div align=\"$stylevar[right]\">
				<select name=\"s$command[cid]\" id=\"commandsel$i\" onchange=\"js_page_jump($i, '$command[cid]')\" class=\"bginput\">
					" . construct_select_options($options) . "
				</select>&nbsp;<input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_page_jump($i, '$command[cid]');\" />
			</div>"
		), false, '', -2);
	}
	
	print_description_row('<div align="center"><input type="button" onclick="window.location=\'mgc_cb_evo.php?do=command_update&what=add&s=' . $vbulletin->session->vars['sessionhash'] . '\'" value="' . stripslashes($vbphrase['mgc_cb_evo_add_command']) . '"></div>',false,4,'tfoot');
	
	print_table_footer();
	
	print_form_header('mgc_cb_evo', 'command_import', 1, 1, 'uploadform');
	print_table_header($vbphrase['mgc_cb_evo_import_command']);
	print_upload_row($vbphrase['mgc_cb_evo_upload_xml'], 'xml_file', 999999999);
	print_yes_no_row($vbphrase['mgc_cb_evo_allow_overwrite'], 'allowoverwrite', 0);
	print_submit_row($vbphrase['import']);	
	
	print_table_footer();	
}

if ($_REQUEST['do'] == "command_enable")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'cid' 	=> TYPE_UINT,
		'what'	=> TYPE_UINT
	));
	
	/* Check if the command exist */
	$check_command = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $vbulletin->GPC['cid'] . "'");

	if (!$vbulletin->db->num_rows($check_command))
	{
		print_stop_message('mgc_cb_evo_nonexisting_command');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_commands');
	
	/* Disabling of the command */
	if (!$vbulletin->GPC['what'])
	{
		/* Deactivate the channel if the command is attached to one */
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel SET active='0' WHERE cid='" . $vbulletin->GPC['cid'] . "'");
		
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command SET active='0' WHERE cid='" . $vbulletin->GPC['cid'] . "'");
		print_stop_message('mgc_cb_evo_command_successfully_disabled');	
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command SET active='1' WHERE cid='" . $vbulletin->GPC['cid'] . "'");
		print_stop_message('mgc_cb_evo_command_successfully_enabled');
	}
}

if ($_REQUEST['do'] == "command_delete")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'cid' 	=> TYPE_UINT,
		'what'	=> TYPE_UINT
	));
	
	/* Check if the command exist */
	$check_command = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $vbulletin->GPC['cid'] . "'");

	if (!$check_command)
	{
		print_stop_message('mgc_cb_evo_nonexisting_command');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_commands');

	/* Removing of the phrases attached to the command if any */
	if (!empty($check_command['phrases_varnames']))
	{
		$phrases_varnames_array = explode(',',$check_command['phrases_varnames']);
		
		foreach($phrases_varnames_array AS $index => $phrase_varname)
		{
			$sql_in_array[] = "varname='$phrase_varname'";
		}
		
		$vbulletin->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "phrase WHERE " . implode('OR ',$sql_in_array) . "
		");
		
		unset($sql_in_array);
	}
	
	/* Removing of the helpphrase if any */
	if (!empty($check_command['helpphrase']))
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname='" . $check_command['helpphrase'] . "'");
	}
	
	/* Removing of the options attached to the command if any */
	if (!empty($check_command['options_varnames']))
	{
		$options_varnames_array = explode(',',$check_command['options_varnames']);
		
		foreach($options_varnames_array AS $index => $option_varname)
		{
			$sql_in_array[] = "varname='$option_varname'";
			$setting_phrases_array[] = "'setting_" . $option_varname . "_desc'";
			$setting_phrases_array[] = "'setting_" . $option_varname . "_title'";
		}
		
		$vbulletin->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "setting WHERE " . implode('OR ',$sql_in_array) . "
		");
		
		$vbulletin->db->query_write("
         DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname IN (" . implode(',',$setting_phrases_array) . ")
      ");
		
		unset($sql_in_array);
	}
   
   /* Retrieving of the uninstallcode */
   $uninstallcodes = $vbulletin->db->query_read("
      SELECT uninstallcode FROM " . TABLE_PREFIX . "mgc_cb_evo_command_code WHERE identifier='" . $check_command['identifier'] . "' ORDER BY version DESC
   ");
   
   while ($uninstallcode = $vbulletin->db->fetch_array($uninstallcodes))
   {
      eval($uninstallcode['uninstallcode']);
   }
		
	/* Removing of the command */
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $vbulletin->GPC['cid'] . "'");
	
	/* Removing of the command codes */
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_command_code WHERE identifier='" . $check_command['identifier'] . "'");
	
	/* Removing of the chats */
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE primcid='" . $vbulletin->GPC['cid'] . "' OR seccid='" . $vbulletin->GPC['cid'] . "'");
	
	/* Removing of the channel attached to the command (if any) */
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE cid='" . $vbulletin->GPC['cid'] . "'");
	
	print_stop_message('mgc_cb_evo_command_successfully_deleted');
}

if ($_REQUEST['do'] == "command_update")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'cid' 	=> TYPE_UINT,
		'what'	=> TYPE_STR
	));
	
	if ($vbulletin->GPC['what'] == "add")
	{
		require_once(DIR . '/includes/class_mgc_cb_evo_cmd.php');
		
		$command = array();
		
		$cmd_obj = new mgcCbEvo_command($command);
		
		print_cp_header($vbphrase['mgc_cb_evo_add_command']);
	}
	else
	{
		/* Check if the command exist and fetch it */
		$command = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $vbulletin->GPC['cid'] . "'");
	
		if (!sizeof($command))
		{
			print_stop_message('mgc_cb_evo_nonexisting_command');
		}
		
		$cmd_obj = new mgcCbEvo_command($command);
		
		print_cp_header($vbphrase['mgc_cb_evo_edit_command']);
	}
	
	print_form_header('mgc_cb_evo','command_do_update');
	construct_hidden_code('what', $vbulletin->GPC['what']);

	/** General information **/	
	print_table_header($vbphrase['mgc_cb_evo_general_information']);

	/* The command identifier and the table header */
	if ($vbulletin->GPC['what'] == "add")
	{
		print_input_row($vbphrase['mgc_cb_evo_command_identifier'], 'identifier', $cmd_obj->identifier, true, 35, 25);
	}
	else
	{
		construct_hidden_code('cid', $vbulletin->GPC['cid']);
		print_label_row($vbphrase['mgc_cb_evo_command_identifier'],$cmd_obj->identifier);
	}

	print_input_row($vbphrase['title'], 'title', $cmd_obj->title, true, 35, 50);
	print_input_row($vbphrase['description'], 'description', $cmd_obj->description, true, 35, 250);
	print_input_row($vbphrase['mgc_cb_evo_command_version'], 'version', $cmd_obj->version, true, 35, 25);
	print_input_row($vbphrase['mgc_cb_evo_command_authorname'], 'authorname', $cmd_obj->authorname, true, 35, 100);
	print_input_row($vbphrase['mgc_cb_evo_command_authorurl'], 'authorurl', $cmd_obj->authorurl, true, 35, 150);
	print_input_row($vbphrase['mgc_cb_evo_command_helpphrase'], 'helpphrase', $cmd_obj->helpphrase, true, 35, 150);
	
	print_table_break();
	
	/** Command parameters **/
	print_table_header($vbphrase['mgc_cb_evo_command_parameters']);
	print_input_row($vbphrase['mgc_cb_evo_command_syntax'], 'syntax', $cmd_obj->syntax, true, 35, 50);
	
	print_yes_no_row($vbphrase['mgc_cb_evo_command_with_paramaters'] . " <font color='red'><b>*</b></font>", 'with_parameters', $cmd_obj->with_parameters ? 1 : 0);
	print_yes_no_row($vbphrase['mgc_cb_evo_command_can_be_in_channel'] . " <font color='red'><b>*</b></font>", 'can_be_in_channel', $cmd_obj->can_be_in_channel ? 1 : 0);
	print_yes_no_row($vbphrase['mgc_cb_evo_command_contains_message'] . " <font color='red'><b>*</b></font>", 'contains_message', $cmd_obj->contains_message ? 1 : 0);
	print_yes_no_row($vbphrase['mgc_cb_evo_command_accepts_userpref'] . " <font color='red'><b>*</b></font>", 'accepts_userpref', $cmd_obj->accepts_userpref ? 1 : 0);
	print_yes_no_row($vbphrase['mgc_cb_evo_command_can_be_in_gen_channel'] . " <font color='red'><b>*</b></font>", 'can_be_in_gen_channel', $cmd_obj->can_be_in_gen_channel ? 1 : 0);
	print_yes_no_row($vbphrase['mgc_cb_evo_command_from_user_to_user'] . " <font color='red'><b>*</b></font>", 'from_user_to_user', $cmd_obj->from_user_to_user ? 1 : 0);
	print_yes_no_row($vbphrase['mgc_cb_evo_command_accepts_bbcode'] . " <font color='red'><b>*</b></font>", 'accepts_bbcode', $cmd_obj->accepts_bbcode ? 1 : 0);
	print_yes_no_row($vbphrase['mgc_cb_evo_command_with_username_in_message'] . " <font color='red'><b>*</b></font>", 'with_username_in_message', $cmd_obj->with_username_in_message ? 1 : 0);
	print_yes_no_row($vbphrase['mgc_cb_evo_command_do_format_in_own_channel'] . " <font color='red'><b>*</b></font>", 'do_format_in_own_channel', $cmd_obj->do_format_in_own_channel ? 1 : 0);

	$aux_array = array();
	$aux_array['membergroupids'] = $cmd_obj->usergroupids;
	print_membergroup_row($vbphrase['mgc_cb_evo_command_usergroupids'], 'usergroupids', 2, $aux_array);
	print_input_row($vbphrase['mgc_cb_evo_command_userids'], 'userids', $cmd_obj->userids, true, 35, 1000);
	
	print_description_row("<font color='red'><b>*</b></font> " . $vbphrase['mgc_cb_evo_command_parameters_note']);
	
	print_table_break();
	
	/** Command PHP codes **/
	print_table_header($vbphrase['mgc_cb_evo_command_phpcode']);
	print_textarea_row($vbphrase['mgc_cb_evo_command_phpcode_chats_sending'],'phpcode_chats_sending',$cmd_obj->phpcode_chats_sending,6,60);
	print_textarea_row($vbphrase['mgc_cb_evo_command_phpcode_chats_retrieving'],'phpcode_chats_retrieving',$cmd_obj->phpcode_chats_retrieving,6,60);
	print_textarea_row($vbphrase['mgc_cb_evo_command_phpcode_chatbox_display'],'phpcode_chatbox_display',$cmd_obj->phpcode_chatbox_display,6,60);
	print_textarea_row($vbphrase['mgc_cb_evo_command_phpcode_chatbox_ar_display'],'phpcode_chatbox_ar_display',$cmd_obj->phpcode_chatbox_ar_display,6,60);
	print_table_break();
	
	/** Commmand HTML codes **/
	print_table_header($vbphrase['mgc_cb_evo_command_htmlcode']);
	print_textarea_row($vbphrase['mgc_cb_evo_command_htmlcode_chats_display'],'htmlcode_chats_display',$cmd_obj->htmlcode_chats_display,6,60);
	print_textarea_row($vbphrase['mgc_cb_evo_command_htmlcode_chatbit_menu'],'htmlcode_chatbit_menu',$cmd_obj->htmlcode_chatbit_menu,18,60);
	print_table_break();
	
	/** Other **/
	print_table_header($vbphrase['mgc_cb_evo_misc']);
	print_input_row($vbphrase['mgc_cb_evo_command_js_file'], 'js_file', $cmd_obj->js_file, true, 35, 50);
	print_textarea_row($vbphrase['mgc_cb_evo_command_options'],'options_varnames',$cmd_obj->options_varnames,6,60);
	print_textarea_row($vbphrase['mgc_cb_evo_command_phrases'],'phrases_varnames',$cmd_obj->phrases_varnames,6,60);
	print_textarea_row($vbphrase['mgc_cb_evo_command_autocomplete'],'autocomplete',$cmd_obj->autocomplete,6,60);
		
	print_yes_no_row($vbphrase['mgc_cb_evo_command_activate'], 'activate', $command['active'], 0);
	
	/** The end **/
	print_submit_row();
	
	/** The install codes form **/
	if ($vbulletin->GPC['what'] == "edit")
	{
		print_hr_row();
	
		/* Retrieving of the install codes */
		$installcodes = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command_code WHERE identifier='" . $command['identifier'] . "'");
		
		print_form_header('mgc_cb_evo','command_update_installcode');		
		
		if ($vbulletin->db->num_rows($installcodes))
		{
			print_table_header($vbphrase['mgc_cb_evo_installcodes'],4);
						
			while($installcode = $vbulletin->db->fetch_array($installcodes))
			{
				$version = preg_replace('#[^a-z0-9_]#i', '', $installcode['version']);
				$installcode_array["$version"]['codeid'] 		= $installcode['codeid'];
				$installcode_array["$version"]['version'] 		= $installcode['version'];
				$installcode_array["$version"]['installcode']	= $installcode['installcode'];
				$installcode_array["$version"]['uninstallcode'] = $installcode['uninstallcode'];				
			}
			
			ksort($installcode_array);
			
			print_cells_row(array($vbphrase['mgc_cb_evo_command_version'],$vbphrase['mgc_cb_evo_installcode'],$vbphrase['mgc_cb_evo_uninstallcode'],$vbphrase['mgc_cb_evo_delete']),true);
			
			foreach($installcode_array AS $safeversion => $version_info)
			{
				$cell['0'] = "<input type='input' size='7' maxlength='25' name='installcode_array[$version_info[codeid]][version]' value='" . htmlspecialchars_uni($version_info['version']) . "' />";
				$cell['1'] = "<textarea name='installcode_array[$version_info[codeid]][installcode]' cols='40' rows='8'>" . htmlspecialchars($version_info['installcode']) . "</textarea>";
				$cell['2'] = "<textarea name='installcode_array[$version_info[codeid]][uninstallcode]' cols='40' rows='8'>" . htmlspecialchars($version_info['uninstallcode']) . "</textarea>";
				$cell['3'] = "<input type='checkbox' name='installcode_array[$version_info[codeid]][delete]' />";
				print_cells_row($cell);
			}
			
			print_table_break();
		}
		
		/* Add new install code form */
		print_table_header($vbphrase['mgc_cb_evo_add_installcode']);
		
		construct_hidden_code('identifier',$command['identifier']);
		
		print_input_row($vbphrase['mgc_cb_evo_command_version'], 'installcode_version', '', true, 35, 25);
		print_textarea_row($vbphrase['mgc_cb_evo_installcode'],'installcode_install','',6,60);
		print_textarea_row($vbphrase['mgc_cb_evo_uninstallcode'],'installcode_uninstall','',6,60);
		
		print_hidden_fields();
		
		print_submit_row();		
	}
}

/* Update of the command */
if ($_POST['do'] == "command_do_update")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'what'						    => TYPE_STR,
		'cid' 						    => TYPE_UINT,
		'activate'					    => TYPE_UINT,
		'identifier'				    => TYPE_STR,
		'title'						    => TYPE_STR,
		'description' 				    => TYPE_STR,
		'version' 					    => TYPE_STR, 
		'authorname' 			       => TYPE_STR,
		'authorurl' 			       => TYPE_STR,
		'helpphrase'			       => TYPE_STR,
		'syntax'                    => TYPE_STR,
		'with_parameters'           => TYPE_BOOL,
		'can_be_in_channel'         => TYPE_BOOL,
		'contains_message'			 => TYPE_BOOL,
		'accepts_userpref'          => TYPE_BOOL,
		'can_be_in_gen_channel'     => TYPE_BOOL,
		'from_user_to_user'         => TYPE_BOOL,
		'accepts_bbcode'			    => TYPE_BOOL,
		'with_username_in_message'	 => TYPE_BOOL,
		'do_format_in_own_channel'  => TYPE_BOOL,
		'usergroupids'              => TYPE_ARRAY_UINT,
		'userids'                   => TYPE_STR,
		'phpcode_chats_sending'     => TYPE_STR,
		'phpcode_chats_retrieving'  => TYPE_STR,
		'phpcode_chatbox_display'	=> TYPE_STR,
		'phpcode_chatbox_ar_display'   => TYPE_STR,
		'htmlcode_chats_display'    => TYPE_STR,
		'htmlcode_chatbit_menu'     => TYPE_STR,
		'js_file'                   => TYPE_STR,
		'options_varnames'			 => TYPE_STR,
		'phrases_varnames'			 => TYPE_STR,
		'autocomplete'					 => TYPE_STR
	));	
	
	/* Check depending on the type of action */
	if ($vbulletin->GPC['what'] == "add")
	{
		/* Empty identifier */
		if (empty($vbulletin->GPC['identifier']))
		{
			print_stop_message('mgc_cb_evo_command_missing_identifier');
		}
		
		/* Existing identifier */
		$check_command = $vbulletin->db->query_read("SELECT identifier FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE identifier='" .$vbulletin->db->escape_string($vbulletin->GPC['identifier']) . "'");
		if ($vbulletin->db->num_rows($check_command))
		{
			print_stop_message('mgc_cb_evo_existing_command_identifier');
		}
		
		/* Valid identifier */
		if (!preg_match('#^[a-z0-9_]+$#s', $vbulletin->GPC['identifier']))
		{
			print_stop_message('mgc_cb_evo_command_invalid_identifier');
		}
	}	
	else
	{
		/* First let's check that the command do exist in the database */
		$command = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $vbulletin->GPC['cid'] . "'");
	
		if (!sizeof($command))
		{
			print_stop_message('mgc_cb_evo_nonexisting_command');
		}
	}
	
	/* Let's do the following important checks :
	 *  - A version is specified
	 *  - A syntax is specified 
	 */
	if (empty($vbulletin->GPC['version']) || empty($vbulletin->GPC['syntax']))
	{
		print_stop_message('mgc_cb_evo_must_fill_version_and_syntax');
	}
	
	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_commands');	
	
	/* Let's add/edit the command */
	if ($vbulletin->GPC['what'] == "add")
	{
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_command
			SET
				identifier = '" . $vbulletin->db->escape_string($vbulletin->GPC['identifier']) . "',
				title = '" . $vbulletin->db->escape_string($vbulletin->GPC['title']) . "',
				description = '" . $vbulletin->db->escape_string($vbulletin->GPC['description']) . "',
				version = '" . $vbulletin->db->escape_string($vbulletin->GPC['version']) . "', 
				authorname = '" . $vbulletin->db->escape_string($vbulletin->GPC['authorname']) . "',
				authorurl = '" . $vbulletin->db->escape_string($vbulletin->GPC['authorurl']) . "',
				helpphrase = '" . $vbulletin->db->escape_string($vbulletin->GPC['helpphrase']) . "',
				syntax = '" . $vbulletin->db->escape_string($vbulletin->GPC['syntax']) . "',
				size = '" . strlen($vbulletin->GPC['syntax']) . "',
				cmd_bitfield = '" . mgcCbEvo_command::construct_bitfield($vbulletin->GPC) . "',
				usergroupids = '" . implode(',',$vbulletin->GPC['usergroupids']) . "',
				userids = '" . $vbulletin->db->escape_string($vbulletin->GPC['userids']) . "',
				phpcode_chats_sending = '" . $vbulletin->db->escape_string($vbulletin->GPC['phpcode_chats_sending']) . "',
				phpcode_chats_retrieving = '" . $vbulletin->db->escape_string($vbulletin->GPC['phpcode_chats_retrieving']) . "',
				phpcode_chatbox_display = '" . $vbulletin->db->escape_string($vbulletin->GPC['phpcode_chatbox_display']) . "',
				phpcode_chatbox_ar_display = '" . $vbulletin->db->escape_string($vbulletin->GPC['phpcode_chatbox_ar_display']) . "',
				htmlcode_chats_display = '" . $vbulletin->db->escape_string($vbulletin->GPC['htmlcode_chats_display']) . "',
				htmlcode_chatbit_menu = '" . $vbulletin->db->escape_string($vbulletin->GPC['htmlcode_chatbit_menu']) . "',
				js_file = '" . $vbulletin->db->escape_string($vbulletin->GPC['js_file']) . "',
				options_varnames = '" . $vbulletin->db->escape_string($vbulletin->GPC['options_varnames']) . "',
				phrases_varnames = '" . $vbulletin->db->escape_string($vbulletin->GPC['phrases_varnames']) . "',
				autocomplete = '" . $vbulletin->db->escape_string($vbulletin->GPC['autocomplete']) . "',
				active = '" . $vbulletin->GPC['activate'] . "'
		");		
		
		print_stop_message('mgc_cb_evo_command_added_successfully');
	}
	else
	{		
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command
			SET
				title = '" . $vbulletin->db->escape_string($vbulletin->GPC['title']) . "',
				description = '" . $vbulletin->db->escape_string($vbulletin->GPC['description']) . "',
				version = '" . $vbulletin->db->escape_string($vbulletin->GPC['version']) . "', 
				authorname = '" . $vbulletin->db->escape_string($vbulletin->GPC['authorname']) . "',
				authorurl = '" . $vbulletin->db->escape_string($vbulletin->GPC['authorurl']) . "',
				helpphrase = '" . $vbulletin->db->escape_string($vbulletin->GPC['helpphrase']) . "',
				syntax = '" . $vbulletin->db->escape_string($vbulletin->GPC['syntax']) . "',
				size = '" . strlen($vbulletin->GPC['syntax']) . "',
				cmd_bitfield = '" . mgcCbEvo_command::construct_bitfield($vbulletin->GPC) . "',
				usergroupids = '" . implode(',',$vbulletin->GPC['usergroupids']) . "',
				userids = '" . $vbulletin->db->escape_string($vbulletin->GPC['userids']) . "',
				phpcode_chats_sending = '" . $vbulletin->db->escape_string($vbulletin->GPC['phpcode_chats_sending']) . "',
				phpcode_chats_retrieving = '" . $vbulletin->db->escape_string($vbulletin->GPC['phpcode_chats_retrieving']) . "',
				phpcode_chatbox_display = '" . $vbulletin->db->escape_string($vbulletin->GPC['phpcode_chatbox_display']) . "',
				phpcode_chatbox_ar_display = '" . $vbulletin->db->escape_string($vbulletin->GPC['phpcode_chatbox_ar_display']) . "',
				htmlcode_chats_display = '" . $vbulletin->db->escape_string($vbulletin->GPC['htmlcode_chats_display']) . "',
				htmlcode_chatbit_menu = '" . $vbulletin->db->escape_string($vbulletin->GPC['htmlcode_chatbit_menu']) . "',
				js_file = '" . $vbulletin->db->escape_string($vbulletin->GPC['js_file']) . "',
				options_varnames = '" . $vbulletin->db->escape_string($vbulletin->GPC['options_varnames']) . "',
				phrases_varnames = '" . $vbulletin->db->escape_string($vbulletin->GPC['phrases_varnames']) . "',
				autocomplete = '" . $vbulletin->db->escape_string($vbulletin->GPC['autocomplete']) . "',
				active = '" . $vbulletin->GPC['activate'] . "'		
			WHERE cid='" . $vbulletin->GPC['cid'] . "'
		");
		
		/* Command deactivation => Channel deactivation if command attached to a channel */
		if (!$vbulletin->GPC['activate'])
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel SET active='0' WHERE cid='" . $vbulletin->GPC['cid'] . "'");
		}
		
		print_stop_message('mgc_cb_evo_command_edited_successfully');
	}	
}

if ($_POST['do'] == "command_update_installcode")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'identifier'             => TYPE_STR,
		'installcode_version'    => TYPE_STR,
		'installcode_install'    => TYPE_STR,
		'installcode_uninstall'	 => TYPE_STR,
		'installcode_array'      => TYPE_NOCLEAN
	));
	
	/* Old installcode updates */
	if (is_array($vbulletin->GPC['installcode_array']))
	{ 
      foreach($vbulletin->GPC['installcode_array'] AS $codeid => $code_infos)
      {
         /* Remove installcode */
         if ($code_infos['delete'])
         {
            $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_command_code WHERE codeid='$codeid'");
         }
         /* Otherwise, update */
         else
         {
            $vbulletin->db->query_write("
               UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command_code
               SET
                  version='" . $vbulletin->db->escape_string($code_infos['version']) . "',
                  installcode='" . $vbulletin->db->escape_string($code_infos['installcode']) . "',
                  uninstallcode='" . $vbulletin->db->escape_string($code_infos['uninstallcode']) . "'
               WHERE codeid='$codeid'
            ");
         }
      }
   }
	
	/* First let's check that the command do exist in the database */
	$command = $vbulletin->db->query_first("SELECT cid,identifier FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE identifier='" . $vbulletin->db->escape_string($vbulletin->GPC['identifier']) . "'");
	
	if (!sizeof($command))
	{
		print_stop_message('mgc_cb_evo_nonexisting_command');
	}
	
	/* Add the command if the fields are not empty */
	if (!empty($vbulletin->GPC['installcode_version']) && !empty($vbulletin->GPC['installcode_install']) && !empty($vbulletin->GPC['installcode_uninstall']))
	{
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_command_code
			SET
				identifier='" . $command['identifier'] . "',
				version = '" . $vbulletin->db->escape_string($vbulletin->GPC['installcode_version']) . "', 
				installcode = '" . $vbulletin->db->escape_string($vbulletin->GPC['installcode_install']) . "', 
				uninstallcode = '" . $vbulletin->db->escape_string($vbulletin->GPC['installcode_uninstall']) . "'
		");
	}
	
	define('CP_REDIRECT', 'mgc_cb_evo.php?do=command_update&what=edit&cid=' . $command['cid'] . '&s=' . $vbulletin->session->vars['sessionhash']);
	print_stop_message('mgc_cb_evo_command_installcode_edited_successfully');
}

if ($_REQUEST['do'] == 'command_manage_perms')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'cid' 	=> TYPE_UINT
	));   
	
	/* Check if the command exist and fetch it */
	$command = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $vbulletin->GPC['cid'] . "'");

	if (!sizeof($command))
	{
		print_stop_message('mgc_cb_evo_nonexisting_command');
	}
	
	$cmd_obj = new mgcCbEvo_command($command);
		
	print_cp_header($vbphrase['mgc_cb_evo_command_permissions']);
	
	print_form_header('mgc_cb_evo','command_do_manage_perms');
	construct_hidden_code('cid', $vbulletin->GPC['cid']);

	print_table_header(construct_phrase($vbphrase['mgc_cb_evo_permissions_command_x'],$command['title']));
	
	$aux_array = array();
	$aux_array['membergroupids'] = $cmd_obj->usergroupids;
	print_membergroup_row($vbphrase['mgc_cb_evo_command_usergroupids'], 'usergroupids', 2, $aux_array);
	print_input_row($vbphrase['mgc_cb_evo_command_userids'], 'userids', $cmd_obj->userids, true, 35, 1000);
	
	/** The end **/
	print_hidden_fields();
	print_submit_row();	
	
}

if ($_POST['do'] == 'command_do_manage_perms')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'cid' 						    => TYPE_UINT,
		'usergroupids'              => TYPE_ARRAY_UINT,
		'userids'                   => TYPE_STR
	));	
	
	/* First let's check that the command do exist in the database */
	$command = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $vbulletin->GPC['cid'] . "'");
	
	if (!sizeof($command))
	{
		print_stop_message('mgc_cb_evo_nonexisting_command');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_commands');	
		
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command
		SET
			usergroupids = '" . implode(',',$vbulletin->GPC['usergroupids']) . "',
			userids = '" . $vbulletin->db->escape_string($vbulletin->GPC['userids']) . "'
		WHERE cid='" . $vbulletin->GPC['cid'] . "'
	");
		
	print_stop_message('mgc_cb_evo_command_permissions_edited_successfully');
}

// #############################################################################
if ($_REQUEST['do'] == 'command_export')
{	
	require_once(DIR . '/includes/class_xml.php');
	require_once(DIR . '/includes/adminfunctions_language.php');
		
	$vbulletin->input->clean_array_gpc('r', array(
		'cid'	=> TYPE_UINT
	));	

	$xml_file = new vB_XML_Builder($vbulletin);

	$command = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $vbulletin->GPC['cid'] . "'");
	
	/* Non existing command */
	if (!$command)
	{
		print_stop_message('mgc_cb_evo_nonexisting_command');
	}

	/* Xml construction starts */	
	$xml_file->add_group('command',array('identifier' => $command['identifier'], 'active' => $command['active']));

   /** Install codes **/
   $codes = $vbulletin->db->query_read("
      SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command_code WHERE identifier='" . $command['identifier'] . "'
   ");
   
   $xml_file->add_group('codes');

   while ($code = $vbulletin->db->fetch_array($codes))
   {
      $xml_file->add_group('code',array('version' => $code['version']));
      $xml_file->add_tag('installcode', $code['installcode']);
      $xml_file->add_tag('uninstallcode', $code['uninstallcode']);
      $xml_file->close_group();
   }   

   $xml_file->close_group();

	/** Command parameters **/
	$xml_file->add_tag('version', $command['version']);
	$xml_file->add_tag('title', $command['title']);
	$xml_file->add_tag('description', $command['description']);	
	$xml_file->add_tag('syntax', $command['syntax']);
	$xml_file->add_tag('authorname', $command['authorname']);
	$xml_file->add_tag('authorurl', $command['authorurl']);
	$xml_file->add_tag('usergroupids', $command['usergroupids']);
	$xml_file->add_tag('phpcode_chats_sending', $command['phpcode_chats_sending']);
	$xml_file->add_tag('phpcode_chats_retrieving', $command['phpcode_chats_retrieving']);
	$xml_file->add_tag('phpcode_chatbox_display', $command['phpcode_chatbox_display']);
	$xml_file->add_tag('phpcode_chatbox_ar_display', $command['phpcode_chatbox_ar_display']);
	$xml_file->add_tag('htmlcode_chats_display', $command['htmlcode_chats_display']);
	$xml_file->add_tag('htmlcode_chatbit_menu', $command['htmlcode_chatbit_menu']);
	$xml_file->add_tag('autocomplete', $command['autocomplete']);
	$xml_file->add_tag('js_file', $command['js_file']);
		
	/** Command bitfields construction **/
	$xml_file->add_group('cmd_bitfield');
	$xml_file->add_tag('with_parameters', ($command['cmd_bitfield'] & 1) ? 1 : 0);
	$xml_file->add_tag('can_be_in_channel', ($command['cmd_bitfield'] & 2) ? 1 : 0);
	$xml_file->add_tag('contains_message', ($command['cmd_bitfield'] & 4) ? 1 : 0);
	$xml_file->add_tag('accepts_userpref', ($command['cmd_bitfield'] & 8) ? 1 : 0);
	$xml_file->add_tag('can_be_in_gen_channel', ($command['cmd_bitfield'] & 16) ? 1 : 0);
	$xml_file->add_tag('from_user_to_user', ($command['cmd_bitfield'] & 32) ? 1 : 0);
	$xml_file->add_tag('accepts_bbcode', ($command['cmd_bitfield'] & 64) ? 1 : 0);
	$xml_file->add_tag('with_username_in_message', ($command['cmd_bitfield'] & 128) ? 1 : 0);
	$xml_file->add_tag('do_format_in_own_channel', ($command['cmd_bitfield'] & 256) ? 1 : 0);
	$xml_file->close_group();	

	/** Phrases **/
	$xml_file->add_group('phrases');
	
	if (!empty($command['phrases_varnames']))
	{
		/* Well forming of the phrase name for the sql query */
		$phrase_varnames_array = explode(',',$command['phrases_varnames']);
		
		foreach($phrase_varnames_array AS $index => $phrase_varname)
		{
			$sql_in_array[] = "varname='$phrase_varname'";
		}

		$phrases = array();
		$retrieved_phrases = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "phrase
			WHERE
				languageid IN (0,-1)
				AND product = 'mgc_cb_evo_cmd'
				AND (" . implode('OR ',$sql_in_array) . ")
			ORDER BY languageid, fieldname, varname
		");
		
		unset($sql_in_array);

		while ($phrase = $vbulletin->db->fetch_array($retrieved_phrases))
		{
			$command_phrases["$phrase[fieldname]"]["$phrase[varname]"] = $phrase;
		}
		unset($phrase);
		
		$vbulletin->db->free_result($retrieved_phrases);
	
		$phrasestypes = fetch_phrasetypes_array(false);	

		foreach ($command_phrases AS $phrase_fieldname => $typephrases)
		{
			$xml_file->add_group('type', array('name' => $phrasestypes["$phrase_fieldname"]['title'], 'fieldname' => $phrase_fieldname));
	
			foreach ($typephrases AS $phrase)
			{
				$xml_file->add_tag(
					'phrase',
					$phrase['text'],
					array(
						'name' 		=> $phrase['varname'],
						'date' 		=> $phrase['dateline'],
						'username' 	=> $phrase['username'],
						'version' 	=> htmlspecialchars_uni($phrase['version'])
					),
					true
				);
			}
	
			$xml_file->close_group();
		}
	}
	
	$xml_file->close_group();
	
	/** Help phrase **/
	$xml_file->add_group('helpphrase');
	
	if (!empty($command['helpphrase']))
	{
		$xml_file->add_group('type', array('name' => 'GLOBAL', 'fieldname' => 'global'));
		
		$gethelphrase = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "phrase
			WHERE
				languageid IN (0,-1)
				AND product = 'mgc_cb_evo_cmd'
				AND varname='" . $command['helpphrase'] . "'
		");
		
		$xml_file->add_tag(
			'phrase',
			$gethelphrase['text'],
			array(
				'name' 		=> $gethelphrase['varname'],
				'date' 		=> $gethelphrase['dateline'],
				'username' 	=> $gethelphrase['username'],
				'version' 	=> htmlspecialchars_uni($gethelphrase['version'])
			),
			true
		);
		
		$xml_file->close_group();
	}
	
	$xml_file->close_group();
	
	/** Settings **/
	$xml_file->add_group('settings');
	
	if (!empty($command['options_varnames']))
	{
		$setting = array();
		$settinggroup = array();
	
		/* Retrieving of the mgc_cb_evo product setting groups */
		$groups = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "settinggroup
			WHERE volatile = 1 AND product='mgc_cb_evo_cmd'
			ORDER BY displayorder
		");
		
		while ($group = $vbulletin->db->fetch_array($groups))
		{
			$settinggroup["$group[grouptitle]"] = $group;
		}

		$options_varnames_array = explode(',',$command['options_varnames']);

		foreach($options_varnames_array AS $index => $option_varname)
		{
			$sql_in_array[] = "varname='$option_varname'";
		}
	
		/* Retrieving of the commands attached to this option */
		$options = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "setting
			WHERE product = 'mgc_cb_evo_cmd' AND volatile = 1 AND (" . implode('OR ',$sql_in_array) . ")
			ORDER BY displayorder
		");
		
		if ($vbulletin->db->num_rows($options))
		{
			while ($set = $vbulletin->db->fetch_array($options))
			{
				$setting["$set[grouptitle]"][] = $set;
			}
			unset($set);
			$vbulletin->db->free_result($sets);
			
			foreach ($settinggroup AS $grouptitle => $group)
			{
				if (array_key_exists($grouptitle,$setting))
				{
					$xml_file->add_group('settinggroup', array('name' => htmlspecialchars($group['grouptitle']), 'displayorder' => $group['displayorder']));
			
					foreach($setting["$grouptitle"] AS $set)
					{
						$arr = array('varname' => $set['varname'], 'displayorder' => $set['displayorder']);

						$settings_phrases[] = '\'setting_' . $arr['varname'] . '_desc\'';
						$settings_phrases[] = '\'setting_' . $arr['varname'] . '_title\'';
						
						if ($set['advanced'])
						{
							$arr['advanced'] = 1;
						}
						
						$xml_file->add_group('setting', $arr);
			
						if ($set['datatype'])
						{
							$xml_file->add_tag('datatype', $set['datatype']);
						}
						if ($set['optioncode'] != '')
						{
							$xml_file->add_tag('optioncode', $set['optioncode']);
						}
						if ($set['validationcode'])
						{
							$xml_file->add_tag('validationcode', $set['validationcode']);
						}
						if ($set['defaultvalue'] !== '')
						{
							$xml_file->add_tag('defaultvalue', $set['defaultvalue']);
						}
						if ($set['blacklist'])
						{
							$xml_file->add_tag('blacklist', 1);
						}
			
						$xml_file->close_group();
					}
					
					$xml_file->close_group();
				}
			}		
		}
	}

	$xml_file->close_group();
	
  	/* Now the settings phrases */
	if ($vbulletin->db->num_rows($options))
	{
      $xml_file->add_group('settingsphrases');
      
   	$getsettingsphrases = $vbulletin->db->query_read("
   		SELECT *
   		FROM " . TABLE_PREFIX . "phrase
   		WHERE
   			languageid IN (0,-1)
   			AND product = 'mgc_cb_evo_cmd'
   			AND varname IN (" . implode(',',$settings_phrases) . ")
   	");
   	
   	while($phrase = $vbulletin->db->fetch_array($getsettingsphrases))
   	{
   		$xml_file->add_tag(
   			'phrase',
   			$phrase['text'],
   			array(
   				'name' 		=> $phrase['varname'],
   				'date' 		=> $phrase['dateline'],
   				'username' 	=> $phrase['username'],
   				'version' 	=> htmlspecialchars_uni($phrase['version'])
   			),
   			true
   		);
   	}
   	
   	$xml_file->close_group();
   }

	// ############## Finish up
	$xml_file->close_group();
	$file = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n" . $xml_file->output();

	unset($xml_file);

	require_once(DIR . '/includes/functions_file.php');
	file_download($file, "mgc_cb_evo_command-" . $command['identifier'] . '.xml', 'text/xml');
}

if ($_POST['do'] == 'command_import')
{
	require_once(DIR . '/includes/class_bitfield_builder.php');
	require_once(DIR . '/includes/class_xml.php');
	
	$vbulletin->input->clean_array_gpc('p', array(
		'allowoverwrite' => TYPE_BOOL
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'xml_file' => TYPE_FILE
	));
	
	/* User did specified a file ? */
	if (file_exists($vbulletin->GPC['xml_file']['tmp_name']))
	{
		$xml_file = file_read($vbulletin->GPC['xml_file']['tmp_name']);
	}
	else
	{
		print_stop_message('mgc_cb_evo_no_file');
	}

   print_cp_header($vbphrase['mgc_cb_evo_command_import']);

	print_dots_start('<b>' . $vbphrase['mgc_cb_evo_importing_command'] . "</b>, $vbphrase[please_wait]", ':', 'dspan');

	/* Parsing of the xml file */
	$xml_object = new vB_XML_Parser($xml_file);
	if ($xml_object->error_no == 1)
	{
			print_dots_stop();
			print_stop_message('mgc_cb_evo_no_file');
	}

	/* Errors */
	if(!$xml_parsed_array = $xml_object->parse())
	{
		print_dots_stop();
		print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
	}

   /* No identifier / Version / Syntax specified */
   if (empty($xml_parsed_array['identifier']) || empty($xml_parsed_array['version']) || empty($xml_parsed_array['syntax']))
   {
      print_dots_stop('mgc_cb_evo_missing_identifier_version_syntax');
   }
	
	/* The command exists ? */
	$getcommand = $vbulletin->db->query_first("
      SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE identifier='" . $vbulletin->db->escape_string($xml_parsed_array['identifier']) . "'
   ");
   
   /* Product exist */
   if ($getcommand)
   {
      if (!$vbulletin->GPC['allowoverwrite'])
      {
         print_dots_stop();
         print_stop_message('mgc_cb_evo_command_x_exist_but_no_overwrite',$xml_parsed_array['title']);
      }
      
      $already_installed   = 1;
      $current_version     = $getcommand['version'];
      $current_cid         = $getcommand['cid'];
   }
   else
   {
      $already_installed = 0;
   }
   
   /* Let's run the installcodes if any */
   if (is_array($xml_parsed_array['codes']))
   {
      require_once(DIR . '/includes/adminfunctions_template.php');
      
      $codes =& $xml_parsed_array['codes']['code'];
      
      /* Only one code */
      if (!isset($codes['0']))
      {
         $codes = array($codes);
      }
      
      foreach($codes AS $index => $code)
      {
         if (!$already_installed || ($already_installed && is_newer_version($code['version'],$current_version)))
         {
            eval($code['installcode']);
            
            $vbulletin->db->query_write("
               INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_command_code
               SET
                  identifier='" . $vbulletin->db->escape_string($xml_parsed_array['identifier']) . "', 
                  version='" . $vbulletin->db->escape_string($code['version']) . "',
                  installcode='" . $vbulletin->db->escape_string($code['installcode']) . "',
                  uninstallcode='" . $vbulletin->db->escape_string($code['uninstallcode']) . "'
            ");
         }
      }
   }

	/* Management of the phrases */
	if (is_array($xml_parsed_array['phrases']['type']))
	{
		require_once(DIR . '/includes/adminfunctions_language.php');

		$types =& $xml_parsed_array['phrases']['type'];

      /* Multiple phrasetypes ? */
      if (!isset($types['0']))
      {
         $types = array($types);  
      }
      
		foreach ($types AS $type)
		{
			$phrases =& $type['phrase'];

         /* If there is only one phrase */
         if (!isset($phrases['0']))
         {
            $phrases = array($phrases);
         }
      	
			$sql = array();

			foreach ($phrases AS $phrase)
			{
			   $command_phrases_array[] = $phrase['name'];
            	   
				$sql[] = "
					(-1,
					'" . $vbulletin->db->escape_string($type['fieldname']) . "',
					'" . $vbulletin->db->escape_string($phrase['name']) . "',
					'" . $vbulletin->db->escape_string($phrase['value']) . "',
					'mgc_cb_evo_cmd',
					'" . $vbulletin->db->escape_string($phrase['username']) . "',
					" . intval($phrase['date']) . ",
					'" . $vbulletin->db->escape_string($phrase['version']) . "')
				";
			}

			/*insert query*/
			$vbulletin->db->query_write("
				REPLACE INTO " . TABLE_PREFIX . "phrase
					(languageid, fieldname, varname, text, product, username, dateline, version)
				VALUES
					" . implode(',', $sql)
			);
		}

		$contains_phrases = 1;
	}
	
	/* The help phrase */
	if (is_array($xml_parsed_array['helpphrase']['type']))
	{
      /* Let's insert the phrase */
      $phrase =& $xml_parsed_array['helpphrase']['type']['phrase'];
      $vbulletin->db->query_write("
         REPLACE INTO " . TABLE_PREFIX . "phrase
					(languageid, fieldname, varname, text, product, username, dateline, version)
				VALUES
					(
                  -1,
                  'global',
                  '" . $vbulletin->db->escape_string($phrase['name']) . "',
                  '" . $vbulletin->db->escape_string($phrase['value']) . "',
                  'mgc_cb_evo_cmd',
                  '" . $vbulletin->db->escape_string($phrase['username']) . "',
                  " . intval($phrase['date']) . ",
                  '" . $vbulletin->db->escape_string($phrase['version']) . "'
               )            
      ");
      
      $command_help_phrase = $phrase['name'];
      
      $contains_helpphrases = 1;
   }
	
	/* Management of the settings */
	if (is_array($xml_parsed_array['settings']['settinggroup']))
	{
		$settinggroups =& $xml_parsed_array['settings']['settinggroup'];

      /* If there is only one settingroup */
      if (!isset($settinggroups['0']))
      {
         $settinggroups = array($settinggroups);
      }

		foreach ($settinggroups AS $group)
		{
			if (empty($group['setting']))
			{
				continue;
			}

         /* Is the settinggroup a valid chatbox settingroup ? */
         if (!in_array($group['name'],array('mgc_cb_evo_opt_cmd')))
         {
            continue;
         }

			$settings =& $group['setting'];

         /* If there is only one setting */
         if (!isset($settings['0']))
         {
            $settings = array($settings);
         }

			$setting_bits = array();

			foreach ($settings AS $setting)
			{
				if (isset($vbulletin->options["$setting[varname]"]))
				{
					$newvalue = $vbulletin->options["$setting[varname]"];
				}
				else
				{
					$newvalue = $setting['defaultvalue'];
				}
				
				$command_settings_array[] = $setting['varname'];

				$setting_bits[] = "(
					'" . $vbulletin->db->escape_string($setting['varname']) . "',
					'" . $vbulletin->db->escape_string($group['name']) . "',
					'" . $vbulletin->db->escape_string(trim($newvalue)) . "',
					'" . $vbulletin->db->escape_string(trim($setting['defaultvalue'])) . "',
					'" . $vbulletin->db->escape_string(trim($setting['datatype'])) . "',
					'" . $vbulletin->db->escape_string($setting['optioncode']) . "',
					" . intval($setting['displayorder']) . ",
					" . intval($setting['advanced']) . ",
					1,
					'" . $vbulletin->db->escape_string($setting['validationcode']) . "',
					" . intval($setting['blacklist']) . ",
					'mgc_cb_evo_cmd'\n\t)";
			}

			/*insert query*/
			$vbulletin->db->query_write("
				REPLACE INTO " . TABLE_PREFIX . "setting
					(varname, grouptitle, value, defaultvalue, datatype, optioncode, displayorder, advanced, volatile, validationcode, blacklist, product)
				VALUES
					" . implode(",\n\t", $setting_bits)
			);
		}

		$contains_settings = 1;
	}
	
	/* Management of the settings phrasees */
	if (is_array($xml_parsed_array['settingsphrases']))
	{
		$settingsphrases =& $xml_parsed_array['settingsphrases']['phrase'];
      
      require_once(DIR . '/includes/adminfunctions_language.php');
   	
		$sql = array();
		
		foreach ($settingsphrases AS $phrase)
		{
			$sql[] = "
				(-1,
				'vbsettings',
				'" . $vbulletin->db->escape_string($phrase['name']) . "',
				'" . $vbulletin->db->escape_string($phrase['value']) . "',
				'mgc_cb_evo_cmd',
				'" . $vbulletin->db->escape_string($phrase['username']) . "',
				" . intval($phrase['date']) . ",
				'" . $vbulletin->db->escape_string($phrase['version']) . "')
			";
		}
		
		/*insert query*/
		$vbulletin->db->query_write("
			REPLACE INTO " . TABLE_PREFIX . "phrase
				(languageid, fieldname, varname, text, product, username, dateline, version)
			VALUES
				" . implode(',', $sql)
		);

		$contains_settingsphrases = 1;
	}	

   /* Needed rebuilds */
   $phrases = '';
	if ($contains_phrases || $contains_helpphrases || $contains_settingsphrases)
	{
	   if ($contains_phrases)
	   {
         $phrases = "phrases_varnames = '" . $vbulletin->db->escape_string(implode(',',$command_phrases_array)) . "',";
      }
		require_once(DIR . '/includes/adminfunctions_language.php');
		build_language();
	}

	$options = '';	
	if ($contains_settings)
	{
      $options = "options_varnames = '" . $vbulletin->db->escape_string(implode(',',$command_settings_array)) . "',";
		build_options();
	}   

   /* Existing command, lets update */
   if ($already_installed)
   {
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command
			SET
				title = '" . $vbulletin->db->escape_string($xml_parsed_array['title']) . "',
				description = '" . $vbulletin->db->escape_string($xml_parsed_array['description']) . "',
				version = '" . $vbulletin->db->escape_string($xml_parsed_array['version']) . "', 
				authorname = '" . $vbulletin->db->escape_string($xml_parsed_array['authorname']) . "',
				authorurl = '" . $vbulletin->db->escape_string($xml_parsed_array['authorurl']) . "',
				helpphrase = '" . $vbulletin->db->escape_string($command_help_phrase) . "',
				syntax = '" . $vbulletin->db->escape_string($xml_parsed_array['syntax']) . "',
				size = '" . strlen($xml_parsed_array['syntax']) . "',
				cmd_bitfield = '" . mgcCbEvo_command::construct_bitfield($xml_parsed_array['cmd_bitfield']) . "',
				phpcode_chats_sending = '" . $vbulletin->db->escape_string($xml_parsed_array['phpcode_chats_sending']) . "',
				phpcode_chats_retrieving = '" . $vbulletin->db->escape_string($xml_parsed_array['phpcode_chats_retrieving']) . "',
				phpcode_chatbox_display = '" . $vbulletin->db->escape_string($xml_parsed_array['phpcode_chatbox_display']) . "',
				phpcode_chatbox_ar_display = '" . $vbulletin->db->escape_string($xml_parsed_array['phpcode_chatbox_ar_display']) . "',
				htmlcode_chats_display = '" . $vbulletin->db->escape_string($xml_parsed_array['htmlcode_chats_display']) . "',
				htmlcode_chatbit_menu = '" . $vbulletin->db->escape_string($xml_parsed_array['htmlcode_chatbit_menu']) . "',
				js_file = '" . $vbulletin->db->escape_string($xml_parsed_array['js_file']) . "',
				autocomplete = '" . $vbulletin->db->escape_string($xml_parsed_array['autocomplete']) . "',
				$options
				$phrases
				active = '" . $xml_parsed_array['active'] . "'		
			WHERE cid='$current_cid'
		");
   }
   /* New command */
   else
   {
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_command
			SET
				identifier = '" . $vbulletin->db->escape_string($xml_parsed_array['identifier']) . "',
				title = '" . $vbulletin->db->escape_string($xml_parsed_array['title']) . "',
				description = '" . $vbulletin->db->escape_string($xml_parsed_array['description']) . "',
				version = '" . $vbulletin->db->escape_string($xml_parsed_array['version']) . "', 
				authorname = '" . $vbulletin->db->escape_string($xml_parsed_array['authorname']) . "',
				authorurl = '" . $vbulletin->db->escape_string($xml_parsed_array['authorurl']) . "',
				usergroupids = '" . $vbulletin->db->escape_string($xml_parsed_array['usergroupids']) . "',
				helpphrase = '" . $vbulletin->db->escape_string($command_help_phrase) . "',
				syntax = '" . $vbulletin->db->escape_string($xml_parsed_array['syntax']) . "',
				size = '" . strlen($xml_parsed_array['syntax']) . "',
				cmd_bitfield = '" . mgcCbEvo_command::construct_bitfield($xml_parsed_array['cmd_bitfield']) . "',
				phpcode_chats_sending = '" . $vbulletin->db->escape_string($xml_parsed_array['phpcode_chats_sending']) . "',
				phpcode_chats_retrieving = '" . $vbulletin->db->escape_string($xml_parsed_array['phpcode_chats_retrieving']) . "',
				phpcode_chatbox_display = '" . $vbulletin->db->escape_string($xml_parsed_array['phpcode_chatbox_display']) . "',
				phpcode_chatbox_ar_display = '" . $vbulletin->db->escape_string($xml_parsed_array['phpcode_chatbox_ar_display']) . "',
				htmlcode_chats_display = '" . $vbulletin->db->escape_string($xml_parsed_array['htmlcode_chats_display']) . "',
				htmlcode_chatbit_menu = '" . $vbulletin->db->escape_string($xml_parsed_array['htmlcode_chatbit_menu']) . "',
				js_file = '" . $vbulletin->db->escape_string($xml_parsed_array['js_file']) . "',
				autocomplete = '" . $vbulletin->db->escape_string($xml_parsed_array['autocomplete']) . "',
				$options
				$phrases
				active = '" . $xml_parsed_array['active'] . "'	
		");
   }   

   print_dots_stop();
   
	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_commands');   
   print_stop_message('mgc_cb_evo_command_x_imported_successfully',$xml_parsed_array['title']);
}

if ($_REQUEST['do'] == 'manage_channels')
{
	print_cp_header($vbphrase['mgc_cb_evo_channels_mngt']);
	
	?>
	<script type="text/javascript">
	function js_page_jump(i, chanid)
	{
		var sel = fetch_object("channelsel" + i);
		var act = sel.options[sel.selectedIndex].value;
		if (act != '')
		{
			switch (act)
			{
				case 'channel_disable': page = "mgc_cb_evo.php?do=channel_enable&what=0&chanid="; break;
				case 'channel_enable': page = "mgc_cb_evo.php?do=channel_enable&what=1&chanid="; break;
				case 'channel_edit': page = "mgc_cb_evo.php?do=channel_update&what=edit&chanid="; break;
				case 'channel_delete':
					if(confirm("<? echo $vbphrase['mgc_cb_evo_are_you_sure_to_delete']; ?>"))
						page = "mgc_cb_evo.php?do=channel_delete&chanid=";
					else
						return;
					break;
				default: return;
			}
			jumptopage = page + chanid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
			window.location = jumptopage;
		}
		else
		{
			alert('<?php echo addslashes_js($vbphrase['invalid_action_specified']); ?>');
		}
	}
	</script>
	<?php
	
	/** Command list **/
	
	/* Retrieving of the commands */
	print_form_header('mgc_cb_evo', 'channel_order_save');
	construct_hidden_code('channelid', '');

	print_table_header($vbphrase['mgc_cb_evo_channels'], 6);
	print_cells_row(array($vbphrase['title'], $vbphrase['mgc_cb_evo_order'], $vbphrase['description'], $vbphrase['mgc_cb_evo_command'], $vbphrase['mgc_cb_evo_warn_user'], $vbphrase['controls']), 1);
	
	/* Retrieving of the channels */
	$getchannels = $vbulletin->db->query_read("
		SELECT ch.*,co.syntax,co.title AS cotitle
		FROM " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch
		LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (ch.cid=co.cid)
		ORDER BY chanorder ASC
	");
	
	while($channel = $vbulletin->db->fetch_array($getchannels))
	{
		$options = array('channel_edit' => $vbphrase['edit']);
		
		if ($channel['active'])
		{
			$options['channel_disable'] = $vbphrase['disable'];
			$title =  htmlspecialchars_uni($channel['title']);
		}
		else
		{
			$options['channel_enable'] = $vbphrase['enable'];
			$title = "<strike>" . htmlspecialchars_uni($channel['title']) . "</strike>";			
		}

		$options['channel_delete'] = $vbphrase['delete'];
		
		$i++;
		
		print_cells_row(array(
			$title,
			"<div align='center'><input type='input' class='input' size='5' name='chan_order[" . $channel['chanid'] . "]' value='" . $channel['chanorder'] . "' /></div>",
			htmlspecialchars_uni($channel['description']),
			"/" . $channel['syntax'] . " : " . $channel['cotitle'],
			($channel['warnon'] ? $vbphrase['yes'] : $vbphrase['no']),
			"<div align=\"$stylevar[right]\">
				<select name=\"s$channel[chanid]\" id=\"channelsel$i\" onchange=\"js_page_jump($i, '$channel[chanid]')\" class=\"bginput\">
					" . construct_select_options($options) . "
				</select>&nbsp;<input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_page_jump($i, '$channel[chanid]');\" />
			</div>"
		), false, '', -2);		
	}
	
	
	print_description_row('<div align="center"><input type="submit" value="' . $vbphrase['mgc_cb_evo_save'] . '" />&nbsp;&nbsp;<input type="button" onclick="window.location=\'mgc_cb_evo.php?do=channel_update&what=add&s=' . $vbulletin->session->vars['sessionhash'] . '\'" value="' . stripslashes($vbphrase['mgc_cb_evo_add_channel']) . '"></div>',false,6,'tfoot');	
	
	print_table_footer();
}

if ($_REQUEST['do'] == 'channel_update')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'chanid' 	=> TYPE_UINT,
		'what'	=> TYPE_STR
	));

	if ($vbulletin->GPC['what'] == "add")
	{	
		/* Retrieving commands which can be put in a channel */
		$getcommands = $vbulletin->db->query_read("
			SELECT co.title,co.syntax,co.cid,co.active
			FROM " . TABLE_PREFIX . "mgc_cb_evo_command AS co
			LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch ON (co.cid = ch.cid)
			WHERE
				(co.cmd_bitfield & 2)
				AND
				(chanid IS NULL" . ($vbulletin->GPC['chanid'] ? " OR chanid='" . $vbulletin->GPC['chanid'] . "')" : ")" ) . "
		");

		print_cp_header($vbphrase['mgc_cb_evo_add_channel']);
		$channel['chanorder'] = 1;
	}
	else
	{
		/* Check if the channel exist and fetch it */
		$channel = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
	
		if (!$channel)
		{
			print_stop_message('mgc_cb_evo_nonexisting_channel');
		}
		
		/* Retrieves channel command */
		$getcommand = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $channel['cid'] . "'");
		
		$cmd_obj = new mgcCbEvo_command($getcommand);
		
		print_cp_header($vbphrase['mgc_cb_evo_edit_channel']);
	}
	
	print_form_header('mgc_cb_evo','channel_do_update');
	construct_hidden_code('what', $vbulletin->GPC['what']);
	construct_hidden_code('chanid', $vbulletin->GPC['chanid']);
	
	print_table_header($vbphrase['mgc_cb_evo_channel_information']);
	
	print_input_row($vbphrase['title'], 'title', $channel['title'], true, 35, 50);
	print_input_row($vbphrase['description'], 'description', $channel['description'], true, 35, 250);
	print_input_row($vbphrase['mgc_cb_evo_channel_image_name'], 'img_name', $channel['img_name'], true, 35, 50);
	
	print_input_row($vbphrase['mgc_cb_evo_order'], 'chanorder', $channel['chanorder'], true, 35, 100);
	print_yes_no_row($vbphrase['mgc_cb_evo_channel_warnon_new_message'], 'warnon', $channel['warnon'], 0);
	print_yes_no_row($vbphrase['mgc_cb_evo_channel_activate'], 'activate', $channel['active'], 0);

	print_table_break();

	print_table_header($vbphrase['mgc_cb_evo_channel_command_info']);
	
	if ($vbulletin->GPC['what'] == "add")
	{
		print_label_row("<strong>" . $vbphrase['mgc_cb_evo_use_of_an_installed_command'] . '...</strong>');
	
		/** Command select **/
		if ($vbulletin->db->num_rows($getcommands))
		{
			$options[0] = $vbphrase['mgc_cb_evo_dont_use_existing_command'];
			while($command = $vbulletin->db->fetch_array($getcommands))
			{
				$options["$command[cid]"] = "/" . $command['syntax'] . " : " . $command['title'] . ($command['active'] ? '' : " *");
				if ($command['cid'] == $channel['cid'])
				{
					$selected = $command['cid'];
				}
			}
		}
	
		print_select_row($vbphrase['mgc_cb_evo_select_command'], 'cid', $options, $selected);

		print_label_row('<strong>... ' . $vbphrase['mgc_cb_evo_use_of_a_new_created_command'] . '</strong>');
		print_input_row($vbphrase['mgc_cb_evo_command_syntax'], 'syntax', '', true, 35, 50);
	}
	
 	$aux_array = array();
	$aux_array['membergroupids'] = $cmd_obj->usergroupids;
	print_membergroup_row($vbphrase['mgc_cb_evo_command_usergroupids'], 'usergroupids', 2, $aux_array);
	print_input_row($vbphrase['mgc_cb_evo_command_userids'], 'userids', $cmd_obj->userids, true, 35, 1000);
	
	/** The end **/
	print_hidden_fields();
	print_submit_row();

}

if ($_POST['do'] == 'channel_do_update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'chanid' 		=> TYPE_UINT,
		'what'			=> TYPE_STR,
		'title'			=> TYPE_STR,
		'description'	=> TYPE_STR,
		'img_name'		=> TYPE_STR,
		'cid'			   => TYPE_UINT,
		'chanorder'		=> TYPE_UINT,
		'syntax'      	=> TYPE_STR,
		'warnon'		   => TYPE_UINT,
		'usergroupids' => TYPE_ARRAY_UINT,
		'userids'      => TYPE_STR,
		'activate'		=> TYPE_UINT
	));
	
	/* In case of edit, let's check if the chan exists */
	if ($vbulletin->GPC['what'] == 'edit')
	{
		$channel = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
	
		if (!$channel)
		{
			print_stop_message('mgc_cb_evo_nonexisting_channel');
		}		
	}
	
	/* Some checks */
	if (empty($vbulletin->GPC['title']) || empty($vbulletin->GPC['img_name']))
	{
		print_stop_message('mgc_cb_evo_missing_title_or_img_name');
	}
	
	
	/** cid = 0 => new command **/
	if ($vbulletin->GPC['what'] == 'add' && $vbulletin->GPC['cid'] == 0)
	{
		if (empty($vbulletin->GPC['syntax']))
		{
			print_stop_message('mgc_cb_evo_missing_cmd_syntax');
		}
		
		/* Check if command identifier doesn't already exist */
		$check_command = $vbulletin->db->query_first("SELECT identifier FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE syntax='" . $vbulletin->db->escape_string($vbulletin->GPC['syntax']) . "'");
		
		
		if ($check_command)
		{
			print_stop_message('mgc_cb_evo_existing_cmd_syntax');
		}
		
		/* Let's create the command */
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_command
			SET
				identifier = 'cmd_" . $vbulletin->db->escape_string($vbulletin->GPC['syntax']) . "',
				title = '" . $vbphrase['mgc_cb_evo_channel_cmd'] . ' ' . $vbulletin->db->escape_string($vbulletin->GPC['title']) . "',
				description = '',
				version = '0.0.0', 
				authorname = '" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
				authorurl = '',
				helpphrase = '',
				syntax = '" . $vbulletin->db->escape_string($vbulletin->GPC['syntax']) . "',
				size = '" . strlen($vbulletin->GPC['syntax']) . "',
				cmd_bitfield = '78',
				usergroupids = '" . implode(',',$vbulletin->GPC['usergroupids']) . "',
				userids = '" . $vbulletin->db->escape_string($vbulletin->GPC['userids']) . "',
				phpcode_chats_sending = '" . $vbulletin->db->escape_string($vbulletin->GPC['phpcode_chats_sending']) . "',
				phpcode_chats_retrieving = '',
				phpcode_chatbox_display = '',
				phpcode_chatbox_ar_display = '',
				htmlcode_chats_display = '',
				htmlcode_chatbit_menu = '',
				js_file = '',
				options_varnames = '',
				phrases_varnames = '',
				active = '" . $vbulletin->GPC['activate'] . "'
		");			
		
		$vbulletin->GPC['cid'] = $vbulletin->db->insert_id();
		$active = $vbulletin->GPC['activate'];
	}
	else
	{	
		/* Update command usergroup permissions */
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command
			SET
				usergroupids = '" . implode(',',$vbulletin->GPC['usergroupids']) . "',
				userids = '" . $vbulletin->db->escape_string($vbulletin->GPC['userids']) . "'
			WHERE cid='" . $channel['cid'] . "'
		");
	
		/* Retrieving of the active field of the command */
		$command = $vbulletin->db->query_first("SELECT active FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $channel['cid'] . "'");
		
		/* The command is inactive => Channel must be inactive */
		if (!$command['active'])
		{
			$active = 0;	
		}
		else
		{
			$active = $vbulletin->GPC['activate'];
		}
	}
	
	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');
	
	/* Ready to add in the database */
	if ($vbulletin->GPC['what'] == 'add')
	{
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_channel
			SET
				title='" . $vbulletin->db->escape_string($vbulletin->GPC['title']) . "',
				description='" . $vbulletin->db->escape_string($vbulletin->GPC['description']) . "',
				cid='" . $vbulletin->GPC['cid'] . "',
				chanorder='" . $vbulletin->GPC['chanorder'] . "',
				img_name='" . $vbulletin->db->escape_string($vbulletin->GPC['img_name']) . "',
				warnon='" . $vbulletin->GPC['warnon'] . "',
				active='$active'
		");
		
		print_stop_message('mgc_cb_evo_channel_added_successfully');
	}
	else
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel
			SET
				title='" . $vbulletin->db->escape_string($vbulletin->GPC['title']) . "',
				description='" . $vbulletin->db->escape_string($vbulletin->GPC['description']) . "',
				chanorder='" . $vbulletin->GPC['chanorder'] . "',
				img_name='" . $vbulletin->db->escape_string($vbulletin->GPC['img_name']) . "',
				warnon='" . $vbulletin->GPC['warnon'] . "',
				active='$active'
			WHERE chanid='" . $vbulletin->GPC['chanid'] . "'
		");		
		
		print_stop_message('mgc_cb_evo_channel_edited_successfully');
	}
}

if ($_POST['do'] == 'channel_order_save')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'chan_order' 		=> TYPE_ARRAY_UINT
	));
	
	foreach($vbulletin->GPC['chan_order'] AS $channel_id => $order)
	{
		if (empty($order))
		{
			$order = 1;
		}
		
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel SET chanorder='$order' WHERE chanid='$channel_id'");
	}
	
	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');
	print_stop_message('mgc_cb_evo_channel_order_saved_successfully');
}

if ($_REQUEST['do'] == "channel_enable")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'chanid' 	=> TYPE_UINT,
		'what'		=> TYPE_UINT
	));
	
	/* Check if the chahnel exist */
	$check_channel = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");

	if (!$vbulletin->db->num_rows($check_channel))
	{
		print_stop_message('mgc_cb_evo_nonexisting_channel');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');
	
	/* Disabling of the command */
	if (!$vbulletin->GPC['what'])
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel SET active='0' WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
		print_stop_message('mgc_cb_evo_channel_successfully_disabled');	
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel SET active='1' WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
		print_stop_message('mgc_cb_evo_channel_successfully_enabled');
	}
}

if ($_REQUEST['do'] == "channel_delete")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'chanid' 	=> TYPE_UINT
	));
	/* Check if the chahnel exist */
	$check_channel = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");

	if (!$vbulletin->db->num_rows($check_channel))
	{
		print_stop_message('mgc_cb_evo_nonexisting_channel');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');

	/* Removing of the chats */
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
	
	print_stop_message('mgc_cb_evo_channel_successfully_deleted');
}

print_cp_footer();

?>