<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'mgc_cb_evo_ajax');
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array('bbcodecache');

// pre-cache templates used by all actions
$globaltemplates = array(
   'mgc_cb_evo_editor',
   'mgc_cb_evo_chatbit',
   'mgc_cb_evo_chatbit_menu',
   'editor_jsoptions_font',
   'editor_jsoptions_size'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

$_POST['ajax'] = 1;

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_xml.php');
require_once (DIR . '/includes/functions_mgc_cb_evo.php');
require_once (DIR . '/includes/class_bbcode.php');

/* Chatbox content refresh */
if ($_POST['do'] == 'ajax_refresh_chat')
{
   /* Chatbox status (open or closed) */
   $status = $vbulletin->input->clean_gpc('p', 'status', TYPE_STR);

   /* Channel id */
   $channel_id = $vbulletin->input->clean_gpc('p', 'channel_id', TYPE_UINT);

   /* Chatbox location : on a vbulletin page or in its own page (full mode) */
   $location = $vbulletin->input->clean_gpc('p', 'location', TYPE_STR);
   
   /* First load */
   $first_load = $vbulletin->input->clean_gpc('p', 'first_load', TYPE_UINT);

   $chats = '';

   if (can_view_mgc_cb_evo())
   {
      /* First load inactive mode => Update session table */
      if ($first_load && $vbulletin->options['mgc_cb_evo_inactive_mode'] && $vbulletin->options['mgc_cb_evo_whoisonline_active'])
      {
         $vbulletin->db->query_write("REPLACE INTO " . TABLE_PREFIX . "mgc_cb_evo_session SET userid='" . $vbulletin->userinfo['userid'] . "',dateline='" . TIMENOW . "'");
      }
      
      /* Warning channels activated => lets refresh it */
      if ($vbulletin->options['mgc_cb_evo_channels_warning'])
      {
         if (empty($vbulletin->userinfo['mgc_cb_evo_channel_activities']))
         {
            $channel_activities = array($channel_id => TIMENOW);
         }
         else
         {
            $channel_activities = unserialize($vbulletin->userinfo['mgc_cb_evo_channel_activities']);
            $channel_activities["$channel_id"] = TIMENOW;
         }
         $serialized_channel_activities = serialize($channel_activities);
         
         $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_channel_activities='$serialized_channel_activities' WHERE userid='".  $vbulletin->userinfo['userid'] . "'");
      }

      /** Retrieving of the commands **/

      /* Constructing the usergroupids REGEXP */
      $sql_condition = "co.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";

      if (!empty($vbulletin->userinfo['membergroupids']))
      {
         $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

         foreach ($ugipds_array as $index => $ugpid)
         {
            $sql_condition .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
         }
      }
      
      $sql_condition .= " OR co.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";

      /* Retrieving the commands in the database */
      $getcommands = $vbulletin->db->query_read("
			SELECT co.*,ch.chanid
			FROM " . TABLE_PREFIX . "mgc_cb_evo_command AS co
			LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch ON (co.cid = ch.cid)
			WHERE co.active='1' AND ($sql_condition)
		");

      if ($vbulletin->db->num_rows($getcommands))
      {
         require_once (DIR . '/includes/class_mgc_cb_evo_cmd.php');

         while ($command = $vbulletin->db->fetch_array($getcommands))
         {
            $commands["$command[cid]"] = new mgcCbEvo_command($command);

            /* General channel */
            if (!$channel_id)
            {
               /* The command is not used in a channel and can be used in the general channel */
               if (!$command['chanid'] && $commands["$command[cid]"]->can_be_in_gen_channel && $commands["$command[cid]"]->contains_message)
               {
                  $cids_array[] = $command['cid'];
               }
            }
            else
            {
               /* The command of the current channel */
               if ($command['chanid'] == $channel_id)
               {
                  $channel_cid = $command['cid'];
               }
            }
         }
      }
      
      unset($getcommands);

      /** Building the chats retrieving query **/

      /* The query parameters depending on the channel */
      $left_join = "";
      $additional_fields = "";

      if ($channel_id)
      {
         $where_clause = "primcid='$channel_cid'";
         
         if ($commands["$channel_cid"]->from_user_to_user)
         {
         	$where_clause .= "AND (fromuid='" . $vbulletin->userinfo['userid'] . "' OR touid='" . $vbulletin->userinfo['userid'] . "')";
         }
      }
      else
      {
         $where_clause = "primcid='0' ";
         if (is_array($cids_array))
         {
            $where_clause = "( " . $where_clause;
            $where_clause .= " OR ( primcid IN(" . implode(',', $cids_array) . ") AND (!(co.cmd_bitfield & 32) OR (fromuid='" . $vbulletin->userinfo['userid'] . "' OR touid='" . $vbulletin->userinfo['userid'] . "'))) )";
         }
      }

      /* The commands phpcode for chat retrievings */
      if (is_array($commands))
      {
         foreach ($commands as $cid => $cmd_obj)
         {
            /* Execution of the where clause if the command is not used in a channel */
            if (!$cmd_obj->chanid)
            {
               eval($cmd_obj->phpcode_chats_retrieving);
            }
         }
      }
      
      /* LIMIT clause construction */
      if ($status == "closed")
      {
         $limit = $vbulletin->options['mgc_cb_evo_nbchats_closed'];
      }
      else if ($location == "full")
      {
         $limit = $vbulletin->options['mgc_cb_evo_nbchats_full'];
      }
      else
      {
         $limit = $vbulletin->options['mgc_cb_evo_nbchats_normal'];
      }

      /* Retrieving of the chats */
      $chats = $vbulletin->db->query_read("
			SELECT c.*,fromu.userid AS fromuserid,fromu.username AS fromusername,fromu.usergroupid AS fromusergroupid,fromu.displaygroupid AS fromdisplaygroupid,
                  tou.userid AS touserid,tou.username AS tousername,tou.usergroupid AS tousergroupid,tou.displaygroupid AS todisplaygroupid
				   $additional_fields
			FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
			LEFT JOIN " . TABLE_PREFIX . "user AS fromu ON (c.fromuid=fromu.userid)
            LEFT JOIN " . TABLE_PREFIX . "user AS tou ON (c.touid=tou.userid)
            LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (c.primcid=co.cid)
			$left_join
			WHERE $where_clause
			ORDER BY sticky DESC,c.dateline DESC
			LIMIT $limit
	  ");

      /* Tri des messages selon l'ordre d'affichage (ascendant ou descendant) */
      $nbchats = $vbulletin->db->num_rows($chats);
      if ($nbchats)
      {
         $parsebbcode = $vbulletin->options['mgc_cb_evo_bbcode'] || $vbulletin->options['mgc_cb_evo_bbcode_url'] || $vbulletin->options['mgc_cb_evo_bbcode_img'];
         
         $alt = 2;
         
         /* Ascending */
         if ($vbulletin->options['mgc_cb_evo_chats_order'])
         {
            $cpt = $nbchats - 1;
            while ($chat = $vbulletin->db->fetch_array($chats))
            {                           
               $chats_table["$cpt"] = fetch_chat_info($chat, $parsebbcode, $commands, $channel_id,$alt);
               $chats_menu_register .= "vbmenu_register('test_+ $chat[chatid]');";
               $cpt--;
               
               if ($vbulletin->options['mgc_cb_evo_alt_colors'])
               {
                  if ($alt == 2)
                  {
                     $alt = 1;
                  }
                  else
                  {
                     $alt = 2;
                  }
               }               
            }
            ksort($chats_table);
         }
         else
         {
            $cpt = 0;
            while ($chat = $vbulletin->db->fetch_array($chats))
            {
               $chats_table["$cpt"] = fetch_chat_info($chat, $parsebbcode, $commands, $channel_id,$alt);
               $cpt++;
               
               if ($vbulletin->options['mgc_cb_evo_alt_colors'])
               {
                  if ($alt == 2)
                  {
                     $alt = 1;
                  }
                  else
                  {
                     $alt = 2;
                  }
               }                 
            }                                    
         }
      }

      $chats_html = "";

      if (is_array($chats_table))
      {
         foreach ($chats_table as $index => $chatbit)
         {
            $chats_html .= $chatbit;
         }
         $chats_html = "<table width=\"95%\" cellspacing=\"0\" align=\"left\">" . $chats_html . "</table>";         
      }
      else
      {
         $chats_html = "<div align=\"center\"><b>" . $vbphrase['mgc_cb_empty'] . "</b></div>";
      }
      
      $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
      $xml->add_tag('chatbox_content',$chats_menu . $chats_html);
      $xml->print_xml();
   }
   else
   {
      $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
      $xml->add_tag('chatbox_content', 'refresh_page');
      $xml->print_xml();
   }
}

/* Chatbox chat sending */
if ($_POST['do'] == 'ajax_chat')
{
   $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
   
   if (can_view_mgc_cb_evo() && can_use_mgc_cb_evo())
   {
      if ($vbulletin->option['mgc_cb_evo_whoisonline_active'])
      {
         $vbulletin->db->query_write("REPLACE INTO " . TABLE_PREFIX . "mgc_cb_evo_session SET userid='" . $vbulletin->userinfo['userid'] . "',dateline='" . TIMENOW . "'");
      }      
      
      /* Retrieval of the message */
      $chat = $vbulletin->input->clean_gpc('p', 'chat', TYPE_NOCLEAN);
      $channel_id = $vbulletin->input->clean_gpc('p', 'channel_id', TYPE_INT);
      $chat = convert_urlencoded_unicode($chat);

      /*** Message processing ***/
      $chat_datam = &datamanager_init('Mgccb_Chat', $vbulletin, ERRTYPE_ARRAY,'mgccbchat');
      $chat_datam->set_channelid($channel_id);
      $chat_datam->fetch_commands();
      $chat_datam->set_raw_chat($chat);
      $chat_datam->pre_save();

      /* The pre-save has returned an action, no need to go further */
      if (!empty($chat_datam->action))
      {
         $xml->add_tag('sendchat_result', $chat_datam->action);
      }
      else
      {
         $chat_datam->save();
         $xml->add_tag('sendchat_result',"chatbox_refresh('forced')");
      }
   }
   else
   {
      $xml->add_tag('sendchat_result','mgc_cb_evo_force_page_refresh()');
   }
   
   $xml->print_xml();
}

/* Chatbox chat editing retrieval */
if ($_POST['do'] == 'ajax_edit_getchat')
{
   $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
   
   if (can_view_mgc_cb_evo() && can_use_mgc_cb_evo())
   {
      $chatid = $vbulletin->input->clean_gpc('p', 'chatid', TYPE_INT);
      
      /* User can manage all chats */
      if (can_manage_mgc_cb_evo())
      {
         $chat = $vbulletin->db->query_first("SELECT chatid,text FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE chatid='$chatid'");
         
         /* Something retrieved ? */
         if ($chat)
         {
            $xml->add_tag('chat_content',$chat['text']);
         }
         else
         {
            $xml->add_tag('chat_content', '');
         }
      }
      else
      {
         if (can_manage_own_chats())
         {
            /* Let's check if user is the author */
            $chat = $vbulletin->db->query_first("SELECT chatid,text FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE chatid='$chatid' and fromuid='" . $vbulletin->userinfo['userid'] . "'");
            
            /* Something retrieved ? */
            if ($chat)
            {
               $xml->add_tag('chat_content',$chat['text']);
            }
            else
            {
               $xml->add_tag('chat_content', '');
            }      
         }
      }
   }
   else
   {
      $xml->add_tag('chat_content', '');
   }
   
   $xml->print_xml();   
}

/* Chatbox chat editing execution */
if ($_POST['do'] == 'ajax_save_edit')
{
   $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
   
   if (can_view_mgc_cb_evo() && can_use_mgc_cb_evo())
   {
      $vbulletin->input->clean_array_gpc('p', array('chat' => TYPE_NOCLEAN, 'chatid' => TYPE_UINT));

      $vbulletin->GPC['chat'] = convert_urlencoded_unicode($vbulletin->GPC['chat']);

      /* Forbidden actions */
      if ((empty($vbulletin->GPC['chat'])) || (trim($vbulletin->GPC['chat']) == ""))
      {
         $xml->add_tag('edit_result',"mgc_cb_js_showpopup('$vbphrase[mgc_cb_evo_edit_failed]'); chatbox_refresh('forced');");
      }
      else
      {
         /* User can manage all chats */
         if (can_manage_mgc_cb_evo())
         {
            $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_chat SET text='" . $vbulletin->db->escape_string(trim($vbulletin->GPC['chat'])) . "' WHERE chatid='" . $vbulletin->GPC['chatid'] . "'");
            
            $xml->add_tag('edit_result',"chatbox_refresh('forced');");
         }
         else
         {
            if (can_manage_own_chats())
            {
               /* Let's check if user is the author */
               $chat = $vbulletin->db->query_first("SELECT chatid,text FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE chatid='" . $vbulletin->GPC['chatid'] . "' and fromuid='" . $vbulletin->userinfo['userid'] . "'");
               
               if ($chat)
               {
                  $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_chat SET text='" . $vbulletin->db->escape_string(trim($vbulletin->GPC['chat'])) . "' WHERE chatid='" . $vbulletin->GPC['chatid'] . "'");
            
                  $xml->add_tag('edit_result',"chatbox_refresh('forced');");
               }
               else
               {
                  $xml->add_tag('edit_result',"mgc_cb_js_showpopup('$vbphrase[mgc_cb_evo_edit_forbidden]');");
               }         
            }
            else
            {
               $xml->add_tag('edit_result',"mgc_cb_js_showpopup('$vbphrase[mgc_cb_evo_edit_forbidden]');");
            }
         }
      }
   }
   
   $xml->print_xml();   
}

/* Chatbox channel statuses retrieving */
if ($_POST['do'] == 'ajax_check_messages')
{
   $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
   
   if (can_view_mgc_cb_evo() && can_use_mgc_cb_evo())
   {
      $channel_id = $vbulletin->input->clean_gpc('p', 'channel_id', TYPE_INT);
      
       /* Constructing the usergroupids REGEXP */
      $sql_condition = "co.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";

      if (!empty($vbulletin->userinfo['membergroupids']))
      {
         $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

         foreach ($ugipds_array as $index => $ugpid)
         {
            $sql_condition .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
         }
      }
      
      $sql_condition .= " OR co.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";     
      
      if ($channel_id)
      {
         $getchannelslastmessage = $vbulletin->db->query_read("
            SELECT MAX(dateline) AS cdate,chanid,primcid
            FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
            LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON ( c.primcid = co.cid ) 
            LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch ON ( co.cid = ch.cid )
            WHERE (($sql_condition) OR primcid='0') AND ((chanid<>'$channel_id' AND warnon='1')" . ($vbulletin->options['mgc_cb_evo_channels_warning_gen'] ? "OR chanid IS NULL" : "") . ")
            GROUP BY chanid
            ORDER BY dateline DESC
         ");
      }
      else
      {
         $getchannelslastmessage = $vbulletin->db->query_read("
            SELECT MAX(dateline) AS cdate,chanid,primcid
            FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
            LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON ( c.primcid = co.cid ) 
            LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch ON ( co.cid = ch.cid )
            WHERE (($sql_condition) OR primcid='0') AND (chanid<>'$channel_id' AND warnon='1')
            GROUP BY chanid
            ORDER BY dateline DESC
         ");         
      }
      
      $channel_activities = unserialize($vbulletin->userinfo['mgc_cb_evo_channel_activities']);
      
      $xml->add_group('channels_statuses');

      if ($vbulletin->db->num_rows($getchannelslastmessage))
      {         
         while ($channellastmessage = $vbulletin->db->fetch_array($getchannelslastmessage))
         {                    
            if (empty($channellastmessage['chanid']))
            {
               $channellastmessage['chanid'] = 0;
            }
                         
            if (array_key_exists($channellastmessage['chanid'],$channel_activities))
            {
               if ($channellastmessage['cdate'] > $channel_activities["$channellastmessage[chanid]"])
               {
                  $xml->add_tag('status', 1, array('chanid' => $channellastmessage['chanid']));
               }
               else
               {
                  $xml->add_tag('status', 0, array('chanid' => $channellastmessage['chanid']));
               }
            }
            else
            {
               $xml->add_tag('status', 1, array('chanid' => $channellastmessage['chanid']));
            }
         }
      }
      else
      {
         $xml->add_tag('status','none');
      }
      
      $xml->close_group();
   }
   
   $xml->print_xml();   
}
 
if ($_POST['do'] == 'ajax_get_online_users')
{
   $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
   
   if (can_view_mgc_cb_evo() && can_use_mgc_cb_evo())
   {     
      /* Inactive mode active and delay < session delay => inactive mode delay taken */
      if ($vbulletin->options['mgc_cb_evo_inactive_mode'] && $vbulletin->options['mgc_cb_evo_inactive_mode_delay'] < $vbulletin->options['mgc_cb_evo_whoisonline_delay'])
      {
         $dateline = TIMENOW - ($vbulletin->options['mgc_cb_evo_inactive_mode_delay'] * 60);
      }
      else
      {
         $dateline = TIMENOW - ($vbulletin->options['mgc_cb_evo_whoisonline_delay'] * 60);
      }
      
      $getusers = $vbulletin->db->query_read("
         SELECT DISTINCT u.username,u.displaygroupid,u.userid,s.userid AS suserid,
                        (u.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ") AS invisible
         FROM " . TABLE_PREFIX . "mgc_cb_evo_session AS cbs
         LEFT JOIN " . TABLE_PREFIX . "user AS u ON (cbs.userid=u.userid)
         LEFT JOIN " . TABLE_PREFIX . "session AS s ON (cbs.userid=s.userid)
         WHERE cbs.dateline>='$dateline' AND cbs.userid!=0      
      ");
      
      if ($vbulletin->db->num_rows($getusers))
      {
         $users_online['nb'] = 0;
         
         $first = 1;
         while ($user = $vbulletin->db->fetch_array($getusers))
         {         
      		if ($user['invisible'])
      		{
      			if (($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canseehidden']) OR $user['userid'] == $vbulletin->userinfo['userid'])
      			{
               	if ($user['suserid'])
               	{
                     $users_online['nb']++;
      				
                     if (!$first)
                     {
                        $users_online['list'] .= ', ';
                     }
                     else
                     {
                        $first = 0;
                     }
      				
                     $users_online['list'] .= '<a href="member.php?' . $session['sessionurl'] . 'u=' . $user['userid'] . '">' . fetch_musername($user,'displaygroupid') . '</a>*';
                  }
      			}
      		}
      		else
      		{
            	if ($user['suserid'])
            	{
                  $users_online['nb']++;
   				
                  if (!$first)
                  {
                     $users_online['list'] .= ', ';
                  }
                  else
                  {
                     $first = 0;
                  }
   				
                  $users_online['list'] .= '<a href="member.php?' . $session['sessionurl'] . 'u=' . $user['userid'] . '">' . fetch_musername($user,'displaygroupid') . '</a>';
               }
      		}                           
         }
         
         $xml->add_tag('online',$users_online['list'],array('nb' => $users_online['nb']));
      }
      else
      {
         $xml->add_tag('online',"",array('nb' => 0));
      }      
   }
   
   $xml->print_xml();   
}
      
      
/* Chatbox chat stickying */
if ($_POST['do'] == 'ajax_sticky_chat')
{
   $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
   
   if (can_manage_mgc_cb_evo())
   {
      $vbulletin->input->clean_array_gpc('p', array('status' => TYPE_UINT, 'chatid' => TYPE_UINT));
      
      /* Let's sticky or unsticky chat */
      $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_chat SET sticky='" . $vbulletin->GPC['status'] . "' WHERE chatid='" . $vbulletin->GPC['chatid'] . "'");
      
      if ($vbulletin->GPC['status'])
      {
			$xml->add_tag('stiky_result',"mgc_cb_js_showpopup('$vbphrase[mgc_cb_evo_chat_stickied]');");
		}
		else
		{
			$xml->add_tag('stiky_result',"mgc_cb_js_showpopup('$vbphrase[mgc_cb_evo_chat_unstickied]');");
		}
   }
   
   $xml->print_xml();   
}

?>