<?php

if (!class_exists('vB_DataManager'))
{
   exit;
}

class vB_DataManager_Mgccb_Chat extends vB_DataManager
{

   var $validfields = array(
      'chatid' => array(TYPE_UINT, REQ_INCR, VF_METHOD,'verify_nonzero'),
      'dateline' => array(TYPE_UINT, REQ_YES),
      'primcid' => array(TYPE_UINT, REQ_NO),
      'seccid' => array(TYPE_UINT, REQ_NO),
      'fromuid' => array(TYPE_UINT, REQ_YES),
      'touid' => array(TYPE_UINT, REQ_NO),
      'text' => array(TYPE_STR, REQ_YES,'VF_METHOD')
   );

   /* The raw chat */
   var $raw_chat = "";

   /* Commands arrays */
   var $nb_commands = 0;
   var $commands = array();
   var $commands_with_param_syntax = array();

   /* Channel id */
   var $channelid = 0;
   var $channelcid = 0;

   /* Action statuses */
   var $action = "";

   var $table = 'mgc_cb_evo_chat';

   var $mgc_cb_evo_chat = array();

   function vB_DataManager_Mgccb_Chat(&$registry, $errtype = ERRTYPE_STANDARD)
   {
      parent::vB_DataManager($registry, $errtype);
   }

   /* Channel id registration */
   function set_channelid(&$current_channelid)
   {
      $this->channelid = $current_channelid;
   }

   /* Commands retrieving from the database */
   function fetch_commands()
   {
      /* Constructing the usergroupids REGEXP */
      $sql_condition = "co.usergroupids REGEXP('^([0-9]+,)*" . $this->registry->
         userinfo['usergroupid'] . "(,[0-9]+)*$')";

      if (!empty($this->registry->userinfo['membergroupids']))
      {
         $ugipds_array = explode(',', $this->registry->userinfo['membergroupids']);

         foreach ($ugipds_array as $index => $ugpid)
         {
            $sql_condition .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid .
               "(,[0-9]+)*$')";
         }
      }

      $sql_condition .= " OR co.userids REGEXP('^([0-9]+,)*" . $this->registry->userinfo['userid'] . "(,[0-9]+)*$')";

      /* Retrieving the commands in the database */
      $getcommands = $this->registry->db->query_read("
			SELECT co.*,ch.chanid
			FROM " . TABLE_PREFIX . "mgc_cb_evo_command AS co
			LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch ON (co.cid = ch.cid)
			WHERE co.active='1' AND ($sql_condition)
		");

      if ($this->registry->db->num_rows($getcommands))
      {
         require_once (DIR . '/includes/class_mgc_cb_evo_cmd.php');

         while ($command = $this->registry->db->fetch_array($getcommands))
         {
            $this->nb_commands++;
            $this->commands["$command[cid]"] = new mgcCbEvo_command($command);

            /* Building of the commands with params */
            if ($this->commands["$command[cid]"]->with_parameters)
            {
               $this->commands_with_param_syntax[] = "/" . $command['syntax'];
            }

            /* If this is not general channel, register the channel command id (if found) */
            if ($this->channelid && $command['chanid'] == $this->channelid)
            {
               $this->channelcid = $command['cid'];
            }
         }
      }
   }

   /* Ah Ah Ah */
   function say_chat()
   {
      global $vbphrase;
      echo $this->chat_brut;
   }

   /* Raw chat registration */
   function set_raw_chat(&$sent_chat)
   {
      $this->raw_chat = &trim($sent_chat);
   }

   /* Commands registration (when not retrieved by the fetch_commands method) */
   function set_commands(&$commands)
   {
      $this->commands = &$commands;
   }

   /* Pre save chekings */
   function pre_save()
   {
      global $vbphrase;

      /* Check if the chat field was not empty ? */
      if (empty($this->raw_chat))
      {
         $this->construct_popup($vbphrase['mgc_cb_evo_enter_chat']);
         return;
      }
      
      /* Check if only bbcodes */
      $temp = strip_bbcode($this->raw_chat);
      if (empty($temp))
      {
         $this->construct_popup($vbphrase['mgc_cb_evo_enter_chat']);
         return;
      }
      
      /* Check if the user has entered only a command witouth parameters (for command with parameters) */
      if ($this->commands_with_param_syntax)
      {
         if (in_array($this->raw_chat, $this->commands_with_param_syntax))
         {
            $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
            return;
         }
      }

      $command_found = 0;
      $command_cid = 0;

      /* If the channel is not the general one and no command is entered */
      if ($this->channelid && substr($this->raw_chat,0,1) != "/")
      {
         /* User don't have access to the current channel command => Force refresh */
         if (!$this->channelcid)
         {
            $this->action = "mgc_cb_force_page_refresh()";
         }
		 
         $cmd_obj =& $this->commands["$this->channelcid"];
         $cid		= $this->channelcid;

         /* This channel command doesn't accept messages */
         if (!$cmd_obj->contains_message)
         {
            $this->construct_popup($vbphrase['mgc_cb_evo_msg_forbidden_in_channel']);
            return;
         }

         $command_found = 1;
         $command_cid = $this->channelcid;

         if (!empty($cmd_obj->phpcode_chats_sending))
         {
            eval($cmd_obj->phpcode_chats_sending);
         }
      }
      /* Searching for a command to parse if chat starts with / */
      else if (substr($this->raw_chat,0,1) == "/")
      {
         foreach ($this->commands as $cid => $cmd_obj)
         {
            /* The command is found */
            if (!$command_found && substr($this->raw_chat, 1, $cmd_obj->size) == $cmd_obj->
               syntax)
            {
               /* Remove the command identifier from the chat */
               $this->raw_chat = trim(substr($this->raw_chat, $cmd_obj->size + 1));

               /* If there is not chat entered => error */
               if (empty($this->raw_chat))
               {
                  $this->construct_popup($vbphrase['mgc_cb_evo_msg_missing']);
                  return;
               }
               
               if (!empty($cmd_obj->phpcode_chats_sending))
               {                  
                  eval($cmd_obj->phpcode_chats_sending);
               }

               $command_found = 1;
               $command_cid = $cid;
            }
         }
      }

      /* If the command wasn't found (general channel chat) or if the command can contain message */
      if (!$command_found || ($command_found && $this->commands["$command_cid"]->
         contains_message))
      {
         /* Maximum smileys allowed */
         require_once (DIR . '/includes/class_bbcode.php');
         $parser = &new vB_BbCodeParser($this->registry, $this->
            construct_bbcode_tag_list(true));
         $parsed_chat = $parser->do_parse($this->raw_chat, false, $this->registry->
            options['mgc_cb_evo_smileys'], $this->registry->options['mgc_cb_evo_bbcode'], false, false, false);

         if (substr_count($parsed_chat, "<img") > $this->registry->options['mgc_cb_evo_nbsmileys'])
         {
            /* Error */
            $this->construct_popup(construct_phrase($vbphrase['mgc_cb_evo_too_much_smileys'],
               $this->registry->options['mgc_cb_evo_nbsmileys']));
            return;
         }

         /* If URL BBCODE is authorized, we need to parse the url in the chat */
         if ($this->registry->options['mgc_cb_evo_bbcode_url'])
         {
            require_once (DIR . '/includes/functions_newpost.php');
            $this->raw_chat = convert_url_to_bbcode($this->raw_chat);
         }

         /* Add the user preferences to the raw chat if they are allowed in the command*/
         if (!$command_found || $this->commands["$command_cid"]->accepts_userpref)
         {
            $this->add_user_pref_to_raw_chat();
         }

         /* All checks have been passed, let's register everything before saving */
         if ($command_found)
         {
            $this->do_set('primcid', $command_cid);
         }
         else
         {
            $defaultcid = 0;
            $this->do_set('primcid', $defaultcid);
         }
         $timenow = TIMENOW;
         $this->do_set('dateline', $timenow);
         $this->do_set('fromuid', $this->registry->userinfo['userid']);
         $this->do_set('text', $this->raw_chat);
      }
   }

   function save()
   {
      $this->db_insert(TABLE_PREFIX, 'mgc_cb_evo_chat', true);
   }

   /* Popup message for UI display construction */
   function construct_popup($error_msg)
   {
      $this->action = "mgc_cb_js_showpopup('" . addslashes_js($error_msg) . "')";
   }

   /* Building of the allowed bbcode array for the parsing function */
   function construct_bbcode_tag_list($with_color)
   {
      $bbcode_list = array();

      if ($this->registry->options['mgc_cb_evo_bbcode'])
      {
         $bbcode_list['no_option']['b'] = array('html' => '<b>%1$s</b>', 'strip_empty' => true);

         $bbcode_list['no_option']['i'] = array('html' => '<i>%1$s</i>', 'strip_empty' => true);

         $bbcode_list['no_option']['u'] = array('html' => '<u>%1$s</u>', 'strip_empty' => true);

         if ($with_color)
         {
            $bbcode_list['option']['color'] = array('html' =>
               '<font color="%2$s">%1$s</font>', 'option_regex' => '#^\#?\w+$#', 'strip_empty' => true);
         }

         $bbcode_list['option']['size'] = array('html' => '<font size="%2$s">%1$s</font>',
            'option_regex' => '#^[0-9\+\-]+$#', 'strip_empty' => true);

         $bbcode_list['option']['font'] = array('html' => '<font face="%2$s">%1$s</font>',
            'option_regex' => '#^[^["`\':]+$#', 'strip_empty' => true);
      }

      if ($this->registry->options['mgc_cb_evo_bbcode_url'])
      {
         $bbcode_list['no_option']['url'] = array('callback' => 'handle_bbcode_url',
            'strip_empty' => true);

         $bbcode_list['option']['url'] = array('callback' => 'handle_bbcode_url',
            'strip_empty' => true);

      }

      return $bbcode_list;
   }

   /* Verifies that the given option can be selected by a user (ie. active in the acp) */
   function is_userpref_active($userpref_name)
   {
      switch ($userpref_name)
      {
         case "font":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 1;
            break;
         case "size":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 2;
            break;
         case "color":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 4;
            break;
         case "b":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 8;
            break;
         case "i":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 16;
            break;
         case "u":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 32;
            break;
      }
   }

   /* Add the user preferences to the raw chat */
   function add_user_pref_to_raw_chat()
   {
      $endchat = '';

      if ($this->registry->userinfo['mgc_cb_evo_u'] && $this->is_userpref_active("u"))
      {
         $this->raw_chat = '[U]' . $this->raw_chat;
         $endchat = $endchat . '[/U]';
      }

      if ($this->registry->userinfo['mgc_cb_evo_i'] && $this->is_userpref_active("i"))
      {
         $this->raw_chat = '[I]' . $this->raw_chat;
         $endchat = $endchat . '[/I]';
      }

      if ($this->registry->userinfo['mgc_cb_evo_b'] && $this->is_userpref_active("b"))
      {
         $this->raw_chat = '[B]' . $this->raw_chat;
         $endchat = $endchat . '[/B]';
      }

      if ($this->registry->userinfo['mgc_cb_evo_size'] && $this->is_userpref_active("size"))
      {
         if ($this->registry->userinfo['mgc_cb_evo_size'] <= $this->registry->options['mgc_cb_evo_max_bbcode_size'])
         {
            $this->raw_chat = '[size=' . $this->registry->userinfo['mgc_cb_evo_size'] . ']' .
               $this->raw_chat;
         }
         else
         {
            $this->raw_chat = '[size=' . $this->registry->options['mgc_cb_evo_max_bbcode_size'] .
               ']' . $this->raw_chat;
         }
         $endchat = $endchat . '[/size]';
      }

      /* User has selected a color */
      if ($this->registry->userinfo['mgc_cb_evo_color'] && $this->is_userpref_active("color"))
      {
         $this->raw_chat = '[color=#' . $this->registry->userinfo['mgc_cb_evo_color'] .
            ']' . $this->raw_chat;
         $endchat = $endchat . '[/color]';
      }
      /* Applies usergroup color if different from 000000 */
      else if(!empty($this->registry->userinfo['mgc_cb_evo_default_color']) && $this->registry->userinfo['mgc_cb_evo_default_color'] != "000000")
      {
         $this->raw_chat = '[color=#' . $this->registry->userinfo['mgc_cb_evo_default_color'] .
            ']' . $this->raw_chat;
         $endchat = $endchat . '[/color]';         
      }

      if ($this->registry->userinfo['mgc_cb_evo_font'] && $this->is_userpref_active("font"))
      {
         $this->raw_chat = '[font=' . $this->registry->userinfo['mgc_cb_evo_font'] . ']' .
            $this->raw_chat;
         $endchat = $endchat . '[/font]';
      }

      $this->raw_chat .= $endchat;
   }
}

?>