<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~ E_NOTICE);

@header('Content-type: text/html; charset=windows-1252');

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'mgc_cb_evo'); // change this depending on your filename
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('pm', 'banning');

// get special data templates from the datastore
$specialtemplates = array('bbcodecache','smiliecache');

// pre-cache templates used by all actions
$globaltemplates = array(
   'GENERIC_SHELL',
   'mgc_cb_evo_archives',
   'mgc_cb_evo_archives_chatbit',
   'mgc_chatbox_archives_nobit',
   'mgc_cb_evo_channel_button',
   'mgc_cb_evo',
   'mgc_cb_evo_editor',
   'mgc_cb_evo_chatbit',
   'mgc_cb_evo_chatbit_menu',
   'editor_jsoptions_font',
   'editor_jsoptions_size',
   'mgc_cb_evo_help',
   'mgc_cb_evo_help_bit',
   'mgc_cb_evo_smilies',
   'mgc_cb_evo_rules'   
);

// ######################### REQUIRE BACK-END ############################
require_once ('./global.php');
require_once (DIR . '/includes/functions_mgc_cb_evo.php');
require_once (DIR . '/includes/class_bbcode.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

/* Chatbox activÃ©e ?? */
if (!$vbulletin->options['mgc_cb_evo_active'])
{
   exit;
}

if (empty($_REQUEST['do']))
{
   if ($vbulletin->options['mgc_cb_evo_fullmode_active'])
   {
      $_REQUEST['do'] = "view_chatbox";
   }
   else
   {
      $_REQUEST['do'] = "view_archives";
   }
}

if ($_REQUEST['do'] == "view_archives")
{
   /* Can access to chatbox and archives */
   if (!(can_view_mgc_cb_evo() && can_view_mgc_cb_evo_archives()))
   {
      print_no_permission();
   }

   $channel_id = $vbulletin->input->clean_gpc('r', 'channel_id', TYPE_UINT);

   if (empty($channel_id))
   {
      $channel_id = 0;
   }
   else
   {
      /* Let's check if the channel exists */
      $checkchannel = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='$channel_id'");
      
      if (!$checkchannel)
      {
         eval(standard_error(fetch_error('mgc_cb_evo_archives_channel_error')));
      }
   }
   
   /* Construction of the user groupids array (member/ugp) */
   if (!empty($vbulletin->userinfo['membergroupids']))
   {
      $memberids = $vbulletin->userinfo['usergroupid'] . ',' . $vbulletin->userinfo['membergroupids'];
      $ugipds_array = explode(',',$memberids);
   }
   else
   {
      $ugipds_array = array($vbulletin->userinfo['usergroupid']);
   }
      
   $getcommands = $vbulletin->db->query_read("
      SELECT co.*,ch.chanid
      FROM " . TABLE_PREFIX . "mgc_cb_evo_command AS co
      LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch ON (co.cid=ch.cid)
      WHERE co.active='1' AND (ch.active='1' OR ch.chanid IS NULL)
   ");
   
   if ($vbulletin->db->num_rows($getcommands))
   {
      require_once (DIR . '/includes/class_mgc_cb_evo_cmd.php');

      while ($command = $vbulletin->db->fetch_array($getcommands))
      {
         /* Execution of the archives display phpcode */
         eval($command['phpcode_chatbox_ar_display']);          
         
         /* Store the command only if the user has access to the command */
         $hasaccess = false;
         
         if (!empty($command['usergroupids']))
         {
            $command_ugpids = explode(',',$command['usergroupids']);
            
            foreach($ugipds_array AS $index => $ugpid)
            {
               if (in_array($ugpid,$command_ugpids))
               {
                  $hasaccess = true;
               }   
            }   
         }
         
         if (!$hasaccess && !empty($command['userids']))
         {
            $command_userids = explode(',',$command['userids']);
            
            if (in_array($vbulletin->userinfo['userid'],$command_userids))
            {
               $hasaccess = true;
            }
         }
         
         if ($hasaccess)
         {
            $commands["$command[cid]"] = new mgcCbEvo_command($command);
   
            /* General channel */
            if (!$channel_id)
            {
               /* The command is not used in a channel and can be used in the general channel */
               if (!$command['chanid'] && $commands["$command[cid]"]->can_be_in_gen_channel && $commands["$command[cid]"]->contains_message)
               {
                  $cids_array[] = $command['cid'];
               }
            }
            else
            {
               /* The command of the current channel */
               if ($command['chanid'] == $channel_id)
               {
                  $channel_cid = $command['cid'];
               }
            }
   
            /* Js files include construction */
            if (!empty($command['js_file']))
            {
               $commands_js_includes .=
                  '<script type="text/javascript" src="clientscript/mgc_cb_evo_cmd/' . $command['js_file'] . '.js"></script>';
            }
         }
      }
   }
   
   unset($getcommands);

   /** Building the chats retrieving query **/

   /* The query parameters depending on the channel */
   $left_join = "";
   $additional_fields = "";

   if ($channel_id)
   {
		$where_clause = "primcid='$channel_cid'";
		
		if ($commands["$channel_cid"]->from_user_to_user)
		{
			$where_clause .= "AND (fromuid='" . $vbulletin->userinfo['userid'] . "' OR touid='" . $vbulletin->userinfo['userid'] . "')";
		}  
   }
   else
   {
      $where_clause = "primcid='0' ";
      if (is_array($cids_array))
      {
         $where_clause = "( " . $where_clause;
         $where_clause .= " OR ( primcid IN(" . implode(',', $cids_array) . ") AND (!(co.cmd_bitfield & 32) OR (fromuid='" . $vbulletin->userinfo['userid'] . "' OR touid='" . $vbulletin->userinfo['userid'] . "'))) )";
      }
   }
   
   /* The commands phpcode for chat retrievings */
   if (is_array($commands))
   {
      foreach ($commands as $cid => $cmd_obj)
      {
         /* Execution of the where clause if the command is not used in a channel */
         if (!$cmd_obj->chanid)
         {
            eval($cmd_obj->phpcode_chats_retrieving);
         }
      }
   }

   $perpage = $vbulletin->options['mgc_cb_evo_archives_nbchats_per_page'];
   $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);

   /* Count of the chats */
   $getnbchats = $vbulletin->db->query_first("
		SELECT COUNT(chatid) AS nbchats
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS fromu ON (c.fromuid=fromu.userid)
         LEFT JOIN " . TABLE_PREFIX . "user AS tou ON (c.touid=tou.userid)
         LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (c.primcid=co.cid)
		$left_join
		WHERE $where_clause
		ORDER BY c.dateline DESC
  ");     
  
   sanitize_pageresults($getnbchats['nbchats'], $pagenumber, $perpage, 100, 25);

   /* page min / page max */
   $limitlower = ($pagenumber - 1) * $perpage + 1;
   $limitupper = $pagenumber * $perpage;
   if ($limitupper > $getnbchats['nbchats'])
   {
      $limitupper = $getnbchats['nbchats'];
      if ($limitlower > $getnbchats['nbchats'])
      {
         $limitlower = $getnbchats['nbchats'] - $perpage;
      }
   }
   if ($limitlower <= 0)
   {
      $limitlower = 1;
   }

   $pagenav = construct_page_nav($pagenumber, $perpage, $getnbchats['nbchats'], $vbulletin->options['bburl'] . '/mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . 'do=view_archives');  
  
   /* Retrieving of the chats */
   $chats = $vbulletin->db->query_read("
		SELECT c.*,fromu.userid AS fromuserid,fromu.username AS fromusername,fromu.usergroupid AS fromusergroupid,fromu.displaygroupid AS fromdisplaygroupid,
               tou.userid AS touserid,tou.username AS tousername,tou.usergroupid AS tousergroupid,tou.displaygroupid AS todisplaygroupid
			   $additional_fields
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS fromu ON (c.fromuid=fromu.userid)
         LEFT JOIN " . TABLE_PREFIX . "user AS tou ON (c.touid=tou.userid)
         LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (c.primcid=co.cid)
		$left_join
		WHERE $where_clause
		ORDER BY c.dateline DESC
      LIMIT " . ($limitlower - 1) . ", $perpage
  ");

   if ($vbulletin->db->num_rows($chats))
   {
      $parsebbcode = $vbulletin->options['mgc_cb_evo_bbcode'] || $vbulletin->options['mgc_cb_evo_bbcode_url'] || $vbulletin->options['mgc_cb_evo_bbcode_img'];
      
      $alt = 2;
      
      /* Ascending */
      if ($vbulletin->options['mgc_cb_evo_archives_chats_order'])
      {
         $cpt = $nbchats - 1;
         while ($chat = $vbulletin->db->fetch_array($chats))
         {                           
            $chats_table["$cpt"] = fetch_chat_info($chat, $parsebbcode, $commands, $channel_id,$alt,1);
            $chats_menu_register .= "vbmenu_register('test_+ $chat[chatid]');";
            $cpt--;
            
            if ($vbulletin->options['mgc_cb_evo_alt_colors'])
            {
               if ($alt == 2)
               {
                  $alt = 1;
               }
               else
               {
                  $alt = 2;
               }
            }               
         }
         ksort($chats_table);
      }
      else
      {
         $cpt = 0;
         while ($chat = $vbulletin->db->fetch_array($chats))
         {
            $chats_table["$cpt"] = fetch_chat_info($chat, $parsebbcode, $commands, $channel_id,$alt,1);
            $cpt++;
            
            if ($vbulletin->options['mgc_cb_evo_alt_colors'])
            {
               if ($alt == 2)
               {
                  $alt = 1;
               }
               else
               {
                  $alt = 2;
               }
            }                 
         }                                    
      }
      
      foreach($chats_table AS $id => $chat)
      {
         $chatbit .= $chat;
      }
   }
   
   /* Stats */
   $mgc_cb_evo_stats['top_x']       = get_top_x(true);
   $mgc_cb_evo_stats['chats']       = get_number_of_chats();
   $mgc_cb_evo_stats['your_chats']  = get_user_number_of_chats();
   $mgc_cb_evo_stats['chats_24h']   = get_number_of_chats(true);

   /* Archive Type Select */
   /* Constructing the usergroupids REGEXP */
   $sql_condition = "( co.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";

   if (!empty($vbulletin->userinfo['membergroupids']))
   {
      $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

      foreach ($ugipds_array as $index => $ugpid)
      {
         $sql_condition .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
      }
   }
   
   $sql_condition .= " OR co.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$') )";
   
   $getchannels = $vbulletin->db->query_read("
      SELECT ch.chanid,ch.title,ch.img_name
      FROM " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch
      LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (ch.cid=co.cid)
      WHERE ch.active=1 AND $sql_condition      
   ");
   
   $show['mgc_cb_evo_archive_type_select'] = false;
      
   if ($vbulletin->db->num_rows($getchannels))
   {
      $show['mgc_cb_evo_archive_type_select'] = true; 
         
      if ($channel_id == -1)
      {  
         $navtext = $vbphrase['mgc_cb_evo_archives_main_channel'];
         $archive_selectbit = "<option value=\"0\" selected=\"selected\">$vbphrase[mgc_cb_evo_archives_main_channel]</option>";
      }
      else
      {
         $archive_selectbit = "<option value=\"0\">$vbphrase[mgc_cb_evo_archives_main_channel]</option>";
      }    
      while($channel = $vbulletin->db->fetch_array($getchannels))
      {
         if ($channel_id == $channel['chanid'])
         {       
            $navtext = construct_phrase($vbphrase['mgc_cb_evo_archives_of_x_channel'],$channel['title']);  
            $archive_selectbit .= "<option value=\"" . $channel['chanid'] . "\" selected=\"selected\">" . construct_phrase($vbphrase['mgc_cb_evo_archives_of_x_channel'],$channel['title']) . "</option>";
         }
         else
         {
            $archive_selectbit .= "<option value=\"" . $channel['chanid'] . "\">" . construct_phrase($vbphrase['mgc_cb_evo_archives_of_x_channel'],$channel['title']) . "</option>";
         }
      }
   }   

   /* Can download shouts permission */
   $show['archives_download'] = can_download_mgc_cb_evo_archives() && !empty($chatbit);
   
   /* Can manage chatbox permission */
   $show['delete_column'] = can_manage_mgc_cb_evo();

   eval('$HTML = "' . fetch_template('mgc_cb_evo_archives') . '";');

   $navbits = array();
   // change the line below to contain whatever you want to show in the navbar (title of your custom page)
   $navbits[$parent] = $vbulletin->options['mgc_cb_evo_title'] . (!empty($navtext) ? ' : ' . $navtext : '');

   $navbits = construct_navbits($navbits);
   eval('$navbar = "' . fetch_template('navbar') . '";');

   // change the line below to contain the name of the actual main output template used in your script
   eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
}

if ($_REQUEST['do'] == 'save_archives')
{
   if (!can_download_mgc_cb_evo_archives())
   {
      print_no_permission();
   }

   require_once (DIR . '/includes/functions_file.php');

   $format     = $vbulletin->input->clean_gpc('r', 'format', TYPE_NOHTML);   
   $channel_id = $vbulletin->input->clean_gpc('r', 'channel_id', TYPE_UINT);

   if (empty($channel_id))
   {
      $channel_id = 0;
   }

   if ($channel_id)
   {
      $sql_condition = "( co.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";
   
      if (!empty($vbulletin->userinfo['membergroupids']))
      {
         $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);
   
         foreach ($ugipds_array as $index => $ugpid)
         {
            $sql_condition .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
         }
      }
      
      $sql_condition .= " OR co.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$') )";
      
      $getchannel = $vbulletin->db->query_first("
         SELECT ch.*,co.cmd_bitfield 
         FROM " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch
         LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (ch.cid=co.cid)
         WHERE ch.active=1 AND $sql_condition      
      ");
      
      if (!$getchannel)
      {
         print_no_permission();
      }
      
   }

   if ($channel_id)
   {
      $where_clause = "primcid='$getchannel[cid]'";
      
		if ($getchannel['cmd_bitfield'] & 32)
		{
			$where_clause .= "AND (fromuid='" . $vbulletin->userinfo['userid'] . "' OR touid='" . $vbulletin->userinfo['userid'] . "')";
		}      
   }
   else
   {
      $where_clause = "primcid='0' ";
      if (is_array($cids_array))
      {
         $where_clause = "( " . $where_clause;
         $where_clause .= " OR ( primcid IN(" . implode(',', $cids_array) . ") AND (!(co.cmd_bitfield & 32) OR (fromuid='" . $vbulletin->userinfo['userid'] . "' OR touid='" . $vbulletin->userinfo['userid'] . "'))) )";
      }
   }

   /* Retrieving of the chats */
   $chats = $vbulletin->db->query_read("
		SELECT c.text,c.dateline,fromu.userid AS fromuserid,fromu.username AS fromusername,tou.userid AS touserid,tou.username AS tousername
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS fromu ON (c.fromuid=fromu.userid)
      LEFT JOIN " . TABLE_PREFIX . "user AS tou ON (c.touid=tou.userid)
      LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (c.primcid=co.cid)
		WHERE $where_clause
		ORDER BY c.dateline DESC
  ");

   /* Error : no chats to download */
   if (!$db->num_rows($chats))
   {
      eval(standard_error(fetch_error('mgc_cb_evo_nochats_to_download')));
   }
   
   if ($channel_id)
   {
      $channel_name = $getchannel['title'];
   }
   else
   {
      $channel_name = $vbphrase['mgc_cb_evo_archives_main_channel'];
   }

   switch ($vbulletin->GPC['format'])
   {
      case 'txt':
         $txt = "################################################################################\r\n";
         $txt .= "MGC Chatbox EVO DUMP - $channel_name\r\n";
         $txt .= $vbulletin->options['bbtitle'] . ';' . $vbulletin->options['bburl'] . "\r\n";
         $txt .= vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'],
            TIMENOW) . "\r\n";
         $txt .= "################################################################################\r\n\r\n";

         while ($chat = $vbulletin->db->fetch_array($chats))
         {
            $chat['text'] = fetch_censored_text($chat['text']);
            $txt .= "==========================================================\r\n";
            $txt .= vbdate($vbulletin->options['mgc_cb_evo_archives_format_date'], $chat['dateline'], false, false) . " - $chat[fromusername] : ";            
            $txt .= "$chat[text]\r\n";               
         }
         $txt .= "==========================================================\r\n";

         unset($chat);
         $vbulletin->db->free_result($getchats);

         // download the file
         file_download($txt, str_replace(array('\\', '/'), '-', "MGC_CHATBOX_EVO_DUMP_$channel_name-" .
            $vbulletin->userinfo['username'] . "-" . vbdate($vbulletin->options['dateformat'],
            TIMENOW) . '.txt'), 'text/plain');
         break;

      case 'csv':
         // column headers
         $csv = "$vbphrase[date],$vbphrase[username],$vbphrase[mgc_cb_evo_chats]\r\n";

         while ($chat = $vbulletin->db->fetch_array($chats))
         {
            $csv_chat['dateline'] = vbdate($vbulletin->options['mgc_cb_evo_archives_format_date'], $chat['dateline'], false, false);
            $csv_chat['username'] = $chat['fromusername'];                
            $csv_chat['text'] = fetch_censored_text($chat['text']);

            foreach ($csv_chat as $key => $val)
            {
               if (preg_match('/\,|"/siU', $val))
               {
                  $csv_chat["$key"] = '"' . str_replace('"', '""', $val) . '"';
               }
            }

            // output the message row
            $csv .= implode(',', $csv_chat) . "\r\n";
         }
         unset($chat);
         $vbulletin->db->free_result($getchats);

         // download the file
         file_download($csv, str_replace(array('\\', '/'), '-', "MGC_CHATBOX_EVO_DUMP_$channel_name-" .
            $vbulletin->userinfo['username'] . "-" . vbdate($vbulletin->options['dateformat'],
            TIMENOW) . '.csv'), 'text/x-csv');

         break;

      case 'xml':
         require_once (DIR . '/includes/class_xml.php');
         $xml = new vB_XML_Builder($vbulletin);

         $xml->add_group('mgc_cb_evo_chats');

         while ($chat = $vbulletin->db->fetch_array($chats))
         {
            $xml_chat['dateline'] = vbdate($vbulletin->options['mgc_cb_evo_archives_format_date'], $chat['dateline'], false, false);
            $xml_chat['user'] = $chat['fromusername'];
            $xml_chat['text'] = fetch_censored_text($chat['text']);

            $xml->add_group('mgc_chatbox_chat');
            foreach ($xml_chat as $key => $val)
            {
               $xml->add_tag($key, $val);
            }
            $xml->close_group();
         }

         unset($chat);
         $vbulletin->db->free_result($getchats);

         $xml->close_group();

         $doc = "<?xml version=\"1.0\" encoding=\"$stylevar[charset]\"?>\r\n\r\n";
         $doc .= "<!-- MGC CHATBOX EVO XML DUMP - $channel_name -->";
         $doc .= "<!-- " . $vbulletin->options['bbtitle'] . ';' . $vbulletin->options['bburl'] .
            " -->\r\n";
         $doc .= '<!-- ' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->
            options['timeformat'], TIMENOW) . " -->\r\n\r\n";

         $doc .= $xml->output();
         $xml = null;

         // download the file
         file_download($doc, str_replace(array('\\', '/'), '-', "MGC_CHATBOX_EVO_DUMP_$channel_name-" .
            $vbulletin->userinfo['username'] . "-" . vbdate($vbulletin->options['dateformat'],
            TIMENOW) . '.xml'), 'text/xml');

         break;

         // *****************************
         // unknown download format
      default:
         eval(standard_error(fetch_error('invalidid', $vbphrase['file_type'], $vbulletin->
            options['contactuslink'])));

   }

}

/* Chatbox display in full mode */
if ($_REQUEST['do'] == "view_chatbox")
{
   /* The user can't view the chatbox or full mode is not yet enabled ? */
   if (!can_view_mgc_cb_evo() || !$vbulletin->options['mgc_cb_evo_fullmode_active'])
   {
      print_no_permission();
   }

   $HTML = build_mgc_cb_evo_display($vbulletin->options['mgc_cb_evo_fullmode_height']);

   $navbits = array();
   // change the line below to contain whatever you want to show in the navbar (title of your custom page)
   $navbits[$parent] = $vbulletin->options['mgc_cb_evo_title'];

   $navbits = construct_navbits($navbits);
   eval('$navbar = "' . fetch_template('navbar') . '";');

   // change the line below to contain the name of the actual main output template used in your script
   eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
}

/* Help popup display */
if ($_REQUEST['do'] == "showhelp")
{
   if (!can_view_mgc_cb_evo() && !can_use_mgc_cb_evo())
   {
      print_no_permission();
   }
   
   /** Retrieving of the commands help phrases **/

   /* Constructing the usergroupids REGEXP */
   $sql_condition = "co.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";

   if (!empty($vbulletin->userinfo['membergroupids']))
   {
      $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

      foreach ($ugipds_array as $index => $ugpid)
      {
         $sql_condition .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
      }
   }
   
   $sql_condition .= " OR co.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";


   /* Retrieving the commands in the database */
   $getcommands = $vbulletin->db->query_read("
		SELECT co.syntax,co.helpphrase
		FROM " . TABLE_PREFIX . "mgc_cb_evo_command AS co
		WHERE co.active='1' AND ($sql_condition)
		ORDER BY syntax ASC
	");

   while ($command = $vbulletin->db->fetch_array($getcommands))
   {
      if(!empty($command['helpphrase']))
      {
         $helpphrase = $vbphrase["$command[helpphrase]"];
         eval('$customhelp .= "' . fetch_template('mgc_cb_evo_help_bit') . '";');
      }
   }
   
   
   eval('$HTML = "' . fetch_template('mgc_cb_evo_help') . '";');

   $header = '';
   $footer = '';
   eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
}

if ($_POST['do'] == 'inline_remove_chats')
{
   if (!can_manage_mgc_cb_evo())
   {
      print_no_permission();
   }
   
   $vbulletin->input->clean_array_gpc('p', array('delchat' => TYPE_ARRAY_STR));
   
   /* No chats to remove */
   if (!$vbulletin->GPC['delchat'])
   {
      eval(standard_error(fetch_error('mgc_cb_evo_archives_no_chat_to_del')));      
   }
   
   $chatids = implode(',',array_keys($vbulletin->GPC['delchat']));
   
   $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE chatid IN($chatids)");
   
   $vbulletin->url = 'mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . "do=view_archives";
	eval(print_standard_redirect('redirect_mgc_cb_evo_archives_chat_removed_successfully'));
}

/* All smilies window */
if ($_REQUEST['do'] == "showsmilies")
{
   if ((!can_view_mgc_cb_evo() && !can_use_mgc_cb_evo()) || !$vbulletin->options['mgc_cb_evo_smileys'])
   {
      print_no_permission();
   }   

   /* Retrieving smilies */
   $getsmilies = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "smilie ORDER BY displayorder ASC");
   
   if (!$vbulletin->db->num_rows($getsmilies))
   {
      print_no_permission();
   }
   
   $i = 0;
   
	while($smilie = $db->fetch_array($getsmilies))
   {
      if ($i == 0)
      {
         $smiliesbit .= "<tr>";
      }
      
      $smiliesbit .= "<td class=\"alt1\" align=\"center\"><a href=\"javascript:insert_smilie_from_window('$smilie[smilietext]')\"><img src=\"$smilie[smiliepath]\" alt=\"\" border=\"0\"></a></td>";
      
		$i++;
		
		if ($i == ($vbulletin->options['mgc_cb_evo_smilieswindow_numberof_column']))
      {
         $smiliesbit .= "</tr>";
			$i = 0;
		}
	}
	
	if ($i < ($vbulletin->options['mgc_cb_evo_smilieswindow_numberof_column']))
	{
      while($i < ($vbulletin->options['mgc_cb_evo_smilieswindow_numberof_column']))
      {
         $smiliesbit .= "<td class=\"alt1\"></td>";
         $i++;
      }
      $smiliesbit .= "</tr>";
   }
   
   eval('print_output("' . fetch_template('mgc_cb_evo_smilies') . '");');
}

/* Rules popup display */
if ($_REQUEST['do'] == "showrules")
{
   if ((!can_view_mgc_cb_evo() && !can_use_mgc_cb_evo()) || empty($vbulletin->options['mgc_cb_evo_rules']))
   {
      print_no_permission();
   } 
   
   eval('$HTML = "' . fetch_template('mgc_cb_evo_rules') . '";');

   $header = '';
   $footer = '';
   eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
}

?>