<?php

/*======================================================================*\
|| #################################################################### ||
|| # Toplist Hack - Version 2.0.0									  # ||
|| # For vBulletin 3.5.5											  # ||
|| # ---------------------------------------------------------------- # ||
|| # By Derek Ivey (derek@nbsdesignz.com)							  # ||
|| # This hack may not be redistributed without my written permission # ||
|| # Hack Copyright  2005-2006 Derek Ivey.							  # ||
|| # $Id: toplist_admin.php,v 1.17 2006/10/07 16:56:50 derek Exp $
|| #################################################################### ||
\*======================================================================*/

define('toplist_version', '2.0.0');

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: toplist_admin.php,v $ - $Revision: 1.17 $');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminsettings'))
{
	print_cp_no_permission();
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if ($_REQUEST['do'] == 'add' OR $_REQUEST['do'] == 'doadd')
{
	print_cp_header($vbphrase['toplist_add_site']);
}
else if ($_REQUEST['do'] == 'edit' OR $_REQUEST['do'] == 'doedit')
{
	print_cp_header($vbphrase['toplist_edit_site']);
}
else if ($_REQUEST['do'] == 'delete' OR $_REQUEST['do'] == 'dodelete')
{
	print_cp_header($vbphrase['toplist_delete_site']);
}
else if ($_REQUEST['do'] == 'inactive')
{
	print_cp_header($vbphrase['toplist_inactive_sites']);
}
else if ($_REQUEST['do'] == 'validate')
{
	print_cp_header($vbphrase['toplist_validate_sites']);
}
else if ($_REQUEST['do'] == 'suspended')
{
	print_cp_header($vbphrase['toplist_suspended_sites']);
}
else if ($_REQUEST['do'] == 'categories' OR $_REQUEST['do'] == 'docategoriesorder')
{
	print_cp_header($vbphrase['toplist_categories']);
}
else if ($_REQUEST['do'] == 'addcat' OR $_REQUEST['do'] == 'doaddcat')
{
	print_cp_header($vbphrase['toplist_add_category']);
}
else if ($_REQUEST['do'] == 'editcat' OR $_REQUEST['do'] == 'doeditcat')
{
	print_cp_header($vbphrase['toplist_edit_category']);
}
else if ($_REQUEST['do'] == 'deletecat' OR $_REQUEST['do'] == 'dodeletecat')
{
	print_cp_header($vbphrase['toplist_delete_category']);
}
else if ($_REQUEST['do'] == 'reset' OR $_REQUEST['do'] == 'doreset')
{
	print_cp_header($vbphrase['toplist_reset_toplist']);
}
else
{
	print_cp_header($vbphrase['toplist_sites']);
}

$inactive1 = "SELECT * FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'inactive'";
$inactive2 = $db->query_read($inactive1);
$inactive = $db->num_rows($inactive2);

if ($inactive >= 1 AND $vbulletin->options['toplist_moderate_sites'] == 1)
{	
	print_table_start();
	print_cells_row(array(construct_phrase($vbphrase['toplist_validate_message'], $inactive)), 0, 0, -5, 'top', 1, 1);
	print_table_footer(2, '', '', false);
	print '<br />';
}

$db->free_result($inactive2);

unset($inactive1, $inactive);

if ($vbulletin->options['toplist_ranking_method'] == 0)
{    
	$order = '`in`';
}
else if ($vbulletin->options['toplist_ranking_method'] == 1)
{
	$order = '`out`';
}
else if ($vbulletin->options['toplist_ranking_method'] == 2)
{
	$order = '`rating_average`';
}
else if ($vbulletin->options['toplist_ranking_method'] == 3)
{
	$order = '`views`';
}
else
{
	$order = '`in`';
}

// ############################### DOADD ##################################
if ($_REQUEST['do'] == 'doadd')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'username' => TYPE_NOHTML,
		'sitename' => TYPE_NOHTML,
		'url' => TYPE_NOHTML,
		'description' => TYPE_STR,
		'in' => TYPE_UINT,
		'out' => TYPE_UINT,
		'status' => TYPE_NOHTML,
		'category' => TYPE_UINT,
		'views' => TYPE_UINT,
		'added_code' => TYPE_BOOL
	));

	$vbulletin->input->clean_gpc('f', 'image', TYPE_FILE);

	if (!empty($vbulletin->GPC['image']['name']))
	{
		$image_name =& $vbulletin->GPC['image']['name'];
		$tmp_name =& $vbulletin->GPC['image']['tmp_name'];
		$image_size =& $vbulletin->GPC['image']['size'];
		$image_type =& $vbulletin->GPC['image']['type'];

		if ($image_type == "image/gif" OR $image_type == "image/pjpeg" OR $image_type == "image/jpeg" OR $image_type == "image/x-png")
		{
			$length = 20; 
			$key_chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'; 
			$rand_max = strlen($key_chars) - 1; 

			for ($i = 0; $i < $length; $i++) 
			{ 
				$rand_pos  = rand(0, $rand_max); 
				$rand_key[] = $key_chars{$rand_pos}; 
			} 

			$key = implode('', $rand_key);


			if (file_exists(DIR  . "/images/toplist/buttons/sites/" . $key))
			{
				// Generate another random string to add to the key.
				unset($length, $i, $rand_pos, $rand_key);
				
				$length = 5;

				for ($i = 0; $i < $length; $i++) 
				{ 
					$rand_pos  = rand(0, $rand_max); 
					$rand_key[] = $key_chars{$rand_pos}; 
				} 

				$key2 = implode('', $rand_key);
				
				@move_uploaded_file($tmp_name, DIR . "/images/toplist/buttons/sites/" . $key . $key2);
	
				$size = getimagesize(DIR . "images/toplist/buttons/sites/" . $key . $key2);
				$width = $size[0];
				$height = $size[1];
				
				unset($length, $key_chars, $rand_max, $i, $rand_pos, $rand_key, $size);
			}
			else
			{
				$key2 = '';
				
				@move_uploaded_file($tmp_name, DIR  . "/images/toplist/buttons/sites/" . $key);
		
				$size = getimagesize(DIR  . "/images/toplist/buttons/sites/" . $key);
				$width = $size[0];
				$height = $size[1];
				
				unset($length, $key_chars, $rand_max, $i, $rand_pos, $rand_key, $size);
			}
		}
		else
		{
			if ($image_type == '')
			{
				print_stop_message('error_toplist_image_size_too_big', $vbulletin->options['toplist_max_image_size']); 
			}
			else
			{
				print_stop_message('error_toplist_incorrect_image_format', $image_type);
			}
		}
	}

//------------------------------------------------------------
// Check to see that the image meets the size requirements.
//------------------------------------------------------------
	if ($width <= $vbulletin->options['toplist_max_width'] AND $height <= $vbulletin->options['toplist_max_height'])
	{

//------------------------------------------------------------
// Make the fields are filled in.
//------------------------------------------------------------
		if (!empty($vbulletin->GPC['sitename']) AND !empty($vbulletin->GPC['url']) AND !empty($vbulletin->GPC['description']))
		{

//------------------------------------------------------------
// Make Sure the URL Submitted is Valid.
//------------------------------------------------------------
			$check_url = substr($vbulletin->GPC['url'], 0, 7);
			
			if ($check_url == "http://")
			{

//------------------------------------------------------------
// Remove HTML Code if needed.
//------------------------------------------------------------
				if ($vbulletin->options['toplist_disable_html'] == 1)
				{
					$vbulletin->GPC['description'] = htmlspecialchars_uni($vbulletin->GPC['description']);
				}

//------------------------------------------------------------
// Add the site to the database if everything is ok.
//------------------------------------------------------------
				if ($vbulletin->options['toplist_check_if_code_exists'] == 1)
				{
					$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_sites SET
							`username` = '" . $db->escape_string($vbulletin->GPC['username']) . "',
							`name` = '" . $db->escape_string($vbulletin->GPC['sitename']) . "',
							`url` = '" . $db->escape_string($vbulletin->GPC['url']) . "',
							`description` = '" . $db->escape_string($vbulletin->GPC['description']) . "',
							`in` = '" . $db->escape_string($vbulletin->GPC['in']) . "',
							`out` = '" . $db->escape_string($vbulletin->GPC['out']) . "',
							`views` = '" . $db->escape_string($vbulletin->GPC['views']) . "',
							`status` = '" . $db->escape_string($vbulletin->GPC['status']) . "',
							`cid` = '" . $db->escape_string($vbulletin->GPC['category']) . "',
							`imagetype` = '" . $image_type . "',
							`imagesize` = '" . $image_size . "',
							`imagecode` = '" . $key . "',
							`imagecode2` = '" . $key2 . "',
							`added_code` = '" . $vbulletin->GPC['added_code'] . "'"; 
				}
				else
				{
					$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_sites SET
							`username` = '" . $db->escape_string($vbulletin->GPC['username']) . "',
							`name` = '" . $db->escape_string($vbulletin->GPC['sitename']) . "',
							`url` = '" . $db->escape_string($vbulletin->GPC['url']) . "',
							`description` = '" . $db->escape_string($vbulletin->GPC['description']) . "',
							`in` = '" . $db->escape_string($vbulletin->GPC['in']) . "',
							`out` = '" . $db->escape_string($vbulletin->GPC['out']) . "',
							`views` = '" . $db->escape_string($vbulletin->GPC['views']) . "',
							`status` = '" . $db->escape_string($vbulletin->GPC['status']) . "',
							`cid` = '" . $db->escape_string($vbulletin->GPC['category']) . "',
							`imagetype` = '" . $image_type . "',
							`imagesize` = '" . $image_size . "',
							`imagecode` = '" . $key . "',
							`imagecode2` = '" . $key2 . "',
							`added_code` = 1";
				}
				
				$sqlr = $db->query_write($sql);
				
				define('CP_REDIRECT', 'toplist_admin.php');
				print_stop_message('toplist_site_added_successfully');

//------------------------------------------------------------
// Show error message if URL is not Valid.
//------------------------------------------------------------
			}
			else
			{
				print_stop_message('error_toplist_url_not_valid');
			}
//------------------------------------------------------------
// Show error messages if certain fields aren't filled in.
//------------------------------------------------------------
		}
		else if (empty($vbulletin->GPC['sitename']) AND empty($vbulletin->GPC['url']) AND empty($vbulletin->GPC['description']))
		{
			print_stop_message('error_toplist_name_url_and_description_empty');
		}
		else if (empty($vbulletin->GPC['sitename']) AND empty($vbulletin->GPC['url']))
		{
			print_stop_message('error_toplist_name_and_url_empty');
		}
		else if (empty($vbulletin->GPC['sitename']) AND empty($vbulletin->GPC['description']))
		{
			print_stop_message('error_toplist_name_and_description_empty');
		}
		else if (empty($vbulletin->GPC['sitename']))
		{
			print_stop_message('error_toplist_name_empty');
		}
		else if (empty($vbulletin->GPC['url']) AND empty($vbulletin->GPC['description']))
		{
			print_stop_message('error_toplist_url_and_description_empty');
		}
		else if (empty($vbulletin->GPC['url']))
		{
			print_stop_message('error_toplist_url_empty');
		}
		else if (empty($vbulletin->GPC['description']))
		{
			print_stop_message('error_toplist_description_empty');
		}

//------------------------------------------------------------
// Show error messages if image doesn't meet the requirements.
//------------------------------------------------------------
	}
	else if ($width > $vbulletin->options['toplist_max_width'] AND $height > $vbulletin->options['toplist_max_height'])
	{
		@unlink(DIR  . "/images/toplist/buttons/sites/" . $key . $key2);
		
		print_stop_message('error_toplist_width_and_height_too_big');
	}
	else if ($width > $vbulletin->options['toplist_max_width'])
	{
		@unlink(DIR  . "/images/toplist/buttons/sites/" . $key . $key2);
		
		print_stop_message('error_toplist_width_too_big');
	}
	else if ($height > $vbulletin->options['toplist_max_height'])
	{
		@unlink(DIR  . "/images/toplist/buttons/sites/" . $key . $key2);
		
		print_stop_message('error_toplist_height_too_big');
	}

// ################################ ADD ###################################
}
else if ($_REQUEST['do'] == 'add')
{
	print_form_header('toplist_admin', 'doadd', 1);
	print_table_header($vbphrase['toplist_add_site'], 2);
	print_input_row($vbphrase['toplist_username'], 'username', $vbulletin->userinfo['username'], '', 35, '', '');
	print_input_row($vbphrase['toplist_site_name'], 'sitename', '', '', '', '', '');	
	print_input_row($vbphrase['toplist_site_url'], 'url', '', '', '50', '', '');
	print_input_row($vbphrase['toplist_description'], 'description', '', '', '50', '', '');	
	print_upload_row($vbphrase['toplist_site_image'], 'image', $vbulletin->options['toplist_max_image_size'], 50);
	print_input_row($vbphrase['toplist_in'], 'in', '0', '', 10, '', '');
	print_input_row($vbphrase['toplist_out'], 'out', '0', '', 10, '', '');
	print_input_row($vbphrase['toplist_views'], 'views', '0', '', 10, '', '');
	print_select_row($vbphrase['toplist_status'], 'status', array('active' => $vbphrase['toplist_active'], 'inactive' => $vbphrase['toplist_inactive'], 'suspended' => $vbphrase['toplist_suspended']), '', 0, 0, 0);
		
	$cat1 = "SELECT `id`, `name` FROM " . TABLE_PREFIX . "toplist_categories WHERE `displayorder` != 0 ORDER BY `displayorder` ASC";
	$cat2 = $db->query_read($cat1);
		
	$categories = array();
		
	while ($cat = $db->fetch_array($cat2))
	{
		$categories[$cat['id']] = $cat['name'];
	}
		
	$db->free_result($cat2);
		
	unset($cat1, $cat);
		
	print_select_row($vbphrase['toplist_category'], 'category', $categories, '', 0, 0, 0);
	
	if ($vbulletin->options['toplist_check_if_code_exists'] == 1)
	{
		print_yes_no_row($vbphrase['toplist_added_html_code_to_site'], 'added_code', 0);
	}
	
	print_submit_row($vbphrase['toplist_add'], $vbphrase['toplist_reset']);
	print_table_footer(2, '', '', false);

// ############################### DOEDIT #################################
}
else if ($_REQUEST['do'] == 'doedit')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'id' => TYPE_UINT,
		'username' => TYPE_NOHTML,
		'name' => TYPE_NOHTML,
		'url' => TYPE_NOHTML,
		'description' => TYPE_STR,
		'in' => TYPE_UINT,
		'out' => TYPE_UINT,
		'rating_total' => TYPE_UINT,
		'votes' => TYPE_UINT,
		'status' => TYPE_NOHTML,
		'category' => TYPE_UINT,
		'imagecode' => TYPE_NOHTML,
		'imagecode2' => TYPE_NOHTML,
		'views' => TYPE_UINT,
		'added_code' => TYPE_BOOL
	));

	$vbulletin->input->clean_gpc('f', 'image', TYPE_FILE);

	if ($vbulletin->GPC['id'] == 0)
	{
		print_stop_message('error_toplist_edit_site_error');
	}
	else
	{
		if ($vbulletin->GPC['rating_total'] >= 0 AND $vbulletin->GPC['votes'] >= 0)
		{
			if ($vbulletin->GPC['rating_total'] > 0 AND $vbulletin->GPC['votes'] >= 1)
			{
				$average = $vbulletin->GPC['rating_total'] / $vbulletin->GPC['votes'];
				$average = round($average);
			}

			if (!empty($vbulletin->GPC['image']['name']))
			{
				@unlink(DIR . "/images/toplist/buttons/sites/" . $vbulletin->GPC['imagecode'] . $vbulletin->GPC['imagecode2']);
				
				$image_name =& $vbulletin->GPC['image']['name'];
				$tmp_name =& $vbulletin->GPC['image']['tmp_name'];
				$image_size =& $vbulletin->GPC['image']['size'];
				$image_type =& $vbulletin->GPC['image']['type'];
			
				if ($image_type == "image/gif" OR $image_type == "image/pjpeg" OR $image_type == "image/jpeg" OR $image_type == "image/x-png")
				{
					$length = 20; 
					$key_chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'; 
					$rand_max = strlen($key_chars) - 1; 

					for ($i = 0; $i < $length; $i++) 
					{ 
						$rand_pos  = rand(0, $rand_max); 
						$rand_key[] = $key_chars{$rand_pos}; 
					} 

					$key = implode('', $rand_key);


					if (file_exists(DIR  . "/images/toplist/buttons/sites/" . $key))
					{
						// Generate another random string to add to the key.
						unset($length, $i, $rand_pos, $rand_key);
				
						$length = 5;

						for ($i = 0; $i < $length; $i++) 
						{ 
							$rand_pos  = rand(0, $rand_max); 
							$rand_key[] = $key_chars{$rand_pos}; 
						} 

						$key2 = implode('', $rand_key);
				
						@move_uploaded_file($tmp_name, DIR . "/images/toplist/buttons/sites/" . $key . $key2);
	
						$size = getimagesize(DIR . "images/toplist/buttons/sites/" . $key . $key2);
						$width = $size[0];
						$height = $size[1];
				
						unset($length, $key_chars, $rand_max, $i, $rand_pos, $rand_key, $size);
					}
					else
					{
						$key2 = '';
						
						@move_uploaded_file($tmp_name, DIR . "/images/toplist/buttons/sites/" . $key);
		
						$size = getimagesize(DIR . "/images/toplist/buttons/sites/" . $key);
						$width = $size[0];
						$height = $size[1];
						
						unset($length, $key_chars, $rand_max, $i, $rand_pos, $rand_key, $size);
					}
				}
				else
				{
					if ($image_type == '')
					{
						print_stop_message('error_toplist_image_size_too_big', $vbulletin->options['toplist_max_image_size']); 
					}
					else
					{
						print_stop_message('error_toplist_incorrect_image_format', $image_type);
					}
				}
			}

//------------------------------------------------------------
// Check to see that the image meets the size requirements.
//------------------------------------------------------------
			if ($width <= $vbulletin->options['toplist_max_width'] AND $height <= $vbulletin->options['toplist_max_height'])
			{

//------------------------------------------------------------
// Make Sure the fields are filled in.
//------------------------------------------------------------
				if (!empty($vbulletin->GPC['name']) AND !empty($vbulletin->GPC['url']) AND !empty($vbulletin->GPC['description']))
				{

//------------------------------------------------------------
// Make Sure the URL Submitted is Valid
//------------------------------------------------------------
					$check_url = substr($vbulletin->GPC['url'], 0, 7);
					
					if ($check_url == "http://")
					{

//------------------------------------------------------------
// Remove HTML Code if needed.
//------------------------------------------------------------
						if ($vbulletin->options['toplist_disable_html'] == 1)
						{
							$vbulletin->GPC['description'] = htmlspecialchars_uni($vbulletin->GPC['description']);
						}

//------------------------------------------------------------
// Update the site if everything is ok.
//------------------------------------------------------------
						if (!empty($vbulletin->GPC['image']['name']))
						{
							if ($vbulletin->options['toplist_check_if_code_exists'] == 1)
							{
								$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET
										`username` = '" . $db->escape_string($vbulletin->GPC['username']) . "',
										`name` = '" . $db->escape_string($vbulletin->GPC['name']) . "',
										`url` = '" . $db->escape_string($vbulletin->GPC['url']) . "',
										`description` = '" . $db->escape_string($vbulletin->GPC['description']) . "',
										`in` = '" . $db->escape_string($vbulletin->GPC['in']) . "',
										`out` = '" . $db->escape_string($vbulletin->GPC['out']) . "',
										`views` = '" . $db->escape_string($vbulletin->GPC['views']) . "',
										`rating_total` = '" . $db->escape_string($vbulletin->GPC['rating_total']) . "',
										`rating_average` = '" . $db->escape_string($average) . "',
										`votes` = '" . $db->escape_string($vbulletin->GPC['votes']) . "',
										`status` = '" . $db->escape_string($vbulletin->GPC['status']) . "',
										`cid` = '" . $db->escape_string($vbulletin->GPC['category']) . "',
										`imagetype` = '" . $image_type . "',
										`imagesize` = '" . $image_size . "',
										`imagecode` = '" . $key . "',
										`imagecode2` = '" . $key2 . "',
										`added_code` = '" . $db->escape_string($vbulletin->GPC['added_code']) . "'
										WHERE `id` = '" . $vbulletin->GPC['id'] . "'"; 
							}
							else
							{
								$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET
										`username` = '" . $db->escape_string($vbulletin->GPC['username']) . "',
										`name` = '" . $db->escape_string($vbulletin->GPC['name']) . "',
										`url` = '" . $db->escape_string($vbulletin->GPC['url']) . "',
										`description` = '" . $db->escape_string($vbulletin->GPC['description']) . "',
										`in` = '" . $db->escape_string($vbulletin->GPC['in']) . "',
										`out` = '" . $db->escape_string($vbulletin->GPC['out']) . "',
										`views` = '" . $db->escape_string($vbulletin->GPC['views']) . "',
										`rating_total` = '" . $db->escape_string($vbulletin->GPC['rating_total']) . "',
										`rating_average` = '" . $db->escape_string($average) . "',
										`votes` = '" . $db->escape_string($vbulletin->GPC['votes']) . "',
										`status` = '" . $db->escape_string($vbulletin->GPC['status']) . "',
										`cid` = '" . $db->escape_string($vbulletin->GPC['category']) . "',
										`imagetype` = '" . $image_type . "',
										`imagesize` = '" . $image_size . "',
										`imagecode` = '" . $key . "',
										`imagecode2` = '" . $key2 . "',
										`added_code` = 1
										WHERE `id` = '" . $vbulletin->GPC['id'] . "'";
							}
						}
						else
						{
							if ($vbulletin->options['toplist_check_if_code_exists'] == 1)
							{
								$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET
										`username` = '" . $db->escape_string($vbulletin->GPC['username']) . "',
										`name` = '" . $db->escape_string($vbulletin->GPC['name']) . "',
										`url` = '" . $db->escape_string($vbulletin->GPC['url']) . "',
										`description` = '" . $db->escape_string($vbulletin->GPC['description']) . "',
										`in` = '" . $db->escape_string($vbulletin->GPC['in']) . "',
										`out` = '" . $db->escape_string($vbulletin->GPC['out']) . "',
										`views` = '" . $db->escape_string($vbulletin->GPC['views']) . "',
										`rating_total` = '" . $db->escape_string($vbulletin->GPC['rating_total']) . "',
										`rating_average` = '" . $db->escape_string($average) . "',
										`votes` = '" . $db->escape_string($vbulletin->GPC['votes']) . "',
										`status` = '" . $db->escape_string($vbulletin->GPC['status']) . "',
										`cid` = '" . $db->escape_string($vbulletin->GPC['category']) . "',
										`added_code` = '" . $db->escape_string($vbulletin->GPC['added_code']) . "'
										WHERE `id` = '" . $vbulletin->GPC['id'] . "'";
							}
							else
							{
								$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET
										`username` = '" . $db->escape_string($vbulletin->GPC['username']) . "',
										`name` = '" . $db->escape_string($vbulletin->GPC['name']) . "',
										`url` = '" . $db->escape_string($vbulletin->GPC['url']) . "',
										`description` = '" . $db->escape_string($vbulletin->GPC['description']) . "',
										`in` = '" . $db->escape_string($vbulletin->GPC['in']) . "',
										`out` = '" . $db->escape_string($vbulletin->GPC['out']) . "',
										`views` = '" . $db->escape_string($vbulletin->GPC['views']) . "',
										`rating_total` = '" . $db->escape_string($vbulletin->GPC['rating_total']) . "',
										`rating_average` = '" . $db->escape_string($average) . "',
										`votes` = '" . $db->escape_string($vbulletin->GPC['votes']) . "',
										`status` = '" . $db->escape_string($vbulletin->GPC['status']) . "',
										`cid` = '" . $db->escape_string($vbulletin->GPC['category']) . "',
										`added_code` = 1
										WHERE `id` = '" . $vbulletin->GPC['id'] . "'";
							}
						}
						
						$sqlr = $db->query_write($sql);
						
						define('CP_REDIRECT', 'toplist_admin.php');
						print_stop_message('toplist_site_edited_successfully');

//------------------------------------------------------------
// Show error message if URL is not Valid.
//------------------------------------------------------------
					}
					else
					{
						print_stop_message('error_toplist_url_not_valid');
					}
//------------------------------------------------------------
// Show error messages if certain fields aren't filled in.
//------------------------------------------------------------
				}
				else if (empty($vbulletin->GPC['sitename']) AND empty($vbulletin->GPC['url']) AND empty($vbulletin->GPC['description']))
				{
					print_stop_message('error_toplist_name_url_and_description_empty');
				}
				else if (empty($vbulletin->GPC['sitename']) AND empty($vbulletin->GPC['url']))
				{
					print_stop_message('error_toplist_name_and_url_empty');
				}
				else if (empty($vbulletin->GPC['sitename']) AND empty($vbulletin->GPC['description']))
				{
					print_stop_message('error_toplist_name_and_description_empty');
				}
				else if (empty($vbulletin->GPC['sitename']))
				{
					print_stop_message('error_toplist_name_empty');
				}
				else if (empty($vbulletin->GPC['url']) AND empty($vbulletin->GPC['description']))
				{
					print_stop_message('error_toplist_url_and_description_empty');
				}
				else if (empty($vbulletin->GPC['url']))
				{
					print_stop_message('error_toplist_url_empty');
				}
				else if (empty($vbulletin->GPC['description']))
				{
					print_stop_message('error_toplist_description_empty');
				}

//------------------------------------------------------------
// Show error messages if image doesn't meet the requirements.
//------------------------------------------------------------
			}
			else if ($width > $vbulletin->options['toplist_max_width'] AND $height > $vbulletin->options['toplist_max_height'])
			{
				@unlink(DIR  . "/images/toplist/buttons/sites/" . $key . $key2);
		
				print_stop_message('error_toplist_width_and_height_too_big');
			}
			else if ($width > $vbulletin->options['toplist_max_width'])
			{
				@unlink(DIR  . "/images/toplist/buttons/sites/" . $key . $key2);
		
				print_stop_message('error_toplist_width_too_big');
			}
			else if ($height > $vbulletin->options['toplist_max_height'])
			{
				@unlink(DIR  . "/images/toplist/buttons/sites/" . $key . $key2);
		
				print_stop_message('error_toplist_height_too_big');
			}
		}
		else
		{
			print_stop_message('error_toplist_rating_edit_error');
		}
	}

// ################################ EDIT ##################################
}
else if ($_REQUEST['do'] == 'edit')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);

	if ($id == '')
	{
		print_stop_message('error_toplist_edit_site_error');
	}
	else
	{
		$sql = "SELECT `imagecode`, `imagecode2`, `id`, `username`, `name`, `url`, `description`, `in`, `out`, `views`, `rating_total`, `rating_average`, `votes`, `status`, `cid`, `added_code` FROM " . TABLE_PREFIX . "toplist_sites WHERE `id` = '" . $id . "'";
		$sqlr = $db->query_read($sql);
		$sr = $db->fetch_array($sqlr);

		print_form_header('toplist_admin', 'doedit', 1);
		print_table_header($vbphrase['toplist_edit_site'], 2);
		construct_hidden_code('imagecode', $sr['imagecode']);
		construct_hidden_code('imagecode2', $sr['imagecode2']);
		print_label_row($vbphrase['toplist_site_id'], '<input type="text" name="id" value="' . $id . '" readonly="readonly" size="2" class="bginput" />', '', 'top', '');
		print_input_row($vbphrase['toplist_username'], 'username', $sr['username'], '', '35', '', '');
		print_input_row($vbphrase['toplist_site_name'], 'name', $sr['name'], '', '', '', '');	
		print_input_row($vbphrase['toplist_site_url'], 'url', $sr['url'], '', '50', '', '');
		print_input_row($vbphrase['toplist_description'], 'description', $sr['description'], '', '50', '', '');
		print_upload_row($vbphrase['toplist_site_image'], 'image', $vbulletin->options['toplist_max_image_size'], 50);
		
		if ($sr['imagecode'] != '')
		{
			$image = '<img src="' . $vbulletin->options['bburl'] . '/toplist_image.php?do=view&amp;id=' . $sr['id'] . '" />';
		}
		else
		{
			$image = $vbphrase['toplist_none'];
		}
		
		print_label_row($vbphrase['toplist_button'], $image, '', 'top', '');
		print_input_row($vbphrase['toplist_in'], 'in', $sr['in'], '', 10, '', '');
		print_input_row($vbphrase['toplist_out'], 'out', $sr['out'], '', 10, '', '');
		print_input_row($vbphrase['toplist_views'], 'views', $sr['views'], '', 10, '', '');
		print_input_row($vbphrase['toplist_rating_total'], 'rating_total', $sr['rating_total'], '', 10, '', '');
		print_label_row($vbphrase['toplist_rating_average'], '<input type="text" name="rating_average" value="' . $sr['rating_average'] . '" readonly="readonly" size="10" class="bginput" />', '', 'top', '');
		print_input_row($vbphrase['toplist_votes'], 'votes', $sr['votes'], '', 10, '', '');		
		print_select_row($vbphrase['toplist_status'], 'status', array('suspended' => $vbphrase['toplist_suspended'], 'inactive' => $vbphrase['toplist_inactive'], 'active' => $vbphrase['toplist_active']), $sr['status'], 0, 0, 0);
		
		$cat1 = "SELECT `id`, `name` FROM " . TABLE_PREFIX . "toplist_categories WHERE `displayorder` != 0 ORDER BY `displayorder` ASC";
		$cat2 = $db->query_read($cat1);
		
		$categories = array();
		
		while ($cat = $db->fetch_array($cat2))
		{
			$categories[$cat['id']] = $cat['name'];
		}
		
		$db->free_result($cat2);
		
		unset($cat1, $cat, $image);
		
		print_select_row($vbphrase['toplist_category'], 'category', $categories, $sr['cid'], 0, 0, 0);
		print_yes_no_row($vbphrase['toplist_added_html_code_to_site'], 'added_code', $sr['added_code']);
		print_submit_row($vbphrase['toplist_edit'], $vbphrase['toplist_reset']);
		print_table_footer(2, '', '', false);
	}

// ############################## DODELETE ################################
}
else if ($_REQUEST['do'] == 'dodelete')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	
	if ($id == 0)
	{
		print_stop_message('error_toplist_delete_site_error');
	}
	else
	{
		$sql = "SELECT `imagecode`, `imagecode2` FROM " . TABLE_PREFIX . "toplist_sites WHERE `id` = '" . $vbulletin->GPC['id'] . "' LIMIT 1";
		$sqlr = $db->query_read($sql);
		$sr = $db->fetch_array($sqlr);

		if ($sr['imagecode'] != '')
		{
			@unlink(DIR . "/images/toplist/buttons/sites/" . $sr['imagecode'] . $sr['imagecode2']);
		}

		$sql = "DELETE FROM " . TABLE_PREFIX . "toplist_clicks WHERE `site_id` = '" . $db->escape_string($id) . "'";
		$db->query_write($sql);
		
		$sql = "DELETE FROM " . TABLE_PREFIX . "toplist_sites WHERE `id` = '" . $db->escape_string($id) . "'";
		$db->query_write($sql);
		
		define('CP_REDIRECT', 'toplist_admin.php');
		print_stop_message('toplist_delete_successful');
	}

// ############################### DELETE #################################
}
else if ($_REQUEST['do'] == 'delete')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);

	if ($id == 0)
	{
		print_stop_message('error_toplist_delete_site_error');
	}
	else
	{
		print_table_start();
		print_table_header($vbphrase['toplist_delete_site_confirmation'], 1);
		print_description_row("<a href = './toplist_admin.php?do=dodelete&id=" . $id . "'>" . $vbphrase['toplist_yes'] . "</a> &nbsp; <a href = './toplist_admin.php'>" . $vbphrase['toplist_no'] . "</a>", false, 1, '', 'center');
		print_table_footer(2, '', '', false);
	}

// ############################## INACTIVE ################################
}
else if ($_REQUEST['do'] == 'inactive')
{
	$sql = "SELECT `imagecode`, `url`, `id`, `name`, `username` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'inactive' ORDER BY `id` ASC";
	$sqlr = $db->query_read($sql);

	print_form_header('toplist_admin', 'validate');
	print_table_header($vbphrase['toplist_inactive_sites'], 4);
	print_cells_row(array('<b>' . $vbphrase['toplist_site_name'] . '</b>', '<b>' . $vbphrase['toplist_button'] . '</b>', '<b>' . $vbphrase['toplist_username'] . '</b>', '<input type="checkbox" name="allbox" id="checkall_all" title="Check / Uncheck All" onclick="js_check_all(this.form)" />&nbsp;<b>' . $vbphrase['toplist_validate'] . '</b>'), 0, 0, -5, 'top', 1, 1);
	
	while ($sr = $db->fetch_array($sqlr))
	{
		if ($sr['imagecode'] != '')
		{
			$image = '<a href="' . $sr['url'] . '" target="_blank"><img src="' . $vbulletin->options['bburl'] . '/toplist_image.php?do=view&amp;id=' . $sr['id'] . '" border="0"></a>';
		}
		else
		{
			$image = $vbphrase['toplist_none'];
		}
		
		print_cells_row(array('<a href="' . $sr['url'] . '" target="_blank">' . $sr['name'] . '</a>', $image, '<a href="' . $vbulletin->options['bburl'] . '/member.php?username = ' . $sr['username'] . '">' . $sr['username'] . '</a>', '<input type="checkbox" name="validate[]" value="' . $sr['id'] . '" />'), 0, 0, -5, 'top', 1, 1);
	}
	
	print_submit_row($vbphrase['toplist_validate_sites_submit'], $vbphrase['reset'], 4);	
	print_table_footer(2, '', '', false);

// ################################ VALIDATE ##############################
}
else if ($_REQUEST['do'] == 'validate')
{
	$vbulletin->input->clean_gpc('p', 'validate', TYPE_ARRAY);

	if (!empty($vbulletin->GPC['validate']))
	{
		foreach ($vbulletin->GPC['validate'] AS $id)
		{
			$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET `status` = 'active' WHERE `id` = '" . $db->escape_string($id) . "'";
			$db->query_write($sql);
		}
		
		define('CP_REDIRECT', 'toplist_admin.php');
		print_stop_message('toplist_site_validated_successfully');
	}
	else
	{
		print_stop_message('error_toplist_validate_error');
	}	 

// ################################ SUSPENDED #############################
}
else if ($_REQUEST['do'] == 'suspended')
{
	$sql = "SELECT `imagecode`, `url`, `id`, `name`, `username` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'suspended' ORDER BY `id` ASC";
	$sqlr = $db->query_read($sql);

	print_form_header('toplist_admin', 'unsuspend');
	print_table_header($vbphrase['toplist_suspended_sites'], 4);
	print_cells_row(array('<b>' . $vbphrase['toplist_site_name'] . '</b>', '<b>' . $vbphrase['toplist_button'] . '</b>', '<b>' . $vbphrase['toplist_username'] . '</b>', '<input type="checkbox" name="allbox" id="checkall_all" title="Check / Uncheck All" onclick="js_check_all(this.form)" />&nbsp;<b>' . $vbphrase['toplist_unsuspend'] . '</b>'), 0, 0, -5, 'top', 1, 1);
	
	while ($sr = $db->fetch_array($sqlr))
	{
		if ($sr['imagecode'] != '')
		{
			$image = '<a href="' . $sr['url'] . '" target="_blank"><img src="' . $vbulletin->options['bburl'] . '/toplist_image.php?do=view&amp;id=' . $sr['id'] . '" border="0"></a>';
		}
		else
		{
			$image = $vbphrase['toplist_none'];
		}
		
		print_cells_row(array('<a href="' . $sr['url'] . '" target="_blank">' . $sr['name'] . '</a>', $image, '<a href="' . $vbulletin->options['bburl'] . '/member.php?username = ' . $sr['username'] . '">' . $sr['username'] . '</a>', '<input type="checkbox" name="unsuspend[]" value="' . $sr['id'] . '" />'), 0, 0, -5, 'top', 1, 1);
	}
		
	print_submit_row($vbphrase['toplist_unsuspend_sites_submit'], $vbphrase['reset'], 4);
	print_table_footer(2, '', '', false);

// ################################ UNSUSPEND #############################
}
else if ($_REQUEST['do'] == 'unsuspend')
{
	$vbulletin->input->clean_gpc('p', 'unsuspend', TYPE_ARRAY);

	if (!empty($vbulletin->GPC['unsuspend']))
	{
		foreach ($vbulletin->GPC['unsuspend'] AS $id)
		{
			$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET `status` = 'active' WHERE `id` = '" . $db->escape_string($id) . "'";
			$db->query_write($sql);
		}
		
		define('CP_REDIRECT', 'toplist_admin.php');
		print_stop_message('toplist_site_unsuspended_successfully');
	}
	else
	{
		print_stop_message('error_toplist_unsuspend_error');
	}

// ############################# MASSDELETE ###############################
}
else if ($_REQUEST['do'] == 'massdelete')
{
	$sql = "SELECT `imagecode`, `url`, `id`, `name`, `username` FROM " . TABLE_PREFIX . "toplist_sites ORDER BY `id` ASC";
	$sqlr = $db->query_read($sql);

	print_form_header('toplist_admin', 'domassdelete');
	print_table_header($vbphrase['toplist_mass_delete_sites'], 4);
	print_cells_row(array('<b>' . $vbphrase['toplist_site_name'] . '</b>', '<b>' . $vbphrase['toplist_button'] . '</b>', '<b>' . $vbphrase['toplist_username'] . '</b>', '<input type="checkbox" name="allbox" id="checkall_all" title="Check / Uncheck All" onclick="js_check_all(this.form)" />&nbsp;<b>' . $vbphrase['toplist_delete'] . '</b>'), 0, 0, -5, 'top', 1, 1);
	
	while ($sr = $db->fetch_array($sqlr))
	{
		if ($sr['imagecode'] != '')
		{
			$image = '<a href="' . $sr['url'] . '" target="_blank"><img src="' . $vbulletin->options['bburl'] . '/toplist_image.php?do=view&amp;id=' . $sr['id'] . '" border="0"></a>';
		}
		else
		{
			$image = $vbphrase['toplist_none'];
		}
		
		print_cells_row(array('<a href="' . $sr['url'] . '" target="_blank">' . $sr['name'] . '</a>', $image, '<a href="' . $vbulletin->options['bburl'] . '/member.php?username = ' . $sr['username'] . '">' . $sr['username'] . '</a>', '<input type="checkbox" name="delete[]" value="' . $sr['id'] . '" />'), 0, 0, -5, 'top', 1, 1);
	}
		
	print_submit_row($vbphrase['toplist_delete_sites_submit'], $vbphrase['reset'], 4);
	print_table_footer(2, '', '', false);

// ############################ DOMASSDELETE ##############################
}
else if ($_REQUEST['do'] == 'domassdelete')
{
	$vbulletin->input->clean_gpc('p', 'delete', TYPE_ARRAY);

	if (!empty($vbulletin->GPC['delete']))
	{
		foreach ($vbulletin->GPC['delete'] AS $id)
		{
			$sql = "SELECT `imagecode`, `imagecode2` FROM " . TABLE_PREFIX . "toplist_sites WHERE id = '" . $db->escape_string($id) . "' LIMIT 1";
			$sqlr = $db->query_read($sql);
			$sr = $db->fetch_array($sqlr);

			if ($sr['imagecode'] != '')
			{
				@unlink(DIR . "/images/toplist/buttons/sites/" . $sr['imagecode'] . $sr['imagecode2']);
			}
				
			$sql = "DELETE FROM " . TABLE_PREFIX . "toplist_sites WHERE `id` = '" . $db->escape_string($id) . "'";
			$db->query_write($sql);
		}
		
		define('CP_REDIRECT', 'toplist_admin.php');
		print_stop_message('toplist_delete_successful');
	}
	else
	{
		print_stop_message('error_toplist_delete_site_error');
	}

// ############################## SUSPEND #################################
}
else if ($_REQUEST['do'] == 'suspend')
{
	$sql = "SELECT `imagecode`, `url`, `id`, `name`, `username` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' ORDER BY `id` ASC";
	$sqlr = $db->query_read($sql);

	print_form_header('toplist_admin', 'dosuspend');
	print_table_header($vbphrase['toplist_suspend_sites'], 4);
	print_cells_row(array('<b>' . $vbphrase['toplist_site_name'] . '</b>', '<b>' . $vbphrase['toplist_button'] . '</b>', '<b>' . $vbphrase['toplist_username'] . '</b>', '<input type="checkbox" name="allbox" id="checkall_all" title="Check / Uncheck All" onclick="js_check_all(this.form)" />&nbsp;<b>' . $vbphrase['toplist_suspend'] . '</b>'), 0, 0, -5, 'top', 1, 1);
	
	while ($sr = $db->fetch_array($sqlr))
	{
		if ($sr['imagecode'] != '')
		{
			$image = '<a href="' . $sr['url'] . '" target="_blank"><img src="' . $vbulletin->options['bburl'] . '/toplist_image.php?do=view&amp;id=' . $sr['id'] . '" border="0"></a>';
		}
		else
		{
			$image = $vbphrase['toplist_none'];
		}
		print_cells_row(array('<a href="' . $sr['url'] . '" target="_blank">' . $sr['name'] . '</a>', $image, '<a href="' . $vbulletin->options['bburl'] . '/member.php?username = ' . $sr['username'] . '">' . $sr['username'] . '</a>', '<input type="checkbox" name="suspend[]" value="' . $sr['id'] . '" />'), 0, 0, -5, 'top', 1, 1);
	}	
	print_submit_row($vbphrase['toplist_suspend_sites_submit'], $vbphrase['reset'], 4);
	print_table_footer(2, '', '', false);

// ############################## DOSUSPEND ###############################
}
else if ($_REQUEST['do'] == 'dosuspend')
{
	$vbulletin->input->clean_gpc('p', 'suspend', TYPE_ARRAY);

	if (!empty($vbulletin->GPC['suspend']))
	{
		foreach ($vbulletin->GPC['suspend'] AS $id)
		{
			$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET `status` = 'suspended' WHERE `id` = '" . $db->escape_string($id) . "'";
			$db->query_write($sql);
		}
		
		define('CP_REDIRECT', 'toplist_admin.php');
		print_stop_message('toplist_suspend_successful');
	}
	else
	{
		print_stop_message('error_toplist_suspend_site_error');
	}

// ############################### VIEWVOTES ##############################
}
else if ($_REQUEST['do'] == 'viewvotes')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);

	$sql = "SELECT `username`, `rating` FROM " . TABLE_PREFIX . "toplist_ratings WHERE `site_id` = '" . $db->escape_string($id) . "'";
	$sqlr = $db->query_read($sql);

	print_table_start();
	print_table_header($vbphrase['toplist_votes'] . '&nbsp;(' . $vbphrase['toplist_id'] . ':&nbsp;' . $id . ')', 2);
	print_cells_row(array('<b>' . $vbphrase['toplist_username'] . '</b>', '<b>' . $vbphrase['toplist_rating'] . '</b>'), 0, 0, -5, 'top', 1, 1);
	
	while ($sr = $db->fetch_array($sqlr))
	{
		print_cells_row(array('<a href="' . $vbulletin->options['bburl'] . '/member.php?username = ' . $sr['username'] . '" target="_blank">' . $sr['username'] . '</a>', $sr['rating'] . '&nbsp;&nbsp;<img src="' . $vbulletin->options['bburl'] . '/images/rating/toplist_rating_' . $sr['rating'] . '.gif">'), 0, 0, -5, 'top', 1, 1);
	}
	
	print_table_footer(2, '', '', false);

// ########################### DOCATEGORIESORDER ##########################
}
else if ($_REQUEST['do'] == 'docategoriesorder')
{
	$vbulletin->input->clean_gpc('p', 'displayorder', TYPE_ARRAY);

	if (is_array($vbulletin->GPC['displayorder']))
	{
		$categories = $db->query_read("SELECT `id` FROM " . TABLE_PREFIX . "toplist_categories");
		
		while ($category = $db->fetch_array($categories))
		{
			if (!isset($vbulletin->GPC['displayorder'][$category['id']]))
			{
				continue;
			}

			$displayorder = intval($vbulletin->GPC['displayorder'][$category['id']]);
			
			$sql = "UPDATE " . TABLE_PREFIX . "toplist_categories SET `displayorder` = '" . $displayorder . "' WHERE `id` = '" . $db->escape_string($category['id']) . "'";
			$db->query_write($sql);
		}
		
		define('CP_REDIRECT', 'toplist_admin.php?do=categories');
		print_stop_message('toplist_display_order_updated_successfully');
	}

// ############################### CATEGORIES #############################
}
else if ($_REQUEST['do'] == 'categories')
{
	$sql = "SELECT `id`, `displayorder`, `name` FROM " . TABLE_PREFIX . "toplist_categories";
	$sqlr = $db->query_read($sql);

	print_form_header('toplist_admin', 'docategoriesorder');
	print_table_header($vbphrase['toplist_categories'], 5);
	print_cells_row(array('<b>' . $vbphrase['toplist_id'] . '</b>', '<b>' . $vbphrase['toplist_display_order'] . '</b>', '<b>' . $vbphrase['toplist_name'] . '</b>', '<b>' . $vbphrase['toplist_edit'] . '</b>', '<b>' . $vbphrase['toplist_delete'] . '</b>'), 0, 0, -5, 'top', 1, 1);
	
	while ($sr = $db->fetch_array($sqlr))
	{
		print_cells_row(array($sr['id'], '<input type="text" name="displayorder[' . $sr['id'] . ']" value="' . $sr['displayorder'] . '" size="10" class="bginput" />', '<a href="' . $vbulletin->options['bburl'] . '/toplist.php?cid=' . $sr['id'] . '" target="_blank">' . $sr['name'] . '</a>', '<a href="toplist_admin.php?do=editcat&amp;id=' . $sr['id'] . '">' . $vbphrase['toplist_edit'] . '</a>', '<a href="toplist_admin.php?do=deletecat&amp;id=' . $sr['id'] . '">' . $vbphrase['toplist_delete'] . '</a>'), 0, 0, -5, 'top', 1, 1);
	}
	
	print_submit_row($vbphrase['toplist_save_display_order'], $vbphrase['toplist_reset'], 5);
	print_table_footer(2, '', '', false);
	
	print '<center><a href="toplist_admin.php?do=addcat">' . $vbphrase['toplist_add_category'] . '</a></center>';

// ############################## DOADDCAT ################################
}
else if ($_REQUEST['do'] == 'doaddcat')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'name' => TYPE_NOHTML,
		'displayorder' => TYPE_UINT
	));

	if (!empty($vbulletin->GPC['name']) AND !empty($vbulletin->GPC['displayorder']))
	{
		$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_categories SET
				`name` = '" . $db->escape_string($vbulletin->GPC['name']) . "',
				`displayorder` = '" . $db->escape_string($vbulletin->GPC['displayorder']) . "'";
		$db->query_write($sql);
		
		define('CP_REDIRECT', 'toplist_admin.php?do=categories');
		print_stop_message('toplist_category_added_successfully');
	}
	else
	{
		if (empty($vbulletin->GPC['name']) AND empty($vbulletin->GPC['displayorder']))
		{
			print_stop_message('error_toplist_category_name_and_displayorder_empty');
		}
		else if (empty($vbulletin->GPC['name']))
		{
			print_stop_message('error_toplist_category_name_empty');
		}
		else
		{
			print_stop_message('error_toplist_category_displayorder_empty');
		}
	}

// ############################### ADDCAT #################################
}
else if ($_REQUEST['do'] == 'addcat')
{
	print_form_header('toplist_admin', 'doaddcat');
	print_table_header($vbphrase['toplist_add_category'], 2);
	print_input_row($vbphrase['toplist_category_name'], 'name', '', '', '50', '', '');
	
	$sql = "SELECT `displayorder` FROM " . TABLE_PREFIX . "toplist_categories ORDER BY `displayorder` DESC LIMIT 1";
	$sqlr = $db->query_read($sql);
	$sr = $db->fetch_array($sqlr);
	
	$displayorder = $sr['displayorder'] + 1;
	
	print_input_row($vbphrase['toplist_display_order'], 'displayorder', $displayorder, '', 10, '', '');
	print_submit_row($vbphrase['toplist_add_category'], $vbphrase['toplist_reset']);
	print_table_footer(2, '', '', false);

// ############################## DOEDITCAT ################################
}
else if ($_REQUEST['do'] == 'doeditcat')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'id' => TYPE_UINT,
		'name' => TYPE_STR,
		'displayorder' => TYPE_UINT
	));

	$sql = "UPDATE " . TABLE_PREFIX . "toplist_categories SET
			`name` = '" . $db->escape_string($vbulletin->GPC['name']) . "',
			`displayorder` = '" . $db->escape_string($vbulletin->GPC['displayorder']) . "'
			WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "'";
	$db->query_write($sql);
	
	define('CP_REDIRECT', 'toplist_admin.php?do=categories');
	print_stop_message('toplist_category_edited_successfully');

// ############################### EDITCAT #################################
}
else if ($_REQUEST['do'] == 'editcat')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);

	if ($id == 0)
	{
		print_stop_message('error_toplist_edit_category_error');
	}
	else
	{
		$sql = "SELECT `name`, `displayorder` FROM " . TABLE_PREFIX . "toplist_categories WHERE `id` = '" . $db->escape_string($id) . "' LIMIT 1";
		$sqlr = $db->query_read($sql);
		$sr = $db->fetch_array($sqlr);
		
		print_form_header('toplist_admin', 'doeditcat');
		print_table_header($vbphrase['toplist_edit_category'], 2);
		construct_hidden_code('id', $id);
		print_input_row($vbphrase['toplist_category_name'], 'name', $sr['name'], '', '50', '', '');
		print_input_row($vbphrase['toplist_display_order'], 'displayorder', $sr['displayorder'], '', 10, '', '');
		print_submit_row($vbphrase['toplist_edit_category'], $vbphrase['toplist_reset']);
		print_table_footer(2, '', '', false);
	}

// ############################ DODELETECAT ###############################
}
else if ($_REQUEST['do'] == 'dodeletecat')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);

	if ($id == 0)
	{
		print_stop_message('error_toplist_delete_category_error');
	}
	else
	{
		$sql = "DELETE FROM " . TABLE_PREFIX . "toplist_categories WHERE `id` = '" . $db->escape_string($id) . "'";
		$db->query_write($sql);
		
		$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET `cid` = '0' WHERE `cid` = '" . $db->escape_string($id) . "'";
		$db->query_write($sql);
		
		define('CP_REDIRECT', 'toplist_admin.php?do=categories');
		print_stop_message('toplist_category_deleted_successfully');
	}

// ############################# DELETECAT ################################
}
else if ($_REQUEST['do'] == 'deletecat')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);

	if ($id == 0)
	{
		print_stop_message('error_toplist_delete_category_error');
	}
	else
	{
		print_table_start();
		print_table_header($vbphrase['toplist_delete_category_confirmation'], 1);
		print_description_row('<a href="./toplist_admin.php?do=dodeletecat&id=' . $id . '">' . $vbphrase['toplist_yes'] . '</a> &nbsp; <a href="./toplist_admin.php?do=categories">' . $vbphrase['toplist_no'] . '</a>', false, 1, '', 'center');
		print_table_footer(2, '', '', false);
	}
	
// ############################ DELETEREPORTS #############################
}
else if ($_REQUEST['do'] == 'deletereports')
{
	$vbulletin->input->clean_gpc('p', 'delete', TYPE_ARRAY);

	if (!empty($vbulletin->GPC['delete']))
	{
		foreach ($vbulletin->GPC['delete'] AS $id)
		{
			$sql = "DELETE FROM " . TABLE_PREFIX . "toplist_reports WHERE `id` = '" . $db->escape_string($id) . "'";
			$db->query_write($sql);
		}
		
		define('CP_REDIRECT', 'toplist_admin.php?do=reports');
		print_stop_message('toplist_reports_deleted_successfully');
	}
	else
	{
		print_stop_message('error_toplist_report_delete_error');
	}

// ############################### REPORTS ################################
}
else if ($_REQUEST['do'] == 'reports')
{
	$sql = "SELECT `id`, `sid`, `userid`, `username`, `ipaddress`, `reason` FROM " . TABLE_PREFIX . "toplist_reports ORDER BY `id` DESC";
	$sqlr = $db->query_read($sql);
	
	print_form_header('toplist_admin', 'deletereports');
	print_table_header($vbphrase['toplist_reported_sites'], 6);
	print_cells_row(array('<b>' . $vbphrase['toplist_id'] . '</b>', '<b>' . $vbphrase['toplist_sid'] . '</b>', '<b>' . $vbphrase['toplist_reporter'] . '</b>', '<b>' . $vbphrase['toplist_ip_address'] . '</b>', '<b>' . $vbphrase['toplist_reason'] . '</b>', '<input type="checkbox" name="allbox" id="checkall_all" title="' . $vbphrase['check_uncheck_all'] . '" onclick="js_check_all(this.form)" />&nbsp;<b>' . $vbphrase['toplist_delete'] . '</b>'), 0, 0, -5, 'top', 1, 1);
	
	while ($sr = $db->fetch_array($sqlr))
	{
		print_cells_row(array($sr['id'], $sr['sid'], '<a href="' . $vbulletin->options['bburl'] . '/member.php?u=' . $sr['userid'] . '" target="_blank">' . $sr['username'] . '</a>', $sr['ipaddress'], $sr['reason'], '<input type="checkbox" name="delete[]" value="' . $sr['id'] . '" />'), 0, 0, -5, 'top', 1, 1);
	}
	
	print_submit_row($vbphrase['toplist_delete'], $vbphrase['reset'], 6);
	print_table_footer(2, '', '', false);
	

// ############################### DORESET ################################
}
else if ($_REQUEST['do'] == 'doreset')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'in' => TYPE_BOOL,
		'out' => TYPE_BOOL,
		'views' => TYPE_BOOL,
		'rating' => TYPE_BOOL,
	));
	
	if ($vbulletin->GPC['in'] OR $vbulletin->GPC['out'] OR $vbulletin->GPC['views'] OR $vbulletin->GPC['rating'])
	{
		if ($vbulletin->GPC['in'])
		{
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "toplist_clicks WHERE `type` = 'in'");
			
			$db->query_write("UPDATE " . TABLE_PREFIX . "toplist_sites SET `in` = 0");
		}
	
		if ($vbulletin->GPC['out'])
		{
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "toplist_clicks WHERE `type` = 'out'");
			
			$db->query_write("UPDATE " . TABLE_PREFIX . "toplist_sites SET `out` = 0");
		}
	
		if ($vbulletin->GPC['views'])
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "toplist_sites SET `views` = 0");
		}
	
		if ($vbulletin->GPC['rating'])
		{
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "toplist_ratings");
			
			$db->query_write("UPDATE " . TABLE_PREFIX . "toplist_sites SET `rating_total` = 0, `votes` = 0, `rating_average` = 0");
		}
			
		/*$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET
				`in` = 0,
				`out` = 0,
				`rating_total` = 0,
				`votes` = 0,
				`rating_average` = 0,
				`views` = 0";
		$db->query_write($sql);*/
	
		build_datastore('toplist_reset', TIMENOW);
	
		define('CP_REDIRECT', 'toplist_admin.php');
		print_stop_message('toplist_reset_successfully');
	}
	else
	{
		print_stop_message('toplist_reset_failed');
	}

// ################################ RESET #################################
}
else if ($_REQUEST['do'] == 'reset')
{
	print_form_header('toplist_admin', 'doreset', 1);
	print_table_header($vbphrase['toplist_reset_toplist'], 2);
	print_description_row($vbphrase['toplist_reset_toplist_message'], false, 2, '', 'center');
	print_yes_no_row($vbphrase['toplist_reset_in_hits'], 'in', 1);
	print_yes_no_row($vbphrase['toplist_reset_out_hits'], 'out', 1);
	print_yes_no_row($vbphrase['toplist_reset_views'], 'views', 1);
	print_yes_no_row($vbphrase['toplist_reset_rating'], 'rating', 0);
	print_submit_row($vbphrase['toplist_reset']);
	print_table_footer(2, '', '', false);

// ################################ MAIN ##################################
}
else
{
	$sql = "SELECT `imagecode`, `added_code`, `url`, `id`, `name`, `username`, `in`, `out`, `views`, `rating_total`, `rating_average`, `votes`, `status`, `cid` FROM " . TABLE_PREFIX . "toplist_sites ORDER BY " . $order . " DESC, `id` ASC";
	$sqlr = $db->query_read($sql);

	print_table_start();
	print_table_header($vbphrase['toplist_sites'], 16);
	print_cells_row(array('<b>' . $vbphrase['toplist_rank'] . '</b>', '<b>' . $vbphrase['toplist_site_name'] . '</b>', '<b>' . $vbphrase['toplist_button'] . '</b>', '<b>' . $vbphrase['toplist_username'] . '</b>', '<b>' . $vbphrase['toplist_in'] . '</b>', '<b>' . $vbphrase['toplist_out'] . '</b>', '<b>' . $vbphrase['toplist_views'] . '</b>', '<b>' . $vbphrase['toplist_rating_total'] . '</b>', '<b>' . $vbphrase['toplist_rating_average'] . '</b>', '<b>' . $vbphrase['toplist_votes'] . '</b>', '<b>' . $vbphrase['toplist_status'] . '</b>', '<b>' . $vbphrase['toplist_added_code'] . '</b>', '<b>' . $vbphrase['toplist_cid'] . '</b>', '<b>' . $vbphrase['toplist_view_votes'] . '</b>', '<b>' . $vbphrase['toplist_edit'] . '</b>', '<b>' . $vbphrase['toplist_delete'] . '</b>'), 0, 0, -5, 'top', 1, 1);
	
	$rank = 1;
	
	while ($sr = $db->fetch_array($sqlr))
	{
		if ($sr['imagecode'] != '')
		{
			$image = '<a href="' . $sr['url'] . '" target="_blank"><img src="' . $vbulletin->options['bburl'] . '/toplist_image.php?do=view&amp;id=' . $sr['id'] . '" border="0"></a>';
		}
		else
		{
			$image = $vbphrase['toplist_none'];
		}
		
		if ($sr['added_code'] == 1)
		{
			$added_code = $vbphrase['yes'];
		}
		else
		{
			$added_code = $vbphrase['no'];
		}
		
		print_cells_row(array($rank, '<a href="' . $sr['url'] . '" target="_blank">' . $sr['name'] . '</a>', $image, '<a href="' . $vbulletin->options['bburl'] . '/member.php?username=' . $sr['username'] . '">' . $sr['username'] . '</a>', $sr['in'], $sr['out'], $sr['views'], $sr['rating_total'], $sr['rating_average'], $sr['votes'], $sr['status'], $added_code, $sr['cid'], '<a href="toplist_admin.php?do=viewvotes&id=' . $sr['id'] . '">' . $vbphrase['toplist_view'] . '</a>', '<a href="toplist_admin.php?do=edit&id=' . $sr['id'] . '">' . $vbphrase['toplist_edit'] . '</a>', '<a href="toplist_admin.php?do=delete&id=' . $sr['id'] . '">' . $vbphrase['toplist_delete'] . '</a>'), 0, 0, -5, 'top', 1, 1);
		
		$rank ++;
	}
		
	print_table_footer(2, '', '', false);
}

print_cp_footer();

?>