<?php
 
/*======================================================================*\
|| #################################################################### ||
|| # Toplist Hack - Version 2.0.0									  # ||
|| # For vBulletin 3.5.5											  # ||
|| # ---------------------------------------------------------------- # ||
|| # By Derek Ivey (derek@nbsdesignz.com)							  # ||
|| # This hack may not be redistributed without my written permission # ||
|| # Hack Copyright  2005-2006 Derek Ivey.							  # ||
|| # $Id: toplist_external.php,v 1.2 2006/10/07 16:56:45 derek Exp $
|| #################################################################### ||
\*======================================================================*/
 
// ####################### SET PHP ENVIRONMENT ########################### 
error_reporting(E_ALL & ~E_NOTICE); 
 
// #################### DEFINE IMPORTANT CONSTANTS ####################### 
define('THIS_SCRIPT', 'toplist_external');
define('toplist_version', '2.0.0');
 
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();
 
// pre-cache templates used by all actions
$globaltemplates = array(); 

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################ 
require_once('./global.php'); 
 
// ####################################################################### 
// ######################## START MAIN SCRIPT ############################ 
// #######################################################################

$vbulletin->input->clean_array_gpc('r', array(
	'type' => TYPE_STR,
	'cid' => TYPE_UINT,
	'orderby' => TYPE_STR,
	'limit' => TYPE_UINT,
));

$vbulletin->GPC['type'] = strtoupper($vbulletin->GPC['type']);

if ($vbulletin->GPC['orderby'] == 'in')
{
	$orderby = '`in`';
}
else if ($vbulletin->GPC['orderby'] == 'out')
{
	$orderby = '`out`';
}
else if ($vbulletin->GPC['orderby'] == 'rating')
{
	$orderby = '`rating_average`';
}
else if ($vbulletin->GPC['orderby'] == 'views')
{
	$orderby = '`views`';
}
else
{
	$orderby = '`in`';
}

if ($vbulletin->GPC['type'] == 'XML' AND $vbulletin->GPC['cid'])
{
	$ranks = array();
	
	$ranks1 = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites ORDER BY '" . $orderby . "' DESC";
	$ranks2 = $db->query_read($ranks1);
	
	$i = 1;
	
	while ($ranks3 = $db->fetch_array($ranks2))
	{
		$ranks[$ranks3['id']] = $i;
		
		$i++;	
	}
	
	$db->free_result($ranks2);
	
	unset($ranks1, $i, $ranks3);	
}

$sites1 = "SELECT toplist_sites.id, toplist_sites.dateline, toplist_sites.name, toplist_sites.url, toplist_sites.description, toplist_sites.username, toplist_sites.in, toplist_sites.out, toplist_sites.rating_average, toplist_sites.votes, toplist_categories.name AS categoryname
		   FROM " . TABLE_PREFIX . "toplist_sites AS toplist_sites
		   LEFT JOIN " . TABLE_PREFIX . "toplist_categories AS toplist_categories ON (toplist_sites.cid = toplist_categories.id)
		   " . iif ($vbulletin->GPC['cid'] != 0, "WHERE toplist_sites.cid = '" . $db->escape_string($vbulletin->GPC['cid']) . "'") . "
		   ORDER BY '" . $orderby . "' DESC " . iif ($vbulletin->GPC['limit'] != 0, "LIMIT " . $vbulletin->GPC['limit']);

if ($vbulletin->GPC['type'] == 'XML')
{
	// set XML type and nocache headers
	header('Content-Type: text/xml');
	header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	header('Pragma: public');
	
	// print out the page header
	echo '<?xml version="1.0" encoding="' . $stylevar['charset'] . '"?>' . "\r\n";
	echo "<sites>\r\n\r\n";
	echo "\t<url>" . $vbulletin->options['bburl'] . "/toplist.php" . iif ($vbulletin->GPC['cid'], "?cid=" . $vbulletin->GPC['cid']) . "</url>\r\n\r\n";
	
	// fetch sites
	$sites2 = $db->query_read($sites1);
	
	if ($vbulletin->GPC['cid'] == 0)
	{
		$rank = 1;
	}
	
	// list returned sites
	while ($site = $db->fetch_array($sites2))
	{
		echo "\t<site id=\"{$site['id']}\">\r\n";
		
		if ($vbulletin->GPC['cid'] == 0)
		{
			echo "\t\t<rank>{$rank}</rank>\r\n";
		}
		else
		{
			echo "\t\t<rank>" . $ranks[$site['id']] . "</rank>\r\n";
		}
		
		echo "\t\t<name><![CDATA[{$site['name']}]]></name>\r\n";		
		echo "\t\t<url><![CDATA[{$site['url']}]]></url>\r\n";		
		echo "\t\t<description><![CDATA[{$site['description']}]]></description>\r\n";
		echo "\t\t<username><![CDATA[{$site['username']}]]></username>\r\n";
		echo "\t\t<in>{$site['in']}</in>\r\n";
		echo "\t\t<out>{$site['out']}</out>\r\n";
		echo "\t\t<rating>{$site['rating_average']}</rating>\r\n";
		echo "\t\t<votes>{$site['votes']}</votes>\r\n";
		echo "\t\t<category><![CDATA[{$site['categoryname']}]]></category>\r\n";
		
		echo "\t</site>\r\n";
		
		if ($vbulletin->GPC['cid'] == 0)
		{
			$rank++;
		}
	}
	
	echo "\r\n</sites>";
}
else if (in_array($vbulletin->GPC['type'], array('RSS', 'RSS1', 'RSS2')))
{
	$rsstitle = htmlspecialchars_uni($vbulletin->options['bbtitle']);
	$rsstitle .= ' ' . $vbphrase['toplist'];
	
	// set XML type and nocache headers
	header('Content-Type: text/xml');
	header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	header('Pragma: public');
	
	echo '<?xml version="1.0" encoding="' . $stylevar['charset'] . '"?>' . "\r\n\r\n";
	
	if ($vbulletin->GPC['type'] == 'RSS')
	{
		echo '<!DOCTYPE rss PUBLIC "-//Netscape Communications//DTD RSS 0.91//EN" "http://my.netscape.com/publish/formats/rss-0.91.dtd">' . "\r\n";
		echo '<rss version="0.91">' . "\r\n";
		echo "<channel>\r\n";
		echo "\t<title>$rsstitle</title>\r\n";
		echo "\t<link>" . $vbulletin->options['bburl'] . "</link>\r\n";
		echo "\t<description><![CDATA[" . htmlspecialchars_uni($vbulletin->options['description']) . "]]></description>\r\n";
		echo "\t<language>$stylevar[languagecode]</language>\r\n";
	}
	else if ($vbulletin->GPC['type'] == 'RSS1')
	{
		echo "<rdf:RDF
  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"
  xmlns:dc=\"http://purl.org/dc/elements/1.1/\"
  xmlns:syn=\"http://purl.org/rss/1.0/modules/syndication/\"
  xmlns=\"http://purl.org/rss/1.0/\">\r\n\r\n";

		echo "\t<channel rdf:about=\"" . $vbulletin->options['bburl'] . "\">\r\n";
		echo "\t<title>$rsstitle</title>\r\n";
		echo "\t<link>" . $vbulletin->options['bburl'] . "</link>\r\n";
		echo "\t<description><![CDATA[". htmlspecialchars_uni($vbulletin->options['description']) . "]]></description>\r\n";
		echo "\t<syn:updatePeriod>hourly</syn:updatePeriod>\r\n";
		echo "\t<syn:updateFrequency>1</syn:updateFrequency>\r\n";
		echo "\t<syn:updateBase>1970-01-01T00:00Z</syn:updateBase>\r\n";
		echo "\t<dc:language>$stylevar[languagecode]</dc:language>\r\n";
		echo "\t<dc:creator>vBulletin</dc:creator>\r\n";
		echo "\t<dc:date>" . gmdate('Y-m-d\TH:i:s', TIMENOW) . "Z</dc:date>\r\n";
		echo "\t<items>\r\n";
		echo "\t<rdf:Seq>\r\n";
		echo "\t<rdf:li rdf:resource=\"" . $vbulletin->options['bburl'] . "\" />\r\n";
		echo "\t</rdf:Seq>\r\n";
		echo "\t</items>\r\n";
		echo "\t</channel>\r\n";
	}
	else if ($vbulletin->GPC['type'] == 'RSS2')
	{
		echo "<rss version=\"2.0\">\r\n";
		echo "<channel>\r\n";
		echo "\t<title>$rsstitle</title>\r\n";
		echo "\t<link>" . $vbulletin->options['bburl'] . "</link>\r\n";
		echo "\t<description><![CDATA[" . htmlspecialchars_uni($vbulletin->options['description']) . "]]></description>\r\n";
		echo "\t<language>$stylevar[languagecode]</language>\r\n";
		echo "\t<pubDate>" . gmdate('D, d M Y H:i:s', TIMENOW) . " GMT</pubDate>\r\n";
		echo "\t<generator>vBulletin</generator>\r\n";
		echo "\t<ttl>60</ttl>\r\n";
	}
	
	// fetch sites
	$sites2 = $db->query_read($sites1);
	
	// list returned sites
	while ($site = $db->fetch_array($sites2))
	{
		if ($vbulletin->GPC['type'] == 'RSS')
		{
			echo "\r\n\t<item>\r\n";
			echo "\t\t<title>{$rank} - {$site['name']}</title>\r\n";
			echo "\t\t<link>" . $vbulletin->options['bburl'] . "/out.php?id={$site['id']}</link>\r\n";
			echo "\t\t<description><![CDATA[{$site['description']}]]></description>\r\n";
			echo "\t</item>\r\n";
		}
		else if ($vbulletin->GPC['type'] == 'RSS1')
		{
			echo "\r\n\t<item rdf:about=\"" . $vbulletin->options['bburl'] . "/out.php?id={$site['id']}\">\r\n";
			echo "\t\t<title>{$rank} - {$site['name']}</title>\r\n";
			echo "\t\t<link>" . $vbulletin->options['bburl'] . "/out.php?id={$site['id']}</link>\r\n";
			echo "\t\t<description><![CDATA[". htmlspecialchars_uni($site['description']) ."]]></description>\r\n";
			echo "\t\t<dc:date>" . gmdate('Y-m-d\TH:i:s', $site['dateline']) . "Z</dc:date>\r\n";
			echo "\t\t<dc:creator><![CDATA[" . $site['username'] . "]]></dc:creator>\r\n";
			echo "\t</item>\r\n";
		}
		else if ($vbulletin->GPC['type'] == 'RSS2')
		{
			echo "\r\n\t<item>\r\n";
			echo "\t\t<title>{$rank} - {$site['name']}</title>\r\n";
			echo "\t\t<link>" . $vbulletin->options['bburl'] . "/out.php?id={$site['id']}</link>\r\n";
			echo "\t\t<pubDate>" . gmdate('D, d M Y H:i:s', $site['dateline']) . " GMT</pubDate>\r\n";
			echo "\t\t<description><![CDATA[". htmlspecialchars_uni($site['description']) ."]]></description>\r\n";
			echo "\t\t<category domain=\"" . $vbulletin->options['bburl'] . "/toplist.php?cid={$site['cid']}\"><![CDATA[" . htmlspecialchars_uni($site['categoryname']) . "]]></category>\r\n";

			# this bit is obtuse
			echo "\t\t<author><![CDATA[example@example.com (" . $site['username'] . ")]]></author>\r\n";
			echo "\t\t<guid isPermaLink=\"false\">" . $vbulletin->options['bburl'] . "/out.php?id={$site['id']}</guid>\r\n";
			echo "\t</item>\r\n";
		}
		
		$rank++;
	}
	
	if ($vbulletin->GPC['type'] == 'RSS1')
	{
		echo "</rdf:RDF>";
	}
	else
	{
		echo "</channel>\r\n";
		echo "</rss>";
	}
}	

?>