<?php
 
/*======================================================================*\
|| #################################################################### ||
|| # Toplist Hack - Version 2.0.0									  # ||
|| # For vBulletin 3.5.5											  # ||
|| # ---------------------------------------------------------------- # ||
|| # By Derek Ivey (derek@nbsdesignz.com)							  # ||
|| # This hack may not be redistributed without my written permission # ||
|| # Hack Copyright  2005-2006 Derek Ivey.							  # ||
|| # $Id: toplist.php,v 1.34 2006/10/29 16:40:49 derek Exp $
|| #################################################################### ||
\*======================================================================*/
 
// ####################### SET PHP ENVIRONMENT ########################### 
error_reporting(E_ALL & ~E_NOTICE); 
 
// #################### DEFINE IMPORTANT CONSTANTS ####################### 
define('THIS_SCRIPT', 'toplist');
define('toplist_version', '2.0.0');
$version = str_replace('.', '', toplist_version);
 
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array(
	'toplist_reset',
	'toplist_ranks',
);
 
// pre-cache templates used by all actions
$globaltemplates = array(
	'Toplist',
	'Toplist_Site_Bits',
	'Toplist_No_Rows',
	'Toplist_Categories_Code',
	'Toplist_Validate_Bits',
	'Toplist_Site_Rate_Menus',
	'Toplist_Site_Report_Menus',
	'Toplist_Inactive_Warning',
); 

// pre-cache templates used by specific actions
$actiontemplates = array(
	'dorate' => array(
		'Toplist_Rate_Misc',
	),
	'rate' => array(
		'Toplist_Rate',
	),
	'report' => array(
		'Toplist_Report',
		'Toplist_Report_Form',
	),
	'doreport' => array(
		'Toplist_Report',
	)
);

// ######################### REQUIRE BACK-END ############################ 
require_once('./global.php'); 
 
// ####################################################################### 
// ######################## START MAIN SCRIPT ############################ 
// #######################################################################

$navbits = array(); 
$navbits[$parent] = $vbphrase['toplist']; 
 
$navbits = construct_navbits($navbits); 
eval('$navbar = "' . fetch_template('navbar') . '";');

// ############## DETECT IF USER IS ALLOWED TO VIEW TOPLIST ##############
if (!($permissions['toplistpermissions'] & $vbulletin->bf_ugp['toplistpermissions']['canviewtoplist']))
{
	print_no_permission();
}
 
// #################### DETECT IF TOPLIST IS ENABLED ##################### 
if (!$vbulletin->options['toplist_enabled'])
{
	if ($permissions['toplistpermissions'] & $vbulletin->bf_ugp['toplistpermissions']['canviewofflinetoplist'])
	{
		eval('$warning = "' . fetch_template('Toplist_Inactive_Warning') . '";');
		$header = $warning . $header;
		$footer .= $warning;	
	}
	else
	{
		eval('standard_error("' . str_replace("\'", "'", addslashes($vbulletin->options['disabled_message'])) . '");');
	}
}

// ################################ OUT ##################################
if ($_REQUEST['do'] == 'out')
{
	$vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	
	if ($vbulletin->GPC['id'])
	{
		if ($vbulletin->options['toplist_count_out_from_guests'])
		{
			if ($vbulletin->userinfo['usergroupid'] == 1)
			{
				$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET `out` = `out` + 1 WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "'";
				$db->query_write($sql);
			}
		}

		if ($vbulletin->options['toplist_limit_out_clicks'])
		{
			//------------------------------------------------------------
			// If user is not a guest, see if they have clicked the out link for the site before.
			//------------------------------------------------------------
			if ($vbulletin->userinfo['usergroupid'] != 1)
			{
				$sql = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_clicks WHERE `username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "' AND `site_id` = '" . $db->escape_string($vbulletin->GPC['id']) . "'";
				$sqlr = $db->query_read($sql);
				$num_rows = $db->num_rows($sqlr);
				$db->free_result($sqlr);

				if ($num_rows < $vbulletin->options['toplist_out_click_limit'])
				{
					//------------------------------------------------------------
					// If they have not, add 1 out hit to the database for the site.
					//------------------------------------------------------------
					$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET
							`out` = `out` + 1,
							`views` = `views` + 1
							WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "'";
					$db->query_write($sql);

					//------------------------------------------------------------
					// If they have not, add their username to toplist_clicks.
					//------------------------------------------------------------
					$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_clicks SET
							`site_id` = '" . $db->escape_string($vbulletin->GPC['id']) . "',
							`username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
							`type` = 'out'";
					$db->query_write($sql);
				}
				else
				{
					$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET `views` = `views` + 1 WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "'";
					$db->query_write($sql);
				}
			}
			else
			{
				$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET `views` = `views` + 1 WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "'";
				$db->query_write($sql);	
			}
		}
		else
		{
			$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET
					`out` = `out` + 1,
					`views` = `views` + 1
					WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "'";
			$db->query_write($sql);
		}
	}  
}

// ######################## DO AJAX RATE SITE ############################
if ($_REQUEST['do'] == 'doajaxrate')
{
	// error codes: 1 = no permission; 2 = no site selected; 3 = site does not exist; 4 = rating not valid; 5 = already rated
	if ($vbulletin->userinfo['usergroupid'] != 1 AND $permissions['toplistpermissions'] & $vbulletin->bf_ugp['toplistpermissions']['canratesites'])
	{
		$vbulletin->input->clean_array_gpc('r', array(
			'id' => TYPE_UINT,
			'rating' => TYPE_UINT,
		));
		
		if ($vbulletin->GPC['id'])
		{
			// check if site exists...
			$check1 = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "' LIMIT 1";
			$check2 = $db->query_read($check1);
			$check3 = $db->num_rows($check2);
			
			if ($check3 == 1)
			{		
				// rating sanity check
				switch ($vbulletin->GPC['rating'])
				{
					case 1:
					case 2:
					case 3:
					case 4:
					case 5:
						$isvalid = true;
						break;
					default:
						$isvalid = false;			
				}
		
				if ($isvalid)
				{
					$chk1 = "SELECT `site_id` FROM " . TABLE_PREFIX . "toplist_ratings WHERE `site_id` = '" . $db->escape_string($vbulletin->GPC['id']) . "' AND `username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "' LIMIT 1";
					$chk2 = $db->query_read($chk1);
					$chk3 = $db->num_rows($chk2);
					$db->free_result($chk2);
			
					if ($chk3 == 0)
					{
						$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_ratings SET
								`site_id` = '" . $db->escape_string($vbulletin->GPC['id']) . "',
								`username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
								`rating` = '" . $db->escape_string($vbulletin->GPC['rating']) . "'";
						$db->query_write($sql);
				
						$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET
					   			`rating_total` = `rating_total` + '" . $vbulletin->GPC['rating'] . "',
					   			`votes` = `votes` + 1
								WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "'";
						$db->query_write($sql);
				
						$avg1 = "SELECT `rating_total`, `votes` FROM " . TABLE_PREFIX . "toplist_sites WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "' LIMIT 1";
						$avg2 = $db->query_read($avg1);
						$avg = $db->fetch_array($avg2);
				
						$average = $avg['rating_total'] / $avg['votes'];
				
						$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET
								`rating_average` = '" . $db->escape_string($average) . "'
								WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "'";
						$db->query_write($sql);
						
						print round($average) . ':' . $avg['votes'];
				
						$db->free_result(avg2);
						
						exit;
					}
					else
					{
						print 5;
						exit;
					}
				}
				else
				{
					print 4;
					exit;
				}
			}
			else
			{					
				print 3;
				exit;
			}
		}
		else
		{
			print 2;
			exit;
		}
	}
	else
	{
		print 1;
		exit;
	}	
}

// ######################## DO AJAX REPORT SITE ##########################
if ($_REQUEST['do'] == 'doajaxreport')
{
	// error codes: 1 = no permission; 2 = no site selected; 3 = site does not exist; 4 = reason field was blank
	if ($permissions['toplistpermissions'] & $vbulletin->bf_ugp['toplistpermissions']['canreportsites'])
	{
		$vbulletin->input->clean_array_gpc('r', array(
			'id' => TYPE_UINT,
			'reason' => TYPE_STR,
		));
	
		if ($vbulletin->GPC['id'])
		{
			// check if site exists...
			$sql = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "' LIMIT 1";
			$sqlr = $db->query_read($sql);
			$num_rows = $db->num_rows($sqlr);
			$db->free_result($sqlr);
		
			unset($sql);
		
			if ($num_rows == 1)
			{
				if ($vbulletin->GPC['reason'])
				{			
					$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_reports SET
							`sid` = '" . $db->escape_string($vbulletin->GPC['id']) . "',
							`username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
							`userid` = '" . $db->escape_string($vbulletin->userinfo['userid']) . "',
							`ipaddress` = '" . $db->escape_string(IPADDRESS) . "',
							`reason` = '" . $db->escape_string($vbulletin->GPC['reason']) . "'";
					$db->query_write($sql);
				
					print 'Success';
					exit;
				}
				else
				{
					print 4;
					exit;
				}
			}
			else
			{			
				print 3;
				exit;
			}
		}
		else
		{
			print 2;
			exit;
		}
	}
	else
	{
		print 1;
		exit;
	}
}

// ########################### DO RATE SITE ##############################
if ($_REQUEST['do'] == 'dorate')
{
	if ($vbulletin->userinfo['usergroupid'] == 1)
	{
		print_no_permission();
	}
	else
	{
		$vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		
		if ($vbulletin->GPC['id'])
		{
			$vbulletin->input->clean_gpc('p', 'rating', TYPE_UINT);
			
			$sql = "SELECT `site_id` FROM " . TABLE_PREFIX . "toplist_ratings WHERE `site_id` = '" . $db->escape_string($vbulletin->GPC['id']) . "' AND `username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "'";
			$sqlr = $db->query_read($sql);
			$num_rows = $db->num_rows($sqlr);
			$db->free_result($sqlr);
			
			if ($num_rows == 0)
			{
				$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_ratings SET
						`site_id` = '" . $db->escape_string($vbulletin->GPC['id']) . "',
						`username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
						`rating` = '" . $db->escape_string($vbulletin->GPC['rating']) . "'";
				$db->query_write($sql);
				
				$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET
					   `rating_total` = `rating_total` +'" . $vbulletin->GPC['rating'] . "',
					   `votes` = `votes` +1
						WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "'";
				$db->query_write($sql);
				
				$avg1 = "SELECT `rating_total`, `votes` FROM " . TABLE_PREFIX . "toplist_sites WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "' LIMIT 1";
				$avg2 = $db->query_read($avg1);
				$avg = $db->fetch_array($avg2);
				
				$average = $avg['rating_total'] / $avg['votes'];
				
				$sql = "UPDATE " . TABLE_PREFIX . "toplist_sites SET
						`rating_average` = '" . $db->escape_string($average) . "'
						WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "'";
				$db->query_write($sql);
				
				$db->free_result(avg2);
				
				$html = $vbphrase['toplist_rating_successful'];
				eval('print_output("' . fetch_template('Toplist_Rate_Misc') . '");');
			}
			else
			{				
				$html = $vbphrase['toplist_rating_error'];
				eval('print_output("' . fetch_template('Toplist_Rate_Misc') . '");');
			}
		}
		else
		{			
			$html = $vbphrase['toplist_rating_no_id'];
			eval('print_output("' . fetch_template('Toplist_Rate_Misc') . '");');
		}
	}

// ########################## RATE SITE FORM #############################
}
else if ($_REQUEST['do'] == 'rate')
{
	if ($vbulletin->userinfo['usergroupid'] == 1)
	{
		print_no_permission();
	}
	else
	{
		$vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		
		$sql = "SELECT `site_id` FROM " . TABLE_PREFIX . "toplist_ratings WHERE `site_id` = '" . $db->escape_string($vbulletin->GPC['id']) . "' AND `username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "'";
		$sqlr = $db->query_read($sql);
		$num_rows = $db->num_rows($sqlr);
		
		eval('print_output("' . fetch_template('Toplist_Rate') . '");');
	}

// ############################# DO REPORT ###############################
}
else if ($_REQUEST['do'] == 'doreport')
{
	$vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	
	if ($vbulletin->GPC['id'] != '')
	{
		$sql = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "' LIMIT 1";
		$sqlr = $db->query_read($sql);
		$num_rows = $db->num_rows($sqlr);
		$db->free_result($sqlr);
		
		unset($sql);
		
		if ($num_rows == 1)
		{
			$vbulletin->input->clean_gpc('p', 'reason', TYPE_STR);
			
			$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_reports SET
					`sid` = '" . $db->escape_string($vbulletin->GPC['id']) . "',
					`username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
					`userid` = '" . $db->escape_string($vbulletin->userinfo['userid']) . "',
					`ipaddress` = '" . $db->escape_string(IPADDRESS) . "',
					`reason` = '" . $db->escape_string($vbulletin->GPC['reason']) . "'";
			$db->query_write($sql);
			
			$html = $vbphrase['toplist_report_submitted'];
		}
		else
		{			
			$html = $vbphrase['toplist_no_site'];
		}
	}
	else
	{
		$html = $vbphrase['toplist_no_id'];
	}
	
	eval('print_output("' . fetch_template('Toplist_Report') . '");');			

// ################################ REPORT ###############################
}
else if ($_REQUEST['do'] == 'report')
{
	$vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	
	if ($vbulletin->GPC['id'] != '')
	{
		$sql = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "' LIMIT 1";
		$sqlr = $db->query_read($sql);
		$num_rows = $db->num_rows($sqlr);
		$db->free_result($sqlr);
		
		unset($sql);
		
		if ($num_rows == 1)
		{			
			eval('$html = "' . fetch_template('Toplist_Report_Form') . '";');
		}
		else
		{			
			$html = $vbphrase['toplist_no_site'];
		}
	}
	else
	{
		$html = $vbphrase['toplist_no_id'];
	}
	
	eval('print_output("' . fetch_template('Toplist_Report') . '");');
}
else
{
// ########### CHECK IF ANY OF THE USER'S SITES NEED VALIDATION ##########
	if ($vbulletin->options['toplist_check_if_code_exists'])
	{
		$sites1 = "SELECT `id`, `name`, `url` FROM " . TABLE_PREFIX . "toplist_sites WHERE `username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "' AND added_code = 0 ORDER BY id ASC";
		$sites2 = $db->query_read($sites1);
		$sites3 = $db->num_rows($sites2);
		
		unset($sites1);
	
		$validate_bits = '';
	
		if ($sites3 == 0)
		{
			$db->free_result($sites2);
			
			unset($sites3);
			
			$validate_bits = '';
		}
		else
		{	
			while ($site = $db->fetch_array($sites2))
			{
				eval('$validate_bits .= "' . fetch_template('Toplist_Validate_Bits') . '";'); 
			}
			
			$db->free_result($sites2);
			
			unset($sites3, $site);
		}
	}

// ############################ CATEGORIES ###############################
	$vbulletin->input->clean_gpc('r', 'cid', TYPE_UINT);
	
	$cat1 = "SELECT `id`, `name` FROM " . TABLE_PREFIX . "toplist_categories WHERE `displayorder` <> 0 ORDER BY `displayorder` ASC";
	$cat2 = $db->query_read($cat1);
	
	$index = 1;
	
	while ($categories = $db->fetch_array($cat2))
	{
		eval('$cat_list .= "' . fetch_template('Toplist_Categories_Code') . '";');
	}
	
	$db->free_result($cat2);
	
	unset($cat1, $categories);	

// ############################ PAGINATION ###############################
//------------------------------------------------------------
// Find the num of recs
//------------------------------------------------------------
	if ($vbulletin->GPC['cid'])
	{
		if ($vbulletin->options['toplist_check_if_code_exists'])
		{
			$sql = "SELECT COUNT(*) FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' AND `added_code` = 1 AND `cid` = '" . $db->escape_string($vbulletin->GPC['cid']) . "'";		
		}
		else
		{
			$sql = "SELECT COUNT(*) FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' AND `cid` = '" . $db->escape_string($vbulletin->GPC['cid']) . "'";
		}
	}
	else
	{
		if ($vbulletin->options['toplist_check_if_code_exists'])
		{
			$sql = "SELECT COUNT(*) FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' AND `added_code` = 1";
		}
		else
		{
			$sql = "SELECT COUNT(*) FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active'";
		}
	}
	
	$total_sites = $db->query_first($sql, DBARRAY_NUM);
	$total_sites = $total_sites[0];
 
 
//------------------------------------------------------------
// Get some needed values
//------------------------------------------------------------
	// Set some defaults
	$per_page = $vbulletin->options['sites_per_page'];
	$cur_page = 1;
 
 
	// Get per_page from user if it specified and valid
	if (isset($_REQUEST['per_page']) AND is_numeric($_REQUEST['per_page']) AND $_REQUEST['per_page'] <= 200 AND $_REQUEST['per_page'] > 5)
	{
		$per_page = $_REQUEST['per_page'];
	}
 
	// How many pages should we have total?
	$num_pages = ceil($total_sites / $per_page); 
 
	// Get the current page from the user if it is specified and valid
	if (isset($_REQUEST['page']) AND is_numeric($_REQUEST['page']) AND $_REQUEST['page'] > 0 AND $_REQUEST['page'] <= $num_pages)
	{
		$cur_page = $_REQUEST['page'];
	} 
 
	// The SQL limit offset
	$limit_offset = ($cur_page * $per_page) - $per_page;

//------------------------------------------------------------
// Build up the HTML nav
//------------------------------------------------------------
	if ($_REQUEST['cid'])
	{
		$pagenav = construct_page_nav($cur_page, $per_page, $total_sites, 'toplist.php?cid = '.$vbulletin->GPC['cid'] . $vbulletin->session->vars['sessionurl'], "");
	}
	else
	{
		$pagenav = construct_page_nav($cur_page, $per_page, $total_sites, 'toplist.php?' . $vbulletin->session->vars['sessionurl'], "");
	}

	if (empty($page))
	{
		$page = 1;
	}

	if (empty($pp))
	{
		$pp = $vbulletin->options['sites_per_page'];
	}
	else
	{
		$pp = $_REQUEST['pp'];
	}
	
// ######################## GET SITES FROM DB ############################
	if ($vbulletin->options['toplist_ranking_method'] == 0)
	{    
		$order = '`in`';
	}
	else if ($vbulletin->options['toplist_ranking_method'] == 1)
	{
		$order = '`out`';
	}
	else if ($vbulletin->options['toplist_ranking_method'] == 2)
	{
		$order = '`rating_average`';
	}
	else if ($vbulletin->options['toplist_ranking_method'] == 3)
	{
		$order = '`views`';
	}
	else
	{
		$order = '`in`';
	}

	if ($vbulletin->GPC['cid'])
	{
		$cat = 1;
		
		if ($vbulletin->options['toplist_check_if_code_exists'])
		{
			$sql = "SELECT `id`, `name`, `url`, `description`, `imagecode`, `in`, `out`, `views`, `votes`, `rating_average`, `username` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' AND `added_code` = 1 AND `cid` = '" . $db->escape_string($vbulletin->GPC['cid']) . "' ORDER BY " . $order . " DESC, `id` ASC LIMIT $limit_offset, $per_page";		  
		}
		else
		{	
			$sql = "SELECT `id`, `name`, `url`, `description`, `imagecode`, `in`, `out`, `views`, `votes`, `rating_average`, `username` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' AND `cid` = '" . $db->escape_string($vbulletin->GPC['cid']) . "' ORDER BY " . $order . " DESC, `id` ASC LIMIT $limit_offset, $per_page";
		}
	}
	else
	{
		if ($vbulletin->options['toplist_check_if_code_exists'])
		{
			$sql = "SELECT `id`, `name`, `url`, `description`, `imagecode`, `in`, `out`, `views`, `votes`, `rating_average`, `username` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' AND `added_code` = 1 ORDER BY " . $order . " DESC, `id` ASC LIMIT $limit_offset, $per_page";
		}
		else
		{
			$sql = "SELECT `id`, `name`, `url`, `description`, `imagecode`, `in`, `out`, `views`, `votes`, `rating_average`, `username` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' ORDER BY " . $order . " DESC, `id` ASC LIMIT $limit_offset, $per_page";
		}
	}
	
	$sqlr = $db->query_read($sql);
 
// ######################## SHOW SITES ################################### 
	$num_rows = $db->num_rows($sqlr);
 
	if ($num_rows == 0)
	{
		eval('$html = "' . fetch_template('Toplist_No_Rows') . '";');
		
		if ($vbulletin->options['toplist_show_random_sites'])
		{
			if ($vbulletin->options['toplist_check_if_code_exists'])
			{
				$randchk1 = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' AND `added_code` = 1";
			}
			else
			{
				$randchk1 = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active'";
			}
		
			$randchk2 = $db->query_read($randchk1);
			$randchk = $db->num_rows($randchk2);
			$db->free_result($randchk2);
		
			if ($randchk >= 1)
			{
				$rrank = 1;
				
				unset($randchk1);
			
				if ($vbulletin->options['toplist_check_if_code_exists'])
				{
					$randsite1 = "SELECT `id`, `name`, `url`, `description`, `imagecode`, `in`, `out`, `views`, `votes`, `rating_average` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' AND `added_code` = 1 ORDER BY RAND() LIMIT 1";
				}
				else
				{
					$randsite1 = "SELECT `id`, `name`, `url`, `description`, `imagecode`, `in`, `out`, `views`, `votes` , `rating_average` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' ORDER BY RAND() LIMIT 1";
				}
			
				$randsite2 = $db->query_read($randsite1);
				$randsite = $db->fetch_array($randsite2);
			
				if ($vbulletin->options['toplist_check_if_code_exists'])
				{
					$rand1 = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' AND `added_code` = 1 ORDER BY " . $order . " DESC, `id` ASC";
				}
				else
				{	
					$rand1 = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' ORDER BY " . $order . " DESC, `id` ASC";
				}
			
				$rand2 = $db->query_read($rand1);
			
				while ($rand = $db->fetch_array($rand2))
				{
					if ($randsite['id'] == $rand['id'])
					{
						$rand_rank = $rrank;
					}
				
					$rrank++;
				}
				
				$db->free_result($randsite2);
				$db->free_result($rand2);
				
				unset($randsite1, $rand1, $rand, $rrank);
			}
		}
	}
	else
	{
		if ($vbulletin->options['toplist_remove_rating_link_if_already_rated'])
		{
			$rated1 = "SELECT `site_id` FROM " . TABLE_PREFIX . "toplist_ratings WHERE `username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "'";
			$rated2 = $db->query_read($rated1);
			
			$rated_sites = array();
			
			while ($rated = $db->fetch_array($rated2))
			{
				$rated_sites[] = $rated['site_id'];	
			}
			
			$db->free_result($rated2);
			
			unset($rated1, $rated);
		}
		
		$rank = $limit_offset + 1;
		
		if ($vbulletin->options['toplist_show_random_sites'])
		{
			$rrank = 1;
		
			if ($vbulletin->options['toplist_check_if_code_exists'])
			{
				$randsite1 = "SELECT `id`, `name`, `url`, `description`, `imagecode`, `in`, `out`, `views`, `votes`, `rating_average` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' AND `added_code` = 1 ORDER BY RAND() LIMIT 1";
			}
			else
			{
				$randsite1 = "SELECT `id`, `name`, `url`, `description`, `imagecode`, `in`, `out`, `views`, `votes`, `rating_average` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' ORDER BY RAND() LIMIT 1";
			}
		
			$randsite2 = $db->query_read($randsite1);
			$randsite = $db->fetch_array($randsite2);

			if ($vbulletin->options['toplist_check_if_code_exists'])
			{
				$rand1 = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' AND `added_code` = 1 ORDER BY " . $order . " DESC, `id` ASC";
			}
			else
			{
				$rand1 = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites WHERE `status` = 'active' ORDER BY " . $order . " DESC, `id` ASC";
			}
		
			$rand2 = $db->query_read($rand1);
		
			while ($rand = $db->fetch_array($rand2))
			{
				if ($randsite['id'] == $rand['id'])
				{
					$rand_rank = $rrank;
				}
				else
				{				
					$rrank++;
				}
			}
			
			$db->free_result($randsite2);
			$db->free_result($rand2);
			
			unset($randsite1, $rand1, $rand, $rrank);
		}
		
		$html = '';
		$rate_menus = '';
		$report_menus = '';
		
		$show = array();
		$show['guest'] = ($vbulletin->userinfo['userid'] ? false : true);
		$show['popups'] = ($vbulletin->options['usepopups'] ? true : false);
		$show['ajax'] = ($vbulletin->options['disable_ajax'] == 2 ? true : false);
		$show['report'] = ($permissions['toplistpermissions'] & $vbulletin->bf_ugp['toplistpermissions']['canreportsites'] ? true : false);
		$show['rate'] = ($permissions['toplistpermissions'] & $vbulletin->bf_ugp['toplistpermissions']['canratesites'] ? true : false);
		$show['rank_images'] = ($vbulletin->options['toplist_show_rank_position_indicators'] ? true : false);
		$show['layout'] =& $vbulletin->options['toplist_layout'];
				
		$vbulletin->toplist_ranks = unserialize($vbulletin->toplist_ranks);
		
		while ($sr = $db->fetch_array($sqlr))
    	{
			if ($vbulletin->options['toplist_disable_html'])
			{
				$sr['name'] = htmlspecialchars_uni($sr['name']);
				$sr['description'] = htmlspecialchars_uni($sr['description']);
			}
			
			if ($show['rank_images'])
			{			
				if ($rank < $vbulletin->toplist_ranks[$sr['id']])
				{
					$rank_image = 'toplist_up.gif';
				}
				else if ($rank > $vbulletin->toplist_ranks[$sr['id']])
				{
					$rank_image = 'toplist_down.gif';
				}
				else
				{
					$rank_image = 'toplist_no_change.gif';
				}
			}
			
			$rating_image = round($sr['rating_average']);
			
			if ($vbulletin->userinfo['username'] == $sr['username'] OR $permissions['toplistpermissions'] & $vbulletin->bf_ugp['toplistpermissions']['canadminsites'])
			{
				if ($permissions['toplistpermissions'] & $vbulletin->bf_ugp['toplistpermissions']['caneditsites'])
				{
					$show['edit'] = true;
				}
				else
				{
					$show['edit'] = false;
				}
				
				if ($permissions['toplistpermissions'] & $vbulletin->bf_ugp['toplistpermissions']['candeletesites'])
				{
					$show['delete'] = true;
				}
				else
				{
					$show['delete'] = false;
				}
			}
			
			$rated = false;
			
			if ($vbulletin->options['toplist_remove_rating_link_if_already_rated'])
			{
				if (in_array($sr['id'], $rated_sites))
				{
					$rated = true;
				}
			}
 
			eval('$html .= "' . fetch_template('Toplist_Site_Bits') . '";');
			
			eval('$rate_menus .= "' . fetch_template('Toplist_Site_Rate_Menus') . '";');
			
			eval('$report_menus .= "' . fetch_template('Toplist_Site_Report_Menus') . '";');
		
       		$rank++;
   		}
	}
	
	if ($vbulletin->toplist_reset == '')
	{
		$last_reset = $vbphrase['toplist_last_reset_never'];  
	}
	else
	{
		$lrdate = vbdate($vbulletin->options['dateformat'], $vbulletin->toplist_reset, true);
		$lrtime = vbdate($vbulletin->options['timeformat'], $vbulletin->toplist_reset);
		
		$last_reset = construct_phrase($vbphrase['toplist_last_reset_x_y'], $lrdate, $lrtime);
	}
 
// ######################## Fetch Templates ##############################
	eval('print_output("' . fetch_template('Toplist') . '");');
}

?>