<?php

/*======================================================================*\
|| #################################################################### ||
|| # Toplist Hack - Version 2.0.0									  # ||
|| # For vBulletin 3.5.5											  # ||
|| # ---------------------------------------------------------------- # ||
|| # By Derek Ivey (derek@nbsdesignz.com)							  # ||
|| # This hack may not be redistributed without my written permission # ||
|| # Hack Copyright  2005-2006 Derek Ivey.							  # ||
|| # $Id: add_site.php,v 1.26 2006/10/14 23:29:28 derek Exp $
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ########################### 
error_reporting(E_ALL & ~E_NOTICE); 

// #################### DEFINE IMPORTANT CONSTANTS #######################  
define('THIS_SCRIPT', 'add_site');
define('toplist_version', '2.0.0'); 

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions 
$globaltemplates = array( 
    'Toplist_Add_Site',
	'Toplist_Rules',
	'Toplist_Categories_Code', 
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'add' => array(
		'Toplist_HTML_Code',
	)
);

// ######################### REQUIRE BACK-END ############################ 
require_once('./global.php'); 

// ####################################################################### 
// ######################## START MAIN SCRIPT ############################ 
// #######################################################################

$navbits = array(); 
$navbits['toplist.php'] = $vbphrase['toplist'];
$navbits['add_site.php'] = $vbphrase['toplist_add_site'];

$navbits = construct_navbits($navbits); 
eval('$navbar = "' . fetch_template('navbar') . '";'); 

// ################ DETECT IF USER IS ALLOWED TO ADD A SITE ##############
if (!($permissions['toplistpermissions'] & $vbulletin->bf_ugp['toplistpermissions']['canaddsites']))
{
	print_no_permission();
}

// #################### DETECT IF TOPLIST IS ENABLED ##################### 
if ($vbulletin->options['toplist_enabled'] == 0)
{
	eval(standard_error(str_replace("\'", "'", addslashes($vbulletin->options['disabled_message']))));
}
 
// ################ SHOW NO PERMISSION PAGE TO GUESTS ####################
if ($vbulletin->userinfo['usergroupid'] == 1)
{
	print_no_permission();
}
 
// ########################### ADD THE SITE ##############################
if ($_REQUEST['do'] == "add")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'sitename' => TYPE_NOHTML,
		'url' => TYPE_STR,
		'description' => TYPE_STR,
		'category' => TYPE_UINT
	));

	$vbulletin->input->clean_gpc('f', 'image', TYPE_FILE);
	
	if (!empty($vbulletin->GPC['image']['name']))
	{
		$image_name =& $vbulletin->GPC['image']['name'];
		$tmp_name =& $vbulletin->GPC['image']['tmp_name'];
		$image_size =& $vbulletin->GPC['image']['size'];
		$image_type =& $vbulletin->GPC['image']['type'];

		if ($image_type == "image/gif" OR $image_type == "image/pjpeg" OR $image_type == "image/jpeg" OR $image_type == "image/x-png")
		{
			$length = 20; 
			$key_chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'; 
			$rand_max = strlen($key_chars) - 1; 

			for ($i = 0; $i < $length; $i++) 
			{ 
				$rand_pos  = rand(0, $rand_max); 
				$rand_key[] = $key_chars{$rand_pos}; 
			} 

			$key = implode('', $rand_key);

			if (file_exists("images/toplist/buttons/sites/" . $key))
			{
				// Generate another random string to add to the key.
				unset($length, $i, $rand_pos, $rand_key);
				
				$length = 5;

				for ($i = 0; $i < $length; $i++) 
				{ 
					$rand_pos  = rand(0, $rand_max); 
					$rand_key[] = $key_chars{$rand_pos}; 
				} 

				$key2 = implode('', $rand_key);
				
				move_uploaded_file($tmp_name, "images/toplist/buttons/sites/" . $key . $key2);
	
				$size = getimagesize("images/toplist/buttons/sites/" . $key . $key2);
				$width = $size[0];
				$height = $size[1];
				
				unset($length, $key_chars, $rand_max, $i, $rand_pos, $rand_key, $size);
			}
			else
			{
				$key2 = '';
				
				move_uploaded_file($tmp_name, "images/toplist/buttons/sites/" . $key);
	
				$size = getimagesize("images/toplist/buttons/sites/" . $key);
				$width = $size[0];
				$height = $size[1];
				
				unset($length, $key_chars, $rand_max, $i, $rand_pos, $rand_key, $size);
			}
		}
		else
		{
			if ($image_type == '')
			{
				eval(standard_error(construct_phrase(fetch_error('error_toplist_image_size_too_big'), $vbulletin->options['toplist_max_image_size'])));
			}
			else
			{				
				eval(standard_error(construct_phrase(fetch_error('error_toplist_incorrect_image_format'), $image_type)));
			}
		}
	}

//------------------------------------------------------------
// Check to see that the image meets the size requirements.
//------------------------------------------------------------
	if ($width <= $vbulletin->options['toplist_max_width'] AND $height <= $vbulletin->options['toplist_max_height'])
	{

//------------------------------------------------------------
// Make Sure the fields are filled in.
//------------------------------------------------------------
		if (!empty($vbulletin->GPC['sitename']) AND !empty($vbulletin->GPC['url']) AND !empty($vbulletin->GPC['description']))
		{

//------------------------------------------------------------
// Make Sure the URL Submitted is Valid.
//------------------------------------------------------------
			$check_url = substr($vbulletin->GPC['url'], 0, 7);
			
			if ($check_url == "http://")
			{

//------------------------------------------------------------
// Remove HTML Code if needed.
//------------------------------------------------------------
				if ($vbulletin->options['toplist_disable_html'] == 1)
				{
					$vbulletin->GPC['description'] = htmlspecialchars_uni($vbulletin->GPC['description']);
				}

//------------------------------------------------------------
// Add the site to the database if everything is ok.
//------------------------------------------------------------
				if ($vbulletin->options['toplist_moderate_sites'] == 1)
				{
					if ($vbulletin->options['toplist_check_if_code_exists'] == 1)
					{
						$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_sites SET
								`username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "', 
								`name` = '" . $db->escape_string($vbulletin->GPC['sitename']) . "',
								`url` = '" . $db->escape_string($vbulletin->GPC['url']) . "',
								`description` = '" . $db->escape_string($vbulletin->GPC['description']) . "',
								`status` = 'inactive',
								`cid` = '" . $db->escape_string($vbulletin->GPC['category']) . "',
								`imagetype` = '" . $image_type . "',
								`imagesize` = '" . $image_size . "',
								`imagecode` = '" . $key . "',
								`imagecode2` = '" . $key2 . "',
								`added_code` = 0";
					}
					else
					{
						$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_sites SET
								`username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "', 
								`name` = '" . $db->escape_string($vbulletin->GPC['sitename']) . "',
								`url` = '" . $db->escape_string($vbulletin->GPC['url']) . "',
								`description` = '" . $db->escape_string($vbulletin->GPC['description']) . "',
								`status` = 'inactive',
								`cid` = '" . $db->escape_string($vbulletin->GPC['category']) . "',
								`imagetype` = '" . $image_type . "',
								`imagesize` = '" . $image_size . "',
								`imagecode` = '" . $key . "',
								`imagecode2` = '" . $key2 . "',
								`added_code` = 1";
					}
				}
				else
				{
					if ($vbulletin->options['toplist_check_if_code_exists'] == 1)
					{
						$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_sites SET
								`username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "', 
								`name` = '" . $db->escape_string($vbulletin->GPC['sitename']) . "',
								`url` = '" . $db->escape_string($vbulletin->GPC['url']) . "',
								`description` = '" . $db->escape_string($vbulletin->GPC['description']) . "',
								`status` = 'active',
								`cid` = '" . $db->escape_string($vbulletin->GPC['category']) . "',
								`imagetype` = '" . $image_type . "',
								`imagesize` = '" . $image_size . "',
								`imagecode` = '" . $key . "',
								`imagecode2` = '" . $key2 . "',
								`added_code` = 0";
					}
					else
					{
						$sql = "INSERT INTO " . TABLE_PREFIX . "toplist_sites SET
								`username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "', 
								`name` = '" . $db->escape_string($vbulletin->GPC['sitename']) . "',
								`url` = '" . $db->escape_string($vbulletin->GPC['url']) . "',
								`description` = '" . $db->escape_string($vbulletin->GPC['description']) . "',
								`status` = 'active',
								`cid` = '" . $db->escape_string($vbulletin->GPC['category']) . "',
								`imagetype` = '" . $image_type . "',
								`imagesize` = '" . $image_size . "',
								`imagecode` = '" . $key . "',
								`imagecode2` = '" . $key2 . "',
								`added_code` = 1";
					}
				}
				
				$db->query_write($sql);
				
				$id = $db->insert_id();
				
				unset($key, $key2, $width, $height, $check_url, $sql);

				if ($vbulletin->options['toplist_moderate_sites'] == 1 AND $vbulletin->options['toplist_email_new_validation'] == 1)
				{
					$query = "SELECT `email` FROM " . TABLE_PREFIX . "user WHERE `userid` IN({$vbulletin->options['toplist_email_users']})";
					$result = $db->query_read($query);

					eval(fetch_email_phrases('toplist_email', 0));

					while ($row = $db->fetch_array($result))
					{												
						vbmail($row['email'], $subject, $message, 1, $vbulletin->options['bbtitle']);
					}
					
					$db->free_result($result);
					
					unset($query, $row, $subject, $message);
				}

				if ($vbulletin->options['toplist_moderate_sites'] == 1 AND $vbulletin->options['toplist_pm_new_validation'] == 1)
				{ 
					$fq = "SELECT `username` FROM " . TABLE_PREFIX . "user WHERE `userid` = '" . $db->escape_string($vbulletin->options['toplist_pm_from_user']) . "'";
					$fr = $db->query_read($fq);
					$from = $db->fetch_array($fr);

					$uq = "SELECT `username` FROM " . TABLE_PREFIX . "user WHERE `userid` IN({$vbulletin->options['toplist_pm_users']})";
					$ur = $db->query_read($uq);
					
					$perms = 2;
					
					$pm_text = construct_phrase($vbphrase['toplist_pm'], $vbulletin->GPC['sitename'], $vbulletin->GPC['url'], $vbulletin->GPC['description'], $vbulletin->userinfo['username']);
					
					while ($user = $db->fetch_array($ur))
					{ 
						$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);						 
						$pmdm->set('fromuserid', $vbulletin->options['toplist_pm_from_user']); 
						$pmdm->set('fromusername', $from['username']); 
						$pmdm->set('title', $vbphrase['toplist_pm_subject']); 
						$pmdm->set('message', $pm_text); 
						$pmdm->set_recipients($user['username'], $perms); 
						$pmdm->set('dateline', TIMENOW);						
						$pmdm->save();
					}
					
					$db->free_result($fr);
					$db->free_result($ur);
					
					unset($fq, $from, $uq, $perms, $user);
				}

				// Send the output.				
				eval('print_output("' . fetch_template('Toplist_HTML_Code') . '");');

//------------------------------------------------------------
// Show error message if URL is not Valid.
//------------------------------------------------------------
			}
			else
			{
				@unlink("images/toplist/buttons/sites/" . $key . $key2);
				
				eval(standard_error(fetch_error('error_toplist_url_not_valid')));
			}
//------------------------------------------------------------
// Show error messages if certain fields aren't filled in.
//------------------------------------------------------------
		}
		else if (empty($vbulletin->GPC['sitename']) AND empty($vbulletin->GPC['url']) AND empty($vbulletin->GPC['description']))
		{
			@unlink("images/toplist/buttons/sites/" . $key . $key2);
			
			eval(standard_error(fetch_error('error_toplist_name_url_and_description_empty')));
		}
		else if (empty($vbulletin->GPC['sitename']) AND empty($vbulletin->GPC['url']))
		{
			@unlink("images/toplist/buttons/sites/" . $key . $key2);
			
			eval(standard_error(fetch_error('error_toplist_name_and_url_empty')));
		}
		else if (empty($vbulletin->GPC['sitename']) AND empty($vbulletin->GPC['description']))
		{
			@unlink("images/toplist/buttons/sites/" . $key . $key2);
			
			eval(standard_error(fetch_error('error_toplist_name_and_description_empty')));
		}
		else if (empty($vbulletin->GPC['sitename']))
		{
			@unlink("images/toplist/buttons/sites/" . $key . $key2);
			
			eval(standard_error(fetch_error('error_toplist_name_empty')));
		}
		else if (empty($vbulletin->GPC['url']) AND empty($vbulletin->GPC['description']))
		{
			@unlink("images/toplist/buttons/sites/" . $key . $key2);
			
			eval(standard_error(fetch_error('error_toplist_url_and_description_empty')));
		}
		else if (empty($vbulletin->GPC['url']))
		{
			@unlink("images/toplist/buttons/sites/" . $key . $key2);
			
			eval(standard_error(fetch_error('error_toplist_url_empty')));
		}
		else if (empty($vbulletin->GPC['description']))
		{
			@unlink("images/toplist/buttons/sites/" . $key . $key2);
			
			eval(standard_error(fetch_error('error_toplist_description_empty')));
		}

//------------------------------------------------------------
// Show error messages if image doesn't meet the requirements.
//------------------------------------------------------------
	}
	else if ($width > $vbulletin->options['toplist_max_width'] AND $height > $vbulletin->options['toplist_max_height'])
	{
		@unlink("images/toplist/buttons/sites/" . $key . $key2);
		
		eval(standard_error(fetch_error('error_toplist_width_and_height_too_big')));
	}
	else if ($width > $vbulletin->options['toplist_max_width'])
	{
		@unlink("images/toplist/buttons/sites/" . $key . $key2);
		
		eval(standard_error(fetch_error('error_toplist_width_too_big')));
	}
	else if ($height > $vbulletin->options['toplist_max_height'])
	{
		@unlink("images/toplist/buttons/sites/" . $key . $key2);
		
		eval(standard_error(fetch_error('error_toplist_height_too_big')));
	}

// ############################# VALIDATE ################################
}
else if ($_REQUEST['do'] == 'validate')
{
	if ($vbulletin->options['toplist_check_if_code_exists'] == 1)
	{
		$vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	
		if ($vbulletin->GPC['id'] != 0)
		{
			$check1 = "SELECT `username`, `url`, `added_code` FROM " . TABLE_PREFIX . "toplist_sites WHERE `id` = '" . $db->escape_string($vbulletin->GPC['id']) . "' LIMIT 1";
			$check2 = $db->query_read($check1);
			$check3 = $db->num_rows($check2);
		
			if ($check3 == 1)
			{
				$check = $db->fetch_array($check2);
			
				if ($check['username'] == $vbulletin->userinfo['username'])
				{
					if ($check['added_code'] == 1)
					{
						eval(standard_error(fetch_error('error_toplist_already_validated')));	
					}
				
					$contents = @file_get_contents($check['url']);
					
					$board_url = str_replace('/', '\/', $vbulletin->options['bburl']);
				
					if (preg_match('/' . $board_url . '\/in.php\?id=' . $vbulletin->GPC['id'] . '/i', $contents))
					{
		  				$db->query_write("UPDATE " . TABLE_PREFIX . "toplist_sites SET `added_code` = 1 WHERE `id` = '" . $vbulletin->GPC['id'] . "'");
		  				
		  				$db->free_result($check2);
						  
						$vbulletin->url = 'toplist.php?' . $vbulletin->session->vars['sessionurl'];
		  				
		  				eval(print_standard_redirect('toplist_site_validated_successfully', true, true));
					}
					else
					{
						$db->free_result($check2);
						
						eval(standard_error(fetch_error('error_toplist_code_not_found')));
					}				
				}
				else
				{
					$db->free_result($check2);
					
					eval(standard_error(fetch_error('error_toplist_site_doesnt_belong_to_you')));
				}
			}
			else
			{
				$db->free_result($check2);
				
				eval(standard_error(fetch_error('error_toplist_site_doesnt_exist')));
			}
		}
		else
		{
			eval(standard_error(fetch_error('error_toplist_no_id')));
		}
	}
	else
	{
		eval(standard_error(fetch_error('error_toplist_validation_disabled')));
	}
}
else
{
	$sql = "SELECT `id` FROM " . TABLE_PREFIX . "toplist_sites WHERE `username` = '" . $db->escape_string($vbulletin->userinfo['username']) . "'";
	$sqlr = $db->query_read($sql);
	$num_rows = $db->num_rows($sqlr);
	$db->free_result($sqlr);
	
	if ($permissions['toplistnumsites'] AND $num_rows >= $permissions['toplistnumsites'])
	{		
		eval(standard_error(fetch_error('error_toplist_number_of_sites_reached')));
	}
	else
	{
		unset($sql, $num_rows);
		
// ############################ CATEGORIES ###############################
		$cat1 = "SELECT `id`, `name` FROM " . TABLE_PREFIX . "toplist_categories WHERE `displayorder` <> 0 ORDER BY `displayorder` ASC";
		$cat2 = $db->query_read($cat1);

		$cat_list = '';

		while ($categories = $db->fetch_array($cat2))
		{
			eval('$cat_list .= "' . fetch_template('Toplist_Categories_Code') . '";');
		}

		$db->free_result($cat2);
		
// ########################## SHOW THE FORM ##############################
		eval('$toplistrules = "' . fetch_template('Toplist_Rules') . '";');
		eval('print_output("' . fetch_template('Toplist_Add_Site') . '");');
	}
}

?>